CREATE OR REPLACE PACKAGE BODY SnapshotError AS

  /**
   *  All the methods in this error package write the error info in the
   *    following format:
   *    elementd id | uoid | name | classname | snapshot name
   *  This information is necessary in order to build a context in the client
   */

  PROCEDURE handleFatalSnapshotError(uoidStr IN VARCHAR2,snap IN NUMBER,
    errorCode IN NUMBER) IS
    snapNameStr snapshotlookup.snapshotname%TYPE;
    BEGIN
      select snapshotname into snapNameStr from snapshotlookup where
        snapshotid = snap;
      mcmErrTable(errNo).errCode:= FATAL_SNAPSHOT_ERROR;
      mcmErrTable(errNo).parameters:= '0' || '|' || uoidStr || '| | |'
        || errorCode || '|' || snapNameStr;
      errNo:= errNo + 1;
    END handleFatalSnapshotError;

  PROCEDURE handleFatalSnapshotError(elemID IN NUMBER,snap IN NUMBER,
    errorCode IN NUMBER) IS
    snapNameStr snapshotlookup.snapshotname%TYPE;
    BEGIN
      select snapshotname into snapNameStr from snapshotlookup where
        snapshotid = snap;
      mcmErrTable(errNo).errCode:= FATAL_SNAPSHOT_ERROR;
      mcmErrTable(errNo).parameters:= TO_CHAR(elemID) || '| | | |'
        || errorCode || '|' || snapNameStr;
      errNo:= errNo + 1;
    END handleFatalSnapshotError;

  PROCEDURE handleGeneralSnapshotError(elemID IN NUMBER,snap IN NUMBER,
    errorCode IN NUMBER) IS
    uoidStr cmpelement_v.uoid%TYPE:= ' ';
    nameStr cmpelement_v.name%TYPE:= ' ';
    classnameStr cmpelement_v.classname%TYPE:= ' ';
    snapNameStr snapshotlookup.snapshotname%TYPE:= ' ';
    v_elementid cmpelement_v.elementid%TYPE;
    BEGIN
      v_elementid:= elemID;
      if (errorCode = REPOS_OBJECT_DOES_NOT_EXIST or
          errorCode = VERSION_OBJECT_DOES_NOT_EXIST) then
        v_elementid:= 0;
      end if;
      if (NOT(snap = 0)) then
        select snapshotname into snapNameStr from snapshotlookup where
          snapshotid = snap;
      end if;
      if (NOT(v_elementid = 0)) then
        select name,classname,uoid into nameStr,classnameStr,uoidStr
          from cmpelement_v where elementid = v_elementid;
      end if;
      mcmErrTable(errNo).errCode:= errorCode;
      mcmErrTable(errNo).parameters:= TO_CHAR(elemID) || '|' || uoidStr
        || '|' || nameStr || '|' || classnameStr || '|' || snapNameStr;
      errNo:= errNo + 1;
    EXCEPTION when NO_DATA_FOUND then
      handleFatalSnapshotError(v_elementid,snap,errorCode);
    END handleGeneralSnapshotError;

  PROCEDURE handleGeneralSnapshotError(uoidStr IN VARCHAR2,snap IN NUMBER,
    errorCode IN NUMBER,isVersion IN BOOLEAN default FALSE) IS
    elemID cmpelement_v.elementid%TYPE:= 0;
    nameStr cmpelement_v.name%TYPE:= ' ';
    classnameStr cmpelement_v.classname%TYPE:= ' ';
    snapNameStr snapshotlookup.snapshotname%TYPE:= ' ';
    v_uoid cmpelement_v.uoid%TYPE;
    BEGIN
      v_uoid:= uoidStr;
      if (errorCode = REPOS_OBJECT_DOES_NOT_EXIST or
          errorCode = VERSION_OBJECT_DOES_NOT_EXIST) then
        v_uoid:= null;
      end if;
      if (NOT(snap = 0)) then
        select snapshotname into snapNameStr from snapshotlookup where
        snapshotid = snap;
      end if;
      if (v_uoid is not null and NOT(isVersion)) then
        select name,classname,elementid into nameStr,classnameStr,elemID
          from cmpelement_v where uoid = v_uoid;
      end if;
      if (v_uoid is not null and isVersion) then
        select name,classname,elementid into nameStr,classnameStr,elemID
          from cmpelement_x where uoid = v_uoid and snapshotid = snap;
      end if;
      mcmErrTable(errNo).errCode:= errorCode;
      mcmErrTable(errNo).parameters:= TO_CHAR(elemID) || '|' || uoidStr
        || '|' || nameStr || '|' || classnameStr || '|' || snapNameStr;
      errNo:= errNo + 1;
    EXCEPTION when NO_DATA_FOUND then
      handleFatalSnapshotError(v_uoid,snap,errorCode);
    END handleGeneralSnapshotError;

  PROCEDURE handleAlterSnapshotError(operation IN NUMBER) IS
    BEGIN
      mcmErrTable(errNo).errCode:= ALTER_SNAPSHOT_OPERATION;
      mcmErrTable(errNo).parameters:= TO_CHAR(operation);
      errNo:= errNo + 1;
    END handleAlterSnapshotError;

  PROCEDURE handleRestoreSnapshotError(uoidStr IN VARCHAR2,snap IN NUMBER,
    errorCode IN NUMBER) IS
    elemID cmpelement_v.elementid%TYPE;
    classnameStr cmpelement_v.classname%TYPE;
    snapNameStr snapshotlookup.snapshotname%TYPE;
    nameStr cmpelement_v.name%TYPE;
    parentNameStr cmpelement_v.name%TYPE;
    BEGIN
      select name,classname,elementid into nameStr,classnameStr,elemID
        from firstclassobject_x where uoid = uoidStr and snapshotid = snap;
      select snapshotname into snapNameStr from snapshotlookup where
        snapshotid = snap;
      mcmErrTable(errNo).errCode:= errorCode;
      mcmErrTable(errNo).parameters:= TO_CHAR(elemID) || '|' || uoidStr
        || '|' || nameStr || '|' || classnameStr || '|' || snapNameStr;
      errNo:= errNo + 1;
    EXCEPTION when NO_DATA_FOUND then
      handleFatalSnapshotError(uoidStr,snap,errorCode);
    END handleRestoreSnapshotError;

END SnapshotError;
/
