CREATE OR REPLACE PACKAGE SnapshotError AS


  type mcmErrType is table of mcmerrors%ROWTYPE
    index by BINARY_INTEGER;
  mcmErrTable mcmErrType;

  -- follow flag switch on debug to copy structure
  structureDebug NUMBER(1) := 1;
  STRUCTURE_DEBUG_ON NUMBER(1) := 0;
  STRUCTURE_DEBUG_OFF NUMBER(1) := 1;

  errNo BINARY_INTEGER:= 0;


  ORACLE_ERROR			NUMBER(2):= -1;
  SUCCESS			NUMBER(2):= 0;

  NOT_RESTORABLE		NUMBER(2):= 1;
  RESTORE_PATH 			NUMBER(2):= 2;
  VERSION_OBJECT_DOES_NOT_EXIST	NUMBER(2):= 3;
  SNAPSHOT_NOT_IN_SNAPTABLE	NUMBER(2):= 4;
  NOT_ROOT_SNAPSHOT		NUMBER(2):= 5;
  ROOT_FLAG_NO_VALUE		NUMBER(2):= 6;
  NOT_HEAVY_SNAPSHOT		NUMBER(2):= 7;
  UNSUPPORTED_OPERATION		NUMBER(2):= 8;
  NAMESPACE_ON_RESTORE		NUMBER(2):= 9;
  UOID_IN_REPOS                 NUMBER(2):= 10;
  SNAPSHOT_ALRDY_HAS_OBJECT     NUMBER(2):= 11;
  ALTER_SNAPSHOT_OPERATION	NUMBER(2):= 12;
  FATAL_SNAPSHOT_ERROR		NUMBER(2):= 13;
  REDUNDANT_COMPONENT           NUMBER(2):= 14;
  HAS_WARNINGS			NUMBER(2):= 15;
  REPOS_OBJECT_DOES_NOT_EXIST	NUMBER(2):= 16;
  INCONSISTENT_MODEL	NUMBER(2):= 17;

  PROCEDURE handleFatalSnapshotError(uoidStr IN VARCHAR2,snap IN NUMBER,
    errorCode IN NUMBER);
  PROCEDURE handleFatalSnapshotError(elemID IN NUMBER,snap IN NUMBER,
    errorCode IN NUMBER);
  PROCEDURE handleGeneralSnapshotError(elemID IN NUMBER,snap IN NUMBER,
    errorCode IN NUMBER);
  PROCEDURE handleGeneralSnapshotError(uoidStr IN VARCHAR2,snap IN NUMBER,
    errorCode IN NUMBER,isVersion IN BOOLEAN default FALSE);
  PROCEDURE handleRestoreSnapshotError(uoidStr IN VARCHAR2,snap IN NUMBER,
    errorCode IN NUMBER);
  PROCEDURE handleAlterSnapshotError(operation IN NUMBER);

END SnapshotError;
/
