CREATE OR REPLACE PACKAGE BODY SnapshotImport AS

PROCEDURE runChange(snap IN NUMBER) IS
  BEGIN
    -- The fcofoldernamespacestorage view is workspace sensitive
    update fcofoldernamespacestorage set active = 1
      where active = 0 and isSeed = 1;
    update fcofoldernamespacestorage set active = 0
      where snapshotid = snap;

    update cmpfcostorage set active = 1
      where active = 0 and isSeed = 1
        and workspaceID = (select sys_context('owb_workspace','workspaceID') from dual);
    -- Bug 5666460: The current workspace must also be active during snapshot import.
    update cmpfcostorage set active = 0
      where (snapshotid = snap or s2_1 = 'CMPWorkspace')
        and workspaceID = (select sys_context('owb_workspace','workspaceID') from dual);

    -- Static meta-metadata is in the global workspace
    -- UserDefinedObject meta-metadata goes into the current workspace
    --update cmpmmmstorage set active = 1
    --  where active = 0 and isSeed = 1
    --    and workspaceID = (select sys_context('owb_workspace','workspaceID') from dual);
    --update cmpmmmstorage set active = 0
    --  where snapshotid = snap
    --    and workspaceID = (select sys_context('owb_workspace','workspaceID') from dual);

    update cmpscostorage set active = 1
      where active = 0 and isSeed = 1
        and workspaceID = (select sys_context('owb_workspace','workspaceID') from dual);
    update cmpscostorage set active = 0
      where snapshotid = snap
        and workspaceID = (select sys_context('owb_workspace','workspaceID') from dual);

    update cmpscocfgstorage set active = 1
      where active = 0 and isSeed = 1
        and workspaceID = (select sys_context('owb_workspace','workspaceID') from dual);
    update cmpscocfgstorage set active = 0
      where snapshotid = snap
        and workspaceID = (select sys_context('owb_workspace','workspaceID') from dual);

    update cmpscomapstorage set active = 1
      where active = 0 and isSeed = 1
        and workspaceID = (select sys_context('owb_workspace','workspaceID') from dual);
    update cmpscomapstorage set active = 0
      where snapshotid = snap
        and workspaceID = (select sys_context('owb_workspace','workspaceID') from dual);

    update cmpscoprpstorage set active = 1
      where active = 0 and isSeed = 1
        and workspaceID = (select sys_context('owb_workspace','workspaceID') from dual);
    update cmpscoprpstorage set active = 0
      where snapshotid = snap
        and workspaceID = (select sys_context('owb_workspace','workspaceID') from dual);

    -- Static metadata is in the global workspace
    -- Probably no end-user ever goes into current workspace, but just in case...
    update cmpsysstorage set active = 1
      where active = 0 and isSeed = 1
        and workspaceID = (select sys_context('owb_workspace','workspaceID') from dual);
    update cmpsysstorage set active = 0
      where snapshotid = snap
        and workspaceID = (select sys_context('owb_workspace','workspaceID') from dual);

  END runChange;

PROCEDURE beforeSnapshotImport(snapName IN VARCHAR2) IS
  snap NUMBER;
  BEGIN
    null;
  END beforeSnapshotImport;

PROCEDURE afterSnapshotExport IS
  BEGIN
    update cmpfcostorage set active = 0
      where active = 1
        and workspaceID = (select sys_context('owb_workspace','workspaceID') from dual);
    --update cmpmmmstorage set active = 0
    --  where active = 1
    --    and workspaceID = (select sys_context('owb_workspace','workspaceID') from dual);
    update cmpscostorage set active = 0
      where active = 1
        and workspaceID = (select sys_context('owb_workspace','workspaceID') from dual);
    update cmpscocfgstorage set active = 0
      where active = 1
        and workspaceID = (select sys_context('owb_workspace','workspaceID') from dual);
    update cmpscomapstorage set active = 0
      where active = 1
        and workspaceID = (select sys_context('owb_workspace','workspaceID') from dual);
    update cmpscoprpstorage set active = 0
      where active = 1
        and workspaceID = (select sys_context('owb_workspace','workspaceID') from dual);
    update cmpsysstorage set active = 0
      where active = 1
        and workspaceID = (select sys_context('owb_workspace','workspaceID') from dual);
    -- The fcofoldernamespacestorage view is workspace sensitive
    update fcofoldernamespacestorage set active = 0
      where active = 1;
    commit;
  END afterSnapshotExport;

PROCEDURE afterSnapshotImport IS
  BEGIN
    afterSnapshotExport();
  END afterSnapshotImport;


FUNCTION getFullyQualifiedName(elemID IN NUMBER) RETURN VARCHAR2 IS
  str VARCHAR2(1000):= '';
  i NUMBER:= 0;
  objName VARCHAR2(4000);
  BEGIN
    for c in (select name,elementid,level from firstclassobject
      start with elementid = elemID connect by prior
      owningfolder = elementid order by level desc) loop
      if (Snapshot.isFunction(c.elementid,Snapshot.VERSION_SNAPSHOT)) then
        select signature into objName from cmpfunction where
          elementid = c.elementid;
      else
        objName:= c.name;
      end if;
      if (i=0) then
        str:= str || objName;
      else
        str:= str || '/' || objName;
      end if;
      i:= i+1;
    end loop;
    return str;
  END getFullyQualifiedName;


/**
 * This procedure inserts the snapshot information into the snapshot
 * store table. This assumes that checking if the snapshot already
 * exists is done from the client.
 * @param elemID element id of the root object taking a snapshot of
 * @param labelStr the snapshot name
 * @param description the description of this snapshot
 */
FUNCTION insertSnapshotStore(elemID IN NUMBER,snap IN NUMBER,
  description IN VARCHAR2,isHeavy IN NUMBER,isCascade IN NUMBER) RETURN NUMBER IS
  isCascadeFlag snapshotstoretable.iscascade%TYPE;
  type recordType IS RECORD (
    name cmpelement_v.name%TYPE,
    logicalname cmpelement_v.logicalname%TYPE,
    uoid cmpelement_v.uoid%TYPE,
    classname cmpelement_v.classname%TYPE
  );
  /**
   * get all fco-only element ids of objects
   * that belong to the component being taken
   */
  vRecord recordType;
  isRoot NUMBER(1);
  fullName VARCHAR2(4000);
  BEGIN
    for c in (select fco.elementid from firstclassobject fco,
      temptable t where fco.elementid = t.elementid) loop
      select name,logicalname,uoid,classname into vRecord
        from cmpelement where elementid = c.elementid;
      if (c.elementid = elemID) then
        if (isCascade = 0) then
          isCascadeFlag:= 0;
        else
          isCascadeFlag:= 1;
        end if;
        isRoot:= 0;
      else
        isRoot:= 1;
      end if;
      fullName:= getFullyQualifiedName(c.elementid);
      BEGIN
        insert into snapshotstoretable values (
          snap,fullName,vRecord.logicalname,vRecord.classname,
          vRecord.uoid,sysdate,description,Snapshot.HEAVY_SNAPSHOT,
          isCascadeFlag,isRoot,Snapshot.currentUser,Snapshot.currentUser,
          sysdate());
      EXCEPTION when DUP_VAL_ON_INDEX then
        SnapshotError.handleGeneralSnapshotError(vRecord.uoid,snap,
          SnapshotError.SNAPSHOT_ALRDY_HAS_OBJECT,TRUE);
        return SnapshotError.SNAPSHOT_ALRDY_HAS_OBJECT;
      END;
    end loop;
    return 0;
  END insertSnapshotStore;

FUNCTION takeLWSnapshot(snapName IN VARCHAR2,snapUOID IN VARCHAR2,
  description IN VARCHAR2,owbuser IN VARCHAR2) RETURN NUMBER IS
  retVal NUMBER;
  retCode NUMBER;
  snap NUMBER;
  elemID NUMBER;
  BEGIN
    Snapshot.debug('SnapshotImport.takeLWSnapshot: ','');

    select snapshotid into snap from snapshotlookup where
      snapshotName = snapName;

    insert into cmpwbproject select * from cmpwbproject_x;
    insert into cmpelement select * from cmpelement_x;
    insert into firstclassobject select * from firstclassobject_x;
    insert into secondclassobject select * from secondclassobject_x;
    insert into cmpreferencepropertyvalue select * from cmpreferencepropertyvalue_x;
    insert into cmpfunction select * from cmpfunction_x;
    insert into cmpphysicalobject select * from cmpphysicalobject_x;

    insert into pctreedebug
      select parentid,childid,parentrole,childrole from pctreestorage
      where snapshotid = snap;
    insert into interlinkdebug
      select linkfrom,linkto,linkfromrole,linktorole from interlinkstorage
      where snapshotid = snap;
    insert into intralinkdebug
      select linkfrom,linkto,linkfromrole,linktorole from intralinkstorage
      where snapshotid = snap;


    retCode:= Snapshot.doMCMOperation(Snapshot.CREATE_SNAPSHOT,snapName,retVal,
      owbuser,description,Snapshot.LIGHT_SNAPSHOT,Snapshot.VERSION_SNAPSHOT);
    if (retCode > 0) then
      return retCode;
    end if;

    return retCode;
  END takeLWSnapshot;

END SnapshotImport;
/
