CREATE OR REPLACE package wb_workspace_management as
  -- create_workspace creates a workspace with the specified name
  -- owned by the current user. 
  -- workspace is set or not is not required
  procedure create_workspace(
    p_ws_name varchar2,
    p_owner varchar2 default user
  );

  -- create_workspace creates a workspace with the specified name
  -- owned by the current user.
  -- workspace id should only be specified as a positive number when called by repository upgrade.  
  -- workspace is set or not is not required
  procedure create_workspace(
    p_ws_name varchar2,
    p_owner varchar2 default user,
    p_ws_id number
  );
  
  -- drop_workspace
  -- Checks that the user has the appropriate privilege (ADMIN_WS) on the 
  -- specified workspace or is the workspace owner, and if so, drops the 
  -- workspace.
  -- workspace is set or not is not required

  procedure drop_workspace(
    p_ws_name varchar2,
    p_owner varchar2 default user
  );
  
  -- grant_workspace_sys_priv
  -- Checks that the user has the appropriate privilege (ADMIN_WS) on the 
  -- specified workspace or is the workspace owner, and if so, grants the 
  -- specified privilege to the specified user.
  -- assume that the workspace is already set by set_workspace call
  procedure grant_workspace_sys_priv(
    p_priv_name varchar2, 
    p_user varchar2

  );
  
  -- revoke_worpkspace_sys_priv
  -- Checks that the user has the appropriate privilege (ADMIN_WS) on the 
  -- specified workspace or is the workspace owner, and if so, revokes the 
  -- specified privilege from the specified user.
  -- assume that the workspace is already set by set_workspace call
  procedure revoke_workspace_sys_priv(
    p_priv_name varchar2, 
    p_user varchar2
  );  


 --register a db user to the current workspace
 -- assume that the workspace is already set by set_workspace call
 --p_is_ws_admin: 0 is not ws_admin, 1 is workspace admin
 procedure register_workspace_user(p_user varchar2 , p_is_ws_admin number default 0);

 --unregister a owb use from the current workspace
 -- assume that the workspace is already set by set_workspace call
 procedure unregister_workspace_user(p_user varchar2);


  -- set_workspace
  -- Sets the current workspace to the one named in workspace_name. Checks
  -- that the user has access to the workspace and sets access flags.
  -- also if user has ACCESS_PUBLICVIEW_BROWSER privilege OWB_DESIGNTIME_VIEW role will be enabled(OWB_USER role will be enabled anyway)
  procedure set_workspace(
    p_ws_name varchar2
  );
  
  procedure set_workspace(
    p_ws_name varchar2,
    p_owner varchar2
  );


procedure  ignore_lockerror_setwksp(ignore number);


  -- unset_workspace
  -- Makes no workspace active in the current session (ie back the default state)
  procedure unset_workspace;  

  -- get_workspace_id
  -- Returns the id of the current workspace.
  function get_workspace_id return number;

 
  -- get_workspace
  -- Returns the name of the current workspace.
  function get_workspace_name return varchar2;

  -- get_workspace_owner
  -- Returns the owner of the current workspace.
  function get_workspace_owner return varchar2;

  -- has_privilege
  -- Returns true if the current user has the specified privilege 
  -- on the current workspace
  function has_system_privilege(
    p_privilege_name varchar2,
    theUser varchar2 default user
  ) return boolean;  
  
  -- has_system_privilege_int
  -- Returns true if the current user has the specified privilege
  -- on the current workspace. Required as SQL does not handle booleans
  function has_system_privilege_int(
    p_privilege_name varchar2
  ) return number;  

 --to check uniqueness of a workspace,it must be unique under its owner. 
 --return 1: means the name is Ok and unique, 0 means: the name is not unique. 
 --no workspace need to be set 
 function isWorkspaceNameUnique(p_ws_name varchar2, p_owner varchar2, toReserve boolean default false) return number;


 -- if seed1stDefWksp is true: which only apply when the userName is registered to this workspace, and need to setup the 1st value of the default workspace.
 -- And if this seed1stDefWksp is true,  this procedure will check if the userName has already setup the 1st default workspace and that workspace still exists, if true this procedure will not do anything; otherwise it will seed the 1st default workspace info (or delete the invalid workspace info and seed a new one)
-- And if this seed1stDefWksp is false: that means: end user wants to change the old default worksapce to something else, so just update that info if exists or insert a new one if not exists already(this later case shoujld not happen ,but no bother to throw an exception)
 procedure set_default_workspace(username varchar2, p_ws_owner varchar2, p_ws_name varchar2, seed1stDefWksp boolean default false); 
  
end wb_workspace_management;
