create or replace view DefinitionElement_V
(
    WorkspaceID,
    LoadingParent,
    DeletionParent,
    AggregatedSignature
   ,ClassName
   ,Completed
   ,CreatedBy
   ,CreationTimestamp
   ,CustomerDeletable
   ,CustomerEditable
   ,CustomerRenamable
   ,Description
   ,Disabled
   ,Editable
   ,ElementId
   ,Frozen
   ,Generated
   ,Imported
   ,LogicalName
   ,MetadataSignature
   ,Name
   ,Note
   ,NOTM
   ,Persistent
   ,Seeded
   ,UOID
   ,UpdatedBy
   ,UpdateTimestamp
   ,Version, isLoadingParent
) as select
    WorkspaceID,
    LoadingParent,
    DeletionParent,
    s2_1
   ,s2_2
   ,b_1
   ,s1_1
   ,d_1
   ,b_2
   ,b_3
   ,b_4
   ,s3_1
   ,b_5
   ,b_6
   ,i_1
   ,b_7
   ,b_8
   ,b_9
   ,s4_1
   ,s2_3
   ,s2_4
   ,s3_3
   ,i_2
   ,b_10
   ,b_11
   ,s2_5
   ,s1_2
   ,d_2
   ,s1_3
   ,b_12
from CMPMMMClasses
where s2_2 in (
          'WBAbstractType'
         ,'WBCollectionType'
         ,'WBScalarType'
         ,'WBExtensibleType'
         ,'WBArrayType'
         ,'WBPrimitiveType'
         ,'WBDomain'
         ,'WBRange'
         ,'ClassDefinition'
         ,'PropertyDefinition'
         ,'ClassInheritanceDefinition'
         ,'DefinitionKeyLookupBundle'
         ,'PropertyGroupDefinition'
         ,'PropertySetDefinition'
         ,'PropertyUsageDefinition'
         ,'PropertyUsageChoice'
         ,'AssociationDefinition'
         ,'RoleDefinition'
         ,'ClassUsageDefinition'
         ,'ComponentDefinition'
         ,'DummyInterestSet'
         ,'DummyInterestUsage'
         ,'InterestSet'
         ,'InterestUsage'
         ,'PublicAPISet'
         ,'DefinitionInterestUsage'
         ,'VerticalTree'
         ,'TreeNode'
         ,'WBProperty'
         ,'WBArrayProperty'
         ,'WBCollectionProperty'
         ,'WBScalarProperty'
         ,'WBPrimitiveProperty'
         ,'WBReferenceProperty'
         ,'DependencyDefinition'
) and (workspaceid = 1
   or  workspaceid = (select sys_context('owb_workspace','workspaceID') from dual)
);
create or replace view LoadingStrategy_V
(
    WorkspaceID
   ,ElementId
   ,ClassName
   ,LoadingParent
) as select
      WorkspaceID
     ,i_1
     ,s2_2
     ,LoadingParent
from CMPMMMClasses
where workspaceid = 1
   or workspaceid = (select sys_context('owb_workspace','workspaceID') from dual)
;
create or replace view AssociationDefinition_V
(
    WorkspaceID,
    LoadingParent,
    DeletionParent,
    AggregatedSignature
   ,ClassName
   ,Completed
   ,CreatedBy
   ,CreationTimestamp
   ,CustomerDeletable
   ,CustomerEditable
   ,CustomerRenamable
   ,Description
   ,Disabled
   ,Editable
   ,ElementId
   ,Frozen
   ,Generated
   ,Imported
   ,LogicalName
   ,MetadataSignature
   ,Name
   ,Note
   ,NOTM
   ,Persistent
   ,Seeded
   ,UOID
   ,UpdatedBy
   ,UpdateTimestamp
   ,Version, isLoadingParent
   ,RoleA
   ,RoleAName
   ,ClassA
   ,RoleB
   ,RoleBName
   ,ClassB
   ,AssociationType
   ,Aggregation
   ,WeaklyTyped
) as select
    WorkspaceID,
    LoadingParent,
    DeletionParent,
    s2_1
   ,s2_2
   ,b_1
   ,s1_1
   ,d_1
   ,b_2
   ,b_3
   ,b_4
   ,s3_1
   ,b_5
   ,b_6
   ,i_1
   ,b_7
   ,b_8
   ,b_9
   ,s4_1
   ,s2_3
   ,s2_4
   ,s3_3
   ,i_2
   ,b_10
   ,b_11
   ,s2_5
   ,s1_2
   ,d_2
   ,s1_3
   ,b_12
   ,r_1
   ,s2_6
   ,r_2
   ,r_3
   ,s2_7
   ,r_4
   ,i_3
   ,b_13
   ,b_14
from CMPMMMClasses
where s2_2 in (
          'AssociationDefinition'
) and (workspaceid = 1
   or  workspaceid = (select sys_context('owb_workspace','workspaceID') from dual)
);
create or replace view ClassDefinition_V
(
    WorkspaceID,
    LoadingParent,
    DeletionParent,
    AggregatedSignature
   ,ClassName
   ,Completed
   ,CreatedBy
   ,CreationTimestamp
   ,CustomerDeletable
   ,CustomerEditable
   ,CustomerRenamable
   ,Description
   ,Disabled
   ,Editable
   ,ElementId
   ,Frozen
   ,Generated
   ,Imported
   ,LogicalName
   ,MetadataSignature
   ,Name
   ,Note
   ,NOTM
   ,Persistent
   ,Seeded
   ,UOID
   ,UpdatedBy
   ,UpdateTimestamp
   ,Version, isLoadingParent
   ,Comparator
   ,Extensible
   ,WeaklyTyped
   ,Stereotype
   ,Generatable
   ,Abstract
   ,PackageName
   ,PropertyParent
   ,ComponentDefinition
   ,ClassPersistent
   ,namespaceParent
   ,namespaceDomain
) as select
    WorkspaceID,
    LoadingParent,
    DeletionParent,
    s2_1
   ,s2_2
   ,b_1
   ,s1_1
   ,d_1
   ,b_2
   ,b_3
   ,b_4
   ,s3_1
   ,b_5
   ,b_6
   ,i_1
   ,b_7
   ,b_8
   ,b_9
   ,s4_1
   ,s2_3
   ,s2_4
   ,s3_3
   ,i_2
   ,b_10
   ,b_11
   ,s2_5
   ,s1_2
   ,d_2
   ,s1_3
   ,b_12
   ,s2_6
   ,b_13
   ,b_14
   ,i_3
   ,b_15
   ,b_16
   ,s2_7
   ,r_1
   ,r_2
   ,b_17
   ,s2_8
   ,s2_9
from CMPMMMClasses
where s2_2 in (
          'ClassDefinition'
) and (workspaceid = 1
   or  workspaceid = (select sys_context('owb_workspace','workspaceID') from dual)
);
create or replace view PropertyDefinition_V
(
    WorkspaceID,
    LoadingParent,
    DeletionParent,
    AggregatedSignature
   ,ClassName
   ,Completed
   ,CreatedBy
   ,CreationTimestamp
   ,CustomerDeletable
   ,CustomerEditable
   ,CustomerRenamable
   ,Description
   ,Disabled
   ,Editable
   ,ElementId
   ,Frozen
   ,Generated
   ,Imported
   ,LogicalName
   ,MetadataSignature
   ,Name
   ,Note
   ,NOTM
   ,Persistent
   ,Seeded
   ,UOID
   ,UpdatedBy
   ,UpdateTimestamp
   ,Version, isLoadingParent
   ,PropertyType
   ,DefinitionKey
   ,ExportControl
   ,Override
   ,Position
   ,ClassDefinition
   ,DataType
   ,isRole
   ,roleDefinition
   ,translatable
   ,isPassword
   ,hidden
   ,propertyReadOnly
   ,nameChecked
   ,userChoiceAllowed
   ,dynamicDefault
   ,inPlaceEditor
   ,customEditor
   ,propertyGroupDefinition
) as select
    WorkspaceID,
    LoadingParent,
    DeletionParent,
    s2_1
   ,s2_2
   ,b_1
   ,s1_1
   ,d_1
   ,b_2
   ,b_3
   ,b_4
   ,s3_1
   ,b_5
   ,b_6
   ,i_1
   ,b_7
   ,b_8
   ,b_9
   ,s4_1
   ,s2_3
   ,s2_4
   ,s3_3
   ,i_2
   ,b_10
   ,b_11
   ,s2_5
   ,s1_2
   ,d_2
   ,s1_3
   ,b_12
   ,i_3
   ,s2_6
   ,i_4
   ,b_13
   ,i_5
   ,r_1
   ,r_2
   ,b_14
   ,r_3
   ,b_15
   ,b_16
   ,b_17
   ,b_18
   ,b_19
   ,b_20
   ,s2_7
   ,s2_8
   ,s2_9
   ,r_4
from CMPMMMClasses
where s2_2 in (
          'PropertyDefinition'
) and (workspaceid = 1
   or  workspaceid = (select sys_context('owb_workspace','workspaceID') from dual)
);
create or replace view ClassInheritanceDefinition_V
(
    WorkspaceID,
    LoadingParent,
    DeletionParent,
    AggregatedSignature
   ,ClassName
   ,Completed
   ,CreatedBy
   ,CreationTimestamp
   ,CustomerDeletable
   ,CustomerEditable
   ,CustomerRenamable
   ,Description
   ,Disabled
   ,Editable
   ,ElementId
   ,Frozen
   ,Generated
   ,Imported
   ,LogicalName
   ,MetadataSignature
   ,Name
   ,Note
   ,NOTM
   ,Persistent
   ,Seeded
   ,UOID
   ,UpdatedBy
   ,UpdateTimestamp
   ,Version, isLoadingParent
   ,inheritanceParent
   ,inheritanceChild
) as select
    WorkspaceID,
    LoadingParent,
    DeletionParent,
    s2_1
   ,s2_2
   ,b_1
   ,s1_1
   ,d_1
   ,b_2
   ,b_3
   ,b_4
   ,s3_1
   ,b_5
   ,b_6
   ,i_1
   ,b_7
   ,b_8
   ,b_9
   ,s4_1
   ,s2_3
   ,s2_4
   ,s3_3
   ,i_2
   ,b_10
   ,b_11
   ,s2_5
   ,s1_2
   ,d_2
   ,s1_3
   ,b_12
   ,r_1
   ,r_2
from CMPMMMClasses
where s2_2 in (
          'ClassInheritanceDefinition'
) and (workspaceid = 1
   or  workspaceid = (select sys_context('owb_workspace','workspaceID') from dual)
);
create or replace view ClassUsageDefinition_V
(
    WorkspaceID,
    LoadingParent,
    DeletionParent,
    AggregatedSignature
   ,ClassName
   ,Completed
   ,CreatedBy
   ,CreationTimestamp
   ,CustomerDeletable
   ,CustomerEditable
   ,CustomerRenamable
   ,Description
   ,Disabled
   ,Editable
   ,ElementId
   ,Frozen
   ,Generated
   ,Imported
   ,LogicalName
   ,MetadataSignature
   ,Name
   ,Note
   ,NOTM
   ,Persistent
   ,Seeded
   ,UOID
   ,UpdatedBy
   ,UpdateTimestamp
   ,Version, isLoadingParent
   ,ComponentDefinition
   ,ClassDefinition
   ,UsageType
) as select
    WorkspaceID,
    LoadingParent,
    DeletionParent,
    s2_1
   ,s2_2
   ,b_1
   ,s1_1
   ,d_1
   ,b_2
   ,b_3
   ,b_4
   ,s3_1
   ,b_5
   ,b_6
   ,i_1
   ,b_7
   ,b_8
   ,b_9
   ,s4_1
   ,s2_3
   ,s2_4
   ,s3_3
   ,i_2
   ,b_10
   ,b_11
   ,s2_5
   ,s1_2
   ,d_2
   ,s1_3
   ,b_12
   ,r_1
   ,r_2
   ,i_3
from CMPMMMClasses
where s2_2 in (
          'ClassUsageDefinition'
) and (workspaceid = 1
   or  workspaceid = (select sys_context('owb_workspace','workspaceID') from dual)
);
create or replace view ComponentDefinition_V
(
    WorkspaceID,
    LoadingParent,
    DeletionParent,
    AggregatedSignature
   ,ClassName
   ,Completed
   ,CreatedBy
   ,CreationTimestamp
   ,CustomerDeletable
   ,CustomerEditable
   ,CustomerRenamable
   ,Description
   ,Disabled
   ,Editable
   ,ElementId
   ,Frozen
   ,Generated
   ,Imported
   ,LogicalName
   ,MetadataSignature
   ,Name
   ,Note
   ,NOTM
   ,Persistent
   ,Seeded
   ,UOID
   ,UpdatedBy
   ,UpdateTimestamp
   ,Version, isLoadingParent
   ,ClassDefinition
) as select
    WorkspaceID,
    LoadingParent,
    DeletionParent,
    s2_1
   ,s2_2
   ,b_1
   ,s1_1
   ,d_1
   ,b_2
   ,b_3
   ,b_4
   ,s3_1
   ,b_5
   ,b_6
   ,i_1
   ,b_7
   ,b_8
   ,b_9
   ,s4_1
   ,s2_3
   ,s2_4
   ,s3_3
   ,i_2
   ,b_10
   ,b_11
   ,s2_5
   ,s1_2
   ,d_2
   ,s1_3
   ,b_12
   ,r_1
from CMPMMMClasses
where s2_2 in (
          'ComponentDefinition'
) and (workspaceid = 1
   or  workspaceid = (select sys_context('owb_workspace','workspaceID') from dual)
);
create or replace view DefinitionKeyLookupBundle_V
(
    WorkspaceID,
    LoadingParent,
    DeletionParent,
    AggregatedSignature
   ,ClassName
   ,Completed
   ,CreatedBy
   ,CreationTimestamp
   ,CustomerDeletable
   ,CustomerEditable
   ,CustomerRenamable
   ,Description
   ,Disabled
   ,Editable
   ,ElementId
   ,Frozen
   ,Generated
   ,Imported
   ,LogicalName
   ,MetadataSignature
   ,Name
   ,Note
   ,NOTM
   ,Persistent
   ,Seeded
   ,UOID
   ,UpdatedBy
   ,UpdateTimestamp
   ,Version, isLoadingParent
   ,definitionKeyLookupBundle
   ,propertySetDefinition
) as select
    WorkspaceID,
    LoadingParent,
    DeletionParent,
    s2_1
   ,s2_2
   ,b_1
   ,s1_1
   ,d_1
   ,b_2
   ,b_3
   ,b_4
   ,s3_1
   ,b_5
   ,b_6
   ,i_1
   ,b_7
   ,b_8
   ,b_9
   ,s4_1
   ,s2_3
   ,s2_4
   ,s3_3
   ,i_2
   ,b_10
   ,b_11
   ,s2_5
   ,s1_2
   ,d_2
   ,s1_3
   ,b_12
   ,i_3
   ,r_1
from CMPMMMClasses
where s2_2 in (
          'DefinitionKeyLookupBundle'
) and (workspaceid = 1
   or  workspaceid = (select sys_context('owb_workspace','workspaceID') from dual)
);
create or replace view InterestSet_V
(
    WorkspaceID,
    LoadingParent,
    DeletionParent,
    AggregatedSignature
   ,ClassName
   ,Completed
   ,CreatedBy
   ,CreationTimestamp
   ,CustomerDeletable
   ,CustomerEditable
   ,CustomerRenamable
   ,Description
   ,Disabled
   ,Editable
   ,ElementId
   ,Frozen
   ,Generated
   ,Imported
   ,LogicalName
   ,MetadataSignature
   ,Name
   ,Note
   ,NOTM
   ,Persistent
   ,Seeded
   ,UOID
   ,UpdatedBy
   ,UpdateTimestamp
   ,Version, isLoadingParent
) as select
    WorkspaceID,
    LoadingParent,
    DeletionParent,
    s2_1
   ,s2_2
   ,b_1
   ,s1_1
   ,d_1
   ,b_2
   ,b_3
   ,b_4
   ,s3_1
   ,b_5
   ,b_6
   ,i_1
   ,b_7
   ,b_8
   ,b_9
   ,s4_1
   ,s2_3
   ,s2_4
   ,s3_3
   ,i_2
   ,b_10
   ,b_11
   ,s2_5
   ,s1_2
   ,d_2
   ,s1_3
   ,b_12
from CMPMMMClasses
where s2_2 in (
          'InterestSet'
         ,'DummyInterestSet'
         ,'PublicAPISet'
         ,'VerticalTree'
) and (workspaceid = 1
   or  workspaceid = (select sys_context('owb_workspace','workspaceID') from dual)
);
create or replace view DummyInterestSet_V
(
    WorkspaceID,
    LoadingParent,
    DeletionParent,
    AggregatedSignature
   ,ClassName
   ,Completed
   ,CreatedBy
   ,CreationTimestamp
   ,CustomerDeletable
   ,CustomerEditable
   ,CustomerRenamable
   ,Description
   ,Disabled
   ,Editable
   ,ElementId
   ,Frozen
   ,Generated
   ,Imported
   ,LogicalName
   ,MetadataSignature
   ,Name
   ,Note
   ,NOTM
   ,Persistent
   ,Seeded
   ,UOID
   ,UpdatedBy
   ,UpdateTimestamp
   ,Version, isLoadingParent
) as select
    WorkspaceID,
    LoadingParent,
    DeletionParent,
    s2_1
   ,s2_2
   ,b_1
   ,s1_1
   ,d_1
   ,b_2
   ,b_3
   ,b_4
   ,s3_1
   ,b_5
   ,b_6
   ,i_1
   ,b_7
   ,b_8
   ,b_9
   ,s4_1
   ,s2_3
   ,s2_4
   ,s3_3
   ,i_2
   ,b_10
   ,b_11
   ,s2_5
   ,s1_2
   ,d_2
   ,s1_3
   ,b_12
from CMPMMMClasses
where s2_2 in (
          'DummyInterestSet'
) and (workspaceid = 1
   or  workspaceid = (select sys_context('owb_workspace','workspaceID') from dual)
);
create or replace view VerticalTree_V
(
    WorkspaceID,
    LoadingParent,
    DeletionParent,
    AggregatedSignature
   ,ClassName
   ,Completed
   ,CreatedBy
   ,CreationTimestamp
   ,CustomerDeletable
   ,CustomerEditable
   ,CustomerRenamable
   ,Description
   ,Disabled
   ,Editable
   ,ElementId
   ,Frozen
   ,Generated
   ,Imported
   ,LogicalName
   ,MetadataSignature
   ,Name
   ,Note
   ,NOTM
   ,Persistent
   ,Seeded
   ,UOID
   ,UpdatedBy
   ,UpdateTimestamp
   ,Version, isLoadingParent
) as select
    WorkspaceID,
    LoadingParent,
    DeletionParent,
    s2_1
   ,s2_2
   ,b_1
   ,s1_1
   ,d_1
   ,b_2
   ,b_3
   ,b_4
   ,s3_1
   ,b_5
   ,b_6
   ,i_1
   ,b_7
   ,b_8
   ,b_9
   ,s4_1
   ,s2_3
   ,s2_4
   ,s3_3
   ,i_2
   ,b_10
   ,b_11
   ,s2_5
   ,s1_2
   ,d_2
   ,s1_3
   ,b_12
from CMPMMMClasses
where s2_2 in (
          'VerticalTree'
) and (workspaceid = 1
   or  workspaceid = (select sys_context('owb_workspace','workspaceID') from dual)
);
create or replace view PublicAPISet_V
(
    WorkspaceID,
    LoadingParent,
    DeletionParent,
    AggregatedSignature
   ,ClassName
   ,Completed
   ,CreatedBy
   ,CreationTimestamp
   ,CustomerDeletable
   ,CustomerEditable
   ,CustomerRenamable
   ,Description
   ,Disabled
   ,Editable
   ,ElementId
   ,Frozen
   ,Generated
   ,Imported
   ,LogicalName
   ,MetadataSignature
   ,Name
   ,Note
   ,NOTM
   ,Persistent
   ,Seeded
   ,UOID
   ,UpdatedBy
   ,UpdateTimestamp
   ,Version, isLoadingParent
) as select
    WorkspaceID,
    LoadingParent,
    DeletionParent,
    s2_1
   ,s2_2
   ,b_1
   ,s1_1
   ,d_1
   ,b_2
   ,b_3
   ,b_4
   ,s3_1
   ,b_5
   ,b_6
   ,i_1
   ,b_7
   ,b_8
   ,b_9
   ,s4_1
   ,s2_3
   ,s2_4
   ,s3_3
   ,i_2
   ,b_10
   ,b_11
   ,s2_5
   ,s1_2
   ,d_2
   ,s1_3
   ,b_12
from CMPMMMClasses
where s2_2 in (
          'PublicAPISet'
) and (workspaceid = 1
   or  workspaceid = (select sys_context('owb_workspace','workspaceID') from dual)
);
create or replace view InterestUsage_V
(
    WorkspaceID,
    LoadingParent,
    DeletionParent,
    AggregatedSignature
   ,ClassName
   ,Completed
   ,CreatedBy
   ,CreationTimestamp
   ,CustomerDeletable
   ,CustomerEditable
   ,CustomerRenamable
   ,Description
   ,Disabled
   ,Editable
   ,ElementId
   ,Frozen
   ,Generated
   ,Imported
   ,LogicalName
   ,MetadataSignature
   ,Name
   ,Note
   ,NOTM
   ,Persistent
   ,Seeded
   ,UOID
   ,UpdatedBy
   ,UpdateTimestamp
   ,Version, isLoadingParent
   ,InterestSet
   ,InterestingObject
) as select
    WorkspaceID,
    LoadingParent,
    DeletionParent,
    s2_1
   ,s2_2
   ,b_1
   ,s1_1
   ,d_1
   ,b_2
   ,b_3
   ,b_4
   ,s3_1
   ,b_5
   ,b_6
   ,i_1
   ,b_7
   ,b_8
   ,b_9
   ,s4_1
   ,s2_3
   ,s2_4
   ,s3_3
   ,i_2
   ,b_10
   ,b_11
   ,s2_5
   ,s1_2
   ,d_2
   ,s1_3
   ,b_12
   ,r_1
   ,r_2
from CMPMMMClasses
where s2_2 in (
          'InterestUsage'
         ,'DummyInterestUsage'
         ,'DefinitionInterestUsage'
         ,'TreeNode'
) and (workspaceid = 1
   or  workspaceid = (select sys_context('owb_workspace','workspaceID') from dual)
);
create or replace view DummyInterestUsage_V
(
    WorkspaceID,
    LoadingParent,
    DeletionParent,
    AggregatedSignature
   ,ClassName
   ,Completed
   ,CreatedBy
   ,CreationTimestamp
   ,CustomerDeletable
   ,CustomerEditable
   ,CustomerRenamable
   ,Description
   ,Disabled
   ,Editable
   ,ElementId
   ,Frozen
   ,Generated
   ,Imported
   ,LogicalName
   ,MetadataSignature
   ,Name
   ,Note
   ,NOTM
   ,Persistent
   ,Seeded
   ,UOID
   ,UpdatedBy
   ,UpdateTimestamp
   ,Version, isLoadingParent
   ,InterestSet
   ,InterestingObject
) as select
    WorkspaceID,
    LoadingParent,
    DeletionParent,
    s2_1
   ,s2_2
   ,b_1
   ,s1_1
   ,d_1
   ,b_2
   ,b_3
   ,b_4
   ,s3_1
   ,b_5
   ,b_6
   ,i_1
   ,b_7
   ,b_8
   ,b_9
   ,s4_1
   ,s2_3
   ,s2_4
   ,s3_3
   ,i_2
   ,b_10
   ,b_11
   ,s2_5
   ,s1_2
   ,d_2
   ,s1_3
   ,b_12
   ,r_1
   ,r_2
from CMPMMMClasses
where s2_2 in (
          'DummyInterestUsage'
) and (workspaceid = 1
   or  workspaceid = (select sys_context('owb_workspace','workspaceID') from dual)
);
create or replace view TreeNode_V
(
    WorkspaceID,
    LoadingParent,
    DeletionParent,
    AggregatedSignature
   ,ClassName
   ,Completed
   ,CreatedBy
   ,CreationTimestamp
   ,CustomerDeletable
   ,CustomerEditable
   ,CustomerRenamable
   ,Description
   ,Disabled
   ,Editable
   ,ElementId
   ,Frozen
   ,Generated
   ,Imported
   ,LogicalName
   ,MetadataSignature
   ,Name
   ,Note
   ,NOTM
   ,Persistent
   ,Seeded
   ,UOID
   ,UpdatedBy
   ,UpdateTimestamp
   ,Version, isLoadingParent
   ,InterestSet
   ,InterestingObject
   ,isRoot
   ,parentNode
   ,realTreeNode
) as select
    WorkspaceID,
    LoadingParent,
    DeletionParent,
    s2_1
   ,s2_2
   ,b_1
   ,s1_1
   ,d_1
   ,b_2
   ,b_3
   ,b_4
   ,s3_1
   ,b_5
   ,b_6
   ,i_1
   ,b_7
   ,b_8
   ,b_9
   ,s4_1
   ,s2_3
   ,s2_4
   ,s3_3
   ,i_2
   ,b_10
   ,b_11
   ,s2_5
   ,s1_2
   ,d_2
   ,s1_3
   ,b_12
   ,r_1
   ,r_2
   ,b_13
   ,r_3
   ,r_4
from CMPMMMClasses
where s2_2 in (
          'TreeNode'
) and (workspaceid = 1
   or  workspaceid = (select sys_context('owb_workspace','workspaceID') from dual)
);
create or replace view DefinitionInterestUsage_V
(
    WorkspaceID,
    LoadingParent,
    DeletionParent,
    AggregatedSignature
   ,ClassName
   ,Completed
   ,CreatedBy
   ,CreationTimestamp
   ,CustomerDeletable
   ,CustomerEditable
   ,CustomerRenamable
   ,Description
   ,Disabled
   ,Editable
   ,ElementId
   ,Frozen
   ,Generated
   ,Imported
   ,LogicalName
   ,MetadataSignature
   ,Name
   ,Note
   ,NOTM
   ,Persistent
   ,Seeded
   ,UOID
   ,UpdatedBy
   ,UpdateTimestamp
   ,Version, isLoadingParent
   ,InterestSet
   ,InterestingObject
   ,targetType
   ,parentInterest
   ,scriptName
   ,publicWeaklyTyped
   ,realInterestUsage
) as select
    WorkspaceID,
    LoadingParent,
    DeletionParent,
    s2_1
   ,s2_2
   ,b_1
   ,s1_1
   ,d_1
   ,b_2
   ,b_3
   ,b_4
   ,s3_1
   ,b_5
   ,b_6
   ,i_1
   ,b_7
   ,b_8
   ,b_9
   ,s4_1
   ,s2_3
   ,s2_4
   ,s3_3
   ,i_2
   ,b_10
   ,b_11
   ,s2_5
   ,s1_2
   ,d_2
   ,s1_3
   ,b_12
   ,r_1
   ,r_2
   ,i_3
   ,r_3
   ,s2_6
   ,b_13
   ,r_4
from CMPMMMClasses
where s2_2 in (
          'DefinitionInterestUsage'
) and (workspaceid = 1
   or  workspaceid = (select sys_context('owb_workspace','workspaceID') from dual)
);
create or replace view PropertyGroupDefinition_V
(
    WorkspaceID,
    LoadingParent,
    DeletionParent,
    AggregatedSignature
   ,ClassName
   ,Completed
   ,CreatedBy
   ,CreationTimestamp
   ,CustomerDeletable
   ,CustomerEditable
   ,CustomerRenamable
   ,Description
   ,Disabled
   ,Editable
   ,ElementId
   ,Frozen
   ,Generated
   ,Imported
   ,LogicalName
   ,MetadataSignature
   ,Name
   ,Note
   ,NOTM
   ,Persistent
   ,Seeded
   ,UOID
   ,UpdatedBy
   ,UpdateTimestamp
   ,Version, isLoadingParent
   ,definitionKey
   ,hidden
   ,groupOwner
) as select
    WorkspaceID,
    LoadingParent,
    DeletionParent,
    s2_1
   ,s2_2
   ,b_1
   ,s1_1
   ,d_1
   ,b_2
   ,b_3
   ,b_4
   ,s3_1
   ,b_5
   ,b_6
   ,i_1
   ,b_7
   ,b_8
   ,b_9
   ,s4_1
   ,s2_3
   ,s2_4
   ,s3_3
   ,i_2
   ,b_10
   ,b_11
   ,s2_5
   ,s1_2
   ,d_2
   ,s1_3
   ,b_12
   ,s2_6
   ,b_13
   ,r_1
from CMPMMMClasses
where s2_2 in (
          'PropertyGroupDefinition'
) and (workspaceid = 1
   or  workspaceid = (select sys_context('owb_workspace','workspaceID') from dual)
);
create or replace view PropertySetDefinition_V
(
    WorkspaceID,
    LoadingParent,
    DeletionParent,
    AggregatedSignature
   ,ClassName
   ,Completed
   ,CreatedBy
   ,CreationTimestamp
   ,CustomerDeletable
   ,CustomerEditable
   ,CustomerRenamable
   ,Description
   ,Disabled
   ,Editable
   ,ElementId
   ,Frozen
   ,Generated
   ,Imported
   ,LogicalName
   ,MetadataSignature
   ,Name
   ,Note
   ,NOTM
   ,Persistent
   ,Seeded
   ,UOID
   ,UpdatedBy
   ,UpdateTimestamp
   ,Version, isLoadingParent
   ,definitionKey
   ,classDefinition
   ,propertyType
   ,parentPropertySetDefinition
   ,parentClassDefinition
   ,superPropertySetDefinition
   ,superClassDefinition
   ,realPropertySetDefinition
) as select
    WorkspaceID,
    LoadingParent,
    DeletionParent,
    s2_1
   ,s2_2
   ,b_1
   ,s1_1
   ,d_1
   ,b_2
   ,b_3
   ,b_4
   ,s3_1
   ,b_5
   ,b_6
   ,i_1
   ,b_7
   ,b_8
   ,b_9
   ,s4_1
   ,s2_3
   ,s2_4
   ,s3_3
   ,i_2
   ,b_10
   ,b_11
   ,s2_5
   ,s1_2
   ,d_2
   ,s1_3
   ,b_12
   ,s2_6
   ,r_1
   ,i_3
   ,r_2
   ,r_3
   ,r_4
   ,r_5
   ,r_6
from CMPMMMClasses
where s2_2 in (
          'PropertySetDefinition'
) and (workspaceid = 1
   or  workspaceid = (select sys_context('owb_workspace','workspaceID') from dual)
);
create or replace view PropertyUsageChoice_V
(
    WorkspaceID,
    LoadingParent,
    DeletionParent,
    AggregatedSignature
   ,ClassName
   ,Completed
   ,CreatedBy
   ,CreationTimestamp
   ,CustomerDeletable
   ,CustomerEditable
   ,CustomerRenamable
   ,Description
   ,Disabled
   ,Editable
   ,ElementId
   ,Frozen
   ,Generated
   ,Imported
   ,LogicalName
   ,MetadataSignature
   ,Name
   ,Note
   ,NOTM
   ,Persistent
   ,Seeded
   ,UOID
   ,UpdatedBy
   ,UpdateTimestamp
   ,Version, isLoadingParent
   ,choice
   ,propertyUsageDefinition
) as select
    WorkspaceID,
    LoadingParent,
    DeletionParent,
    s2_1
   ,s2_2
   ,b_1
   ,s1_1
   ,d_1
   ,b_2
   ,b_3
   ,b_4
   ,s3_1
   ,b_5
   ,b_6
   ,i_1
   ,b_7
   ,b_8
   ,b_9
   ,s4_1
   ,s2_3
   ,s2_4
   ,s3_3
   ,i_2
   ,b_10
   ,b_11
   ,s2_5
   ,s1_2
   ,d_2
   ,s1_3
   ,b_12
   ,s2_6
   ,r_1
from CMPMMMClasses
where s2_2 in (
          'PropertyUsageChoice'
) and (workspaceid = 1
   or  workspaceid = (select sys_context('owb_workspace','workspaceID') from dual)
);
create or replace view PropertyUsageDefinition_V
(
    WorkspaceID,
    LoadingParent,
    DeletionParent,
    AggregatedSignature
   ,ClassName
   ,Completed
   ,CreatedBy
   ,CreationTimestamp
   ,CustomerDeletable
   ,CustomerEditable
   ,CustomerRenamable
   ,Description
   ,Disabled
   ,Editable
   ,ElementId
   ,Frozen
   ,Generated
   ,Imported
   ,LogicalName
   ,MetadataSignature
   ,Name
   ,Note
   ,NOTM
   ,Persistent
   ,Seeded
   ,UOID
   ,UpdatedBy
   ,UpdateTimestamp
   ,Version, isLoadingParent
   ,propertySetDefinition
   ,propertyDefinition
   ,definitionKey
) as select
    WorkspaceID,
    LoadingParent,
    DeletionParent,
    s2_1
   ,s2_2
   ,b_1
   ,s1_1
   ,d_1
   ,b_2
   ,b_3
   ,b_4
   ,s3_1
   ,b_5
   ,b_6
   ,i_1
   ,b_7
   ,b_8
   ,b_9
   ,s4_1
   ,s2_3
   ,s2_4
   ,s3_3
   ,i_2
   ,b_10
   ,b_11
   ,s2_5
   ,s1_2
   ,d_2
   ,s1_3
   ,b_12
   ,r_1
   ,r_2
   ,s2_6
from CMPMMMClasses
where s2_2 in (
          'PropertyUsageDefinition'
) and (workspaceid = 1
   or  workspaceid = (select sys_context('owb_workspace','workspaceID') from dual)
);
create or replace view RoleDefinition_V
(
    WorkspaceID,
    LoadingParent,
    DeletionParent,
    AggregatedSignature
   ,ClassName
   ,Completed
   ,CreatedBy
   ,CreationTimestamp
   ,CustomerDeletable
   ,CustomerEditable
   ,CustomerRenamable
   ,Description
   ,Disabled
   ,Editable
   ,ElementId
   ,Frozen
   ,Generated
   ,Imported
   ,LogicalName
   ,MetadataSignature
   ,Name
   ,Note
   ,NOTM
   ,Persistent
   ,Seeded
   ,UOID
   ,UpdatedBy
   ,UpdateTimestamp
   ,Version, isLoadingParent
   ,aggregate
   ,navigable
   ,minCardinality
   ,maxCardinality
   ,propertyDefinition
   ,classDefinition
   ,associationDefinition
) as select
    WorkspaceID,
    LoadingParent,
    DeletionParent,
    s2_1
   ,s2_2
   ,b_1
   ,s1_1
   ,d_1
   ,b_2
   ,b_3
   ,b_4
   ,s3_1
   ,b_5
   ,b_6
   ,i_1
   ,b_7
   ,b_8
   ,b_9
   ,s4_1
   ,s2_3
   ,s2_4
   ,s3_3
   ,i_2
   ,b_10
   ,b_11
   ,s2_5
   ,s1_2
   ,d_2
   ,s1_3
   ,b_12
   ,b_13
   ,b_14
   ,i_3
   ,i_4
   ,r_1
   ,r_2
   ,r_3
from CMPMMMClasses
where s2_2 in (
          'RoleDefinition'
) and (workspaceid = 1
   or  workspaceid = (select sys_context('owb_workspace','workspaceID') from dual)
);
create or replace view WBAbstractType_V
(
    WorkspaceID,
    LoadingParent,
    DeletionParent,
    AggregatedSignature
   ,ClassName
   ,Completed
   ,CreatedBy
   ,CreationTimestamp
   ,CustomerDeletable
   ,CustomerEditable
   ,CustomerRenamable
   ,Description
   ,Disabled
   ,Editable
   ,ElementId
   ,Frozen
   ,Generated
   ,Imported
   ,LogicalName
   ,MetadataSignature
   ,Name
   ,Note
   ,NOTM
   ,Persistent
   ,Seeded
   ,UOID
   ,UpdatedBy
   ,UpdateTimestamp
   ,Version, isLoadingParent
   ,Comparator
) as select
    WorkspaceID,
    LoadingParent,
    DeletionParent,
    s2_1
   ,s2_2
   ,b_1
   ,s1_1
   ,d_1
   ,b_2
   ,b_3
   ,b_4
   ,s3_1
   ,b_5
   ,b_6
   ,i_1
   ,b_7
   ,b_8
   ,b_9
   ,s4_1
   ,s2_3
   ,s2_4
   ,s3_3
   ,i_2
   ,b_10
   ,b_11
   ,s2_5
   ,s1_2
   ,d_2
   ,s1_3
   ,b_12
   ,s2_6
from CMPMMMClasses
where s2_2 in (
          'WBAbstractType'
         ,'WBCollectionType'
         ,'WBScalarType'
         ,'WBExtensibleType'
         ,'WBArrayType'
         ,'WBPrimitiveType'
         ,'WBDomain'
         ,'ClassDefinition'
) and (workspaceid = 1
   or  workspaceid = (select sys_context('owb_workspace','workspaceID') from dual)
);
create or replace view WBScalarType_V
(
    WorkspaceID,
    LoadingParent,
    DeletionParent,
    AggregatedSignature
   ,ClassName
   ,Completed
   ,CreatedBy
   ,CreationTimestamp
   ,CustomerDeletable
   ,CustomerEditable
   ,CustomerRenamable
   ,Description
   ,Disabled
   ,Editable
   ,ElementId
   ,Frozen
   ,Generated
   ,Imported
   ,LogicalName
   ,MetadataSignature
   ,Name
   ,Note
   ,NOTM
   ,Persistent
   ,Seeded
   ,UOID
   ,UpdatedBy
   ,UpdateTimestamp
   ,Version, isLoadingParent
   ,Comparator
) as select
    WorkspaceID,
    LoadingParent,
    DeletionParent,
    s2_1
   ,s2_2
   ,b_1
   ,s1_1
   ,d_1
   ,b_2
   ,b_3
   ,b_4
   ,s3_1
   ,b_5
   ,b_6
   ,i_1
   ,b_7
   ,b_8
   ,b_9
   ,s4_1
   ,s2_3
   ,s2_4
   ,s3_3
   ,i_2
   ,b_10
   ,b_11
   ,s2_5
   ,s1_2
   ,d_2
   ,s1_3
   ,b_12
   ,s2_6
from CMPMMMClasses
where s2_2 in (
          'WBPrimitiveType'
         ,'WBDomain'
         ,'WBScalarType'
         ,'ClassDefinition'
) and (workspaceid = 1
   or  workspaceid = (select sys_context('owb_workspace','workspaceID') from dual)
);
create or replace view WBPrimitiveType_V
(
    WorkspaceID,
    LoadingParent,
    DeletionParent,
    AggregatedSignature
   ,ClassName
   ,Completed
   ,CreatedBy
   ,CreationTimestamp
   ,CustomerDeletable
   ,CustomerEditable
   ,CustomerRenamable
   ,Description
   ,Disabled
   ,Editable
   ,ElementId
   ,Frozen
   ,Generated
   ,Imported
   ,LogicalName
   ,MetadataSignature
   ,Name
   ,Note
   ,NOTM
   ,Persistent
   ,Seeded
   ,UOID
   ,UpdatedBy
   ,UpdateTimestamp
   ,Version, isLoadingParent
   ,Comparator
   ,Formator
) as select
    WorkspaceID,
    LoadingParent,
    DeletionParent,
    s2_1
   ,s2_2
   ,b_1
   ,s1_1
   ,d_1
   ,b_2
   ,b_3
   ,b_4
   ,s3_1
   ,b_5
   ,b_6
   ,i_1
   ,b_7
   ,b_8
   ,b_9
   ,s4_1
   ,s2_3
   ,s2_4
   ,s3_3
   ,i_2
   ,b_10
   ,b_11
   ,s2_5
   ,s1_2
   ,d_2
   ,s1_3
   ,b_12
   ,s2_6
   ,s2_7
from CMPMMMClasses
where s2_2 in (
          'WBPrimitiveType'
) and (workspaceid = 1
   or  workspaceid = (select sys_context('owb_workspace','workspaceID') from dual)
);
create or replace view WBDomain_V
(
    WorkspaceID,
    LoadingParent,
    DeletionParent,
    AggregatedSignature
   ,ClassName
   ,Completed
   ,CreatedBy
   ,CreationTimestamp
   ,CustomerDeletable
   ,CustomerEditable
   ,CustomerRenamable
   ,Description
   ,Disabled
   ,Editable
   ,ElementId
   ,Frozen
   ,Generated
   ,Imported
   ,LogicalName
   ,MetadataSignature
   ,Name
   ,Note
   ,NOTM
   ,Persistent
   ,Seeded
   ,UOID
   ,UpdatedBy
   ,UpdateTimestamp
   ,Version, isLoadingParent
   ,Comparator
   ,DataType
) as select
    WorkspaceID,
    LoadingParent,
    DeletionParent,
    s2_1
   ,s2_2
   ,b_1
   ,s1_1
   ,d_1
   ,b_2
   ,b_3
   ,b_4
   ,s3_1
   ,b_5
   ,b_6
   ,i_1
   ,b_7
   ,b_8
   ,b_9
   ,s4_1
   ,s2_3
   ,s2_4
   ,s3_3
   ,i_2
   ,b_10
   ,b_11
   ,s2_5
   ,s1_2
   ,d_2
   ,s1_3
   ,b_12
   ,s2_6
   ,r_1
from CMPMMMClasses
where s2_2 in (
          'WBDomain'
) and (workspaceid = 1
   or  workspaceid = (select sys_context('owb_workspace','workspaceID') from dual)
);
create or replace view WBCollectionType_V
(
    WorkspaceID,
    LoadingParent,
    DeletionParent,
    AggregatedSignature
   ,ClassName
   ,Completed
   ,CreatedBy
   ,CreationTimestamp
   ,CustomerDeletable
   ,CustomerEditable
   ,CustomerRenamable
   ,Description
   ,Disabled
   ,Editable
   ,ElementId
   ,Frozen
   ,Generated
   ,Imported
   ,LogicalName
   ,MetadataSignature
   ,Name
   ,Note
   ,NOTM
   ,Persistent
   ,Seeded
   ,UOID
   ,UpdatedBy
   ,UpdateTimestamp
   ,Version, isLoadingParent
   ,Comparator
) as select
    WorkspaceID,
    LoadingParent,
    DeletionParent,
    s2_1
   ,s2_2
   ,b_1
   ,s1_1
   ,d_1
   ,b_2
   ,b_3
   ,b_4
   ,s3_1
   ,b_5
   ,b_6
   ,i_1
   ,b_7
   ,b_8
   ,b_9
   ,s4_1
   ,s2_3
   ,s2_4
   ,s3_3
   ,i_2
   ,b_10
   ,b_11
   ,s2_5
   ,s1_2
   ,d_2
   ,s1_3
   ,b_12
   ,s2_6
from CMPMMMClasses
where s2_2 in (
          'WBCollectionType'
         ,'WBExtensibleType'
         ,'WBArrayType'
) and (workspaceid = 1
   or  workspaceid = (select sys_context('owb_workspace','workspaceID') from dual)
);
create or replace view WBArrayType_V
(
    WorkspaceID,
    LoadingParent,
    DeletionParent,
    AggregatedSignature
   ,ClassName
   ,Completed
   ,CreatedBy
   ,CreationTimestamp
   ,CustomerDeletable
   ,CustomerEditable
   ,CustomerRenamable
   ,Description
   ,Disabled
   ,Editable
   ,ElementId
   ,Frozen
   ,Generated
   ,Imported
   ,LogicalName
   ,MetadataSignature
   ,Name
   ,Note
   ,NOTM
   ,Persistent
   ,Seeded
   ,UOID
   ,UpdatedBy
   ,UpdateTimestamp
   ,Version, isLoadingParent
   ,Comparator
   ,baseElementType
) as select
    WorkspaceID,
    LoadingParent,
    DeletionParent,
    s2_1
   ,s2_2
   ,b_1
   ,s1_1
   ,d_1
   ,b_2
   ,b_3
   ,b_4
   ,s3_1
   ,b_5
   ,b_6
   ,i_1
   ,b_7
   ,b_8
   ,b_9
   ,s4_1
   ,s2_3
   ,s2_4
   ,s3_3
   ,i_2
   ,b_10
   ,b_11
   ,s2_5
   ,s1_2
   ,d_2
   ,s1_3
   ,b_12
   ,s2_6
   ,r_1
from CMPMMMClasses
where s2_2 in (
          'WBArrayType'
) and (workspaceid = 1
   or  workspaceid = (select sys_context('owb_workspace','workspaceID') from dual)
);
create or replace view WBExtensibleType_V
(
    WorkspaceID,
    LoadingParent,
    DeletionParent,
    AggregatedSignature
   ,ClassName
   ,Completed
   ,CreatedBy
   ,CreationTimestamp
   ,CustomerDeletable
   ,CustomerEditable
   ,CustomerRenamable
   ,Description
   ,Disabled
   ,Editable
   ,ElementId
   ,Frozen
   ,Generated
   ,Imported
   ,LogicalName
   ,MetadataSignature
   ,Name
   ,Note
   ,NOTM
   ,Persistent
   ,Seeded
   ,UOID
   ,UpdatedBy
   ,UpdateTimestamp
   ,Version, isLoadingParent
   ,Comparator
   ,classDefinition
) as select
    WorkspaceID,
    LoadingParent,
    DeletionParent,
    s2_1
   ,s2_2
   ,b_1
   ,s1_1
   ,d_1
   ,b_2
   ,b_3
   ,b_4
   ,s3_1
   ,b_5
   ,b_6
   ,i_1
   ,b_7
   ,b_8
   ,b_9
   ,s4_1
   ,s2_3
   ,s2_4
   ,s3_3
   ,i_2
   ,b_10
   ,b_11
   ,s2_5
   ,s1_2
   ,d_2
   ,s1_3
   ,b_12
   ,s2_6
   ,r_1
from CMPMMMClasses
where s2_2 in (
          'WBExtensibleType'
) and (workspaceid = 1
   or  workspaceid = (select sys_context('owb_workspace','workspaceID') from dual)
);
create or replace view WBRange_V
(
    WorkspaceID,
    LoadingParent,
    DeletionParent,
    AggregatedSignature
   ,ClassName
   ,Completed
   ,CreatedBy
   ,CreationTimestamp
   ,CustomerDeletable
   ,CustomerEditable
   ,CustomerRenamable
   ,Description
   ,Disabled
   ,Editable
   ,ElementId
   ,Frozen
   ,Generated
   ,Imported
   ,LogicalName
   ,MetadataSignature
   ,Name
   ,Note
   ,NOTM
   ,Persistent
   ,Seeded
   ,UOID
   ,UpdatedBy
   ,UpdateTimestamp
   ,Version, isLoadingParent
   ,Domain
   ,minValueInclusive
   ,maxValueInclusive
) as select
    WorkspaceID,
    LoadingParent,
    DeletionParent,
    s2_1
   ,s2_2
   ,b_1
   ,s1_1
   ,d_1
   ,b_2
   ,b_3
   ,b_4
   ,s3_1
   ,b_5
   ,b_6
   ,i_1
   ,b_7
   ,b_8
   ,b_9
   ,s4_1
   ,s2_3
   ,s2_4
   ,s3_3
   ,i_2
   ,b_10
   ,b_11
   ,s2_5
   ,s1_2
   ,d_2
   ,s1_3
   ,b_12
   ,r_1
   ,b_13
   ,b_14
from CMPMMMClasses
where s2_2 in (
          'WBRange'
) and (workspaceid = 1
   or  workspaceid = (select sys_context('owb_workspace','workspaceID') from dual)
);
create or replace view WBProperty_V
(
    WorkspaceID,
    LoadingParent,
    DeletionParent,
    AggregatedSignature
   ,ClassName
   ,Completed
   ,CreatedBy
   ,CreationTimestamp
   ,CustomerDeletable
   ,CustomerEditable
   ,CustomerRenamable
   ,Description
   ,Disabled
   ,Editable
   ,ElementId
   ,Frozen
   ,Generated
   ,Imported
   ,LogicalName
   ,MetadataSignature
   ,Name
   ,Note
   ,NOTM
   ,Persistent
   ,Seeded
   ,UOID
   ,UpdatedBy
   ,UpdateTimestamp
   ,Version, isLoadingParent
   ,owner
   ,dataType
   ,position
   ,hasName
   ,hasPosition
) as select
    WorkspaceID,
    LoadingParent,
    DeletionParent,
    s2_1
   ,s2_2
   ,b_1
   ,s1_1
   ,d_1
   ,b_2
   ,b_3
   ,b_4
   ,s3_1
   ,b_5
   ,b_6
   ,i_1
   ,b_7
   ,b_8
   ,b_9
   ,s4_1
   ,s2_3
   ,s2_4
   ,s3_3
   ,i_2
   ,b_10
   ,b_11
   ,s2_5
   ,s1_2
   ,d_2
   ,s1_3
   ,b_12
   ,r_1
   ,r_2
   ,i_3
   ,b_13
   ,b_14
from CMPMMMClasses
where s2_2 in (
          'WBProperty'
         ,'WBArrayProperty'
         ,'WBScalarProperty'
         ,'WBPrimitiveProperty'
         ,'WBCollectionProperty'
         ,'WBReferenceProperty'
) and (workspaceid = 1
   or  workspaceid = (select sys_context('owb_workspace','workspaceID') from dual)
);
create or replace view WBCollectionProperty_V
(
    WorkspaceID,
    LoadingParent,
    DeletionParent,
    AggregatedSignature
   ,ClassName
   ,Completed
   ,CreatedBy
   ,CreationTimestamp
   ,CustomerDeletable
   ,CustomerEditable
   ,CustomerRenamable
   ,Description
   ,Disabled
   ,Editable
   ,ElementId
   ,Frozen
   ,Generated
   ,Imported
   ,LogicalName
   ,MetadataSignature
   ,Name
   ,Note
   ,NOTM
   ,Persistent
   ,Seeded
   ,UOID
   ,UpdatedBy
   ,UpdateTimestamp
   ,Version, isLoadingParent
   ,owner
   ,dataType
   ,position
   ,hasName
   ,hasPosition
) as select
    WorkspaceID,
    LoadingParent,
    DeletionParent,
    s2_1
   ,s2_2
   ,b_1
   ,s1_1
   ,d_1
   ,b_2
   ,b_3
   ,b_4
   ,s3_1
   ,b_5
   ,b_6
   ,i_1
   ,b_7
   ,b_8
   ,b_9
   ,s4_1
   ,s2_3
   ,s2_4
   ,s3_3
   ,i_2
   ,b_10
   ,b_11
   ,s2_5
   ,s1_2
   ,d_2
   ,s1_3
   ,b_12
   ,r_1
   ,r_2
   ,i_3
   ,b_13
   ,b_14
from CMPMMMClasses
where s2_2 in (
          'WBCollectionProperty'
         ,'WBArrayProperty'
) and (workspaceid = 1
   or  workspaceid = (select sys_context('owb_workspace','workspaceID') from dual)
);
create or replace view WBArrayProperty_V
(
    WorkspaceID,
    LoadingParent,
    DeletionParent,
    AggregatedSignature
   ,ClassName
   ,Completed
   ,CreatedBy
   ,CreationTimestamp
   ,CustomerDeletable
   ,CustomerEditable
   ,CustomerRenamable
   ,Description
   ,Disabled
   ,Editable
   ,ElementId
   ,Frozen
   ,Generated
   ,Imported
   ,LogicalName
   ,MetadataSignature
   ,Name
   ,Note
   ,NOTM
   ,Persistent
   ,Seeded
   ,UOID
   ,UpdatedBy
   ,UpdateTimestamp
   ,Version, isLoadingParent
   ,owner
   ,dataType
   ,position
   ,hasName
   ,hasPosition
) as select
    WorkspaceID,
    LoadingParent,
    DeletionParent,
    s2_1
   ,s2_2
   ,b_1
   ,s1_1
   ,d_1
   ,b_2
   ,b_3
   ,b_4
   ,s3_1
   ,b_5
   ,b_6
   ,i_1
   ,b_7
   ,b_8
   ,b_9
   ,s4_1
   ,s2_3
   ,s2_4
   ,s3_3
   ,i_2
   ,b_10
   ,b_11
   ,s2_5
   ,s1_2
   ,d_2
   ,s1_3
   ,b_12
   ,r_1
   ,r_2
   ,i_3
   ,b_13
   ,b_14
from CMPMMMClasses
where s2_2 in (
          'WBArrayProperty'
) and (workspaceid = 1
   or  workspaceid = (select sys_context('owb_workspace','workspaceID') from dual)
);
create or replace view WBPrimitiveProperty_V
(
    WorkspaceID,
    LoadingParent,
    DeletionParent,
    AggregatedSignature
   ,ClassName
   ,Completed
   ,CreatedBy
   ,CreationTimestamp
   ,CustomerDeletable
   ,CustomerEditable
   ,CustomerRenamable
   ,Description
   ,Disabled
   ,Editable
   ,ElementId
   ,Frozen
   ,Generated
   ,Imported
   ,LogicalName
   ,MetadataSignature
   ,Name
   ,Note
   ,NOTM
   ,Persistent
   ,Seeded
   ,UOID
   ,UpdatedBy
   ,UpdateTimestamp
   ,Version, isLoadingParent
   ,owner
   ,dataType
   ,position
   ,hasName
   ,hasPosition
   ,value
) as select
    WorkspaceID,
    LoadingParent,
    DeletionParent,
    s2_1
   ,s2_2
   ,b_1
   ,s1_1
   ,d_1
   ,b_2
   ,b_3
   ,b_4
   ,s3_1
   ,b_5
   ,b_6
   ,i_1
   ,b_7
   ,b_8
   ,b_9
   ,s4_1
   ,s2_3
   ,s2_4
   ,s3_3
   ,i_2
   ,b_10
   ,b_11
   ,s2_5
   ,s1_2
   ,d_2
   ,s1_3
   ,b_12
   ,r_1
   ,r_2
   ,i_3
   ,b_13
   ,b_14
   ,s3_4
from CMPMMMClasses
where s2_2 in (
          'WBPrimitiveProperty'
) and (workspaceid = 1
   or  workspaceid = (select sys_context('owb_workspace','workspaceID') from dual)
);
create or replace view WBReferenceProperty_V
(
    WorkspaceID,
    LoadingParent,
    DeletionParent,
    AggregatedSignature
   ,ClassName
   ,Completed
   ,CreatedBy
   ,CreationTimestamp
   ,CustomerDeletable
   ,CustomerEditable
   ,CustomerRenamable
   ,Description
   ,Disabled
   ,Editable
   ,ElementId
   ,Frozen
   ,Generated
   ,Imported
   ,LogicalName
   ,MetadataSignature
   ,Name
   ,Note
   ,NOTM
   ,Persistent
   ,Seeded
   ,UOID
   ,UpdatedBy
   ,UpdateTimestamp
   ,Version, isLoadingParent
   ,owner
   ,dataType
   ,position
   ,hasName
   ,hasPosition
   ,referencedElement
) as select
    WorkspaceID,
    LoadingParent,
    DeletionParent,
    s2_1
   ,s2_2
   ,b_1
   ,s1_1
   ,d_1
   ,b_2
   ,b_3
   ,b_4
   ,s3_1
   ,b_5
   ,b_6
   ,i_1
   ,b_7
   ,b_8
   ,b_9
   ,s4_1
   ,s2_3
   ,s2_4
   ,s3_3
   ,i_2
   ,b_10
   ,b_11
   ,s2_5
   ,s1_2
   ,d_2
   ,s1_3
   ,b_12
   ,r_1
   ,r_2
   ,i_3
   ,b_13
   ,b_14
   ,r_4
from CMPMMMClasses
where s2_2 in (
          'WBReferenceProperty'
) and (workspaceid = 1
   or  workspaceid = (select sys_context('owb_workspace','workspaceID') from dual)
);
create or replace view WBScalarProperty_V
(
    WorkspaceID,
    LoadingParent,
    DeletionParent,
    AggregatedSignature
   ,ClassName
   ,Completed
   ,CreatedBy
   ,CreationTimestamp
   ,CustomerDeletable
   ,CustomerEditable
   ,CustomerRenamable
   ,Description
   ,Disabled
   ,Editable
   ,ElementId
   ,Frozen
   ,Generated
   ,Imported
   ,LogicalName
   ,MetadataSignature
   ,Name
   ,Note
   ,NOTM
   ,Persistent
   ,Seeded
   ,UOID
   ,UpdatedBy
   ,UpdateTimestamp
   ,Version, isLoadingParent
   ,owner
   ,dataType
   ,position
   ,hasName
   ,hasPosition
) as select
    WorkspaceID,
    LoadingParent,
    DeletionParent,
    s2_1
   ,s2_2
   ,b_1
   ,s1_1
   ,d_1
   ,b_2
   ,b_3
   ,b_4
   ,s3_1
   ,b_5
   ,b_6
   ,i_1
   ,b_7
   ,b_8
   ,b_9
   ,s4_1
   ,s2_3
   ,s2_4
   ,s3_3
   ,i_2
   ,b_10
   ,b_11
   ,s2_5
   ,s1_2
   ,d_2
   ,s1_3
   ,b_12
   ,r_1
   ,r_2
   ,i_3
   ,b_13
   ,b_14
from CMPMMMClasses
where s2_2 in (
          'WBScalarProperty'
         ,'WBPrimitiveProperty'
         ,'WBReferenceProperty'
) and (workspaceid = 1
   or  workspaceid = (select sys_context('owb_workspace','workspaceID') from dual)
);
create or replace view DependencyDefinition_V
(
    WorkspaceID,
    LoadingParent,
    DeletionParent,
    AggregatedSignature
   ,ClassName
   ,Completed
   ,CreatedBy
   ,CreationTimestamp
   ,CustomerDeletable
   ,CustomerEditable
   ,CustomerRenamable
   ,Description
   ,Disabled
   ,Editable
   ,ElementId
   ,Frozen
   ,Generated
   ,Imported
   ,LogicalName
   ,MetadataSignature
   ,Name
   ,Note
   ,NOTM
   ,Persistent
   ,Seeded
   ,UOID
   ,UpdatedBy
   ,UpdateTimestamp
   ,Version, isLoadingParent
   ,associationDefinition
   ,sourceRole
   ,biDirectional
   ,sourceComponentType
   ,targetComponentType
) as select
    WorkspaceID,
    LoadingParent,
    DeletionParent,
    s2_1
   ,s2_2
   ,b_1
   ,s1_1
   ,d_1
   ,b_2
   ,b_3
   ,b_4
   ,s3_1
   ,b_5
   ,b_6
   ,i_1
   ,b_7
   ,b_8
   ,b_9
   ,s4_1
   ,s2_3
   ,s2_4
   ,s3_3
   ,i_2
   ,b_10
   ,b_11
   ,s2_5
   ,s1_2
   ,d_2
   ,s1_3
   ,b_12
   ,r_1
   ,r_2
   ,b_13
   ,s2_6
   ,s2_7
from CMPMMMClasses
where s2_2 in (
         'DependencyDefinition'
) and (workspaceid = 1
   or  workspaceid = (select sys_context('owb_workspace','workspaceID') from dual)
);
