create or replace view DefinitionElement_X
(
    WorkspaceID,
    LoadingParent,
    DeletionParent,
    AggregatedSignature
   ,ClassName
   ,Completed
   ,CreatedBy
   ,CreationTimestamp
   ,CustomerDeletable
   ,CustomerEditable
   ,CustomerRenamable
   ,Description
   ,Disabled
   ,Editable
   ,ElementId
   ,Frozen
   ,Generated
   ,Imported
   ,LogicalName
   ,MetadataSignature
   ,Name
   ,Note
   ,NOTM
   ,Persistent
   ,Seeded
   ,UOID
   ,UpdatedBy
   ,UpdateTimestamp
   ,Version, isLoadingParent
   ,SnapshotID
) as select
    WorkspaceID,
    LoadingParent,
    DeletionParent,
    s2_1
   ,s2_2
   ,b_1
   ,s1_1
   ,d_1
   ,b_2
   ,b_3
   ,b_4
   ,s3_1
   ,b_5
   ,b_6
   ,i_1
   ,b_7
   ,b_8
   ,b_9
   ,s4_1
   ,s2_3
   ,s2_4
   ,s3_3
   ,i_2
   ,b_10
   ,b_11
   ,s2_5
   ,s1_2
   ,d_2
   ,s1_3
   ,b_12
   ,SnapshotID
from CMPMMMStorage
where active=0 and s2_2 in (
          'WBAbstractType'
         ,'WBCollectionType'
         ,'WBScalarType'
         ,'WBExtensibleType'
         ,'WBArrayType'
         ,'WBPrimitiveType'
         ,'WBDomain'
         ,'WBRange'
         ,'ClassDefinition'
         ,'PropertyDefinition'
         ,'ClassInheritanceDefinition'
         ,'DefinitionKeyLookupBundle'
         ,'PropertyGroupDefinition'
         ,'PropertySetDefinition'
         ,'PropertyUsageDefinition'
         ,'PropertyUsageChoice'
         ,'AssociationDefinition'
         ,'RoleDefinition'
         ,'ClassUsageDefinition'
         ,'ComponentDefinition'
         ,'DummyInterestSet'
         ,'DummyInterestUsage'
         ,'InterestSet'
         ,'InterestUsage'
         ,'PublicAPISet'
         ,'DefinitionInterestUsage'
         ,'VerticalTree'
         ,'TreeNode'
         ,'WBProperty'
         ,'WBArrayProperty'
         ,'WBCollectionProperty'
         ,'WBScalarProperty'
         ,'WBPrimitiveProperty'
         ,'WBReferenceProperty'
) and (workspaceid = 1
   or  workspaceid = (select sys_context('owb_workspace','workspaceID') from dual)
);
create or replace view LoadingStrategy_X
(
    WorkspaceID
   ,ElementId
   ,ClassName
   ,LoadingParent
) as select
      WorkspaceID
     ,i_1
     ,s2_2
     ,LoadingParent
from CMPMMMStorage
where active=0
  and (workspaceid = 1
   or  workspaceid = (select sys_context('owb_workspace','workspaceID') from dual)
);
create or replace view AssociationDefinition_X
(
    WorkspaceID,
    LoadingParent,
    DeletionParent,
    AggregatedSignature
   ,ClassName
   ,Completed
   ,CreatedBy
   ,CreationTimestamp
   ,CustomerDeletable
   ,CustomerEditable
   ,CustomerRenamable
   ,Description
   ,Disabled
   ,Editable
   ,ElementId
   ,Frozen
   ,Generated
   ,Imported
   ,LogicalName
   ,MetadataSignature
   ,Name
   ,Note
   ,NOTM
   ,Persistent
   ,Seeded
   ,UOID
   ,UpdatedBy
   ,UpdateTimestamp
   ,Version, isLoadingParent
   ,RoleA
   ,RoleAName
   ,ClassA
   ,RoleB
   ,RoleBName
   ,ClassB
   ,AssociationType
   ,Aggregation
   ,WeaklyTyped
   ,SnapshotID
) as select
    WorkspaceID,
    LoadingParent,
    DeletionParent,
    s2_1
   ,s2_2
   ,b_1
   ,s1_1
   ,d_1
   ,b_2
   ,b_3
   ,b_4
   ,s3_1
   ,b_5
   ,b_6
   ,i_1
   ,b_7
   ,b_8
   ,b_9
   ,s4_1
   ,s2_3
   ,s2_4
   ,s3_3
   ,i_2
   ,b_10
   ,b_11
   ,s2_5
   ,s1_2
   ,d_2
   ,s1_3
   ,b_12
   ,r_1
   ,s2_6
   ,r_2
   ,r_3
   ,s2_7
   ,r_4
   ,i_3
   ,b_13
   ,b_14
   ,SnapshotID
from CMPMMMStorage
where active=0 and s2_2 in (
          'AssociationDefinition'
) and (workspaceid = 1
   or  workspaceid = (select sys_context('owb_workspace','workspaceID') from dual)
);
create or replace view ClassDefinition_X
(
    WorkspaceID,
    LoadingParent,
    DeletionParent,
    AggregatedSignature
   ,ClassName
   ,Completed
   ,CreatedBy
   ,CreationTimestamp
   ,CustomerDeletable
   ,CustomerEditable
   ,CustomerRenamable
   ,Description
   ,Disabled
   ,Editable
   ,ElementId
   ,Frozen
   ,Generated
   ,Imported
   ,LogicalName
   ,MetadataSignature
   ,Name
   ,Note
   ,NOTM
   ,Persistent
   ,Seeded
   ,UOID
   ,UpdatedBy
   ,UpdateTimestamp
   ,Version, isLoadingParent
   ,Comparator
   ,Extensible
   ,WeaklyTyped
   ,Stereotype
   ,Generatable
   ,Abstract
   ,PackageName
   ,PropertyParent
   ,ComponentDefinition
   ,ClassPersistent
   ,namespaceParent
   ,namespaceDomain
   ,SnapshotID
) as select
    WorkspaceID,
    LoadingParent,
    DeletionParent,
    s2_1
   ,s2_2
   ,b_1
   ,s1_1
   ,d_1
   ,b_2
   ,b_3
   ,b_4
   ,s3_1
   ,b_5
   ,b_6
   ,i_1
   ,b_7
   ,b_8
   ,b_9
   ,s4_1
   ,s2_3
   ,s2_4
   ,s3_3
   ,i_2
   ,b_10
   ,b_11
   ,s2_5
   ,s1_2
   ,d_2
   ,s1_3
   ,b_12
   ,s2_6
   ,b_13
   ,b_14
   ,i_3
   ,b_15
   ,b_16
   ,s2_7
   ,r_1
   ,r_2
   ,b_17
   ,s2_8
   ,s2_9
   ,SnapshotID
from CMPMMMStorage
where active=0 and s2_2 in (
          'ClassDefinition'
) and (workspaceid = 1
   or  workspaceid = (select sys_context('owb_workspace','workspaceID') from dual)
);
create or replace view PropertyDefinition_X
(
    WorkspaceID,
    LoadingParent,
    DeletionParent,
    AggregatedSignature
   ,ClassName
   ,Completed
   ,CreatedBy
   ,CreationTimestamp
   ,CustomerDeletable
   ,CustomerEditable
   ,CustomerRenamable
   ,Description
   ,Disabled
   ,Editable
   ,ElementId
   ,Frozen
   ,Generated
   ,Imported
   ,LogicalName
   ,MetadataSignature
   ,Name
   ,Note
   ,NOTM
   ,Persistent
   ,Seeded
   ,UOID
   ,UpdatedBy
   ,UpdateTimestamp
   ,Version, isLoadingParent
   ,PropertyType
   ,DefinitionKey
   ,ExportControl
   ,Override
   ,Position
   ,ClassDefinition
   ,DataType
   ,isRole
   ,roleDefinition
   ,translatable
   ,isPassword
   ,hidden
   ,propertyReadOnly
   ,nameChecked
   ,userChoiceAllowed
   ,dynamicDefault
   ,inPlaceEditor
   ,customEditor
   ,propertyGroupDefinition
   ,SnapshotID
) as select
    WorkspaceID,
    LoadingParent,
    DeletionParent,
    s2_1
   ,s2_2
   ,b_1
   ,s1_1
   ,d_1
   ,b_2
   ,b_3
   ,b_4
   ,s3_1
   ,b_5
   ,b_6
   ,i_1
   ,b_7
   ,b_8
   ,b_9
   ,s4_1
   ,s2_3
   ,s2_4
   ,s3_3
   ,i_2
   ,b_10
   ,b_11
   ,s2_5
   ,s1_2
   ,d_2
   ,s1_3
   ,b_12
   ,i_3
   ,s2_6
   ,i_4
   ,b_13
   ,i_5
   ,r_1
   ,r_2
   ,b_14
   ,r_3
   ,b_15
   ,b_16
   ,b_17
   ,b_18
   ,b_19
   ,b_20
   ,s2_7
   ,s2_8
   ,s2_9
   ,r_4
   ,SnapshotID
from CMPMMMStorage
where active=0 and s2_2 in (
          'PropertyDefinition'
) and (workspaceid = 1
   or  workspaceid = (select sys_context('owb_workspace','workspaceID') from dual)
);
create or replace view ClassInheritanceDefinition_X
(
    WorkspaceID,
    LoadingParent,
    DeletionParent,
    AggregatedSignature
   ,ClassName
   ,Completed
   ,CreatedBy
   ,CreationTimestamp
   ,CustomerDeletable
   ,CustomerEditable
   ,CustomerRenamable
   ,Description
   ,Disabled
   ,Editable
   ,ElementId
   ,Frozen
   ,Generated
   ,Imported
   ,LogicalName
   ,MetadataSignature
   ,Name
   ,Note
   ,NOTM
   ,Persistent
   ,Seeded
   ,UOID
   ,UpdatedBy
   ,UpdateTimestamp
   ,Version, isLoadingParent
   ,inheritanceParent
   ,inheritanceChild
   ,SnapshotID
) as select
    WorkspaceID,
    LoadingParent,
    DeletionParent,
    s2_1
   ,s2_2
   ,b_1
   ,s1_1
   ,d_1
   ,b_2
   ,b_3
   ,b_4
   ,s3_1
   ,b_5
   ,b_6
   ,i_1
   ,b_7
   ,b_8
   ,b_9
   ,s4_1
   ,s2_3
   ,s2_4
   ,s3_3
   ,i_2
   ,b_10
   ,b_11
   ,s2_5
   ,s1_2
   ,d_2
   ,s1_3
   ,b_12
   ,r_1
   ,r_2
   ,SnapshotID
from CMPMMMStorage
where active=0 and s2_2 in (
          'ClassInheritanceDefinition'
) and (workspaceid = 1
   or  workspaceid = (select sys_context('owb_workspace','workspaceID') from dual)
);
create or replace view ClassUsageDefinition_X
(
    WorkspaceID,
    LoadingParent,
    DeletionParent,
    AggregatedSignature
   ,ClassName
   ,Completed
   ,CreatedBy
   ,CreationTimestamp
   ,CustomerDeletable
   ,CustomerEditable
   ,CustomerRenamable
   ,Description
   ,Disabled
   ,Editable
   ,ElementId
   ,Frozen
   ,Generated
   ,Imported
   ,LogicalName
   ,MetadataSignature
   ,Name
   ,Note
   ,NOTM
   ,Persistent
   ,Seeded
   ,UOID
   ,UpdatedBy
   ,UpdateTimestamp
   ,Version, isLoadingParent
   ,ComponentDefinition
   ,ClassDefinition
   ,UsageType
   ,SnapshotID
) as select
    WorkspaceID,
    LoadingParent,
    DeletionParent,
    s2_1
   ,s2_2
   ,b_1
   ,s1_1
   ,d_1
   ,b_2
   ,b_3
   ,b_4
   ,s3_1
   ,b_5
   ,b_6
   ,i_1
   ,b_7
   ,b_8
   ,b_9
   ,s4_1
   ,s2_3
   ,s2_4
   ,s3_3
   ,i_2
   ,b_10
   ,b_11
   ,s2_5
   ,s1_2
   ,d_2
   ,s1_3
   ,b_12
   ,r_1
   ,r_2
   ,i_3
   ,SnapshotID
from CMPMMMStorage
where active=0 and s2_2 in (
          'ClassUsageDefinition'
) and (workspaceid = 1
   or  workspaceid = (select sys_context('owb_workspace','workspaceID') from dual)
);
create or replace view ComponentDefinition_X
(
    WorkspaceID,
    LoadingParent,
    DeletionParent,
    AggregatedSignature
   ,ClassName
   ,Completed
   ,CreatedBy
   ,CreationTimestamp
   ,CustomerDeletable
   ,CustomerEditable
   ,CustomerRenamable
   ,Description
   ,Disabled
   ,Editable
   ,ElementId
   ,Frozen
   ,Generated
   ,Imported
   ,LogicalName
   ,MetadataSignature
   ,Name
   ,Note
   ,NOTM
   ,Persistent
   ,Seeded
   ,UOID
   ,UpdatedBy
   ,UpdateTimestamp
   ,Version, isLoadingParent
   ,ClassDefinition
   ,SnapshotID
) as select
    WorkspaceID,
    LoadingParent,
    DeletionParent,
    s2_1
   ,s2_2
   ,b_1
   ,s1_1
   ,d_1
   ,b_2
   ,b_3
   ,b_4
   ,s3_1
   ,b_5
   ,b_6
   ,i_1
   ,b_7
   ,b_8
   ,b_9
   ,s4_1
   ,s2_3
   ,s2_4
   ,s3_3
   ,i_2
   ,b_10
   ,b_11
   ,s2_5
   ,s1_2
   ,d_2
   ,s1_3
   ,b_12
   ,r_1
   ,SnapshotID
from CMPMMMStorage
where active=0 and s2_2 in (
          'ComponentDefinition'
) and (workspaceid = 1
   or  workspaceid = (select sys_context('owb_workspace','workspaceID') from dual)
);
create or replace view DefinitionKeyLookupBundle_X
(
    WorkspaceID,
    LoadingParent,
    DeletionParent,
    AggregatedSignature
   ,ClassName
   ,Completed
   ,CreatedBy
   ,CreationTimestamp
   ,CustomerDeletable
   ,CustomerEditable
   ,CustomerRenamable
   ,Description
   ,Disabled
   ,Editable
   ,ElementId
   ,Frozen
   ,Generated
   ,Imported
   ,LogicalName
   ,MetadataSignature
   ,Name
   ,Note
   ,NOTM
   ,Persistent
   ,Seeded
   ,UOID
   ,UpdatedBy
   ,UpdateTimestamp
   ,Version, isLoadingParent
   ,definitionKeyLookupBundle
   ,propertySetDefinition
   ,SnapshotID
) as select
    WorkspaceID,
    LoadingParent,
    DeletionParent,
    s2_1
   ,s2_2
   ,b_1
   ,s1_1
   ,d_1
   ,b_2
   ,b_3
   ,b_4
   ,s3_1
   ,b_5
   ,b_6
   ,i_1
   ,b_7
   ,b_8
   ,b_9
   ,s4_1
   ,s2_3
   ,s2_4
   ,s3_3
   ,i_2
   ,b_10
   ,b_11
   ,s2_5
   ,s1_2
   ,d_2
   ,s1_3
   ,b_12
   ,i_3
   ,r_1
   ,SnapshotID
from CMPMMMStorage
where active=0 and s2_2 in (
          'DefinitionKeyLookupBundle'
) and (workspaceid = 1
   or  workspaceid = (select sys_context('owb_workspace','workspaceID') from dual)
);
create or replace view InterestSet_X
(
    WorkspaceID,
    LoadingParent,
    DeletionParent,
    AggregatedSignature
   ,ClassName
   ,Completed
   ,CreatedBy
   ,CreationTimestamp
   ,CustomerDeletable
   ,CustomerEditable
   ,CustomerRenamable
   ,Description
   ,Disabled
   ,Editable
   ,ElementId
   ,Frozen
   ,Generated
   ,Imported
   ,LogicalName
   ,MetadataSignature
   ,Name
   ,Note
   ,NOTM
   ,Persistent
   ,Seeded
   ,UOID
   ,UpdatedBy
   ,UpdateTimestamp
   ,Version, isLoadingParent
   ,SnapshotID
) as select
    WorkspaceID,
    LoadingParent,
    DeletionParent,
    s2_1
   ,s2_2
   ,b_1
   ,s1_1
   ,d_1
   ,b_2
   ,b_3
   ,b_4
   ,s3_1
   ,b_5
   ,b_6
   ,i_1
   ,b_7
   ,b_8
   ,b_9
   ,s4_1
   ,s2_3
   ,s2_4
   ,s3_3
   ,i_2
   ,b_10
   ,b_11
   ,s2_5
   ,s1_2
   ,d_2
   ,s1_3
   ,b_12
   ,SnapshotID
from CMPMMMStorage
where active=0 and s2_2 in (
          'InterestSet'
         ,'DummyInterestSet'
         ,'PublicAPISet'
         ,'VerticalTree'
) and (workspaceid = 1
   or  workspaceid = (select sys_context('owb_workspace','workspaceID') from dual)
);
create or replace view DummyInterestSet_X
(
    WorkspaceID,
    LoadingParent,
    DeletionParent,
    AggregatedSignature
   ,ClassName
   ,Completed
   ,CreatedBy
   ,CreationTimestamp
   ,CustomerDeletable
   ,CustomerEditable
   ,CustomerRenamable
   ,Description
   ,Disabled
   ,Editable
   ,ElementId
   ,Frozen
   ,Generated
   ,Imported
   ,LogicalName
   ,MetadataSignature
   ,Name
   ,Note
   ,NOTM
   ,Persistent
   ,Seeded
   ,UOID
   ,UpdatedBy
   ,UpdateTimestamp
   ,Version, isLoadingParent
   ,SnapshotID
) as select
    WorkspaceID,
    LoadingParent,
    DeletionParent,
    s2_1
   ,s2_2
   ,b_1
   ,s1_1
   ,d_1
   ,b_2
   ,b_3
   ,b_4
   ,s3_1
   ,b_5
   ,b_6
   ,i_1
   ,b_7
   ,b_8
   ,b_9
   ,s4_1
   ,s2_3
   ,s2_4
   ,s3_3
   ,i_2
   ,b_10
   ,b_11
   ,s2_5
   ,s1_2
   ,d_2
   ,s1_3
   ,b_12
   ,SnapshotID
from CMPMMMStorage
where active=0 and s2_2 in (
          'DummyInterestSet'
) and (workspaceid = 1
   or  workspaceid = (select sys_context('owb_workspace','workspaceID') from dual)
);
create or replace view VerticalTree_X
(
    WorkspaceID,
    LoadingParent,
    DeletionParent,
    AggregatedSignature
   ,ClassName
   ,Completed
   ,CreatedBy
   ,CreationTimestamp
   ,CustomerDeletable
   ,CustomerEditable
   ,CustomerRenamable
   ,Description
   ,Disabled
   ,Editable
   ,ElementId
   ,Frozen
   ,Generated
   ,Imported
   ,LogicalName
   ,MetadataSignature
   ,Name
   ,Note
   ,NOTM
   ,Persistent
   ,Seeded
   ,UOID
   ,UpdatedBy
   ,UpdateTimestamp
   ,Version, isLoadingParent
   ,SnapshotID
) as select
    WorkspaceID,
    LoadingParent,
    DeletionParent,
    s2_1
   ,s2_2
   ,b_1
   ,s1_1
   ,d_1
   ,b_2
   ,b_3
   ,b_4
   ,s3_1
   ,b_5
   ,b_6
   ,i_1
   ,b_7
   ,b_8
   ,b_9
   ,s4_1
   ,s2_3
   ,s2_4
   ,s3_3
   ,i_2
   ,b_10
   ,b_11
   ,s2_5
   ,s1_2
   ,d_2
   ,s1_3
   ,b_12
   ,SnapshotID
from CMPMMMStorage
where active=0 and s2_2 in (
          'VerticalTree'
) and (workspaceid = 1
   or  workspaceid = (select sys_context('owb_workspace','workspaceID') from dual)
);
create or replace view PublicAPISet_X
(
    WorkspaceID,
    LoadingParent,
    DeletionParent,
    AggregatedSignature
   ,ClassName
   ,Completed
   ,CreatedBy
   ,CreationTimestamp
   ,CustomerDeletable
   ,CustomerEditable
   ,CustomerRenamable
   ,Description
   ,Disabled
   ,Editable
   ,ElementId
   ,Frozen
   ,Generated
   ,Imported
   ,LogicalName
   ,MetadataSignature
   ,Name
   ,Note
   ,NOTM
   ,Persistent
   ,Seeded
   ,UOID
   ,UpdatedBy
   ,UpdateTimestamp
   ,Version, isLoadingParent
   ,SnapshotID
) as select
    WorkspaceID,
    LoadingParent,
    DeletionParent,
    s2_1
   ,s2_2
   ,b_1
   ,s1_1
   ,d_1
   ,b_2
   ,b_3
   ,b_4
   ,s3_1
   ,b_5
   ,b_6
   ,i_1
   ,b_7
   ,b_8
   ,b_9
   ,s4_1
   ,s2_3
   ,s2_4
   ,s3_3
   ,i_2
   ,b_10
   ,b_11
   ,s2_5
   ,s1_2
   ,d_2
   ,s1_3
   ,b_12
   ,SnapshotID
from CMPMMMStorage
where active=0 and s2_2 in (
          'PublicAPISet'
) and (workspaceid = 1
   or  workspaceid = (select sys_context('owb_workspace','workspaceID') from dual)
);
create or replace view InterestUsage_X
(
    WorkspaceID,
    LoadingParent,
    DeletionParent,
    AggregatedSignature
   ,ClassName
   ,Completed
   ,CreatedBy
   ,CreationTimestamp
   ,CustomerDeletable
   ,CustomerEditable
   ,CustomerRenamable
   ,Description
   ,Disabled
   ,Editable
   ,ElementId
   ,Frozen
   ,Generated
   ,Imported
   ,LogicalName
   ,MetadataSignature
   ,Name
   ,Note
   ,NOTM
   ,Persistent
   ,Seeded
   ,UOID
   ,UpdatedBy
   ,UpdateTimestamp
   ,Version, isLoadingParent
   ,InterestSet
   ,InterestingObject
   ,SnapshotID
) as select
    WorkspaceID,
    LoadingParent,
    DeletionParent,
    s2_1
   ,s2_2
   ,b_1
   ,s1_1
   ,d_1
   ,b_2
   ,b_3
   ,b_4
   ,s3_1
   ,b_5
   ,b_6
   ,i_1
   ,b_7
   ,b_8
   ,b_9
   ,s4_1
   ,s2_3
   ,s2_4
   ,s3_3
   ,i_2
   ,b_10
   ,b_11
   ,s2_5
   ,s1_2
   ,d_2
   ,s1_3
   ,b_12
   ,r_1
   ,r_2
   ,SnapshotID
from CMPMMMStorage
where active=0 and s2_2 in (
          'InterestUsage'
         ,'DummyInterestUsage'
         ,'DefinitionInterestUsage'
         ,'TreeNode'
) and (workspaceid = 1
   or  workspaceid = (select sys_context('owb_workspace','workspaceID') from dual)
);
create or replace view DummyInterestUsage_X
(
    WorkspaceID,
    LoadingParent,
    DeletionParent,
    AggregatedSignature
   ,ClassName
   ,Completed
   ,CreatedBy
   ,CreationTimestamp
   ,CustomerDeletable
   ,CustomerEditable
   ,CustomerRenamable
   ,Description
   ,Disabled
   ,Editable
   ,ElementId
   ,Frozen
   ,Generated
   ,Imported
   ,LogicalName
   ,MetadataSignature
   ,Name
   ,Note
   ,NOTM
   ,Persistent
   ,Seeded
   ,UOID
   ,UpdatedBy
   ,UpdateTimestamp
   ,Version, isLoadingParent
   ,InterestSet
   ,InterestingObject
   ,SnapshotID
) as select
    WorkspaceID,
    LoadingParent,
    DeletionParent,
    s2_1
   ,s2_2
   ,b_1
   ,s1_1
   ,d_1
   ,b_2
   ,b_3
   ,b_4
   ,s3_1
   ,b_5
   ,b_6
   ,i_1
   ,b_7
   ,b_8
   ,b_9
   ,s4_1
   ,s2_3
   ,s2_4
   ,s3_3
   ,i_2
   ,b_10
   ,b_11
   ,s2_5
   ,s1_2
   ,d_2
   ,s1_3
   ,b_12
   ,r_1
   ,r_2
   ,SnapshotID
from CMPMMMStorage
where active=0 and s2_2 in (
          'DummyInterestUsage'
) and (workspaceid = 1
   or  workspaceid = (select sys_context('owb_workspace','workspaceID') from dual)
);
create or replace view TreeNode_X
(
    WorkspaceID,
    LoadingParent,
    DeletionParent,
    AggregatedSignature
   ,ClassName
   ,Completed
   ,CreatedBy
   ,CreationTimestamp
   ,CustomerDeletable
   ,CustomerEditable
   ,CustomerRenamable
   ,Description
   ,Disabled
   ,Editable
   ,ElementId
   ,Frozen
   ,Generated
   ,Imported
   ,LogicalName
   ,MetadataSignature
   ,Name
   ,Note
   ,NOTM
   ,Persistent
   ,Seeded
   ,UOID
   ,UpdatedBy
   ,UpdateTimestamp
   ,Version, isLoadingParent
   ,InterestSet
   ,InterestingObject
   ,isRoot
   ,parentNode
   ,realTreeNode
   ,SnapshotID
) as select
    WorkspaceID,
    LoadingParent,
    DeletionParent,
    s2_1
   ,s2_2
   ,b_1
   ,s1_1
   ,d_1
   ,b_2
   ,b_3
   ,b_4
   ,s3_1
   ,b_5
   ,b_6
   ,i_1
   ,b_7
   ,b_8
   ,b_9
   ,s4_1
   ,s2_3
   ,s2_4
   ,s3_3
   ,i_2
   ,b_10
   ,b_11
   ,s2_5
   ,s1_2
   ,d_2
   ,s1_3
   ,b_12
   ,r_1
   ,r_2
   ,b_13
   ,r_3
   ,r_4
   ,SnapshotID
from CMPMMMStorage
where active=0 and s2_2 in (
          'TreeNode'
) and (workspaceid = 1
   or  workspaceid = (select sys_context('owb_workspace','workspaceID') from dual)
);
create or replace view DefinitionInterestUsage_X
(
    WorkspaceID,
    LoadingParent,
    DeletionParent,
    AggregatedSignature
   ,ClassName
   ,Completed
   ,CreatedBy
   ,CreationTimestamp
   ,CustomerDeletable
   ,CustomerEditable
   ,CustomerRenamable
   ,Description
   ,Disabled
   ,Editable
   ,ElementId
   ,Frozen
   ,Generated
   ,Imported
   ,LogicalName
   ,MetadataSignature
   ,Name
   ,Note
   ,NOTM
   ,Persistent
   ,Seeded
   ,UOID
   ,UpdatedBy
   ,UpdateTimestamp
   ,Version, isLoadingParent
   ,InterestSet
   ,InterestingObject
   ,targetType
   ,parentInterest
   ,scriptName
   ,publicWeaklyTyped
   ,realInterestUsage
   ,SnapshotID
) as select
    WorkspaceID,
    LoadingParent,
    DeletionParent,
    s2_1
   ,s2_2
   ,b_1
   ,s1_1
   ,d_1
   ,b_2
   ,b_3
   ,b_4
   ,s3_1
   ,b_5
   ,b_6
   ,i_1
   ,b_7
   ,b_8
   ,b_9
   ,s4_1
   ,s2_3
   ,s2_4
   ,s3_3
   ,i_2
   ,b_10
   ,b_11
   ,s2_5
   ,s1_2
   ,d_2
   ,s1_3
   ,b_12
   ,r_1
   ,r_2
   ,i_3
   ,r_3
   ,s2_6
   ,b_13
   ,r_4
   ,SnapshotID
from CMPMMMStorage
where active=0 and s2_2 in (
          'DefinitionInterestUsage'
) and (workspaceid = 1
   or  workspaceid = (select sys_context('owb_workspace','workspaceID') from dual)
);
create or replace view PropertyGroupDefinition_X
(
    WorkspaceID,
    LoadingParent,
    DeletionParent,
    AggregatedSignature
   ,ClassName
   ,Completed
   ,CreatedBy
   ,CreationTimestamp
   ,CustomerDeletable
   ,CustomerEditable
   ,CustomerRenamable
   ,Description
   ,Disabled
   ,Editable
   ,ElementId
   ,Frozen
   ,Generated
   ,Imported
   ,LogicalName
   ,MetadataSignature
   ,Name
   ,Note
   ,NOTM
   ,Persistent
   ,Seeded
   ,UOID
   ,UpdatedBy
   ,UpdateTimestamp
   ,Version, isLoadingParent
   ,definitionKey
   ,hidden
   ,groupOwner
   ,SnapshotID
) as select
    WorkspaceID,
    LoadingParent,
    DeletionParent,
    s2_1
   ,s2_2
   ,b_1
   ,s1_1
   ,d_1
   ,b_2
   ,b_3
   ,b_4
   ,s3_1
   ,b_5
   ,b_6
   ,i_1
   ,b_7
   ,b_8
   ,b_9
   ,s4_1
   ,s2_3
   ,s2_4
   ,s3_3
   ,i_2
   ,b_10
   ,b_11
   ,s2_5
   ,s1_2
   ,d_2
   ,s1_3
   ,b_12
   ,s2_6
   ,b_13
   ,r_1
   ,SnapshotID
from CMPMMMStorage
where active=0 and s2_2 in (
          'PropertyGroupDefinition'
) and (workspaceid = 1
   or  workspaceid = (select sys_context('owb_workspace','workspaceID') from dual)
);
create or replace view PropertySetDefinition_X
(
    WorkspaceID,
    LoadingParent,
    DeletionParent,
    AggregatedSignature
   ,ClassName
   ,Completed
   ,CreatedBy
   ,CreationTimestamp
   ,CustomerDeletable
   ,CustomerEditable
   ,CustomerRenamable
   ,Description
   ,Disabled
   ,Editable
   ,ElementId
   ,Frozen
   ,Generated
   ,Imported
   ,LogicalName
   ,MetadataSignature
   ,Name
   ,Note
   ,NOTM
   ,Persistent
   ,Seeded
   ,UOID
   ,UpdatedBy
   ,UpdateTimestamp
   ,Version, isLoadingParent
   ,definitionKey
   ,classDefinition
   ,propertyType
   ,parentPropertySetDefinition
   ,parentClassDefinition
   ,superPropertySetDefinition
   ,superClassDefinition
   ,realPropertySetDefinition
   ,SnapshotID
) as select
    WorkspaceID,
    LoadingParent,
    DeletionParent,
    s2_1
   ,s2_2
   ,b_1
   ,s1_1
   ,d_1
   ,b_2
   ,b_3
   ,b_4
   ,s3_1
   ,b_5
   ,b_6
   ,i_1
   ,b_7
   ,b_8
   ,b_9
   ,s4_1
   ,s2_3
   ,s2_4
   ,s3_3
   ,i_2
   ,b_10
   ,b_11
   ,s2_5
   ,s1_2
   ,d_2
   ,s1_3
   ,b_12
   ,s2_6
   ,r_1
   ,i_3
   ,r_2
   ,r_3
   ,r_4
   ,r_5
   ,r_6
   ,SnapshotID
from CMPMMMStorage
where active=0 and s2_2 in (
          'PropertySetDefinition'
) and (workspaceid = 1
   or  workspaceid = (select sys_context('owb_workspace','workspaceID') from dual)
);
create or replace view PropertyUsageChoice_X
(
    WorkspaceID,
    LoadingParent,
    DeletionParent,
    AggregatedSignature
   ,ClassName
   ,Completed
   ,CreatedBy
   ,CreationTimestamp
   ,CustomerDeletable
   ,CustomerEditable
   ,CustomerRenamable
   ,Description
   ,Disabled
   ,Editable
   ,ElementId
   ,Frozen
   ,Generated
   ,Imported
   ,LogicalName
   ,MetadataSignature
   ,Name
   ,Note
   ,NOTM
   ,Persistent
   ,Seeded
   ,UOID
   ,UpdatedBy
   ,UpdateTimestamp
   ,Version, isLoadingParent
   ,choice
   ,propertyUsageDefinition
   ,SnapshotID
) as select
    WorkspaceID,
    LoadingParent,
    DeletionParent,
    s2_1
   ,s2_2
   ,b_1
   ,s1_1
   ,d_1
   ,b_2
   ,b_3
   ,b_4
   ,s3_1
   ,b_5
   ,b_6
   ,i_1
   ,b_7
   ,b_8
   ,b_9
   ,s4_1
   ,s2_3
   ,s2_4
   ,s3_3
   ,i_2
   ,b_10
   ,b_11
   ,s2_5
   ,s1_2
   ,d_2
   ,s1_3
   ,b_12
   ,s2_6
   ,r_1
   ,SnapshotID
from CMPMMMStorage
where active=0 and s2_2 in (
          'PropertyUsageChoice'
) and (workspaceid = 1
   or  workspaceid = (select sys_context('owb_workspace','workspaceID') from dual)
);
create or replace view PropertyUsageDefinition_X
(
    WorkspaceID,
    LoadingParent,
    DeletionParent,
    AggregatedSignature
   ,ClassName
   ,Completed
   ,CreatedBy
   ,CreationTimestamp
   ,CustomerDeletable
   ,CustomerEditable
   ,CustomerRenamable
   ,Description
   ,Disabled
   ,Editable
   ,ElementId
   ,Frozen
   ,Generated
   ,Imported
   ,LogicalName
   ,MetadataSignature
   ,Name
   ,Note
   ,NOTM
   ,Persistent
   ,Seeded
   ,UOID
   ,UpdatedBy
   ,UpdateTimestamp
   ,Version, isLoadingParent
   ,propertySetDefinition
   ,propertyDefinition
   ,definitionKey
   ,SnapshotID
) as select
    WorkspaceID,
    LoadingParent,
    DeletionParent,
    s2_1
   ,s2_2
   ,b_1
   ,s1_1
   ,d_1
   ,b_2
   ,b_3
   ,b_4
   ,s3_1
   ,b_5
   ,b_6
   ,i_1
   ,b_7
   ,b_8
   ,b_9
   ,s4_1
   ,s2_3
   ,s2_4
   ,s3_3
   ,i_2
   ,b_10
   ,b_11
   ,s2_5
   ,s1_2
   ,d_2
   ,s1_3
   ,b_12
   ,r_1
   ,r_2
   ,s2_6
   ,SnapshotID
from CMPMMMStorage
where active=0 and s2_2 in (
          'PropertyUsageDefinition'
) and (workspaceid = 1
   or  workspaceid = (select sys_context('owb_workspace','workspaceID') from dual)
);
create or replace view RoleDefinition_X
(
    WorkspaceID,
    LoadingParent,
    DeletionParent,
    AggregatedSignature
   ,ClassName
   ,Completed
   ,CreatedBy
   ,CreationTimestamp
   ,CustomerDeletable
   ,CustomerEditable
   ,CustomerRenamable
   ,Description
   ,Disabled
   ,Editable
   ,ElementId
   ,Frozen
   ,Generated
   ,Imported
   ,LogicalName
   ,MetadataSignature
   ,Name
   ,Note
   ,NOTM
   ,Persistent
   ,Seeded
   ,UOID
   ,UpdatedBy
   ,UpdateTimestamp
   ,Version, isLoadingParent
   ,aggregate
   ,navigable
   ,minCardinality
   ,maxCardinality
   ,propertyDefinition
   ,classDefinition
   ,associationDefinition
   ,SnapshotID
) as select
    WorkspaceID,
    LoadingParent,
    DeletionParent,
    s2_1
   ,s2_2
   ,b_1
   ,s1_1
   ,d_1
   ,b_2
   ,b_3
   ,b_4
   ,s3_1
   ,b_5
   ,b_6
   ,i_1
   ,b_7
   ,b_8
   ,b_9
   ,s4_1
   ,s2_3
   ,s2_4
   ,s3_3
   ,i_2
   ,b_10
   ,b_11
   ,s2_5
   ,s1_2
   ,d_2
   ,s1_3
   ,b_12
   ,b_13
   ,b_14
   ,i_3
   ,i_4
   ,r_1
   ,r_2
   ,r_3
   ,SnapshotID
from CMPMMMStorage
where active=0 and s2_2 in (
          'RoleDefinition'
) and (workspaceid = 1
   or  workspaceid = (select sys_context('owb_workspace','workspaceID') from dual)
);
create or replace view WBAbstractType_X
(
    WorkspaceID,
    LoadingParent,
    DeletionParent,
    AggregatedSignature
   ,ClassName
   ,Completed
   ,CreatedBy
   ,CreationTimestamp
   ,CustomerDeletable
   ,CustomerEditable
   ,CustomerRenamable
   ,Description
   ,Disabled
   ,Editable
   ,ElementId
   ,Frozen
   ,Generated
   ,Imported
   ,LogicalName
   ,MetadataSignature
   ,Name
   ,Note
   ,NOTM
   ,Persistent
   ,Seeded
   ,UOID
   ,UpdatedBy
   ,UpdateTimestamp
   ,Version, isLoadingParent
   ,Comparator
   ,SnapshotID
) as select
    WorkspaceID,
    LoadingParent,
    DeletionParent,
    s2_1
   ,s2_2
   ,b_1
   ,s1_1
   ,d_1
   ,b_2
   ,b_3
   ,b_4
   ,s3_1
   ,b_5
   ,b_6
   ,i_1
   ,b_7
   ,b_8
   ,b_9
   ,s4_1
   ,s2_3
   ,s2_4
   ,s3_3
   ,i_2
   ,b_10
   ,b_11
   ,s2_5
   ,s1_2
   ,d_2
   ,s1_3
   ,b_12
   ,s2_6
   ,SnapshotID
from CMPMMMStorage
where active=0 and s2_2 in (
          'WBAbstractType'
         ,'WBCollectionType'
         ,'WBScalarType'
         ,'WBExtensibleType'
         ,'WBArrayType'
         ,'WBPrimitiveType'
         ,'WBDomain'
         ,'ClassDefinition'
) and (workspaceid = 1
   or  workspaceid = (select sys_context('owb_workspace','workspaceID') from dual)
);
create or replace view WBScalarType_X
(
    WorkspaceID,
    LoadingParent,
    DeletionParent,
    AggregatedSignature
   ,ClassName
   ,Completed
   ,CreatedBy
   ,CreationTimestamp
   ,CustomerDeletable
   ,CustomerEditable
   ,CustomerRenamable
   ,Description
   ,Disabled
   ,Editable
   ,ElementId
   ,Frozen
   ,Generated
   ,Imported
   ,LogicalName
   ,MetadataSignature
   ,Name
   ,Note
   ,NOTM
   ,Persistent
   ,Seeded
   ,UOID
   ,UpdatedBy
   ,UpdateTimestamp
   ,Version, isLoadingParent
   ,Comparator
   ,SnapshotID
) as select
    WorkspaceID,
    LoadingParent,
    DeletionParent,
    s2_1
   ,s2_2
   ,b_1
   ,s1_1
   ,d_1
   ,b_2
   ,b_3
   ,b_4
   ,s3_1
   ,b_5
   ,b_6
   ,i_1
   ,b_7
   ,b_8
   ,b_9
   ,s4_1
   ,s2_3
   ,s2_4
   ,s3_3
   ,i_2
   ,b_10
   ,b_11
   ,s2_5
   ,s1_2
   ,d_2
   ,s1_3
   ,b_12
   ,s2_6
   ,SnapshotID
from CMPMMMStorage
where active=0 and s2_2 in (
          'WBPrimitiveType'
         ,'WBDomain'
         ,'WBScalarType'
         ,'ClassDefinition'
) and (workspaceid = 1
   or  workspaceid = (select sys_context('owb_workspace','workspaceID') from dual)
);
create or replace view WBPrimitiveType_X
(
    WorkspaceID,
    LoadingParent,
    DeletionParent,
    AggregatedSignature
   ,ClassName
   ,Completed
   ,CreatedBy
   ,CreationTimestamp
   ,CustomerDeletable
   ,CustomerEditable
   ,CustomerRenamable
   ,Description
   ,Disabled
   ,Editable
   ,ElementId
   ,Frozen
   ,Generated
   ,Imported
   ,LogicalName
   ,MetadataSignature
   ,Name
   ,Note
   ,NOTM
   ,Persistent
   ,Seeded
   ,UOID
   ,UpdatedBy
   ,UpdateTimestamp
   ,Version, isLoadingParent
   ,Comparator
   ,Formator
   ,SnapshotID
) as select
    WorkspaceID,
    LoadingParent,
    DeletionParent,
    s2_1
   ,s2_2
   ,b_1
   ,s1_1
   ,d_1
   ,b_2
   ,b_3
   ,b_4
   ,s3_1
   ,b_5
   ,b_6
   ,i_1
   ,b_7
   ,b_8
   ,b_9
   ,s4_1
   ,s2_3
   ,s2_4
   ,s3_3
   ,i_2
   ,b_10
   ,b_11
   ,s2_5
   ,s1_2
   ,d_2
   ,s1_3
   ,b_12
   ,s2_6
   ,s2_7
   ,SnapshotID
from CMPMMMStorage
where active=0 and s2_2 in (
          'WBPrimitiveType'
) and (workspaceid = 1
   or  workspaceid = (select sys_context('owb_workspace','workspaceID') from dual)
);
create or replace view WBDomain_X
(
    WorkspaceID,
    LoadingParent,
    DeletionParent,
    AggregatedSignature
   ,ClassName
   ,Completed
   ,CreatedBy
   ,CreationTimestamp
   ,CustomerDeletable
   ,CustomerEditable
   ,CustomerRenamable
   ,Description
   ,Disabled
   ,Editable
   ,ElementId
   ,Frozen
   ,Generated
   ,Imported
   ,LogicalName
   ,MetadataSignature
   ,Name
   ,Note
   ,NOTM
   ,Persistent
   ,Seeded
   ,UOID
   ,UpdatedBy
   ,UpdateTimestamp
   ,Version, isLoadingParent
   ,Comparator
   ,DataType
   ,SnapshotID
) as select
    WorkspaceID,
    LoadingParent,
    DeletionParent,
    s2_1
   ,s2_2
   ,b_1
   ,s1_1
   ,d_1
   ,b_2
   ,b_3
   ,b_4
   ,s3_1
   ,b_5
   ,b_6
   ,i_1
   ,b_7
   ,b_8
   ,b_9
   ,s4_1
   ,s2_3
   ,s2_4
   ,s3_3
   ,i_2
   ,b_10
   ,b_11
   ,s2_5
   ,s1_2
   ,d_2
   ,s1_3
   ,b_12
   ,s2_6
   ,r_1
   ,SnapshotID
from CMPMMMStorage
where active=0 and s2_2 in (
          'WBDomain'
) and (workspaceid = 1
   or  workspaceid = (select sys_context('owb_workspace','workspaceID') from dual)
);
create or replace view WBCollectionType_X
(
    WorkspaceID,
    LoadingParent,
    DeletionParent,
    AggregatedSignature
   ,ClassName
   ,Completed
   ,CreatedBy
   ,CreationTimestamp
   ,CustomerDeletable
   ,CustomerEditable
   ,CustomerRenamable
   ,Description
   ,Disabled
   ,Editable
   ,ElementId
   ,Frozen
   ,Generated
   ,Imported
   ,LogicalName
   ,MetadataSignature
   ,Name
   ,Note
   ,NOTM
   ,Persistent
   ,Seeded
   ,UOID
   ,UpdatedBy
   ,UpdateTimestamp
   ,Version, isLoadingParent
   ,Comparator
   ,SnapshotID
) as select
    WorkspaceID,
    LoadingParent,
    DeletionParent,
    s2_1
   ,s2_2
   ,b_1
   ,s1_1
   ,d_1
   ,b_2
   ,b_3
   ,b_4
   ,s3_1
   ,b_5
   ,b_6
   ,i_1
   ,b_7
   ,b_8
   ,b_9
   ,s4_1
   ,s2_3
   ,s2_4
   ,s3_3
   ,i_2
   ,b_10
   ,b_11
   ,s2_5
   ,s1_2
   ,d_2
   ,s1_3
   ,b_12
   ,s2_6
   ,SnapshotID
from CMPMMMStorage
where active=0 and s2_2 in (
          'WBCollectionType'
         ,'WBExtensibleType'
         ,'WBArrayType'
) and (workspaceid = 1
   or  workspaceid = (select sys_context('owb_workspace','workspaceID') from dual)
);
create or replace view WBArrayType_X
(
    WorkspaceID,
    LoadingParent,
    DeletionParent,
    AggregatedSignature
   ,ClassName
   ,Completed
   ,CreatedBy
   ,CreationTimestamp
   ,CustomerDeletable
   ,CustomerEditable
   ,CustomerRenamable
   ,Description
   ,Disabled
   ,Editable
   ,ElementId
   ,Frozen
   ,Generated
   ,Imported
   ,LogicalName
   ,MetadataSignature
   ,Name
   ,Note
   ,NOTM
   ,Persistent
   ,Seeded
   ,UOID
   ,UpdatedBy
   ,UpdateTimestamp
   ,Version, isLoadingParent
   ,Comparator
   ,baseElementType
   ,SnapshotID
) as select
    WorkspaceID,
    LoadingParent,
    DeletionParent,
    s2_1
   ,s2_2
   ,b_1
   ,s1_1
   ,d_1
   ,b_2
   ,b_3
   ,b_4
   ,s3_1
   ,b_5
   ,b_6
   ,i_1
   ,b_7
   ,b_8
   ,b_9
   ,s4_1
   ,s2_3
   ,s2_4
   ,s3_3
   ,i_2
   ,b_10
   ,b_11
   ,s2_5
   ,s1_2
   ,d_2
   ,s1_3
   ,b_12
   ,s2_6
   ,r_1
   ,SnapshotID
from CMPMMMStorage
where active=0 and s2_2 in (
          'WBArrayType'
) and (workspaceid = 1
   or  workspaceid = (select sys_context('owb_workspace','workspaceID') from dual)
);
create or replace view WBExtensibleType_X
(
    WorkspaceID,
    LoadingParent,
    DeletionParent,
    AggregatedSignature
   ,ClassName
   ,Completed
   ,CreatedBy
   ,CreationTimestamp
   ,CustomerDeletable
   ,CustomerEditable
   ,CustomerRenamable
   ,Description
   ,Disabled
   ,Editable
   ,ElementId
   ,Frozen
   ,Generated
   ,Imported
   ,LogicalName
   ,MetadataSignature
   ,Name
   ,Note
   ,NOTM
   ,Persistent
   ,Seeded
   ,UOID
   ,UpdatedBy
   ,UpdateTimestamp
   ,Version, isLoadingParent
   ,Comparator
   ,classDefinition
   ,SnapshotID
) as select
    WorkspaceID,
    LoadingParent,
    DeletionParent,
    s2_1
   ,s2_2
   ,b_1
   ,s1_1
   ,d_1
   ,b_2
   ,b_3
   ,b_4
   ,s3_1
   ,b_5
   ,b_6
   ,i_1
   ,b_7
   ,b_8
   ,b_9
   ,s4_1
   ,s2_3
   ,s2_4
   ,s3_3
   ,i_2
   ,b_10
   ,b_11
   ,s2_5
   ,s1_2
   ,d_2
   ,s1_3
   ,b_12
   ,s2_6
   ,r_1
   ,SnapshotID
from CMPMMMStorage
where active=0 and s2_2 in (
          'WBExtensibleType'
) and (workspaceid = 1
   or  workspaceid = (select sys_context('owb_workspace','workspaceID') from dual)
);
create or replace view WBRange_X
(
    WorkspaceID,
    LoadingParent,
    DeletionParent,
    AggregatedSignature
   ,ClassName
   ,Completed
   ,CreatedBy
   ,CreationTimestamp
   ,CustomerDeletable
   ,CustomerEditable
   ,CustomerRenamable
   ,Description
   ,Disabled
   ,Editable
   ,ElementId
   ,Frozen
   ,Generated
   ,Imported
   ,LogicalName
   ,MetadataSignature
   ,Name
   ,Note
   ,NOTM
   ,Persistent
   ,Seeded
   ,UOID
   ,UpdatedBy
   ,UpdateTimestamp
   ,Version, isLoadingParent
   ,Domain
   ,minValueInclusive
   ,maxValueInclusive
   ,SnapshotID
) as select
    WorkspaceID,
    LoadingParent,
    DeletionParent,
    s2_1
   ,s2_2
   ,b_1
   ,s1_1
   ,d_1
   ,b_2
   ,b_3
   ,b_4
   ,s3_1
   ,b_5
   ,b_6
   ,i_1
   ,b_7
   ,b_8
   ,b_9
   ,s4_1
   ,s2_3
   ,s2_4
   ,s3_3
   ,i_2
   ,b_10
   ,b_11
   ,s2_5
   ,s1_2
   ,d_2
   ,s1_3
   ,b_12
   ,r_1
   ,b_13
   ,b_14
   ,SnapshotID
from CMPMMMStorage
where active=0 and s2_2 in (
          'WBRange'
) and (workspaceid = 1
   or  workspaceid = (select sys_context('owb_workspace','workspaceID') from dual)
);
create or replace view WBProperty_X
(
    WorkspaceID,
    LoadingParent,
    DeletionParent,
    AggregatedSignature
   ,ClassName
   ,Completed
   ,CreatedBy
   ,CreationTimestamp
   ,CustomerDeletable
   ,CustomerEditable
   ,CustomerRenamable
   ,Description
   ,Disabled
   ,Editable
   ,ElementId
   ,Frozen
   ,Generated
   ,Imported
   ,LogicalName
   ,MetadataSignature
   ,Name
   ,Note
   ,NOTM
   ,Persistent
   ,Seeded
   ,UOID
   ,UpdatedBy
   ,UpdateTimestamp
   ,Version, isLoadingParent
   ,owner
   ,dataType
   ,position
   ,hasName
   ,hasPosition
   ,SnapshotID
) as select
    WorkspaceID,
    LoadingParent,
    DeletionParent,
    s2_1
   ,s2_2
   ,b_1
   ,s1_1
   ,d_1
   ,b_2
   ,b_3
   ,b_4
   ,s3_1
   ,b_5
   ,b_6
   ,i_1
   ,b_7
   ,b_8
   ,b_9
   ,s4_1
   ,s2_3
   ,s2_4
   ,s3_3
   ,i_2
   ,b_10
   ,b_11
   ,s2_5
   ,s1_2
   ,d_2
   ,s1_3
   ,b_12
   ,r_1
   ,r_2
   ,i_3
   ,b_13
   ,b_14
   ,SnapshotID
from CMPMMMStorage
where active=0 and s2_2 in (
          'WBProperty'
         ,'WBArrayProperty'
         ,'WBScalarProperty'
         ,'WBPrimitiveProperty'
         ,'WBCollectionProperty'
         ,'WBReferenceProperty'
) and (workspaceid = 1
   or  workspaceid = (select sys_context('owb_workspace','workspaceID') from dual)
);
create or replace view WBCollectionProperty_X
(
    WorkspaceID,
    LoadingParent,
    DeletionParent,
    AggregatedSignature
   ,ClassName
   ,Completed
   ,CreatedBy
   ,CreationTimestamp
   ,CustomerDeletable
   ,CustomerEditable
   ,CustomerRenamable
   ,Description
   ,Disabled
   ,Editable
   ,ElementId
   ,Frozen
   ,Generated
   ,Imported
   ,LogicalName
   ,MetadataSignature
   ,Name
   ,Note
   ,NOTM
   ,Persistent
   ,Seeded
   ,UOID
   ,UpdatedBy
   ,UpdateTimestamp
   ,Version, isLoadingParent
   ,owner
   ,dataType
   ,position
   ,hasName
   ,hasPosition
   ,SnapshotID
) as select
    WorkspaceID,
    LoadingParent,
    DeletionParent,
    s2_1
   ,s2_2
   ,b_1
   ,s1_1
   ,d_1
   ,b_2
   ,b_3
   ,b_4
   ,s3_1
   ,b_5
   ,b_6
   ,i_1
   ,b_7
   ,b_8
   ,b_9
   ,s4_1
   ,s2_3
   ,s2_4
   ,s3_3
   ,i_2
   ,b_10
   ,b_11
   ,s2_5
   ,s1_2
   ,d_2
   ,s1_3
   ,b_12
   ,r_1
   ,r_2
   ,i_3
   ,b_13
   ,b_14
   ,SnapshotID
from CMPMMMStorage
where active=0 and s2_2 in (
          'WBCollectionProperty'
         ,'WBArrayProperty'
) and (workspaceid = 1
   or  workspaceid = (select sys_context('owb_workspace','workspaceID') from dual)
);
create or replace view WBArrayProperty_X
(
    WorkspaceID,
    LoadingParent,
    DeletionParent,
    AggregatedSignature
   ,ClassName
   ,Completed
   ,CreatedBy
   ,CreationTimestamp
   ,CustomerDeletable
   ,CustomerEditable
   ,CustomerRenamable
   ,Description
   ,Disabled
   ,Editable
   ,ElementId
   ,Frozen
   ,Generated
   ,Imported
   ,LogicalName
   ,MetadataSignature
   ,Name
   ,Note
   ,NOTM
   ,Persistent
   ,Seeded
   ,UOID
   ,UpdatedBy
   ,UpdateTimestamp
   ,Version, isLoadingParent
   ,owner
   ,dataType
   ,position
   ,hasName
   ,hasPosition
   ,SnapshotID
) as select
    WorkspaceID,
    LoadingParent,
    DeletionParent,
    s2_1
   ,s2_2
   ,b_1
   ,s1_1
   ,d_1
   ,b_2
   ,b_3
   ,b_4
   ,s3_1
   ,b_5
   ,b_6
   ,i_1
   ,b_7
   ,b_8
   ,b_9
   ,s4_1
   ,s2_3
   ,s2_4
   ,s3_3
   ,i_2
   ,b_10
   ,b_11
   ,s2_5
   ,s1_2
   ,d_2
   ,s1_3
   ,b_12
   ,r_1
   ,r_2
   ,i_3
   ,b_13
   ,b_14
   ,SnapshotID
from CMPMMMStorage
where active=0 and s2_2 in (
          'WBArrayProperty'
) and (workspaceid = 1
   or  workspaceid = (select sys_context('owb_workspace','workspaceID') from dual)
);
create or replace view WBPrimitiveProperty_X
(
    WorkspaceID,
    LoadingParent,
    DeletionParent,
    AggregatedSignature
   ,ClassName
   ,Completed
   ,CreatedBy
   ,CreationTimestamp
   ,CustomerDeletable
   ,CustomerEditable
   ,CustomerRenamable
   ,Description
   ,Disabled
   ,Editable
   ,ElementId
   ,Frozen
   ,Generated
   ,Imported
   ,LogicalName
   ,MetadataSignature
   ,Name
   ,Note
   ,NOTM
   ,Persistent
   ,Seeded
   ,UOID
   ,UpdatedBy
   ,UpdateTimestamp
   ,Version, isLoadingParent
   ,owner
   ,dataType
   ,position
   ,hasName
   ,hasPosition
   ,value
   ,SnapshotID
) as select
    WorkspaceID,
    LoadingParent,
    DeletionParent,
    s2_1
   ,s2_2
   ,b_1
   ,s1_1
   ,d_1
   ,b_2
   ,b_3
   ,b_4
   ,s3_1
   ,b_5
   ,b_6
   ,i_1
   ,b_7
   ,b_8
   ,b_9
   ,s4_1
   ,s2_3
   ,s2_4
   ,s3_3
   ,i_2
   ,b_10
   ,b_11
   ,s2_5
   ,s1_2
   ,d_2
   ,s1_3
   ,b_12
   ,r_1
   ,r_2
   ,i_3
   ,b_13
   ,b_14
   ,s3_4
   ,SnapshotID
from CMPMMMStorage
where active=0 and s2_2 in (
          'WBPrimitiveProperty'
) and (workspaceid = 1
   or  workspaceid = (select sys_context('owb_workspace','workspaceID') from dual)
);
create or replace view WBReferenceProperty_X
(
    WorkspaceID,
    LoadingParent,
    DeletionParent,
    AggregatedSignature
   ,ClassName
   ,Completed
   ,CreatedBy
   ,CreationTimestamp
   ,CustomerDeletable
   ,CustomerEditable
   ,CustomerRenamable
   ,Description
   ,Disabled
   ,Editable
   ,ElementId
   ,Frozen
   ,Generated
   ,Imported
   ,LogicalName
   ,MetadataSignature
   ,Name
   ,Note
   ,NOTM
   ,Persistent
   ,Seeded
   ,UOID
   ,UpdatedBy
   ,UpdateTimestamp
   ,Version, isLoadingParent
   ,owner
   ,dataType
   ,position
   ,hasName
   ,hasPosition
   ,referencedElement
   ,SnapshotID
) as select
    WorkspaceID,
    LoadingParent,
    DeletionParent,
    s2_1
   ,s2_2
   ,b_1
   ,s1_1
   ,d_1
   ,b_2
   ,b_3
   ,b_4
   ,s3_1
   ,b_5
   ,b_6
   ,i_1
   ,b_7
   ,b_8
   ,b_9
   ,s4_1
   ,s2_3
   ,s2_4
   ,s3_3
   ,i_2
   ,b_10
   ,b_11
   ,s2_5
   ,s1_2
   ,d_2
   ,s1_3
   ,b_12
   ,r_1
   ,r_2
   ,i_3
   ,b_13
   ,b_14
   ,r_4
   ,SnapshotID
from CMPMMMStorage
where active=0 and s2_2 in (
          'WBReferenceProperty'
) and (workspaceid = 1
   or  workspaceid = (select sys_context('owb_workspace','workspaceID') from dual)
);
create or replace view WBScalarProperty_X
(
    WorkspaceID,
    LoadingParent,
    DeletionParent,
    AggregatedSignature
   ,ClassName
   ,Completed
   ,CreatedBy
   ,CreationTimestamp
   ,CustomerDeletable
   ,CustomerEditable
   ,CustomerRenamable
   ,Description
   ,Disabled
   ,Editable
   ,ElementId
   ,Frozen
   ,Generated
   ,Imported
   ,LogicalName
   ,MetadataSignature
   ,Name
   ,Note
   ,NOTM
   ,Persistent
   ,Seeded
   ,UOID
   ,UpdatedBy
   ,UpdateTimestamp
   ,Version, isLoadingParent
   ,owner
   ,dataType
   ,position
   ,hasName
   ,hasPosition
   ,SnapshotID
) as select
    WorkspaceID,
    LoadingParent,
    DeletionParent,
    s2_1
   ,s2_2
   ,b_1
   ,s1_1
   ,d_1
   ,b_2
   ,b_3
   ,b_4
   ,s3_1
   ,b_5
   ,b_6
   ,i_1
   ,b_7
   ,b_8
   ,b_9
   ,s4_1
   ,s2_3
   ,s2_4
   ,s3_3
   ,i_2
   ,b_10
   ,b_11
   ,s2_5
   ,s1_2
   ,d_2
   ,s1_3
   ,b_12
   ,r_1
   ,r_2
   ,i_3
   ,b_13
   ,b_14
   ,SnapshotID
from CMPMMMStorage
where active=0 and s2_2 in (
          'WBScalarProperty'
         ,'WBPrimitiveProperty'
         ,'WBReferenceProperty'
) and (workspaceid = 1
   or  workspaceid = (select sys_context('owb_workspace','workspaceID') from dual)
);
create or replace view DependencyDefinition_X
(
    WorkspaceID,
    LoadingParent,
    DeletionParent,
    AggregatedSignature
   ,ClassName
   ,Completed
   ,CreatedBy
   ,CreationTimestamp
   ,CustomerDeletable
   ,CustomerEditable
   ,CustomerRenamable
   ,Description
   ,Disabled
   ,Editable
   ,ElementId
   ,Frozen
   ,Generated
   ,Imported
   ,LogicalName
   ,MetadataSignature
   ,Name
   ,Note
   ,NOTM
   ,Persistent
   ,Seeded
   ,UOID
   ,UpdatedBy
   ,UpdateTimestamp
   ,Version, isLoadingParent
   ,associationDefinition
   ,sourceRole
   ,biDirectional
   ,sourceComponentType
   ,targetComponentType
   ,SnapshotID
) as select
    WorkspaceID,
    LoadingParent,
    DeletionParent,
    s2_1
   ,s2_2
   ,b_1
   ,s1_1
   ,d_1
   ,b_2
   ,b_3
   ,b_4
   ,s3_1
   ,b_5
   ,b_6
   ,i_1
   ,b_7
   ,b_8
   ,b_9
   ,s4_1
   ,s2_3
   ,s2_4
   ,s3_3
   ,i_2
   ,b_10
   ,b_11
   ,s2_5
   ,s1_2
   ,d_2
   ,s1_3
   ,b_12
   ,r_1
   ,r_2
   ,b_13
   ,s2_6
   ,s2_7
   ,SnapshotID
from CMPMMMStorage
where active=0 and s2_2 in (
         'DependencyDefinition'
) and (workspaceid = 1
   or  workspaceid = (select sys_context('owb_workspace','workspaceID') from dual)
);
