CREATE OR REPLACE VIEW structural_dependency_v
  AS 
          SELECT
          entity_stage.linkto AS source_objID,
          entity_stage.linkfrom AS target_objID
          FROM
          interlink entity_stage
          WHERE
          entity_stage.linkfromrole = 'BindingOperator' AND
          entity_stage.linktorole = 'ReferencingObject' AND
          entity_stage.linkto IS NOT NULL
          UNION
          SELECT
          entity_stage.linkto AS source_objID,
          map_operator.parentid AS target_objID
          FROM
          pctree map_operator,
          interlink entity_stage
          WHERE
          map_operator.parentrole = 'OperatorOwner' AND
          entity_stage.linkfrom = map_operator.childid  AND
          entity_stage.linkto IS NOT NULL
          UNION
          SELECT
          mapfunction_activity.linkto AS source_objID,
          mapfunction_activity.linkfrom AS target_objID
          FROM
          interlink mapfunction_activity
          WHERE
          mapfunction_activity.linktorole = 'CopyOf' AND
          mapfunction_activity.linkto IS NOT NULL
          UNION
          SELECT
          source_rel.parentid AS source_objID,
          target_rel.parentid AS target_objID
          FROM
          interlink,
          pctree source_rel,
          pctree target_rel
          WHERE
          interlink.linktorole = 'UniqueKey' AND
          interlink.linkfromrole = 'ForeignKeys' AND
          source_rel.childid = interlink.linkto AND
          target_rel.childid = interlink.linkfrom
          UNION
          SELECT
          map_processactivity.linkto AS source_objID,
          process_activity.parentid AS target_objID
          FROM
          pctree process_activity,
          interlink map_processactivity
          WHERE
          process_activity.parentrole = 'OwningBaseProcess' AND
          map_processactivity.linkfrom = process_activity.childid  AND
          map_processactivity.linkto IS NOT NULL AND
          map_processactivity.linktorole <> 'TaskImplementation' 
          UNION
          SELECT
          rec_ext.linkto AS source_objID,
          rec_ext.linkfrom AS target_objID
          FROM
          interlink rec_ext
          WHERE
          rec_ext.linktorole = 'RefersTo' AND
          rec_ext.linkfromrole = 'Representation'  AND
          rec_ext.linkto IS NOT NULL
          UNION
          SELECT
          rec_file.parentid AS source_objID,
          rec_ext.linkfrom AS target_objID
          FROM
          interlink rec_ext,
          pctree rec_file
          WHERE
          rec_ext.linktorole = 'RefersTo' AND
          rec_ext.linkfromrole = 'Representation' AND
          rec_ext.linkto = rec_file.childid AND
          rec_file.parentrole = 'OwningFile' AND
          rec_file.parentid IS NOT NULL
          UNION
           SELECT
           sourceRel.parentid AS source_objid,
           targetObj.parentid AS target_objid
           FROM
           interlink itemCon,
           pctree sourceRel,
           pctree targetObj
           WHERE
           itemCon.linkfromrole = 'IntelligenceItems' AND
           itemCon.linkto = sourceRel.childid AND
           itemCon.linkfrom = targetObj.childid AND
           sourceRel.parentid IS NOT NULL
           UNION -- for dataflow between queryItem (as source) and LOV (Defining)
           SELECT
           sourceObj.parentid AS source_objid,
           itemCon.linkfrom AS target_objid
           FROM
           interlink itemCon,
           pctree sourceObj
           WHERE
           itemCon.linkfromrole = 'ItemClassesUsingValues' AND
           itemCon.linkto = sourceObj.childid AND
           sourceObj.parentid IS NOT NULL
           UNION -- for dataflow between queryItem (as source) and LOV (Ordered)
           SELECT
           sourceObj.parentid AS source_objid,
           itemCon.linkfrom AS target_objid
           FROM
           interlink itemCon,
           pctree sourceObj
           WHERE
           itemCon.linkfromrole = 'ItemClassesOrdered' AND
           itemCon.linkto = sourceObj.childid AND
           sourceObj.parentid IS NOT NULL
           UNION -- for dataflow between LOV (as source) and queryItem
           SELECT
           itemCon.linkto AS source_objid,
           targetObj.parentid AS target_objid
           FROM
           interlink itemCon,
           pctree targetObj
           WHERE
           itemCon.linkfromrole = 'QueryItems' AND
           itemCon.linkfrom = targetObj.childid AND
           itemCon.linkto IS NOT NULL
           UNION -- for dataflow between Simple QueryItem and Complex QueryItem/QueryCondition
           SELECT
           sourceObj.parentid AS source_objid,
           targetObj.parentid AS target_objid
           FROM
           interlink srcItem,
           pctree trgItem,
           pctree sourceObj,
           pctree targetObj
           WHERE
           (srcItem.linktorole = 'ReferencedSCO' OR
           srcItem.linktorole = 'ReferencedFunction') AND
           trgItem.parentrole = 'QueryExpOwner' AND
           srcItem.linkfrom = trgItem.childid AND
           srcItem.linkto = sourceObj.childid AND
           trgItem.parentid = targetObj.childid AND
           sourceObj.parentid IS NOT NULL
           UNION -- for dataflow between QueryItem and DrillLevel
           SELECT
           sourceObj.parentid AS source_objid,
           targetObj.parentid AS target_objid
           FROM
           interlink srcItem,
           pctree trgItem,
           pctree sourceObj,
           pctree targetObj
           WHERE
           srcItem.linkfromrole = 'DrillItems' AND
           trgItem.childrole = 'OwnedAttributes' AND
           srcItem.linkfrom = trgItem.childid AND
           srcItem.linkto = sourceObj.childid AND
           trgItem.parentid = targetObj.childid AND
           sourceObj.parentid IS NOT NULL
           UNION -- for dataflow between derivationSourceSCO and derivedSCO
           SELECT
           sourceObj.parentid AS source_objid,
           targetObj.parentid AS target_objid
           FROM
           interlink itemCon,
           pctree sourceObj,
           pctree targetObj
           WHERE
           itemCon.linktorole = 'DerivationSourceSCO' AND
           itemCon.linkto = sourceObj.childid AND
           itemCon.linkfrom = targetObj.childid AND
           sourceObj.parentid IS NOT NULL
            UNION 
            SELECT
            dim_level.parentid AS source_objID,               
            cube_dimref.parentid AS target_objID
            FROM
            interlink level_dimref,
            pctree dim_level,
            pctree cube_dimref
            WHERE
            level_dimref.linkfromrole = 'ReferencingCubeDimRef' AND
            level_dimref.linktorole = 'ReferencedLevel' AND
            dim_level.parentrole = 'OwningDimension' AND
            dim_level.childid = level_dimref.linkto AND
            cube_dimref.parentrole = 'OwningCube' AND
            cube_dimref.childid = level_dimref.linkfrom AND
            dim_level.parentid IS NOT NULL
            UNION 
            SELECT
            source_table.parentid AS source_objID,
            target_cube.parentid AS target_objID
            FROM
            interlink column_measure,
            pctree source_table,
            pctree target_cube
            WHERE
            column_measure.linktorole = 'BindingAttribute' AND
            source_table.childid = column_measure.linkto AND
            target_cube.parentrole = 'OwningCube' AND
            target_cube.childid = column_measure.linkfrom AND
            source_table.parentid IS NOT NULL
            UNION 
            SELECT
            source_table.parentid AS source_objID,
            target_dim.parentid AS target_objID
            FROM
            interlink column_lvattr,
            pctree source_table,
            pctree dim_level,
            pctree target_dim
            WHERE
            (column_lvattr.linktorole = 'BindingAttribute' OR
            column_lvattr.linktorole = 'BindingDimensionKeyAttr') AND
            source_table.childid = column_lvattr.linkto AND
            dim_level.parentrole = 'OwningLevel' AND
            dim_level.childid = column_lvattr.linkfrom AND
            target_dim.parentrole = 'OwningDimension' AND
            dim_level.parentid = target_dim.childid AND
            source_table.parentid IS NOT NULL
            UNION
            SELECT
            link.linkto AS source_objID,           
            link.linkfrom AS target_objID
            FROM
            interlink link
            WHERE
            link.linktorole = 'IconObject' AND
            link.linkfromrole = 'Element' AND
            link.linkto IS NOT NULL
            UNION
            SELECT
            link.linkto AS source_objID,           
            source.parentid AS target_objID
            FROM
            interlink link,
            pctree source
            WHERE
            link.linkfromrole = 'LocationUsages' AND
            link.linktorole = 'Location' AND
            source.childid = link.linkfrom AND
            link.linkto IS NOT NULL
            UNION
            SELECT
            link.linkto AS source_objID,           
            source.parentid AS target_objID
            FROM
            interlink link,
            pctree source
            WHERE
            link.linkfromrole = 'PhysicalConfigs' AND
            link.linktorole = 'NamedConfiguration' AND
            source.childid = link.linkfrom AND
            link.linkto IS NOT NULL
            UNION
            SELECT
            link.linkto AS source_objID,           
            link.linkfrom AS target_objID
            FROM
            interlink link
            WHERE
            link.linktorole = 'RuntimeLocation' AND
            link.linkfromrole = 'ConfigurationUsages' AND
            link.linkto IS NOT NULL            
            UNION
            SELECT
            link.linkto AS source_objID,           
            link.linkfrom AS target_objID
            FROM
            interlink link
            WHERE
            link.linktorole = 'DimensionKeySequence' AND
            link.linkfromrole = 'KeyedDimensions' AND
            link.linkto IS NOT NULL
            UNION
            SELECT
            link.linkto AS source_objID,           
            link.linkfrom AS target_objID
            FROM
            interlink link
            WHERE
            link.linktorole = 'DefaultLocation' AND
            link.linkfromrole = 'ExternalTables' AND
            link.linkto IS NOT NULL
            UNION
            SELECT
            link.linkto AS source_objID,           
            link.linkfrom AS target_objID
            FROM
            interlink link
            WHERE
            link.linktorole = 'ReferencedRelation' AND
            link.linkfromrole = 'ReferencingPrfTable' AND
            link.linkto IS NOT NULL            
            UNION
            SELECT
            link.linkto AS source_objID,           
            source.parentid AS target_objID
            FROM
            interlink link,
            pctree source
            WHERE
            link.linkfromrole = 'RuleUsage' AND
            link.linktorole = 'RuleDefinition' AND
            source.childid = link.linkfrom AND
            link.linkto IS NOT NULL
            UNION
            SELECT
            link.linkto AS source_objID,           
            link.linkfrom AS target_objID
            FROM
            interlink link
            WHERE
            link.linktorole = 'ReturnType' AND
            link.linkfromrole = 'ReferringCursor' AND
            link.linkto IS NOT NULL
            UNION
            SELECT
            link.linkto AS source_objID,           
            link.linkfrom AS target_objID
            FROM
            interlink link
            WHERE
            link.linktorole = 'TimeDimPopulationMap' AND
            link.linkfromrole = 'TimeDimensions' AND
            link.linkto IS NOT NULL
            UNION            
            SELECT 
            link.linkto AS source_objID,
            source.parentid AS target_objID
            FROM 
            interlink link, 
            pctree source
            WHERE 
            link.linktorole = 'CopyOf' AND
            link.linkto IS NOT NULL AND
            source.childid = link.linkfrom
            UNION
            SELECT
            link.linkto AS source_objID,           
            source.parentid AS target_objID
            FROM
            interlink link, 
            pctree source
            WHERE
            link.linktorole = 'FCO' AND
            link.linkfromrole = 'BusinessAreaShortcut' AND
            source.childid = link.linkfrom AND
            link.linkto IS NOT NULL
            UNION
            SELECT
            link.linkto AS source_objID,           
            link.linkfrom AS target_objID
            FROM
            interlink link
            WHERE
            link.linktorole = 'LogicalObject' AND
            link.linkfromrole = 'PhysicalConfigs' AND
            link.linkto IS NOT NULL
            UNION
            SELECT
            link.linkto AS source_objID,           
            link.linkfrom AS target_objID
            FROM
            interlink link
            WHERE
            link.linktorole = 'TypeDefinition' AND
            link.linkfromrole = 'TypedObject' AND
            link.linkto IS NOT NULL AND
            link.linkto > 50000
            UNION
            SELECT
            mapattributegroup.linkto AS source_objID,
            targetobj.parentid AS target_objID
            FROM
            interlink mapattributegroup,
            pctree mapoperator,
            pctree targetObj            
            WHERE
            mapattributegroup.linkfromrole = 'AttributeGroup' AND            
            mapattributegroup.linktorole = 'ReferencingObject' AND
            mapattributegroup.linkto IS NOT NULL AND 
            mapattributegroup.linkfrom = mapoperator.childid AND
            mapoperator.parentrole = 'AttributeGroupOwner' AND
            mapoperator.parentid =  targetObj.childid AND 
            targetObj.parentrole = 'OperatorOwner'
            UNION
            SELECT
            link.linkto AS source_objID,           
            source.parentid AS target_objID
            FROM
            interlink link,
            pctree source
            WHERE
            link.linktorole = 'TypeDefinition' AND
            link.linkfromrole = 'TypedObject' AND
            source.childid = link.linkfrom AND
            link.linkto IS NOT NULL AND
            link.linkto > 50000
            UNION
            SELECT
            link.linkto AS source_objID,           
            link.linkfrom AS target_objID
            FROM
            interlink link
            WHERE
            link.linktorole = 'ConfigTemplateSet' AND
            link.linkfromrole = 'NamedConfigurations' AND
            link.linkto IS NOT NULL;
