
begin

declare
 TYPE it_128 is table of varchar(128) index by binary_integer;
 TYPE it_64 is table of varchar(64) index by binary_integer;
 TYPE it_1 is table of number(1) index by binary_integer;
 
 cg_gk it_128;
 cg_fn it_64;
 cg_in it_64;
 cg_gt it_1;
 cg_pk it_128;
 cg_lan it_64;
 cg_types it_128;
 cp_pk  it_128;
 cp_pn it_64;
 cp_lan it_64;
 cp_val it_128;
 cp_gk  it_128;
 cg_index it_64;
 cp_index it_64;
 
 cg_i number := 0;
 cp_i number := 0;

 procedure add_cg (
 	g_gk in varchar2,
 	g_fn in varchar2,
 	g_in in varchar2,
 	g_gt in number,
 	g_pk in varchar2,
 	g_lan in varchar2,
 	g_types in varchar2,
        g_key in varchar2
  ) 
  is
  	l_gk varchar2(128) := g_gk;
  	l_fn varchar2(64) := g_fn;
  	l_gt number(1) := g_gt;
  	l_lan varchar2(64) := g_lan;
  	l_types varchar2(128) := g_types;
  begin
  	if l_gk is null then
  		 l_gk := 'A';
        end if;
        if l_fn is null then 
       		l_fn := 'A';
       	end if;
       	if l_gt is null then
       		l_gt := 0;
       	end if;
       	if l_lan is null then
       		l_lan := 'en';
       	end if;
       	if l_types is null then
       		l_types := 'A';
       	end if;
       	
       	cg_i := cg_i +1;
       	cg_gk(cg_i) := l_gk;
  	cg_fn(cg_i) := l_fn;
  	cg_in(cg_i) := g_in;
  	cg_gt(cg_i) := l_gt;
  	cg_pk(cg_i) := g_pk;
  	cg_lan(cg_i) := l_lan;
  	cg_types(cg_i) := l_types;
        
       
	cg_index(cg_i) := g_key;

  end;

  procedure add_cp (
  	p_pk in varchar2,
  	p_pn in varchar2,
  	p_gk in varchar2,
  	p_lan in varchar2,
  	p_val in varchar2,
	p_key in varchar2
  )
  is
  	l_pk varchar2(128) := p_pk;
  	l_pn varchar2(64) := p_pn;
  	l_gk varchar2(128) := p_gk;
  	l_lan varchar2(64) := p_lan;
  	l_val varchar2(128) := p_val;
  begin
  	if l_pk	is null then
  		l_pk := 'A';
  	end if;
  	if l_pn	is null then
  		l_pn := 'A';
  	end if;
  	if l_gk	is null then
  		l_gk := 'A';
  	end if;
  	if l_lan is null then
  		l_lan := 'en';
  	end if;
  	if l_val is null then
  		l_val := 'A';
  	end if;

  	cp_i := cp_i + 1;
  	cp_pk(cp_i) := l_pk;
  	cp_pn(cp_i) := l_pn;
  	cp_gk(cp_i) := l_gk;
  	cp_lan(cp_i) := l_lan;
        cp_val(cp_i) := l_val;
	cp_index(cp_i) := p_key;

  end;




begin




-- File /tmp/map_mzfan/map_logical.xml
 add_cg('FILE.DEFAULT',
 		   	'Generation',
  		   	null,
  		   	'4',
  		   	'',
  		   	'en',
  		   	'CMPCompositeStageComponent',
  		   	'12205'
  		   	);
  add_cp('FILE.DEFAULT.BOUNDNAME',
                   	'Bound Name',
  		   	'FILE.DEFAULT',
  		   	'en',
  		   	'',
  		   	'12103'
  		   	);
  add_cg('FILE.PARAMETERS',
 		   	'File Properties',
  		   	null,
  		   	'4',
  		   	'',
  		   	'en',
  		   	'CMPCompositeStageComponent',
  		   	'12206'
  		   	);
  add_cp('FILE.PARAMETERS.LOADTYPE',
                   	'Loading type',
  		   	'FILE.PARAMETERS',
  		   	'en',
  		   	'INSERT',
  		   	'12207'
  		   	);
  add_cp('FILE.PARAMETERS.DATAFILENAME',
                   	'Source Data File Name',
  		   	'FILE.PARAMETERS',
  		   	'en',
  		   	'',
  		   	'12208'
  		   	);
  add_cp('FILE.PARAMETERS.DATAFILELOC',
                   	'Source Data File Location',
  		   	'FILE.PARAMETERS',
  		   	'en',
  		   	'',
  		   	'12209'
  		   	);
  add_cp('FILE.PARAMETERS.CHARACTERSET',
                   	'NLS Characterset',
  		   	'FILE.PARAMETERS',
  		   	'en',
  		   	'WE8MSWIN1252',
  		   	'12210'
  		   	);
  add_cp('FILE.PARAMETERS.FILEFORMAT',
                   	'File Format',
  		   	'FILE.PARAMETERS',
  		   	'en',
  		   	'DELIMITED',
  		   	'12211'
  		   	);
  add_cp('FILE.PARAMETERS.RECORDDELIMITER',
                   	'Record Delimiter',
  		   	'FILE.PARAMETERS',
  		   	'en',
  		   	'',
  		   	'12212'
  		   	);
  add_cp('FILE.PARAMETERS.CONTINUECHAR',
                   	'Continuation Character',
  		   	'FILE.PARAMETERS',
  		   	'en',
  		   	'',
  		   	'12213'
  		   	);
  add_cp('FILE.PARAMETERS.TERMINATOR',
                   	'Field Termination Character',
  		   	'FILE.PARAMETERS',
  		   	'en',
  		   	',',
  		   	'12214'
  		   	);
  add_cp('FILE.PARAMETERS.ENCLOSURE',
                   	'Field Enclosure Characters',
  		   	'FILE.PARAMETERS',
  		   	'en',
  		   	'',
  		   	'12215'
  		   	);
  add_cp('FILE.PARAMETERS.RECORDSIZE',
                   	'Record Size',
  		   	'FILE.PARAMETERS',
  		   	'en',
  		   	'0',
  		   	'12216'
  		   	);
  add_cp('FILE.PARAMETERS.CONCATENATE',
                   	'Concatenate Records',
  		   	'FILE.PARAMETERS',
  		   	'en',
  		   	'0',
  		   	'12217'
  		   	);
  add_cp('FILE.PARAMETERS.CLASSIFIERPOS',
                   	'Record Type Position',
  		   	'FILE.PARAMETERS',
  		   	'en',
  		   	'0',
  		   	'12218'
  		   	);
  add_cp('FILE.PARAMETERS.CLASSIFIERLEN',
                   	'Record Type Length',
  		   	'FILE.PARAMETERS',
  		   	'en',
  		   	'0',
  		   	'12219'
  		   	);
  add_cp('FILE.PARAMETERS.CONTINUEONNEXT',
                   	'Continuation Character on Next Line',
  		   	'FILE.PARAMETERS',
  		   	'en',
  		   	'FALSE',
  		   	'12220'
  		   	);
  add_cp('FILE.PARAMETERS.OUTPUTFIELDNAMES',
                   	'Field names in the first row',
  		   	'FILE.PARAMETERS',
  		   	'en',
  		   	'FALSE',
  		   	'12221'
  		   	);
  add_cg('FILE.RECORD.PARAMETERS',
 		   	'Record Properties',
  		   	null,
  		   	'4',
  		   	'',
  		   	'en',
  		   	'CMPCompositeStageComponent',
  		   	'12222'
  		   	);
  add_cp('FILE.RECORD.PARAMETERS.CLASSIFIERVALUES',
                   	'Record Type Values',
  		   	'FILE.RECORD.PARAMETERS',
  		   	'en',
  		   	'',
  		   	'12223'
  		   	);
  add_cg('AGGREGATION.DEFAULTGROUP',
 		   	'Default',
  		   	null,
  		   	'4',
  		   	'',
  		   	'en',
  		   	'CMPCompositeStageComponent',
  		   	'12122'
  		   	);
  add_cp('GROUP_BY_CLAUSE',
                   	'Group By Clause',
  		   	'AGGREGATION.DEFAULTGROUP',
  		   	'en',
  		   	'',
  		   	'12224'
  		   	);
  add_cp('HAVING_CLAUSE',
                   	'Having Clause',
  		   	'AGGREGATION.DEFAULTGROUP',
  		   	'en',
  		   	'',
  		   	'12225'
  		   	);
  add_cg('FILTER.DEFAULTGROUP',
 		   	'Default',
  		   	null,
  		   	'4',
  		   	'',
  		   	'en',
  		   	'CMPCompositeStageComponent',
  		   	'12122'
  		   	);
  add_cp('FILTER.FILTER_CONDITION',
                   	'Filter Condition',
  		   	'FILTER.DEFAULTGROUP',
  		   	'en',
  		   	'',
  		   	'12226'
  		   	);
  add_cg('YZZYX.BLJ.L.GROUP',
 		   	'',
  		   	null,
  		   	'4',
  		   	'',
  		   	'en',
  		   	'CMPCompositeStageComponent',
  		   	'12161'
  		   	);
  add_cp('YZZYX.LOGICAL.PARM.ONE',
                   	'',
  		   	'YZZYX.BLJ.L.GROUP',
  		   	'en',
  		   	'',
  		   	'12161'
  		   	);
  add_cp('YZZYX.LOGICAL.PARM.TWO',
                   	'',
  		   	'YZZYX.BLJ.L.GROUP',
  		   	'en',
  		   	'',
  		   	'12161'
  		   	);
  add_cg('JOIN.INPUT.PARAMGROUP1',
 		   	'Default',
  		   	null,
  		   	'4',
  		   	'',
  		   	'en',
  		   	'CMPCompositeStageComponent',
  		   	'12122'
  		   	);
  add_cp('JOIN.INPUT.DEFAULT_JOIN_CONDITION',
                   	'Default Group Join Condition',
  		   	'JOIN.INPUT.PARAMGROUP1',
  		   	'en',
  		   	'',
  		   	'12227'
  		   	);
  add_cg('JOIN.INPUT.PARAMGROUP1',
 		   	'Default',
  		   	null,
  		   	'4',
  		   	'',
  		   	'en',
  		   	'CMPCompositeStageComponent',
  		   	'12122'
  		   	);
  add_cp('JOIN.JOIN_CONDITION',
                   	'Join Condition',
  		   	'JOIN.INPUT.PARAMGROUP1',
  		   	'en',
  		   	'',
  		   	'12228'
  		   	);
  add_cp('JOIN.INPUT.JOIN_CONDITION_USER_MODIFIED_FLAG',
                   	'Join Condition User Modified Flag',
  		   	'JOIN.INPUT.PARAMGROUP1',
  		   	'en',
  		   	'',
  		   	'12229'
  		   	);
  add_cg('KEYLOOKUPTABLE.DEFAULT_GROUP',
 		   	'Default',
  		   	null,
  		   	'4',
  		   	'',
  		   	'en',
  		   	'CMPCompositeStageComponent',
  		   	'12122'
  		   	);
  add_cp('KEYLOOKUPTABLE.KEY_CONDITION',
                   	'Lookup Condition',
  		   	'KEYLOOKUPTABLE.DEFAULT_GROUP',
  		   	'en',
  		   	'',
  		   	'12230'
  		   	);
  add_cg('KEYLOOKUPTABLE.OUTPUT.PARAMGROUP1',
 		   	'Output',
  		   	null,
  		   	'4',
  		   	'',
  		   	'en',
  		   	'CMPCompositeStageComponent',
  		   	'12231'
  		   	);
  add_cp('KEYLOOKUPTABLE.OUTPUTPARAM.DEFAULT_VALUE',
                   	'Default Value',
  		   	'KEYLOOKUPTABLE.OUTPUT.PARAMGROUP1',
  		   	'en',
  		   	'',
  		   	'12232'
  		   	);
  add_cg('DATAENTITY.DEFAULT',
 		   	'Default',
  		   	null,
  		   	'4',
  		   	'',
  		   	'en',
  		   	'CMPCompositeStageComponent',
  		   	'12122'
  		   	);
  add_cp('DATAENTITY.DEFAULT.BOUNDNAME',
                   	'Bound Name',
  		   	'DATAENTITY.DEFAULT',
  		   	'en',
  		   	'',
  		   	'12103'
  		   	);
  add_cg('MAPPING_INPUT_PARAMETERS.OUTPUTGROUP.PARAMETER.PROPERTIES',
 		   	'Mapping Parameter Properties',
  		   	null,
  		   	'4',
  		   	'',
  		   	'en',
  		   	'CMPCompositeStageComponent',
  		   	'12233'
  		   	);
  add_cp('MAPPING_INPUT_PARAMETERS.OUTPUTGROUP.PARAMETER.PROPERTIES.DEFAULT_VALUE',
                   	'Default Value',
  		   	'MAPPING_INPUT_PARAMETERS.OUTPUTGROUP.PARAMETER.PROPERTIES',
  		   	'en',
  		   	'',
  		   	'12232'
  		   	);
  add_cg('DATAENTITY.DEFAULT',
 		   	'Default',
  		   	null,
  		   	'4',
  		   	'',
  		   	'en',
  		   	'CMPCompositeStageComponent',
  		   	'12122'
  		   	);
  add_cp('DATAENTITY.DEFAULT.BOUNDNAME',
                   	'Bound Name',
  		   	'DATAENTITY.DEFAULT',
  		   	'en',
  		   	'',
  		   	'12103'
  		   	);
  add_cg('ORDER_BY.DEFAULTGROUP',
 		   	'Default',
  		   	null,
  		   	'4',
  		   	'',
  		   	'en',
  		   	'CMPCompositeStageComponent',
  		   	'12122'
  		   	);
  add_cp('ORDER_BY.ORDER_BY_EXPRESSION',
                   	'Order By Clause',
  		   	'ORDER_BY.DEFAULTGROUP',
  		   	'en',
  		   	'',
  		   	'12234'
  		   	);
  add_cg('FUNCTION.INPUT.DEFAULT',
 		   	'Default',
  		   	null,
  		   	'4',
  		   	'',
  		   	'en',
  		   	'CMPCompositeStageComponent',
  		   	'12122'
  		   	);
  add_cp('MAPPING.BOUNDNAME',
                   	'',
  		   	'FUNCTION.INPUT.DEFAULT',
  		   	'en',
  		   	'',
  		   	'12161'
  		   	);
  add_cg('FUNCTION.INPUT.PARAMGROUP1',
 		   	'Inputs',
  		   	null,
  		   	'4',
  		   	'',
  		   	'en',
  		   	'CMPCompositeStageComponent',
  		   	'12235'
  		   	);
  add_cp('FUNCTION.INPUTPARAM.DEFAULT_VALUE',
                   	'Default Value',
  		   	'FUNCTION.INPUT.PARAMGROUP1',
  		   	'en',
  		   	'',
  		   	'12232'
  		   	);
  add_cp('FUNCTION.INPUTPARAM.IS_OPTIONAL',
                   	'Is Optional',
  		   	'FUNCTION.INPUT.PARAMGROUP1',
  		   	'en',
  		   	'',
  		   	'12236'
  		   	);
  add_cg('FUNCTION.OUTPUT.DEFAULT',
 		   	'Default',
  		   	null,
  		   	'4',
  		   	'',
  		   	'en',
  		   	'CMPCompositeStageComponent',
  		   	'12122'
  		   	);
  add_cp('MAPPING.BOUNDNAME',
                   	'',
  		   	'FUNCTION.OUTPUT.DEFAULT',
  		   	'en',
  		   	'',
  		   	'12161'
  		   	);
  add_cg('FUNCTION.OUTPUT.PARAMGROUP1',
 		   	'Outputs',
  		   	null,
  		   	'4',
  		   	'',
  		   	'en',
  		   	'CMPCompositeStageComponent',
  		   	'12237'
  		   	);
  add_cp('FUNCTION.OUTPUTPARAM.IS_RESULT',
                   	'Function Return',
  		   	'FUNCTION.OUTPUT.PARAMGROUP1',
  		   	'en',
  		   	'',
  		   	'12238'
  		   	);
  add_cg('FUNCTION.DEFAULTGROUP',
 		   	'Default',
  		   	null,
  		   	'4',
  		   	'',
  		   	'en',
  		   	'CMPCompositeStageComponent',
  		   	'12122'
  		   	);
  add_cp('FUNCTION.FUNCTION_NAME',
                   	'Function Name',
  		   	'FUNCTION.DEFAULTGROUP',
  		   	'en',
  		   	'',
  		   	'12239'
  		   	);
  add_cp('FUNCTION.PROCEDURE_CALL',
                   	'Function Call',
  		   	'FUNCTION.DEFAULTGROUP',
  		   	'en',
  		   	'',
  		   	'12240'
  		   	);
  add_cp('FUNCTION.POSTMAPPROCESSRUNCONDITION',
                   	'Post-Mapping Process Run Condition',
  		   	'FUNCTION.DEFAULTGROUP',
  		   	'en',
  		   	'ON_SUCCESS',
  		   	'12241'
  		   	);
  add_cp('FUNCTION.IS_PROCEDURE',
                   	'Row-based only',
  		   	'FUNCTION.DEFAULTGROUP',
  		   	'en',
  		   	'',
  		   	'12242'
  		   	);
  add_cg('FUNCTION.INPUT.DEFAULT',
 		   	'Default',
  		   	null,
  		   	'4',
  		   	'',
  		   	'en',
  		   	'CMPCompositeStageComponent',
  		   	'12122'
  		   	);
  add_cp('MAPPING.BOUNDNAME',
                   	'',
  		   	'FUNCTION.INPUT.DEFAULT',
  		   	'en',
  		   	'',
  		   	'12161'
  		   	);
  add_cg('FUNCTION.INPUT.PARAMGROUP1',
 		   	'Inputs',
  		   	null,
  		   	'4',
  		   	'',
  		   	'en',
  		   	'CMPCompositeStageComponent',
  		   	'12235'
  		   	);
  add_cp('FUNCTION.INPUTPARAM.DEFAULT_VALUE',
                   	'Default Value',
  		   	'FUNCTION.INPUT.PARAMGROUP1',
  		   	'en',
  		   	'',
  		   	'12232'
  		   	);
  add_cp('FUNCTION.INPUTPARAM.IS_OPTIONAL',
                   	'Is Optional',
  		   	'FUNCTION.INPUT.PARAMGROUP1',
  		   	'en',
  		   	'',
  		   	'12236'
  		   	);
  add_cg('FUNCTION.OUTPUT.DEFAULT',
 		   	'Default',
  		   	null,
  		   	'4',
  		   	'',
  		   	'en',
  		   	'CMPCompositeStageComponent',
  		   	'12122'
  		   	);
  add_cp('MAPPING.BOUNDNAME',
                   	'',
  		   	'FUNCTION.OUTPUT.DEFAULT',
  		   	'en',
  		   	'',
  		   	'12161'
  		   	);
  add_cg('FUNCTION.OUTPUT.PARAMGROUP1',
 		   	'Outputs',
  		   	null,
  		   	'4',
  		   	'',
  		   	'en',
  		   	'CMPCompositeStageComponent',
  		   	'12237'
  		   	);
  add_cp('FUNCTION.OUTPUTPARAM.IS_RESULT',
                   	'Function Return',
  		   	'FUNCTION.OUTPUT.PARAMGROUP1',
  		   	'en',
  		   	'',
  		   	'12238'
  		   	);
  add_cg('FUNCTION.DEFAULTGROUP',
 		   	'Default',
  		   	null,
  		   	'4',
  		   	'',
  		   	'en',
  		   	'CMPCompositeStageComponent',
  		   	'12122'
  		   	);
  add_cp('FUNCTION.FUNCTION_NAME',
                   	'Function Name',
  		   	'FUNCTION.DEFAULTGROUP',
  		   	'en',
  		   	'',
  		   	'12239'
  		   	);
  add_cp('FUNCTION.PROCEDURE_CALL',
                   	'Function Call',
  		   	'FUNCTION.DEFAULTGROUP',
  		   	'en',
  		   	'',
  		   	'12240'
  		   	);
  add_cp('FUNCTION.MAPRUNCONDITION',
                   	'Mapping Run Condition',
  		   	'FUNCTION.DEFAULTGROUP',
  		   	'en',
  		   	'ON_SUCCESS',
  		   	'12243'
  		   	);
  add_cp('FUNCTION.IS_PROCEDURE',
                   	'Row-based only',
  		   	'FUNCTION.DEFAULTGROUP',
  		   	'en',
  		   	'',
  		   	'12242'
  		   	);
  add_cg('SPLITTER.OUTPUT.PARAMGROUP1',
 		   	'Default',
  		   	null,
  		   	'4',
  		   	'',
  		   	'en',
  		   	'CMPCompositeStageComponent',
  		   	'12122'
  		   	);
  add_cp('SPLITTER.OUTPUT.SPLIT_CONDITION',
                   	'Split Condition',
  		   	'SPLITTER.OUTPUT.PARAMGROUP1',
  		   	'en',
  		   	'',
  		   	'12244'
  		   	);
  add_cg('FUNCTION.INPUT.DEFAULT',
 		   	'Default',
  		   	null,
  		   	'4',
  		   	'',
  		   	'en',
  		   	'CMPCompositeStageComponent',
  		   	'12122'
  		   	);
  add_cp('MAPPING.BOUNDNAME',
                   	'',
  		   	'FUNCTION.INPUT.DEFAULT',
  		   	'en',
  		   	'',
  		   	'12161'
  		   	);
  add_cg('FUNCTION.INPUT.PARAMGROUP1',
 		   	'Inputs',
  		   	null,
  		   	'4',
  		   	'',
  		   	'en',
  		   	'CMPCompositeStageComponent',
  		   	'12235'
  		   	);
  add_cp('FUNCTION.INPUTPARAM.DEFAULT_VALUE',
                   	'Default Value',
  		   	'FUNCTION.INPUT.PARAMGROUP1',
  		   	'en',
  		   	'',
  		   	'12232'
  		   	);
  add_cp('FUNCTION.INPUTPARAM.IS_OPTIONAL',
                   	'Is Optional',
  		   	'FUNCTION.INPUT.PARAMGROUP1',
  		   	'en',
  		   	'',
  		   	'12236'
  		   	);
  add_cg('FUNCTION.OUTPUT.DEFAULT',
 		   	'Default',
  		   	null,
  		   	'4',
  		   	'',
  		   	'en',
  		   	'CMPCompositeStageComponent',
  		   	'12122'
  		   	);
  add_cp('MAPPING.BOUNDNAME',
                   	'',
  		   	'FUNCTION.OUTPUT.DEFAULT',
  		   	'en',
  		   	'',
  		   	'12161'
  		   	);
  add_cg('FUNCTION.OUTPUT.PARAMGROUP1',
 		   	'Outputs',
  		   	null,
  		   	'4',
  		   	'',
  		   	'en',
  		   	'CMPCompositeStageComponent',
  		   	'12237'
  		   	);
  add_cp('FUNCTION.OUTPUTPARAM.IS_RESULT',
                   	'Function Return',
  		   	'FUNCTION.OUTPUT.PARAMGROUP1',
  		   	'en',
  		   	'',
  		   	'12238'
  		   	);
  add_cg('FUNCTION.INOUT.DEFAULT',
 		   	'Default',
  		   	null,
  		   	'4',
  		   	'',
  		   	'en',
  		   	'CMPCompositeStageComponent',
  		   	'12122'
  		   	);
  add_cp('MAPPING.BOUNDNAME',
                   	'',
  		   	'FUNCTION.INOUT.DEFAULT',
  		   	'en',
  		   	'',
  		   	'12161'
  		   	);
  add_cg('FUNCTION.DEFAULTGROUP',
 		   	'Default',
  		   	null,
  		   	'4',
  		   	'',
  		   	'en',
  		   	'CMPCompositeStageComponent',
  		   	'12122'
  		   	);
  add_cp('FUNCTION.FUNCTION_NAME',
                   	'Function Name',
  		   	'FUNCTION.DEFAULTGROUP',
  		   	'en',
  		   	'',
  		   	'12239'
  		   	);
  add_cp('FUNCTION.PROCEDURE_CALL',
                   	'Function Call',
  		   	'FUNCTION.DEFAULTGROUP',
  		   	'en',
  		   	'',
  		   	'12240'
  		   	);
  add_cp('FUNCTION.IS_PROCEDURE',
                   	'Row-based only',
  		   	'FUNCTION.DEFAULTGROUP',
  		   	'en',
  		   	'',
  		   	'12242'
  		   	);
  add_cg('TRIGGER.DEFAULTGROUP',
 		   	'Default',
  		   	null,
  		   	'4',
  		   	'',
  		   	'en',
  		   	'CMPCompositeStageComponent',
  		   	'12122'
  		   	);
  add_cp('TRIGGER_EXPRESSION',
                   	'Trigger expression',
  		   	'TRIGGER.DEFAULTGROUP',
  		   	'en',
  		   	'',
  		   	'12245'
  		   	);
  add_cp('TRIGGER_EVENT',
                   	'Trigger event',
  		   	'TRIGGER.DEFAULTGROUP',
  		   	'en',
  		   	'Pre-Map',
  		   	'12246'
  		   	);
  add_cg('NAMEADDRESS.DEFAULTGROUP',
 		   	'Default',
  		   	null,
  		   	'4',
  		   	'',
  		   	'en',
  		   	'CMPCompositeStageComponent',
  		   	'12122'
  		   	);
  add_cp('NAMEADDRESS_KEY',
                   	'Parsing Type',
  		   	'NAMEADDRESS.DEFAULTGROUP',
  		   	'en',
  		   	'NA_NAMEANDADDRESS',
  		   	'12247'
  		   	);
  add_cp('NAMEADDRESS_COUNTRY',
                   	'Primary Country',
  		   	'NAMEADDRESS.DEFAULTGROUP',
  		   	'en',
  		   	'NA_USA',
  		   	'12248'
  		   	);
  add_cg('NAMEADDRESS.CASSGROUP',
 		   	'CASS Report',
  		   	null,
  		   	'4',
  		   	'',
  		   	'en',
  		   	'CMPCompositeStageComponent',
  		   	'12249'
  		   	);
  add_cp('NAMEADDRESS_CASS',
                   	'Generate CASS Report',
  		   	'NAMEADDRESS.CASSGROUP',
  		   	'en',
  		   	'NA_NO',
  		   	'12250'
  		   	);
  add_cp('NAMEADDRESS_CASS_PROCESSOR',
                   	'Processor Name',
  		   	'NAMEADDRESS.CASSGROUP',
  		   	'en',
  		   	'',
  		   	'12251'
  		   	);
  add_cp('NAMEADDRESS_CASS_LISTNAME',
                   	'List Name',
  		   	'NAMEADDRESS.CASSGROUP',
  		   	'en',
  		   	'',
  		   	'12252'
  		   	);
  add_cg('NAMEADDRESS.INPUT.PARAMGROUP1',
 		   	'Name-Address',
  		   	null,
  		   	'4',
  		   	'',
  		   	'en',
  		   	'CMPCompositeStageComponent',
  		   	'12253'
  		   	);
  add_cp('NAMEADDRESS.INPUTPARAM.DEFAULT_VALUE',
                   	'Input Role',
  		   	'NAMEADDRESS.INPUT.PARAMGROUP1',
  		   	'en',
  		   	'NA_NONE',
  		   	'12254'
  		   	);
  add_cg('NAMEADDRESS.OUTPUT.PARAMGROUP1',
 		   	'Name-Address',
  		   	null,
  		   	'4',
  		   	'',
  		   	'en',
  		   	'CMPCompositeStageComponent',
  		   	'12253'
  		   	);
  add_cp('NAMEADDRESS.OUTPUTPARAM.DEFAULT_VALUE',
                   	'Output Component',
  		   	'NAMEADDRESS.OUTPUT.PARAMGROUP1',
  		   	'en',
  		   	'NA_NONE',
  		   	'12255'
  		   	);
  add_cg('SETOPERATION.PARAMGROUP1',
 		   	'Default',
  		   	null,
  		   	'4',
  		   	'',
  		   	'en',
  		   	'CMPCompositeStageComponent',
  		   	'12122'
  		   	);
  add_cp('SETOPERATION.SETOPERATION',
                   	'Set operation',
  		   	'SETOPERATION.PARAMGROUP1',
  		   	'en',
  		   	'UNION',
  		   	'12256'
  		   	);
  add_cg('DATAENTITY.INOUTGRP.ATTRIBUTE.DEFAULT',
 		   	'Default',
  		   	null,
  		   	'4',
  		   	'',
  		   	'en',
  		   	'CMPCompositeStageComponent',
  		   	'12122'
  		   	);
  add_cp('MAPPING.BOUNDNAME',
                   	'',
  		   	'DATAENTITY.INOUTGRP.ATTRIBUTE.DEFAULT',
  		   	'en',
  		   	'',
  		   	'12161'
  		   	);
  add_cg('ADVANCEDQUEUE.DEFAULT',
 		   	'Default',
  		   	null,
  		   	'4',
  		   	'',
  		   	'en',
  		   	'CMPCompositeStageComponent',
  		   	'12122'
  		   	);
  add_cp('MAPPING.BOUNDNAME',
                   	'',
  		   	'ADVANCEDQUEUE.DEFAULT',
  		   	'en',
  		   	'',
  		   	'12161'
  		   	);
  add_cp('ADVANCEDQUEUE.DEFAULT.QUEUETABLE',
                   	'Queue Table Name',
  		   	'ADVANCEDQUEUE.DEFAULT',
  		   	'en',
  		   	'',
  		   	'12123'
  		   	);
  add_cp('ADVANCEDQUEUE.DEFAULT.PAYLOAD',
                   	'Payload Name',
  		   	'ADVANCEDQUEUE.DEFAULT',
  		   	'en',
  		   	'',
  		   	'12257'
  		   	);
  add_cp('ADVANCEDQUEUE.DEFAULT.TEMPTABLE',
                   	'Temporary Table Name',
  		   	'ADVANCEDQUEUE.DEFAULT',
  		   	'en',
  		   	'',
  		   	'12258'
  		   	);
  add_cp('ADVANCEDQUEUE.DEFAULT.BOUNDOBJECTUOID',
                   	'Bound AQ UOID',
  		   	'ADVANCEDQUEUE.DEFAULT',
  		   	'en',
  		   	'',
  		   	'12259'
  		   	);
  add_cg('ADVANCEDQUEUE.INOUTGRP.ATTRIBUTE.DEFAULT',
 		   	'Default',
  		   	null,
  		   	'4',
  		   	'',
  		   	'en',
  		   	'CMPCompositeStageComponent',
  		   	'12122'
  		   	);
  add_cp('MAPPING.BOUNDNAME',
                   	'',
  		   	'ADVANCEDQUEUE.INOUTGRP.ATTRIBUTE.DEFAULT',
  		   	'en',
  		   	'',
  		   	'12161'
  		   	);
  add_cg('PIVOT.DEFAULTGROUP',
 		   	'Default',
  		   	null,
  		   	'4',
  		   	'',
  		   	'en',
  		   	'CMPCompositeStageComponent',
  		   	'12122'
  		   	);
  add_cp('PIVOT.GROUPSIZE',
                   	'Pivot group size',
  		   	'PIVOT.DEFAULTGROUP',
  		   	'en',
  		   	'2',
  		   	'12260'
  		   	);
  add_cg('PIVOT.INPUTGRP.ATTRIBUTE.DEFAULTGROUP',
 		   	'Default',
  		   	null,
  		   	'4',
  		   	'',
  		   	'en',
  		   	'CMPCompositeStageComponent',
  		   	'12122'
  		   	);
  add_cp('PIVOT.INPUTGRP.ATTRIBUTE.GROUPKEY',
                   	'Group key',
  		   	'PIVOT.INPUTGRP.ATTRIBUTE.DEFAULTGROUP',
  		   	'en',
  		   	'false',
  		   	'12261'
  		   	);
  add_cg('PIVOT.OUTPUTGRP.DEFAULTGROUP',
 		   	'Default',
  		   	null,
  		   	'4',
  		   	'',
  		   	'en',
  		   	'CMPCompositeStageComponent',
  		   	'12122'
  		   	);
  add_cp('PIVOT.OUTPUTGRP.ROWLOCATOR',
                   	'Row locator',
  		   	'PIVOT.OUTPUTGRP.DEFAULTGROUP',
  		   	'en',
  		   	'',
  		   	'12262'
  		   	);
  add_cg('PIVOT.OUTPUTGRP.ATTRIBUTE.DEFAULTGROUP',
 		   	'Default',
  		   	null,
  		   	'4',
  		   	'',
  		   	'en',
  		   	'CMPCompositeStageComponent',
  		   	'12122'
  		   	);
  add_cp('PIVOT.OUTPUTGRP.ATTRIBUTE.PIVOTEXPRESSION',
                   	'Pivot expression',
  		   	'PIVOT.OUTPUTGRP.ATTRIBUTE.DEFAULTGROUP',
  		   	'en',
  		   	'',
  		   	'12263'
  		   	);
  add_cp('PIVOT.OUTPUTGRP.ATTRIBUTE.GROUPKEY',
                   	'Group key',
  		   	'PIVOT.OUTPUTGRP.ATTRIBUTE.DEFAULTGROUP',
  		   	'en',
  		   	'false',
  		   	'12261'
  		   	);
  add_cg('UNPIVOT.INPUTGRP.DEFAULTGROUP',
 		   	'Default',
  		   	null,
  		   	'4',
  		   	'',
  		   	'en',
  		   	'CMPCompositeStageComponent',
  		   	'12122'
  		   	);
  add_cp('UNPIVOT.INPUTGRP.ROWLOCATOR',
                   	'Row locator',
  		   	'UNPIVOT.INPUTGRP.DEFAULTGROUP',
  		   	'en',
  		   	'',
  		   	'12262'
  		   	);
  add_cp('UNPIVOT.INPUTGRP.ROWLOCATORVALUES',
                   	'Row locator values',
  		   	'UNPIVOT.INPUTGRP.DEFAULTGROUP',
  		   	'en',
  		   	'NULL, NULL',
  		   	'12264'
  		   	);
  add_cg('UNPIVOT.INPUTGRP.ATTRIBUTE.DEFAULTGROUP',
 		   	'Default',
  		   	null,
  		   	'4',
  		   	'',
  		   	'en',
  		   	'CMPCompositeStageComponent',
  		   	'12122'
  		   	);
  add_cp('UNPIVOT.INPUTGRP.ATTRIBUTE.GROUPKEY',
                   	'Group key',
  		   	'UNPIVOT.INPUTGRP.ATTRIBUTE.DEFAULTGROUP',
  		   	'en',
  		   	'false',
  		   	'12261'
  		   	);
  add_cg('UNPIVOT.OUTPUTGRP.ATTRIBUTE.DEFAULTGROUP',
 		   	'Default',
  		   	null,
  		   	'4',
  		   	'',
  		   	'en',
  		   	'CMPCompositeStageComponent',
  		   	'12122'
  		   	);
  add_cp('UNPIVOT.OUTPUTGRP.ATTRIBUTE.UNPIVOTEXPRESSION',
                   	'Unpivot expression',
  		   	'UNPIVOT.OUTPUTGRP.ATTRIBUTE.DEFAULTGROUP',
  		   	'en',
  		   	'NULL',
  		   	'12265'
  		   	);
  add_cp('UNPIVOT.OUTPUTGRP.ATTRIBUTE.MATCHINGROW',
                   	'Matching row',
  		   	'UNPIVOT.OUTPUTGRP.ATTRIBUTE.DEFAULTGROUP',
  		   	'en',
  		   	'1',
  		   	'12266'
  		   	);
  add_cp('UNPIVOT.OUTPUTGRP.ATTRIBUTE.GROUPKEY',
                   	'Group key',
  		   	'UNPIVOT.OUTPUTGRP.ATTRIBUTE.DEFAULTGROUP',
  		   	'en',
  		   	'false',
  		   	'12261'
  		   	);
  add_cg('FUNCTION.INPUT.DEFAULT',
 		   	'Default',
  		   	null,
  		   	'4',
  		   	'',
  		   	'en',
  		   	'CMPCompositeStageComponent',
  		   	'12122'
  		   	);
  add_cp('MAPPING.BOUNDNAME',
                   	'',
  		   	'FUNCTION.INPUT.DEFAULT',
  		   	'en',
  		   	'',
  		   	'12161'
  		   	);
  add_cg('FUNCTION.INPUT.PARAMGROUP1',
 		   	'Inputs',
  		   	null,
  		   	'4',
  		   	'',
  		   	'en',
  		   	'CMPCompositeStageComponent',
  		   	'12235'
  		   	);
  add_cp('FUNCTION.INPUTPARAM.DEFAULT_VALUE',
                   	'Default Value',
  		   	'FUNCTION.INPUT.PARAMGROUP1',
  		   	'en',
  		   	'',
  		   	'12232'
  		   	);
  add_cp('FUNCTION.INPUTPARAM.IS_OPTIONAL',
                   	'Is Optional',
  		   	'FUNCTION.INPUT.PARAMGROUP1',
  		   	'en',
  		   	'',
  		   	'12236'
  		   	);
  add_cg('FUNCTION.OUTPUT.DEFAULT',
 		   	'Default',
  		   	null,
  		   	'4',
  		   	'',
  		   	'en',
  		   	'CMPCompositeStageComponent',
  		   	'12122'
  		   	);
  add_cp('MAPPING.BOUNDNAME',
                   	'',
  		   	'FUNCTION.OUTPUT.DEFAULT',
  		   	'en',
  		   	'',
  		   	'12161'
  		   	);
  add_cg('FUNCTION.OUTPUT.PARAMGROUP1',
 		   	'Outputs',
  		   	null,
  		   	'4',
  		   	'',
  		   	'en',
  		   	'CMPCompositeStageComponent',
  		   	'12237'
  		   	);
  add_cp('FUNCTION.OUTPUTPARAM.IS_RESULT',
                   	'Function Return',
  		   	'FUNCTION.OUTPUT.PARAMGROUP1',
  		   	'en',
  		   	'',
  		   	'12238'
  		   	);
  add_cg('FUNCTION.DEFAULTGROUP',
 		   	'Default',
  		   	null,
  		   	'4',
  		   	'',
  		   	'en',
  		   	'CMPCompositeStageComponent',
  		   	'12122'
  		   	);
  add_cp('FUNCTION.FUNCTION_NAME',
                   	'Function Name',
  		   	'FUNCTION.DEFAULTGROUP',
  		   	'en',
  		   	'',
  		   	'12239'
  		   	);
  add_cp('FUNCTION.PROCEDURE_CALL',
                   	'Function Call',
  		   	'FUNCTION.DEFAULTGROUP',
  		   	'en',
  		   	'',
  		   	'12240'
  		   	);
  add_cp('FUNCTION.IS_PROCEDURE',
                   	'Row-based only',
  		   	'FUNCTION.DEFAULTGROUP',
  		   	'en',
  		   	'',
  		   	'12242'
  		   	);
  add_cg('DATAENTITY.DEFAULT',
 		   	'Default',
  		   	null,
  		   	'4',
  		   	'',
  		   	'en',
  		   	'CMPCompositeStageComponent',
  		   	'12122'
  		   	);
  add_cp('MAPPING.BOUNDNAME',
                   	'',
  		   	'DATAENTITY.DEFAULT',
  		   	'en',
  		   	'',
  		   	'12161'
  		   	);
  add_cg('DATAENTITY.KEYS.IDENTIFICATION',
 		   	'Identification',
  		   	null,
  		   	'4',
  		   	'',
  		   	'en',
  		   	'CMPCompositeStageComponent',
  		   	'12005'
  		   	);
  add_cp('DATAENTITY.KEY.NAME',
                   	'Key Name',
  		   	'DATAENTITY.KEYS.IDENTIFICATION',
  		   	'en',
  		   	'',
  		   	'12267'
  		   	);
  add_cp('DATAENTITY.KEY.ID',
                   	'Key ID',
  		   	'DATAENTITY.KEYS.IDENTIFICATION',
  		   	'en',
  		   	'',
  		   	'12268'
  		   	);
  add_cp('DATAENTITY.KEY.RECONCILEUOID',
                   	'Reconcile UOID',
  		   	'DATAENTITY.KEYS.IDENTIFICATION',
  		   	'en',
  		   	'',
  		   	'12269'
  		   	);
  add_cg('DATAENTITY.KEYS.DEFINITION',
 		   	'Identification',
  		   	null,
  		   	'4',
  		   	'',
  		   	'en',
  		   	'CMPCompositeStageComponent',
  		   	'12005'
  		   	);
  add_cp('DATAENTITY.KEY.KEYCOLUMNS',
                   	'Key Columns',
  		   	'DATAENTITY.KEYS.DEFINITION',
  		   	'en',
  		   	'',
  		   	'12270'
  		   	);
  add_cg('DATAENTITY.KEYS.KEYTYPEPARAMS',
 		   	'Key Type Parameters',
  		   	null,
  		   	'4',
  		   	'',
  		   	'en',
  		   	'CMPCompositeStageComponent',
  		   	'12271'
  		   	);
  add_cp('DATAENTITY.KEY.KEYTYPE',
                   	'Key Type',
  		   	'DATAENTITY.KEYS.KEYTYPEPARAMS',
  		   	'en',
  		   	'UNIQUE',
  		   	'12272'
  		   	);
  add_cg('DATAENTITY.KEYS.REFERENCES',
 		   	'References',
  		   	null,
  		   	'4',
  		   	'',
  		   	'en',
  		   	'CMPCompositeStageComponent',
  		   	'12273'
  		   	);
  add_cp('DATAENTITY.KEY.REFERENCEDKEYS',
                   	'Referenced Keys',
  		   	'DATAENTITY.KEYS.REFERENCES',
  		   	'en',
  		   	'',
  		   	'12274'
  		   	);
  add_cp('DATAENTITY.KEY.REFERENCED_RECONCILEUOIDS',
                   	'Referenced Reconcile UOIDs',
  		   	'DATAENTITY.KEYS.REFERENCES',
  		   	'en',
  		   	'',
  		   	'12275'
  		   	);
  add_cg('DATAENTITY.PARMETERS',
 		   	'Default',
  		   	null,
  		   	'4',
  		   	'',
  		   	'en',
  		   	'CMPCompositeStageComponent',
  		   	'12122'
  		   	);
  add_cp('DATAENTITY.PARMETERS.LOADTYPE',
                   	'Loading Type',
  		   	'DATAENTITY.PARMETERS',
  		   	'en',
  		   	'INSERT',
  		   	'12276'
  		   	);
  add_cg('DATAENTITY.CONDITIONALLOAD',
 		   	'Conditional Loading',
  		   	null,
  		   	'4',
  		   	'',
  		   	'en',
  		   	'CMPCompositeStageComponent',
  		   	'12277'
  		   	);
  add_cp('DATAENTITY.PARMETERS.UPDATETARGETCONDITION',
                   	'Target Filter for Update',
  		   	'DATAENTITY.CONDITIONALLOAD',
  		   	'en',
  		   	'',
  		   	'12278'
  		   	);
  add_cp('DATAENTITY.PARMETERS.DELETETARGETCONDITION',
                   	'Delete target condition',
  		   	'DATAENTITY.CONDITIONALLOAD',
  		   	'en',
  		   	'',
  		   	'12279'
  		   	);
  add_cp('DATAENTITY.PARMETERS.MATCHBYCONSTRAINT',
                   	'Match by constraint',
  		   	'DATAENTITY.CONDITIONALLOAD',
  		   	'en',
  		   	'YES',
  		   	'12280'
  		   	);
  add_cg('DATAENTITY.INOUTGRP.ATTRIBUTE.DEFAULT',
 		   	'Default',
  		   	null,
  		   	'4',
  		   	'',
  		   	'en',
  		   	'CMPCompositeStageComponent',
  		   	'12122'
  		   	);
  add_cp('MAPPING.BOUNDNAME',
                   	'',
  		   	'DATAENTITY.INOUTGRP.ATTRIBUTE.DEFAULT',
  		   	'en',
  		   	'',
  		   	'12161'
  		   	);
  add_cg('DATAENTITY.INOUTGRP.ATTRIBUTE.LOADINGPROPERTIES',
 		   	'Loading Properties',
  		   	null,
  		   	'4',
  		   	'',
  		   	'en',
  		   	'CMPCompositeStageComponent',
  		   	'12281'
  		   	);
  add_cp('DATAENTITY.INOUTGRP.ATTRIBUTE.INSERTLOADING',
                   	'Load Column when Inserting Row',
  		   	'DATAENTITY.INOUTGRP.ATTRIBUTE.LOADINGPROPERTIES',
  		   	'en',
  		   	'YES',
  		   	'12282'
  		   	);
  add_cp('DATAENTITY.INOUTGRP.ATTRIBUTE.UPDATELOADING',
                   	'Load Column when Updating Row',
  		   	'DATAENTITY.INOUTGRP.ATTRIBUTE.LOADINGPROPERTIES',
  		   	'en',
  		   	'YES',
  		   	'12283'
  		   	);
  add_cp('DATAENTITY.INOUTGRP.ATTRIBUTE.UPDATEMATCHING',
                   	'Match Column when Updating Row',
  		   	'DATAENTITY.INOUTGRP.ATTRIBUTE.LOADINGPROPERTIES',
  		   	'en',
  		   	'YES',
  		   	'12284'
  		   	);
  add_cp('DATAENTITY.INOUTGRP.ATTRIBUTE.UPDATEOPERATION',
                   	'Update: Operation',
  		   	'DATAENTITY.INOUTGRP.ATTRIBUTE.LOADINGPROPERTIES',
  		   	'en',
  		   	'=',
  		   	'12285'
  		   	);
  add_cp('DATAENTITY.INOUTGRP.ATTRIBUTE.DELETEMATCHING',
                   	'Match Column when Deleting Row',
  		   	'DATAENTITY.INOUTGRP.ATTRIBUTE.LOADINGPROPERTIES',
  		   	'en',
  		   	'YES',
  		   	'12286'
  		   	);
  add_cg('DATAENTITY.DEFAULT',
 		   	'Default',
  		   	null,
  		   	'4',
  		   	'',
  		   	'en',
  		   	'CMPCompositeStageComponent',
  		   	'12122'
  		   	);
  add_cp('DATAENTITY.DEFAULT.PRIMARY_SOURCE',
                   	'Primary Source',
  		   	'DATAENTITY.DEFAULT',
  		   	'en',
  		   	'NO',
  		   	'12287'
  		   	);
 
 begin
  forall p in 1..cg_gk.count 
   insert into OWB_UTIL_CONFIGGROUPS(groupkey, foldername, instancename, grouptype, parentkey, language, logicaltypes, nlskey) values (cg_gk(p), cg_fn(p),cg_in(p),cg_gt(p),cg_pk(p),cg_lan(p),cg_types(p), cg_index(p));
 exception
  when others then
   for p in 1..cg_gk.count loop
    begin
      insert into OWB_UTIL_CONFIGGROUPS(groupkey, foldername, instancename, grouptype, parentkey, language, logicaltypes, nlskey) values (cg_gk(p), cg_fn(p),cg_in(p),cg_gt(p),cg_pk(p),cg_lan(p),cg_types(p), cg_index(p));
    exception
     when others then
      null;
    end;
   end loop;
  end;

 begin
  forall q in 1..cp_pk.count 
   insert into OWB_UTIL_CONFIGPARAMS(paramkey, paramname, groupkey, language, defaultvalue, nlskey) values (cp_pk(q), cp_pn(q),cp_gk(q),cp_lan(q), cp_val(q), cp_index(q));
  exception
   when others then
    for q in 1..cp_pk.count loop
     begin
       insert into OWB_UTIL_CONFIGPARAMS(paramkey, paramname, groupkey, language, defaultvalue, nlskey) values (cp_pk(q), cp_pn(q),cp_gk(q),cp_lan(q), cp_val(q), cp_index(q));
     exception
      when others then
       null;
     end;
    end loop;
  end; 

end;

end;

/



