
begin

declare
 TYPE it_128 is table of varchar(128) index by binary_integer;
 TYPE it_64 is table of varchar(64) index by binary_integer;
 TYPE it_1 is table of number(1) index by binary_integer;
 
 cg_gk it_128;
 cg_fn it_64;
 cg_in it_64;
 cg_gt it_1;
 cg_pk it_128;
 cg_lan it_64;
 cg_types it_128;
 cp_pk  it_128;
 cp_pn it_64;
 cp_lan it_64;
 cp_val it_128;
 cp_gk  it_128;
 cg_index it_64;
 cp_index it_64;
 
 cg_i number := 0;
 cp_i number := 0;

 procedure add_cg (
 	g_gk in varchar2,
 	g_fn in varchar2,
 	g_in in varchar2,
 	g_gt in number,
 	g_pk in varchar2,
 	g_lan in varchar2,
 	g_types in varchar2,
        g_key in varchar2
  ) 
  is
  	l_gk varchar2(128) := g_gk;
  	l_fn varchar2(64) := g_fn;
  	l_gt number(1) := g_gt;
  	l_lan varchar2(64) := g_lan;
  	l_types varchar2(128) := g_types;
  begin
  	if l_gk is null then
  		 l_gk := 'A';
        end if;
        if l_fn is null then 
       		l_fn := 'A';
       	end if;
       	if l_gt is null then
       		l_gt := 0;
       	end if;
       	if l_lan is null then
       		l_lan := 'en';
       	end if;
       	if l_types is null then
       		l_types := 'A';
       	end if;
       	
       	cg_i := cg_i +1;
       	cg_gk(cg_i) := l_gk;
  	cg_fn(cg_i) := l_fn;
  	cg_in(cg_i) := g_in;
  	cg_gt(cg_i) := l_gt;
  	cg_pk(cg_i) := g_pk;
  	cg_lan(cg_i) := l_lan;
  	cg_types(cg_i) := l_types;
        
       
	cg_index(cg_i) := g_key;

  end;

  procedure add_cp (
  	p_pk in varchar2,
  	p_pn in varchar2,
  	p_gk in varchar2,
  	p_lan in varchar2,
  	p_val in varchar2,
	p_key in varchar2
  )
  is
  	l_pk varchar2(128) := p_pk;
  	l_pn varchar2(64) := p_pn;
  	l_gk varchar2(128) := p_gk;
  	l_lan varchar2(64) := p_lan;
  	l_val varchar2(128) := p_val;
  begin
  	if l_pk	is null then
  		l_pk := 'A';
  	end if;
  	if l_pn	is null then
  		l_pn := 'A';
  	end if;
  	if l_gk	is null then
  		l_gk := 'A';
  	end if;
  	if l_lan is null then
  		l_lan := 'en';
  	end if;
  	if l_val is null then
  		l_val := 'A';
  	end if;

  	cp_i := cp_i + 1;
  	cp_pk(cp_i) := l_pk;
  	cp_pn(cp_i) := l_pn;
  	cp_gk(cp_i) := l_gk;
  	cp_lan(cp_i) := l_lan;
        cp_val(cp_i) := l_val;
	cp_index(cp_i) := p_key;

  end;




begin




-- File /tmp/map_sganti/map_physical_step.xml
 add_cg('8i.MAPPINGS.ABAPSTEP.RUNTIMEPARAMS',
 		   	'Runtime parameters',
  		   	null,
  		   	'4',
  		   	'',
  		   	'en',
  		   	'CMPCompositeStageComponent',
  		   	'12249'
  		   	);
  add_cp('8i.MAPPINGS.ABAPSTEP.RUNTIMEPARAMS.SAPSYSTEMVERSION',
                   	'SAP System Version',
  		   	'8i.MAPPINGS.ABAPSTEP.RUNTIMEPARAMS',
  		   	'en',
  		   	'SAP_R3_4X','12250'
  		   	);
  add_cp('8i.MAPPINGS.ABAPSTEP.RUNTIMEPARAMS.STAGINGFILEDIRECTORY',
                   	'Staging File Directory',
  		   	'8i.MAPPINGS.ABAPSTEP.RUNTIMEPARAMS',
  		   	'en',
  		   	'C:\temp\','12251'
  		   	);
  add_cp('8i.MAPPINGS.ABAPSTEP.RUNTIMEPARAMS.DATAFILE',
                   	'Data File Name',
  		   	'8i.MAPPINGS.ABAPSTEP.RUNTIMEPARAMS',
  		   	'en',
  		   	'owb.dat','12071'
  		   	);
  add_cp('8i.MAPPINGS.ABAPSTEP.RUNTIMEPARAMS.CONTROLFILE',
                   	'Control File Name',
  		   	'8i.MAPPINGS.ABAPSTEP.RUNTIMEPARAMS',
  		   	'en',
  		   	'owb.dat','12252'
  		   	);
  add_cp('8i.MAPPINGS.ABAPSTEP.RUNTIMEPARAMS.LOGFILE',
                   	'Log File Name',
  		   	'8i.MAPPINGS.ABAPSTEP.RUNTIMEPARAMS',
  		   	'en',
  		   	'owb.log','12253'
  		   	);
  add_cp('8i.MAPPINGS.ABAPSTEP.RUNTIMEPARAMS.FILEDELIMITER',
                   	'File Delimiter for Staging File',
  		   	'8i.MAPPINGS.ABAPSTEP.RUNTIMEPARAMS',
  		   	'en',
  		   	'~','12254'
  		   	);
  add_cp('8i.MAPPINGS.ABAPSTEP.RUNTIMEPARAMS.SQLJOINCOLLAPSING',
                   	'Sql Join Collapsing',
  		   	'8i.MAPPINGS.ABAPSTEP.RUNTIMEPARAMS',
  		   	'en',
  		   	'TRUE_DEFAULT','12255'
  		   	);
  add_cp('8i.MAPPINGS.ABAPSTEP.RUNTIMEPARAMS.NESTEDLOOP',
                   	'Nested Loop',
  		   	'8i.MAPPINGS.ABAPSTEP.RUNTIMEPARAMS',
  		   	'en',
  		   	'TRUE_DEFAULT','12256'
  		   	);
  add_cp('8i.MAPPINGS.ABAPSTEP.RUNTIMEPARAMS.SELECTSINGLE',
                   	'Use Select Single',
  		   	'8i.MAPPINGS.ABAPSTEP.RUNTIMEPARAMS',
  		   	'en',
  		   	'TRUE_DEFAULT','12257'
  		   	);
  add_cp('8i.MAPPINGS.ABAPSTEP.RUNTIMEPARAMS.PRIMARYFKJOIN',
                   	'Primary Foreign Key for Join',
  		   	'8i.MAPPINGS.ABAPSTEP.RUNTIMEPARAMS',
  		   	'en',
  		   	'DEFAULT','12258'
  		   	);
 
 begin
  forall p in 1..cg_gk.count 
   insert into OWB_UTIL_CONFIGGROUPS(groupkey, foldername, instancename, grouptype, parentkey, language, logicaltypes, nlskey) values (cg_gk(p), cg_fn(p),cg_in(p),cg_gt(p),cg_pk(p),cg_lan(p),cg_types(p), cg_index(p));
 exception
  when others then
   for p in 1..cg_gk.count loop
    begin
      insert into OWB_UTIL_CONFIGGROUPS(groupkey, foldername, instancename, grouptype, parentkey, language, logicaltypes, nlskey) values (cg_gk(p), cg_fn(p),cg_in(p),cg_gt(p),cg_pk(p),cg_lan(p),cg_types(p), cg_index(p));
    exception
     when others then
      null;
    end;
   end loop;
  end;

 begin
  forall q in 1..cp_pk.count 
   insert into OWB_UTIL_CONFIGPARAMS(paramkey, paramname, groupkey, language, defaultvalue, nlskey) values (cp_pk(q), cp_pn(q),cp_gk(q),cp_lan(q), cp_val(q), cp_index(q));
  exception
   when others then
    for q in 1..cp_pk.count loop
     begin
       insert into OWB_UTIL_CONFIGPARAMS(paramkey, paramname, groupkey, language, defaultvalue, nlskey) values (cp_pk(q), cp_pn(q),cp_gk(q),cp_lan(q), cp_val(q), cp_index(q));
     exception
      when others then
       null;
     end;
    end loop;
  end; 

end;

end;

/



