--sochen:may 28, add elementId to locate an object's old reservation ,
--used for pkged function for bug: 2971664, for other object, it is
--possible that an name is reserved without any object associated with it

create type T_Reserved_List IS VARRAY(2000) OF VARCHAR2(100);
--create type SEC_STRINGLIST AS VARRAY(200) OF VARCHAR2(200);

--gggraham: 25Jun2006. Technically, workspaceID not needed for Reservation_Store
-- since parentid is unique across OWBSYS.  Add later for consistency, performance?
create table Reservation_Store(parentID NUMBER,
        domain VARCHAR2(60),
        reservedName VARCHAR2(200),
        isPhys NUMBER(1),
        languageISOID VARCHAR2(40) ,
        elementId NUMBER,
        sessID NUMBER NOT NULL,
	instanceID number not null,
        sessSerial NUMBER NOT NULL,
        sessLogonTime VARCHAR2(30) NOT NULL,
        osUser VARCHAR2(512)  NOT NULL ,
        constraint R_S_PK primary key (parentID, domain, reservedName, isPhys,languageISOID))
        organization index overflow tablespace %tndex
        ;

--gggraham: 25Jun2006. Add WorkspaceID for Owb_Error_Log_Table.
create table Owb_Error_Log_Table(
        workspaceID NUMBER(9) default sys_context('owb_workspace','workspaceID') not null,
        errCode NUMBER NOT NULL,
        errText VARCHAR2(500) NOT NULL,
        info VARCHAR2(500),
        whenHappend VARCHAR2(30)
);
--PARTITION BY LIST (workspaceID)
--(PARTITION ws_global  VALUES (1),
-- PARTITION ws_default VALUES (DEFAULT));
alter table Owb_Error_Log_Table nologging;

--gggraham: 25Jun2006. WorkspaceID not needed for Classification_Store: static, global.
create table Classification_Store(className VARCHAR2(60) NOT NULL ,
        domainName VARCHAR2(60) NOT NULL,
        constraint C_S_PK primary key (className))
        organization index overflow tablespace %tndex
        ;
--sochen:for calais,we added some new object into some domain,hence
--need to synchronize the classification store NOV 1,2002,bug:2639011,4129254

insert into Classification_Store(className, domainName) values('CMPInstalledModule','Schema');
insert into Classification_Store(className, domainName) values('CMPWBOracleInstalledModule','Schema');
insert into Classification_Store(className, domainName) values('CMPWBGatewayInstalledModule','Schema');
insert into Classification_Store(className, domainName) values('CMPWBDataWarehouse','Schema');
insert into Classification_Store(className, domainName) values('CMPWBFileInstalledModule','Schema');
insert into Classification_Store(className, domainName) values('CMPWBPsftInstalledModule','Schema');
insert into Classification_Store(className, domainName) values('CMPWBSAPInstalledModule','Schema');


--fix bug 6711818 
insert into Classification_Store(className, domainName) values('CMPDatabaseModule','Schema');

--sochen
insert into Classification_Store(className, domainName) values('CMPIntelligenceSchema','Schema');
insert into Classification_Store(className, domainName) values('CMPReportSchema','Schema');
insert into Classification_Store(className, domainName) values('CMPLogicalLocation','Location');
insert into Classification_Store(className, domainName) values('CMPRuntimeLocation','Location');

insert into Classification_Store(className, domainName) values('CMPSubProcess','Task');
insert into Classification_Store(className, domainName) values('CMPTask','Task');

insert into Classification_Store(className, domainName) values('CMPProcessInstalledModule','Schema');
--end of schema change
insert into Classification_Store(className, domainName) values('CMPProcessPackage','Package');
insert into Classification_Store(className, domainName) values('CMPProcess','Process');


--changed ? insert into Classification_Store(className, domainName) values('CMPFunction','Procedure');
insert into Classification_Store(className, domainName) values('CMPFunction','DBObject');
insert into Classification_Store(className, domainName) values('CMPFunctionCategory','DBObject');
insert into Classification_Store(className, domainName) values('CMPWBProject','Project');
insert into Classification_Store(className, domainName) values('CMPCube', 'Cube');
insert into Classification_Store(className, domainName) values('CMPCubeMeasure', 'Measure');
insert into Classification_Store(className, domainName) values('CMPCompositeDimension', 'CompositeDimension');
insert into Classification_Store(className, domainName) values('CMPCubeDefAggrMethod', 'DefaultAggregationMethod');
insert into Classification_Store(className, domainName) values('CMPCubeDimReference', 'CubeDimReference');
insert into Classification_Store(className, domainName) values('CMPDimension', 'Dimension');
insert into Classification_Store(className, domainName) values('CMPDimensionRole', 'DimensionRole');
insert into Classification_Store(className, domainName) values('CMPDimensionAttribute', 'DimensionAttribute');
insert into Classification_Store(className, domainName) values('CMPHierarchy', 'Hierarchy');
insert into Classification_Store(className, domainName) values('CMPLevel', 'Level');
insert into Classification_Store(className, domainName) values('CMPLevelRelationship', 'LevelRelationship');
insert into Classification_Store(className, domainName) values('CMPLevelAttribute', 'LevelAttribute');
insert into Classification_Store(className, domainName) values('CMPWBTable','DBObject');
--sochen
insert into Classification_Store(className, domainName) values('CMPExternalTable','DBObject');

insert into Classification_Store(className, domainName) values('CMPWBVirtualTable','DBObject');
insert into Classification_Store(className, domainName) values('CMPWBView','DBObject');
insert into Classification_Store(className, domainName) values('CMPWBMaterializedView','DBObject');
insert into Classification_Store(className, domainName) values('CMPWBTemporaryTable','DBObject');
insert into Classification_Store(className, domainName) values('CMPWBSequence','DBObject');
--sochen:
insert into Classification_Store(className, domainName) values('CMPAdvancedQueue','AdvancedQueue');
insert into Classification_Store(className, domainName) values('CMPObjectType','DBObject');

insert into Classification_Store(className, domainName) values('CMPCatalog','Catalog');
--sochen:
insert into Classification_Store(className, domainName) values('CMPIntelligenceBusArea','IntBusArea');


insert into Classification_Store(className, domainName) values('CMPQueryObject','QueryObject');
insert into Classification_Store(className, domainName) values('CMPReport','Report');
insert into Classification_Store(className, domainName) values('CMPReportGroup','ReportGroup');

insert into Classification_Store(className, domainName) values('CMPBusinessRuleModule','BrModuleType');
insert into Classification_Store(className, domainName) values('CMPBusinessRuleDefinition','BrType');


insert into Classification_Store(className, domainName) values('CMPRelationalDBItem','Column');
insert into Classification_Store(className, domainName) values('CMPMap','DBObject');
	
--jan 31, 05: sync between namespaceHookupService.java and
--nscreate.sql on domain
insert into Classification_Store(className, domainName) values('CMPDataRuleMap','DBObject');
insert into Classification_Store(className, domainName) values('CMPMapOperator','Map');
insert into Classification_Store(className, domainName) values('CMPMapAttributeGroup','MapOperator');
insert into Classification_Store(className, domainName) values('CMPMapAttribute','MapAttributeGroup');
insert into Classification_Store(className, domainName) values('CMPMapDisplaySet','MapDisplaySet');
insert into Classification_Store(className, domainName) values('CMPVariable','Map');


insert into Classification_Store(className, domainName) values('CMPCompositeStageComponent','DBObject');
insert into Classification_Store(className, domainName) values('CMPStageComponent','Stage');
insert into Classification_Store(className, domainName) values('CMPMappingParameterGroup','StageComponent');
insert into Classification_Store(className, domainName) values('CMPMappingParameter','ParameterGroup');
insert into Classification_Store(className, domainName) values('CMPUniqueKey','Constraint');
insert into Classification_Store(className, domainName) values('CMPForeignKey','Constraint');
insert into Classification_Store(className, domainName) values('CMPWBCheckConstraint','Constraint');
insert into Classification_Store(className, domainName) values('CMPIndex','Constraint');
insert into Classification_Store(className, domainName) values('CMPFunctionArgument','Parameter');
insert into Classification_Store(className, domainName) values('CMPSoftwareModule','SoftwareModule');
insert into Classification_Store(className, domainName) values('CMPWBSystem','System');
insert into Classification_Store(className, domainName) values('CMPWBFile','DBObject');
insert into Classification_Store(className, domainName) values('CMPWBIntegrator','Integrator');
insert into Classification_Store(className, domainName) values('CMPWBApplicationType','ApplicationType');
insert into Classification_Store(className, domainName) values('CMPWBSystemType','SystemType');
insert into Classification_Store(className, domainName) values('CMPACEType','ACEType');
insert into Classification_Store(className, domainName) values('CMPWBLogicalTree','LogicalTree');
insert into Classification_Store(className, domainName) values('CMPWBField','Field');
--insert into Classification_Store(className, domainName) values('CMPWBFormatMask','Field');
insert into Classification_Store(className, domainName) values('CMPWBFormatMask','Mask');
--sochen , add more
insert into Classification_Store(className, domainName) values('CMPQueryItem','QueryItem');
insert into Classification_Store(className, domainName) values('CMPDrillPath','DrillPath');
insert into Classification_Store(className, domainName) values('CMPDrillLevel','DrillLevel');
insert into Classification_Store(className, domainName) values('CMPJoin','Join');
insert into Classification_Store(className, domainName) values('CMPDMModel','MiningModel');

insert into Classification_Store(className, domainName) values('CMPLOVItemClass','ItemClass');
insert into Classification_Store(className, domainName) values('CMPQueryCondition','QueryCondition');
insert into Classification_Store(className, domainName) values('CMPDateHierTemplate','DateHierTemplate');
insert into Classification_Store(className, domainName) values('CMPDateHierLevel','DateHierLevel');
insert into Classification_Store(className, domainName) values('CMPReportItem','ReportItem');
insert into Classification_Store(className, domainName) values('CMPRefCursorType','UserType');
insert into Classification_Store(className, domainName) values('CMPPLSCollection','UserType');
insert into Classification_Store(className, domainName) values('CMPPLSRecord','UserType');
insert into Classification_Store(className, domainName) values('CMPQueueTable','DBObject');
insert into Classification_Store(className, domainName) values('CMPQueuePropagation','AQ');
insert into Classification_Store(className, domainName) values('CMPWBUser','PrivilegeOwner');
insert into Classification_Store(className, domainName) values('CMPWBRole','PrivilegeOwner');
insert into Classification_Store(className, domainName) values('CMPWBMIVDefinition','MIV');
insert into Classification_Store(className, domainName) values('CMPChangeLog','DBObject');
insert into Classification_Store(className, domainName) values('CMPStreamsCapture','DBObject');
insert into Classification_Store(className, domainName) values('CMPCaptureRelation','DBObject');

---sochen: newly introduced for paris(April 26,04, paris version:17)
insert into Classification_Store(className, domainName) values('CMPVariableFolder','Schema');
insert into Classification_Store(className, domainName) values('CMPProgramGroup','Schema');

insert into Classification_Store(className, domainName) values('CMPProgram','Program');
insert into Classification_Store(className, domainName) values('CMPProcessActivity','ProcessActivity');
insert into Classification_Store(className, domainName) values('CMPGlobalVariable','GlobalVariable');
insert into Classification_Store(className, domainName) values('CMPCalendarInstalledModule','Schema');
insert into Classification_Store(className, domainName) values('CMPCalendarFolder','CalendarFolder');

insert into Classification_Store(className, domainName) values('CMPCalendar','Calendar');
insert into Classification_Store(className, domainName) values('CMPLocalCalendar','LocalCalendar');
insert into Classification_Store(className, domainName) values('CMPTimeWindow','TimeWindow');
insert into Classification_Store(className, domainName) values('CMPSQLCollection','DBObject');
--insert into Classification_Store(className, domainName) values('CMPDateHierTemplate','DateHierTemplate');
insert into Classification_Store(className, domainName) values('CMPLocation','Location');
insert into Classification_Store(className, domainName) values('CMPLogicalConnector','Connector');
insert into Classification_Store(className, domainName) values('CMPNamedConfiguration', 'Schema');
insert into Classification_Store(className, domainName) values('CMPNamedConfigurationUsage', 'Deployment');

--sochen: Jan 31, 05: need to sync between  objnsgrouping and
-- nscreate.sql on domain, fix bug:4129254
--insert into Classification_Store(className, domainName) values('CMPBusinessRuleModule', 'BrModuleType');
--insert into Classification_Store(className, domainName) values('CMPBusinessRuleDefinition', 'BrType');
--sochen: Jan 31, 05: fix bug: 4110096, this one need to sync between
--cmpwaakmodule.getNamespaceType and nsscreate.sql on domain
insert into Classification_Store(className, domainName) values('CMPWeakModule', 'Schema');
insert into Classification_Store(className, domainName) values('CMPWeakFolder', 'DBObject');
insert into Classification_Store(className, domainName) values('CMPWeakFirstClassObject', 'DBObject');

-- xiaoge: added for model, platform objects
insert into Classification_Store(className, domainName) values('CMPPlatform', 'Platform');
insert into Classification_Store(className, domainName) values('CMPUserConfigTemplateSet', 'UserConfigTemplateSet');
insert into Classification_Store(className, domainName) values('CMPPlatformConfigTemplate', 'PlatformConfigTemplate');
insert into Classification_Store(className, domainName) values('CMPModelUsage', 'ModelUsage');
insert into Classification_Store(className, domainName) values('CMPPlatformConfiguration', 'PlatformConfiguration');
insert into Classification_Store(className, domainName) values('CMPArrayType', 'Type');
insert into Classification_Store(className, domainName) values('CMPPrimitiveType', 'Type');
insert into Classification_Store(className, domainName) values('CMPNamedDomain', 'Type');
insert into Classification_Store(className, domainName) values('CMPRange', 'Range');
insert into Classification_Store(className, domainName) values('CMPArrayModelAttribute', 'ModelAttribute');
insert into Classification_Store(className, domainName) values('CMPPrimitiveModelAttribute', 'ModelAttribute');
insert into Classification_Store(className, domainName) values('CMPReferenceModelAttribute', 'ModelAttribute');
insert into Classification_Store(className, domainName) values('CMPAssociationDefinition', 'AssociationDefinition');
insert into Classification_Store(className, domainName) values('CMPClassDefinition', 'Type');
insert into Classification_Store(className, domainName) values('CMPClassUsage', 'ClassUsage');
insert into Classification_Store(className, domainName) values('CMPClassUsageGroup', 'ClassUsageGroup');
insert into Classification_Store(className, domainName) values('CMPDependencyDefinition', 'DependencyDefinition');
insert into Classification_Store(className, domainName) values('CMPPropertyDefinition', 'PropertyDefinition');
insert into Classification_Store(className, domainName) values('CMPPropertyGroupDefinition', 'PropertyGroup');
insert into Classification_Store(className, domainName) values('CMPPropertySetDefinition', 'PropertySet');
insert into Classification_Store(className, domainName) values('CMPRegistryEntry', 'RegistryEntry');
insert into Classification_Store(className, domainName) values('CMPRegistryService', 'RegistryService');
insert into Classification_Store(className, domainName) values('CMPRoleDefinition', 'RoleDefinition');
insert into Classification_Store(className, domainName) values('CMPTranslatedField', 'TranslatedField');

--sochen: feb 26, 2008: add some for tahoe
insert into Classification_Store(className, domainName) values('CMPDiagram', 'Map');
insert into Classification_Store(className, domainName) values('CMPDiagramFolder', 'Map');


--gggraham: 25Jun2006. Add WorkspaceID for FCOFOLDERNamespace
create table FCOFOLDERNamespace (
  workspaceID NUMBER(9) default sys_context('owb_workspace','workspaceID') not null,
  snapshotID NUMBER(9) default 0,
  isSeed NUMBER(1) default 1,
  active NUMBER(1) default 0,
  parentID NUMBER(9),
  domain VARCHAR2(60),
  name VARCHAR2(200),
  isPhys NUMBER(1),
  elementid NUMBER,
  aggregateParent NUMBER,
  languageISOID varchar(40)
);
--PARTITION BY LIST (workspaceID)
--(PARTITION ws_global  VALUES (1),
-- PARTITION ws_default VALUES (DEFAULT));
alter table FCOFOLDERNamespace nologging;

--gggraham: 25Jun2006. Add WorkspaceID for CMPALLFOLDERFCONAMES
create view CMPALLFOLDERFCONAMES (
  workspaceID,
  parentID,
  domain,
  name,
  isPhys,
  elementid,
  aggregateParent,
  languageISOID
)
as select
  workspaceID,
  parentID,
  domain,
  name,
  isPhys,
  elementid,
  aggregateParent,
  languageISOID
from FCOFOLDERNamespace
where active = 0
  and workspaceid = (select sys_context('owb_workspace','workspaceID') from dual);



--create a table to contain the namespace rules related to different target db platform e.g. db2, sql server, oracle
--this table is not workspace sensitive

--create table namespace_rules(
--platform_name varchar2(200) ,
--name_max_length number, 
--name_length_semantics varchar2(100), 
--illegal_chars varchar2(400), 
--illegal_leading_chars varchar2(400), 
--escape_char char(1), 
--enclosure_char char(1) 
--);

create table reserved_words(
platform_name varchar2(200), 
reserved_word varchar2(400)
);
create index reserved_words_idx on reserved_words(platform_name);
