CREATE OR REPLACE PACKAGE WBSecurityHelper AS
PROCEDURE updateRolePwd(pwd in VARCHAR2);
PROCEDURE registerOWBUser(userid in VARCHAR2);	
PROCEDURE unregisterOWBUser(userid in VARCHAR2);	
PROCEDURE listOWBUsers;	
PROCEDURE recordLoginUserInfo(userId in varchar2, sessionInstId in number, sessionSid in number, sessionOsUser in varchar2, theWorkspaceId number);

procedure cleanLoginUserInfo(sessionInstId in number, sessionSid in number);


-- 0: means not connected  to cur wksp
-- 1: means connected to cur workspace  
function isUserConnedToCurrWksp(sessionInstId in number, sessionSid in number,  curWs in  number, userName in varchar2) return number;

subtype digested_str is varchar2(16);
subtype digested_raw is RAW(16);


PROCEDURE initRoleInfo(outcome out VARCHAR2, 
			 time in VARCHAR2,
			 schemaName in VARCHAR2);	
FUNCTION isUserDefaultRoleSetAsAll(userid in VARCHAR2)
RETURN NUMBER;

FUNCTION doesOWBSysHasAlterUserPriv return number;

FUNCTION DigestSchema( input in varchar2, needObfu boolean default true) return digested_raw;

FUNCTION doesUserHasRoleGranted(theUser in varchar2, theRole in varchar2, adminOption in varchar2) return number;	 
FUNCTION getListOfGrantedRoles(theUser in varchar2, isDefault in varchar2) return SEC_STRINGLIST;


END WBSecurityHelper;

