#top level module that handles all the  options of emctl related to dbconsole.
#Author : Kondayya Duvvuri
#Date Created: 05/18/2004
package CompEMdbconsole;
use DBConsoleLifeCycle;
use AgentStatus;
use AgentMisc;
use EmKeyCmds;
use EmCommonCmdDriver;
use EmctlCommon;
use DBConsoleStatus;
use DBConsole;
use CompEMagent;
use SecureDBConsoleCmds;
use RegisterTType;
use DBConsoleBanner;

$EMHOME=getEMHome();
$ENV{'EMHOME'} = $EMHOME;
$EM_OC4J_HOME=getOC4JHome();

sub new {
  my $classname = shift;
  my $self = {} ;
  bless ( $self, $classname);

  #cmdList is a list containing all the command implementors.
  $self->{cmds} = [ DBConsoleLifeCycle->new(), DBConsoleStatus->new(),
                    AgentStatus->new(), AgentMisc->new(), EmKeyCmds->new(),
                    SecureDBConsoleCmds->new(), RegisterTType->new() ] ;

  return $self;
}

sub doIT {
   my $self = shift;
   $refCmds = $self->{cmds};
   $cmdDriver = EmCommonCmdDriver->new();
   $result = $cmdDriver->doIT($refCmds, \@_);
   return $result;
}

sub usage {
    print "   Oracle Enterprise Manager 10g Database Control commands:\n";
    my $self = shift;
    $refCmds = $self->{cmds};
    $cmdDriver = EmCommonCmdDriver->new();
    $result = $cmdDriver->usage($refCmds, \@_);
}

sub getVersion {
  #print "this is Version from CompEMdbconsole.pm\n";
  my $self = shift;
  $refVars = [ DBConsole->new(), EMAgent->new() ];
  $cmdDriver = EmCommonCmdDriver->new();
  $result = $cmdDriver->getVersion($refVars, \@_);
}

sub banner {
  my $self = shift;
  my $rargs = shift; #reference to command line args.
                                                                                                                                                             
  #print "Oracle Enterprise Manager 11g Database Control Release 11.2.0.0.1 \n";
   DBConsoleBanner::printOEMVersion();  
  # print "Copyright (c) 1996, 2008 Oracle Corporation.  All rights reserved.\n";
   DBConsoleBanner::printCopyright();  
  print "$DB_URL\n" if (defined($DB_URL));

  if($DEBUG_ENABLED)
  {
    print "NOHUP Files are $AGENT_NOHUPFILE | $DB_NOHUPFILE | $IAS_NOHUPFILE \n";
  }
                                                                                                                                                             
}

sub getOC4JHome {
  return &DBConsole::getOC4JHome();
}

sub getEMHome {
  return &DBConsole::getEMHome();
}

sub DESTROY {
    my $self = shift;
}

1;
