# File:DBConsoleStatus.pm
#Author: Kondayya Duvvuri
#Date Created: 05/18/2004
# kduvvuri  06/08/2004  add emctl getemhome 

package DBConsoleStatus;
use EmctlCommon;
use EmCommonCmdDriver;
use EMSAConsoleCommon;
use DBConsole;

sub new {
  my $classname = shift;
  my $self = { };
  bless ( $self, $classname);

  return $self;
}

sub doIT {
   my $classname = shift;
   my $rargs = shift;
   my $result = $EMCTL_UNK_CMD;

   $argCount = @$rargs;
   # if 2nd arg is  dbconsole, look for start and stop as the first args.
   #print "doIT of DBConsoleStatus.pm: self is $classname, args from dbconsole.pm @$rargs\n";
   if ( $rargs->[1] eq "dbconsole" )
   {
     #print "Processing <options> dbconsole \n";

     if ( $rargs->[0] eq "status" )
     {
        #print "Processing status dbconsole\n";
        statusDBConsole();
        $result = $EMCTL_DONE;
     }
     elsif ( $rargs->[0] eq "istatus" )
     {
        #print "Processing istatus dbconsole\n";
        istatusDBConsole(); 
        $result =  $EMCTL_DONE;
     }
     elsif ( $rargs->[0] eq "setpasswd")
     {
       setReposPasswd();
       $result = $EMCTL_DONE;
     }
     elsif ( $rargs->[0] eq "config" )
     {
       $result = configHeap($rargs);
     }
     else  
     {
       $result = $EMCTL_UNK_CMD;
     }
   }
   elsif ( $rargs->[0] eq "getemhome")
   {
     print "EMHOME=$ENV{EMHOME}\n";
     $result = $EMCTL_DONE;
   }
   return $result;
}

sub statusDBConsole
{
  @args = ();
  $args[0] = "dbconsole";
  $args[1] = new DBConsole();
  $args[2] = "Oracle Enterprise Manager 11g";
  $saStatObj = EMSAConsoleCommon->new();
  $saStatObj->statusSAConsole(@args);
}

sub istatusDBConsole
{
  @args = ();
  $args[0] = new DBConsole();
  $saStatObj = EMSAConsoleCommon->new();
  my ($pstatus) = $saStatObj->statusSAConsole_Internal(@args);
  # Agent returns 3 or 4 for either running or running but not ready
  # While console returns 0 for UP and rest for DOWN.
  # We convert the PROCESS_OK status to return code 3
  if($pstatus == $STATUS_PROCESS_OK)
  {
      exit 3;
  }
  else
  {
    exit 1;
  }
}

#
# setupSecure takes
# 1) Array of arguments
#
# Secure::secure leads to other perl modules that make use of a shell
# env var DEFAULT_CLASSPATH
#
sub setupSecure()
{
  local (*args) = @_;
  #print "args to secure are @args\n";
  shift(@args);
  Secure::secure( @args );
}

#
# Adds heap entry to emoms.properties
# emctl config dbconsole -heap_size <size_value> -max_perm_size <size_value>
#
sub configHeap()
{
  local (*args) = @_;

  shift(@args);                  # -- shift out config...
  shift(@args);                  # -- shift out dbconsole ...

  if (@args lt 1)
  {
    return($EMCTL_BAD_USAGE);
  }

  my $heap_size = "";
  my $perm_size = "";

  while(@args gt 0)
  {
    if ($args[0] eq "-heap_size")
    {
      shift(@args);
      $heap_size = $args[0];
      #print "heap size is $heap_size\n";
      shift(@args);
    }
    elsif($args[0] eq "-max_perm_size")
    {
      shift(@args);
      $perm_size = $args[0];
      #print "perm size is $perm_size\n";
      shift(@args);
    }
    else 
    {
      return($EMCTL_BAD_USAGE);
    }
  }

  if (($heap_size eq "") && ($perm_size eq ""))
  {
    return($EMCTL_BAD_USAGE);
  }

  my $prop_file ="$ENV{EMHOME}/sysman/config/emoms.properties";
  open(PROPFILE, "$prop_file") || die "Could not open $prop_file\n";
  my @PROPS = <PROPFILE>;
  close PROPFILE;

  open(PROPFILE, ">$prop_file") || die "Could not open $prop_file\n";
  foreach $line (@PROPS)
  {
    if (($line =~ m/^\s*oracle.sysman.dbc.heapSize/i) && ($heap_size ne ""))
    {
      #skip copy line since have new value
      next;
    }
    elsif (($line =~ m/^\s*oracle.sysman.dbc.permSize/i) && ($perm_size ne ""))
    {
      next;
    }
    else
    {
      print PROPFILE $line;
    }  
  }

  #append new values to end of file
  if ($heap_size ne "")
  {
      print PROPFILE "oracle.sysman.dbc.heapSize=$heap_size\n"; 
  }
  if ($perm_size ne "")
  {
      print PROPFILE "oracle.sysman.dbc.permSize=$perm_size\n";
  }

  close(PROPFILE);

  print "\nOMS heap size properties successfully added to emoms.properties file.\n";

  return $EMCTL_DONE;
}


sub usage
{
  print "        emctl status | secure | setpasswd dbconsole\n";
  print "        emctl config dbconsole -heap_size <size_value> -max_perm_size <size_value>\n";
}

sub DESTROY {
    my $self = shift;
}

1;
