Rem Copyright (c) 2007, 2009, Oracle and/or its affiliates. 
Rem All rights reserved. 
Rem
Rem    NAME
Rem      rab_install.sql - create Runtime Audit Browser view definitions
Rem
Rem    DESCRIPTION
Rem      This script is used to create Runtime Audit Browser tables and views
Rem      for a heterogeneous environment using a DB2 database
Rem
Rem    NOTES
Rem      Logon to the DB2 database to be used for the Audit Data Source
Rem      @<OWB-HOME>/owb/rtasst/jrtaudit/db2/rab_install.sql
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    lmogilev    03/18/08 - 
Rem    tzrose      01/15/07 - Created to be compatible for DB2
Rem

create table dual (dummy varchar(1));


INSERT into dual (dummy) VALUES ('X');


create view ALL_RT_INSTALLATIONS as 
select
cast(null as numeric(22,0)) as installation_id,
'OWB JRT' as installation_name,
'' as description,
'11.2' as installed_version,
cast(null as varchar(32)) as release,
'11.2' as public_view_version,
'HRAB' as schema_type,
cast(null as date) as updated_on,
cast(null as date) as created_on
from dual;


CREATE VIEW "RAB_RT_INSTALLATIONS" ("INSTALLATION_ID", "INSTALLATION_NAME", "DESCRIPTION", "INSTALLED_VERSION", "RELEASE", "PUBLIC_VIEW_VERSION", "SCHEMA_TYPE", "UPDATED_ON", "CREATED_ON") AS 
select
installation_id,
installation_name,
description,
installed_version,
release,
public_view_version,
'HRAB' as schema_type,
updated_on,
created_on
from
ALL_RT_INSTALLATIONS;


-- Used ProcExecution.sqlj
CREATE TABLE "RAB_RT_AUDIT_OBJECTS"(
    "AUDIT_DEPLOYMENT_ID" numeric(22,0), 
	"AUDIT_UNIT_ID" numeric(22,0), 
	"STORE_UOID" varchar(32), 
	"STORE_NAME" varchar(64), 
	"TGT_STORE_UOID" varchar(32), 
	"TGT_STORE_NAME" varchar(64), 
	"AUDIT_OBJECT_ID" numeric(22,0), 
	"OBJECT_UOID" varchar(32), 
	"OBJECT_TYPE" varchar(64), 
	"OBJECT_TYPE_SYMBOL" varchar(64), 
	"OBJECT_NAME" varchar(64), 
	"PARENT_AUDIT_OBJECT_ID" numeric(22,0), 
	"OBJECT_VERSION_TAG" varchar(80), 
	"OBJECT_numeric" numeric(10,0), 
	"NUMBER_OF_OBJECTS" numeric(10,0), 
	"NUMBER_OF_SCRIPTS" numeric(10,0), 
	"AUDIT_STATUS" numeric(8,0), 
	"AUDIT_STATUS_SYMBOL" varchar(32), 
	"FINAL_OBJECT_STATUS" numeric(8,0), 
	"FINAL_OBJECT_STATUS_SYMBOL" varchar(32), 
	"SEVERITY" numeric, 
	"SEVERITY_SYMBOL" varchar(32), 
	"ELAPSE_TIME" numeric, 
	"DEPLOYMENT_DATE" date, 
	"CREATED_BY" varchar(30), 
	"UPDATED_DATE" date, 
	"UPDATED_BY" varchar(30)
   ) ;


CREATE TABLE "RAB_RT_DEP_SEVERITY" 
   (	"SEVERITY" numeric, 
	"SYMBOL" VARCHAR(32), 
	"ICON" VARCHAR(18)
   ) ;


Insert into RAB_RT_DEP_SEVERITY (SEVERITY,SYMBOL,ICON) values (7001,'INFORMATIONAL','images/info.gif');
Insert into RAB_RT_DEP_SEVERITY (SEVERITY,SYMBOL,ICON) values (7002,'WARNING','images/warning.gif');
Insert into RAB_RT_DEP_SEVERITY (SEVERITY,SYMBOL,ICON) values (7003,'ERROR','images/error.gif');
Insert into RAB_RT_DEP_SEVERITY (SEVERITY,SYMBOL,ICON) values (7004,'RECOVERY','images/Failed.gif');


CREATE TABLE "RAB_RT_EXEC_PROC_RESULTS" 
   (	"RESULT_NUMBER" numeric, 
	"RESULT_SYMBOL" VARCHAR(32), 
	"COMPLETE_RESULT" VARCHAR(81), 
	"COMPLETE_SYMBOL" VARCHAR(32)
   ) ;


Insert into RAB_RT_EXEC_PROC_RESULTS (RESULT_NUMBER,RESULT_SYMBOL,COMPLETE_RESULT,COMPLETE_SYMBOL) values (1,'OK','16004:1','COMPLETE_OK');
Insert into RAB_RT_EXEC_PROC_RESULTS (RESULT_NUMBER,RESULT_SYMBOL,COMPLETE_RESULT,COMPLETE_SYMBOL) values (2,'OK_WITH_WARNINGS','16004:2','COMPLETE_OK_WITH_WARNINGS');
Insert into RAB_RT_EXEC_PROC_RESULTS (RESULT_NUMBER,RESULT_SYMBOL,COMPLETE_RESULT,COMPLETE_SYMBOL) values (3,'FAILURE','16004:3','COMPLETE_FAILURE');


CREATE TABLE "RAB_RT_EXEC_PROC_STATUS" 
   (	"STATUS" numeric, 
	"SYMBOL" VARCHAR(32), 
	"PURGE_DISABLED" VARCHAR(5), 
	"ABORT_DISABLED" VARCHAR(5), 
	"COMPLETE_DISABLED" VARCHAR(5), 
	"STYLE" VARCHAR(11)
   ) ;


Insert into RAB_RT_EXEC_PROC_STATUS (STATUS,SYMBOL,PURGE_DISABLED,ABORT_DISABLED,COMPLETE_DISABLED,STYLE) values (16001,'INACTIVE','false','true','true',null);
Insert into RAB_RT_EXEC_PROC_STATUS (STATUS,SYMBOL,PURGE_DISABLED,ABORT_DISABLED,COMPLETE_DISABLED,STYLE) values (16002,'BUSY','true','false','false','OraDataText');
Insert into RAB_RT_EXEC_PROC_STATUS (STATUS,SYMBOL,PURGE_DISABLED,ABORT_DISABLED,COMPLETE_DISABLED,STYLE) values (16003,'READY','true','false','true','OraDataText');
Insert into RAB_RT_EXEC_PROC_STATUS (STATUS,SYMBOL,PURGE_DISABLED,ABORT_DISABLED,COMPLETE_DISABLED,STYLE) values (16004,'COMPLETE','false','true','true',null);


CREATE TABLE "RAB_RT_EXEC_SEVERITY" 
   (	"SYMBOL" CHAR(5), 
	"ICON" CHAR(16)
   ) ;


Insert into RAB_RT_EXEC_SEVERITY (SYMBOL,ICON) values ('ERROR','images/error.gif');


CREATE TABLE "RAB_RT_SOURCE_TARGET" 
   (	"CODE" CHAR(1), 
	"SYMBOL" CHAR(6)
   ) ;


Insert into RAB_RT_SOURCE_TARGET (CODE,SYMBOL) values ('S','SOURCE');
Insert into RAB_RT_SOURCE_TARGET (CODE,SYMBOL) values ('T','TARGET');


CREATE TABLE "RAB_RT_EXCEPTION_CHECKS"
   ("ERR_NUMBER" numeric,
    "ERR_CODE" VARCHAR(30),
    "RAB_CONTEXT" VARCHAR(30),
    "ERR_DESC" VARCHAR(200));


insert into RAB_RT_EXCEPTION_CHECKS (ERR_NUMBER,ERR_CODE,RAB_CONTEXT,ERR_DESC)
values (-1, 'ORA-00001', 'constraint_checking', 'ORA-00001: unique constraint (string.string) violated');
insert into RAB_RT_EXCEPTION_CHECKS (ERR_NUMBER,ERR_CODE,RAB_CONTEXT,ERR_DESC)
values (-942, 'ORA-00942', 'login_validation', 'ORA-00942: table or view does not exist');
insert into RAB_RT_EXCEPTION_CHECKS (ERR_NUMBER,ERR_CODE,RAB_CONTEXT,ERR_DESC)
values (-942, 'ORA-00942', 'shadow_table', 'ORA-00942: table or view does not exist');
insert into RAB_RT_EXCEPTION_CHECKS (ERR_NUMBER,ERR_CODE,RAB_CONTEXT,ERR_DESC)
values (-1017, 'ORA-01017', 'store_validation', 'ORA-01017: invalid username/password; logon denied');
insert into RAB_RT_EXCEPTION_CHECKS (ERR_NUMBER,ERR_CODE,RAB_CONTEXT,ERR_DESC)
values (-1031, 'ORA-01031', 'shadow_table', 'ORA-01031: insufficient privileges');
insert into RAB_RT_EXCEPTION_CHECKS (ERR_NUMBER,ERR_CODE,RAB_CONTEXT,ERR_DESC)
values (-2291, 'ORA-02291', 'constraint_checking', 'ORA-02291: integrity constraint (string.string) violated - parent key not found');
insert into RAB_RT_EXCEPTION_CHECKS (ERR_NUMBER,ERR_CODE,RAB_CONTEXT,ERR_DESC)
values (-20001, 'RTV-20001', 'constraint_checking', 'RTV-20001: integrity constraint {0} violated - parent key not found.');
insert into RAB_RT_EXCEPTION_CHECKS (ERR_NUMBER,ERR_CODE,RAB_CONTEXT,ERR_DESC)
values (-20002, 'RTV-20002', 'constraint_checking', 'RTV-20002: Cannot validate {0} - parent keys not found.');
insert into RAB_RT_EXCEPTION_CHECKS (ERR_NUMBER,ERR_CODE,RAB_CONTEXT,ERR_DESC)
values (-22285, 'ORA-22285', 'store_validation', 'ORA-22285: non-existent directory or file for string operation');
insert into RAB_RT_EXCEPTION_CHECKS (ERR_NUMBER,ERR_CODE,RAB_CONTEXT,ERR_DESC)
values (-28000, 'ORA-28000', 'store_validation', 'ORA-28000: the account is locked');


CREATE TABLE "RAB_RT_EXTERNAL_URLS" 
   (	"EXT_PRODUCT" CHAR(3), 
	"EXT_TARGET" VARCHAR(14), 
	"URL_SYMBOL" VARCHAR(18), 
	"REPORT_BASE" CHAR(9), 
	"PARAM_DELIMITER" CHAR(2), 
	"TYPE_NAME_CHECK" CHAR(15), 
	"TYPE_VERSION_CHECK" VARCHAR(2), 
	"PREFERRED_PATH" VARCHAR(59), 
	"ALTERNATIVE_PATH" CHAR(59)
   ) ;


Insert into RAB_RT_EXTERNAL_URLS (EXT_PRODUCT,EXT_TARGET,URL_SYMBOL,REPORT_BASE,PARAM_DELIMITER,TYPE_NAME_CHECK,TYPE_VERSION_CHECK,PREFERRED_PATH,ALTERNATIVE_PATH) values ('OEM','SCHEDULER_JOBS','OEM_SCHEDULER_JOBS','RTProcess','**','Oracle Database','10','**OEMWebServerBase**/em/console/database/instance/schr/jobs','http://**Host**:5500/em/console/database/instance/schr/jobs');
Insert into RAB_RT_EXTERNAL_URLS (EXT_PRODUCT,EXT_TARGET,URL_SYMBOL,REPORT_BASE,PARAM_DELIMITER,TYPE_NAME_CHECK,TYPE_VERSION_CHECK,PREFERRED_PATH,ALTERNATIVE_PATH) values ('OWF','MONITOR','OWF_MONITOR','RTProcess','**','Oracle Workflow','0','**OWFWebServerBase**',null);


CREATE TABLE "RAB_RT_REP_TYPES" 
   (	"OBJ_TYPE" VARCHAR(64), 
	"SYMBOL" VARCHAR(64), 
	"REP_FCO" VARCHAR(5), 
	"REP_TYPE" VARCHAR(12)
   ) ;


Insert into RAB_RT_REP_TYPES (OBJ_TYPE,SYMBOL,REP_FCO,REP_TYPE) values ('ABAPFile','ABAPFILE','true','RTMap');
Insert into RAB_RT_REP_TYPES (OBJ_TYPE,SYMBOL,REP_FCO,REP_TYPE) values ('AND','AND','false',null);
Insert into RAB_RT_REP_TYPES (OBJ_TYPE,SYMBOL,REP_FCO,REP_TYPE) values ('AQPayloadType','AQPAYLOADTYPE','false','RTDataObject');
Insert into RAB_RT_REP_TYPES (OBJ_TYPE,SYMBOL,REP_FCO,REP_TYPE) values ('AQSubsciption','AQSUBSCIPTION','true','RTDataObject');
Insert into RAB_RT_REP_TYPES (OBJ_TYPE,SYMBOL,REP_FCO,REP_TYPE) values ('AccessGrants','ACCESSGRANTS','false','RTDataObject');
Insert into RAB_RT_REP_TYPES (OBJ_TYPE,SYMBOL,REP_FCO,REP_TYPE) values ('AccessViewCube','ACCESSVIEWCUBE','false','RTDataObject');
Insert into RAB_RT_REP_TYPES (OBJ_TYPE,SYMBOL,REP_FCO,REP_TYPE) values ('AccessViewDimension','ACCESSVIEWDIMENSION','false','RTDataObject');
Insert into RAB_RT_REP_TYPES (OBJ_TYPE,SYMBOL,REP_FCO,REP_TYPE) values ('AdvancedQueue','ADVANCEDQUEUE','true','RTDataObject');
Insert into RAB_RT_REP_TYPES (OBJ_TYPE,SYMBOL,REP_FCO,REP_TYPE) values ('AggregationCube','AGGREGATIONCUBE','false','RTDataObject');
Insert into RAB_RT_REP_TYPES (OBJ_TYPE,SYMBOL,REP_FCO,REP_TYPE) values ('AlternativeSortOrder','ALTERNATIVESORTORDER','true','RTDataObject');
Insert into RAB_RT_REP_TYPES (OBJ_TYPE,SYMBOL,REP_FCO,REP_TYPE) values ('AppsCMScheduler','APPSCMSCHEDULER','false',null);
Insert into RAB_RT_REP_TYPES (OBJ_TYPE,SYMBOL,REP_FCO,REP_TYPE) values ('Assign','ASSIGN','false',null);
Insert into RAB_RT_REP_TYPES (OBJ_TYPE,SYMBOL,REP_FCO,REP_TYPE) values ('AutosysProcessFlow','AUTOSYSPROCESSFLOW','false',null);
Insert into RAB_RT_REP_TYPES (OBJ_TYPE,SYMBOL,REP_FCO,REP_TYPE) values ('BusinessArea','BUSINESSAREA','true','RTDataObject');
Insert into RAB_RT_REP_TYPES (OBJ_TYPE,SYMBOL,REP_FCO,REP_TYPE) values ('CDCChangeSet','CDCCHANGESET','false',null);
Insert into RAB_RT_REP_TYPES (OBJ_TYPE,SYMBOL,REP_FCO,REP_TYPE) values ('CDCStreamsCapture','CDCSTREAMSCAPTURE','false',null);
Insert into RAB_RT_REP_TYPES (OBJ_TYPE,SYMBOL,REP_FCO,REP_TYPE) values ('CMPKMTaskFlow','KMTASKFLOW','true','RTProcess');
Insert into RAB_RT_REP_TYPES (OBJ_TYPE,SYMBOL,REP_FCO,REP_TYPE) values ('CMPMapKM','KMMAP','true','RTMap');
Insert into RAB_RT_REP_TYPES (OBJ_TYPE,SYMBOL,REP_FCO,REP_TYPE) values ('CheckConstraint','CHECKCONSTRAINT','false','RTDataObject');
Insert into RAB_RT_REP_TYPES (OBJ_TYPE,SYMBOL,REP_FCO,REP_TYPE) values ('Column','COLUMN','false','RTDataObject');
Insert into RAB_RT_REP_TYPES (OBJ_TYPE,SYMBOL,REP_FCO,REP_TYPE) values ('Comment','COMMENT','false','RTDataObject');
Insert into RAB_RT_REP_TYPES (OBJ_TYPE,SYMBOL,REP_FCO,REP_TYPE) values ('Cube','CUBE','true','RTDataObject');
Insert into RAB_RT_REP_TYPES (OBJ_TYPE,SYMBOL,REP_FCO,REP_TYPE) values ('DBMSScheduler','DBMSSCHEDULER','false',null);
Insert into RAB_RT_REP_TYPES (OBJ_TYPE,SYMBOL,REP_FCO,REP_TYPE) values ('DataAuditor','DATAAUDITOR','true','RTMap');
Insert into RAB_RT_REP_TYPES (OBJ_TYPE,SYMBOL,REP_FCO,REP_TYPE) values ('DataProfile','DATAPROFILE','true','RTDataObject');
Insert into RAB_RT_REP_TYPES (OBJ_TYPE,SYMBOL,REP_FCO,REP_TYPE) values ('DatabaseLink','DATABASELINK','true','RTDBLink');
Insert into RAB_RT_REP_TYPES (OBJ_TYPE,SYMBOL,REP_FCO,REP_TYPE) values ('Dimension','DIMENSION','true','RTDataObject');
Insert into RAB_RT_REP_TYPES (OBJ_TYPE,SYMBOL,REP_FCO,REP_TYPE) values ('Directory','DIRECTORY','true','RTDataObject');
Insert into RAB_RT_REP_TYPES (OBJ_TYPE,SYMBOL,REP_FCO,REP_TYPE) values ('DrillPath','DRILLPATH','true','RTDataObject');
Insert into RAB_RT_REP_TYPES (OBJ_TYPE,SYMBOL,REP_FCO,REP_TYPE) values ('DrillToDetail','DRILLTODETAIL','true','RTDataObject');
Insert into RAB_RT_REP_TYPES (OBJ_TYPE,SYMBOL,REP_FCO,REP_TYPE) values ('EJB','EJB','false',null);
Insert into RAB_RT_REP_TYPES (OBJ_TYPE,SYMBOL,REP_FCO,REP_TYPE) values ('Email','EMAIL','false',null);
Insert into RAB_RT_REP_TYPES (OBJ_TYPE,SYMBOL,REP_FCO,REP_TYPE) values ('EnablerCube','ENABLERCUBE','false','RTDataObject');
Insert into RAB_RT_REP_TYPES (OBJ_TYPE,SYMBOL,REP_FCO,REP_TYPE) values ('EnablerDimension','ENABLERDIMENSION','false','RTDataObject');
Insert into RAB_RT_REP_TYPES (OBJ_TYPE,SYMBOL,REP_FCO,REP_TYPE) values ('EvaluateTransition','EVALUATETRANSITION','false',null);
Insert into RAB_RT_REP_TYPES (OBJ_TYPE,SYMBOL,REP_FCO,REP_TYPE) values ('execute','KMPHASE','true','RTProcess');
Insert into RAB_RT_REP_TYPES (OBJ_TYPE,SYMBOL,REP_FCO,REP_TYPE) values ('ExternalTable','EXTERNALTABLE','true','RTDataObject');
Insert into RAB_RT_REP_TYPES (OBJ_TYPE,SYMBOL,REP_FCO,REP_TYPE) values ('FTP','FTP','false',null);
Insert into RAB_RT_REP_TYPES (OBJ_TYPE,SYMBOL,REP_FCO,REP_TYPE) values ('ForeignKey','FOREIGNKEY','false','RTDataObject');
Insert into RAB_RT_REP_TYPES (OBJ_TYPE,SYMBOL,REP_FCO,REP_TYPE) values ('IOFunction','IOFUNCTION','true','RTDataObject');
Insert into RAB_RT_REP_TYPES (OBJ_TYPE,SYMBOL,REP_FCO,REP_TYPE) values ('Index','INDEX','false','RTDataObject');
Insert into RAB_RT_REP_TYPES (OBJ_TYPE,SYMBOL,REP_FCO,REP_TYPE) values ('J2EEApplication','J2EEAPPLICATION','true','RTDataObject');
Insert into RAB_RT_REP_TYPES (OBJ_TYPE,SYMBOL,REP_FCO,REP_TYPE) values ('JRTJob','JRTJOB','true','RTProcess');
Insert into RAB_RT_REP_TYPES (OBJ_TYPE,SYMBOL,REP_FCO,REP_TYPE) values ('JRTPhase','JRTPHASE','true','RTProcess');
Insert into RAB_RT_REP_TYPES (OBJ_TYPE,SYMBOL,REP_FCO,REP_TYPE) values ('JRTStep','JRTSTEP','true','RTMap');
Insert into RAB_RT_REP_TYPES (OBJ_TYPE,SYMBOL,REP_FCO,REP_TYPE) values ('JRTTask','JRTTASK','true','RTProcess');
Insert into RAB_RT_REP_TYPES (OBJ_TYPE,SYMBOL,REP_FCO,REP_TYPE) values ('Java','JAVA','false',null);
Insert into RAB_RT_REP_TYPES (OBJ_TYPE,SYMBOL,REP_FCO,REP_TYPE) values ('JavaOSProcess','JAVAOSPROCESS','false',null);
Insert into RAB_RT_REP_TYPES (OBJ_TYPE,SYMBOL,REP_FCO,REP_TYPE) values ('KnowledgeModule','KNOWLEDGEMODULE','true','RTDataObject');
Insert into RAB_RT_REP_TYPES (OBJ_TYPE,SYMBOL,REP_FCO,REP_TYPE) values ('LibraryFunction','LIBRARYFUNCTION','true','RTDataObject');
Insert into RAB_RT_REP_TYPES (OBJ_TYPE,SYMBOL,REP_FCO,REP_TYPE) values ('LibraryPackage','LIBRARYPACKAGE','true','RTDataObject');
Insert into RAB_RT_REP_TYPES (OBJ_TYPE,SYMBOL,REP_FCO,REP_TYPE) values ('LibraryProcedure','LIBRARYPROCEDURE','true','RTDataObject');
Insert into RAB_RT_REP_TYPES (OBJ_TYPE,SYMBOL,REP_FCO,REP_TYPE) values ('LibraryTableFunction','LIBRARYTABLEFUNCTION','true','RTDataObject');
Insert into RAB_RT_REP_TYPES (OBJ_TYPE,SYMBOL,REP_FCO,REP_TYPE) values ('ListOfValues','LISTOFVALUES','true','RTDataObject');
Insert into RAB_RT_REP_TYPES (OBJ_TYPE,SYMBOL,REP_FCO,REP_TYPE) values ('Location','LOCATION','true','RTDataObject');
Insert into RAB_RT_REP_TYPES (OBJ_TYPE,SYMBOL,REP_FCO,REP_TYPE) values ('Manual','MANUAL','false',null);
Insert into RAB_RT_REP_TYPES (OBJ_TYPE,SYMBOL,REP_FCO,REP_TYPE) values ('Mapping','MAPPING','true','RTProcess');
Insert into RAB_RT_REP_TYPES (OBJ_TYPE,SYMBOL,REP_FCO,REP_TYPE) values ('MatViewCube','MATVIEWCUBE','false','RTDataObject');
Insert into RAB_RT_REP_TYPES (OBJ_TYPE,SYMBOL,REP_FCO,REP_TYPE) values ('MaterializedView','MATERIALIZEDVIEW','true','RTDataObject');
Insert into RAB_RT_REP_TYPES (OBJ_TYPE,SYMBOL,REP_FCO,REP_TYPE) values ('NullOperation','NULLOPERATION','false',null);
Insert into RAB_RT_REP_TYPES (OBJ_TYPE,SYMBOL,REP_FCO,REP_TYPE) values ('OMBPlus','OMBPLUS','false',null);
Insert into RAB_RT_REP_TYPES (OBJ_TYPE,SYMBOL,REP_FCO,REP_TYPE) values ('OR','OR','false',null);
Insert into RAB_RT_REP_TYPES (OBJ_TYPE,SYMBOL,REP_FCO,REP_TYPE) values ('ObjectType','OBJECTTYPE','true','RTDataObject');
Insert into RAB_RT_REP_TYPES (OBJ_TYPE,SYMBOL,REP_FCO,REP_TYPE) values ('OlapCube','OLAPCUBE','false','RTDataObject');
Insert into RAB_RT_REP_TYPES (OBJ_TYPE,SYMBOL,REP_FCO,REP_TYPE) values ('OlapDimension','OLAPDIMENSION','false','RTDataObject');
Insert into RAB_RT_REP_TYPES (OBJ_TYPE,SYMBOL,REP_FCO,REP_TYPE) values ('OwfNotification','OWFNOTIFICATION','false',null);
Insert into RAB_RT_REP_TYPES (OBJ_TYPE,SYMBOL,REP_FCO,REP_TYPE) values ('PLSQL','PLSQL','false',null);
Insert into RAB_RT_REP_TYPES (OBJ_TYPE,SYMBOL,REP_FCO,REP_TYPE) values ('PLSQLFunction','PLSQLFUNCTION','false',null);
Insert into RAB_RT_REP_TYPES (OBJ_TYPE,SYMBOL,REP_FCO,REP_TYPE) values ('PLSQLMap','PLSQLMAP','true','RTMap');
Insert into RAB_RT_REP_TYPES (OBJ_TYPE,SYMBOL,REP_FCO,REP_TYPE) values ('PLSQLProcedure','PLSQLPROCEDURE','false',null);
Insert into RAB_RT_REP_TYPES (OBJ_TYPE,SYMBOL,REP_FCO,REP_TYPE) values ('Partition','PARTITION','false','RTDataObject');
Insert into RAB_RT_REP_TYPES (OBJ_TYPE,SYMBOL,REP_FCO,REP_TYPE) values ('PathExists','PATHEXISTS','false',null);
Insert into RAB_RT_REP_TYPES (OBJ_TYPE,SYMBOL,REP_FCO,REP_TYPE) values ('PostGeneric','POSTGENERIC','true','RTDataObject');
Insert into RAB_RT_REP_TYPES (OBJ_TYPE,SYMBOL,REP_FCO,REP_TYPE) values ('PostOwfNotification','POSTOWFNOTIFICATION','false',null);
Insert into RAB_RT_REP_TYPES (OBJ_TYPE,SYMBOL,REP_FCO,REP_TYPE) values ('PreGeneric','PREGENERIC','true','RTDataObject');
Insert into RAB_RT_REP_TYPES (OBJ_TYPE,SYMBOL,REP_FCO,REP_TYPE) values ('PreOwfNotification','PREOWFNOTIFICATION','false',null);
Insert into RAB_RT_REP_TYPES (OBJ_TYPE,SYMBOL,REP_FCO,REP_TYPE) values ('PrimaryKey','PRIMARYKEY','false','RTDataObject');
Insert into RAB_RT_REP_TYPES (OBJ_TYPE,SYMBOL,REP_FCO,REP_TYPE) values ('ProcessFlow','PROCESSFLOW','true','RTProcess');
Insert into RAB_RT_REP_TYPES (OBJ_TYPE,SYMBOL,REP_FCO,REP_TYPE) values ('ProcessFlowPackage','PROCESSFLOWPACKAGE','true','RTProcess');
Insert into RAB_RT_REP_TYPES (OBJ_TYPE,SYMBOL,REP_FCO,REP_TYPE) values ('QueryObject','QUERYOBJECT','true','RTDataObject');
Insert into RAB_RT_REP_TYPES (OBJ_TYPE,SYMBOL,REP_FCO,REP_TYPE) values ('QueuePropagation','QUEUEPROPAGATION','true','RTDataObject');
Insert into RAB_RT_REP_TYPES (OBJ_TYPE,SYMBOL,REP_FCO,REP_TYPE) values ('QueueTable','QUEUETABLE','true','RTDataObject');
Insert into RAB_RT_REP_TYPES (OBJ_TYPE,SYMBOL,REP_FCO,REP_TYPE) values ('Report','REPORT','true','RTDataObject');
Insert into RAB_RT_REP_TYPES (OBJ_TYPE,SYMBOL,REP_FCO,REP_TYPE) values ('SAP','SAP','false',null);
Insert into RAB_RT_REP_TYPES (OBJ_TYPE,SYMBOL,REP_FCO,REP_TYPE) values ('SQLCollection','SQLCOLLECTION','true','RTDataObject');
Insert into RAB_RT_REP_TYPES (OBJ_TYPE,SYMBOL,REP_FCO,REP_TYPE) values ('SQLLoader','SQLLOADER','false',null);
Insert into RAB_RT_REP_TYPES (OBJ_TYPE,SYMBOL,REP_FCO,REP_TYPE) values ('SQLLoaderControlFile','SQLLOADERCONTROLFILE','true','RTMap');
Insert into RAB_RT_REP_TYPES (OBJ_TYPE,SYMBOL,REP_FCO,REP_TYPE) values ('SQLPLUSFile','SQLPLUSFILE','true','RTDataObject');
Insert into RAB_RT_REP_TYPES (OBJ_TYPE,SYMBOL,REP_FCO,REP_TYPE) values ('SQLPlus','SQLPLUS','false',null);
Insert into RAB_RT_REP_TYPES (OBJ_TYPE,SYMBOL,REP_FCO,REP_TYPE) values ('SQLPlusDirect','SQLPLUSDIRECT','false',null);
Insert into RAB_RT_REP_TYPES (OBJ_TYPE,SYMBOL,REP_FCO,REP_TYPE) values ('ScheduledJob','SCHEDULEDJOB','true','RTProcess');
Insert into RAB_RT_REP_TYPES (OBJ_TYPE,SYMBOL,REP_FCO,REP_TYPE) values ('Sequence','SEQUENCE','true','RTDataObject');
Insert into RAB_RT_REP_TYPES (OBJ_TYPE,SYMBOL,REP_FCO,REP_TYPE) values ('SetStatus','SETSTATUS','false',null);
Insert into RAB_RT_REP_TYPES (OBJ_TYPE,SYMBOL,REP_FCO,REP_TYPE) values ('ShadowTable','SHADOWTABLE','false','RTDataObject');
Insert into RAB_RT_REP_TYPES (OBJ_TYPE,SYMBOL,REP_FCO,REP_TYPE) values ('Shell','SHELL','false',null);
Insert into RAB_RT_REP_TYPES (OBJ_TYPE,SYMBOL,REP_FCO,REP_TYPE) values ('StagingObjects','STAGINGOBJECTS','false','RTDataObject');
Insert into RAB_RT_REP_TYPES (OBJ_TYPE,SYMBOL,REP_FCO,REP_TYPE) values ('StreamObjects','STREAMOBJECTS','true','RTDataObject');
Insert into RAB_RT_REP_TYPES (OBJ_TYPE,SYMBOL,REP_FCO,REP_TYPE) values ('StreamsCapture','STREAMSCAPTURE','true','RTMap');
Insert into RAB_RT_REP_TYPES (OBJ_TYPE,SYMBOL,REP_FCO,REP_TYPE) values ('StreamsQueue','STREAMSQUEUE','true','RTDataObject');
Insert into RAB_RT_REP_TYPES (OBJ_TYPE,SYMBOL,REP_FCO,REP_TYPE) values ('SubstituteKey','SUBSTITUTEKEY','false','RTDataObject');
Insert into RAB_RT_REP_TYPES (OBJ_TYPE,SYMBOL,REP_FCO,REP_TYPE) values ('SupplementalLog','SUPPLEMENTALLOG','true','RTDataObject');
Insert into RAB_RT_REP_TYPES (OBJ_TYPE,SYMBOL,REP_FCO,REP_TYPE) values ('SwitchTransition','SWITCHTRANSITION','false',null);
Insert into RAB_RT_REP_TYPES (OBJ_TYPE,SYMBOL,REP_FCO,REP_TYPE) values ('TTSSet','TTSSET','true','RTDataObject');
Insert into RAB_RT_REP_TYPES (OBJ_TYPE,SYMBOL,REP_FCO,REP_TYPE) values ('Table','TABLE','true','RTDataObject');
Insert into RAB_RT_REP_TYPES (OBJ_TYPE,SYMBOL,REP_FCO,REP_TYPE) values ('TaskGroup','TASKGROUP','false',null);
Insert into RAB_RT_REP_TYPES (OBJ_TYPE,SYMBOL,REP_FCO,REP_TYPE) values ('TrickleFeed','TRICKLEFEED','false',null);
Insert into RAB_RT_REP_TYPES (OBJ_TYPE,SYMBOL,REP_FCO,REP_TYPE) values ('UniqueKey','UNIQUEKEY','false','RTDataObject');
Insert into RAB_RT_REP_TYPES (OBJ_TYPE,SYMBOL,REP_FCO,REP_TYPE) values ('View','VIEW','true','RTDataObject');
Insert into RAB_RT_REP_TYPES (OBJ_TYPE,SYMBOL,REP_FCO,REP_TYPE) values ('ViewRedefinition','VIEWREDEFINITION','false','RTDataObject');
Insert into RAB_RT_REP_TYPES (OBJ_TYPE,SYMBOL,REP_FCO,REP_TYPE) values ('Wait','WAIT','false',null);
Insert into RAB_RT_REP_TYPES (OBJ_TYPE,SYMBOL,REP_FCO,REP_TYPE) values ('WebService','WEBSERVICE','false',null);
Insert into RAB_RT_REP_TYPES (OBJ_TYPE,SYMBOL,REP_FCO,REP_TYPE) values ('WhileLoop','WHILELOOP','false',null);


-- Used ProcExecution.sqlj
CREATE TABLE "RAB_RT_WH_OBJECTS"(	
    "WH_OBJECT_ID" numeric(22,0), 
	"OBJECT_UOID" varchar(32), 
	"OBJECT_NAME" varchar(64), 
	"OBJECT_QNAME" varchar(32), 
	"OBJECT_TYPE" varchar(64), 
	"OBJECT_TYPE_SYMBOL" varchar(64), 
	"OBJECT_STATUS" numeric(8,0), 
	"SUB_OBJECTS_VALID" numeric(1,0), 
	"RELATED_OBJECTS_VALID" numeric(1,0), 
	"OBJECT_STATUS_SYMBOL" varchar(32), 
	"VERSION_TAG" varchar(80), 
	"PARENT_WH_OBJECT_ID" numeric(22,0), 
	"STORE_ID" numeric(22,0), 
	"STORE_UOID" varchar(32), 
	"STORE_NAME" varchar(64), 
	"TGT_STORE_ID" numeric(22,0), 
	"TGT_STORE_UOID" varchar(32), 
	"TGT_STORE_NAME" varchar(64), 
	"LAST_DEPLOYMENT_STATUS" varchar(40), 
	"LAST_DEPLOYMENT_STATUS_SYMBOL" varchar(32), 
	"LAST_MAX_SEVERITY" numeric, 
	"LAST_MAX_SEVERITY_SYMBOL" varchar(32), 
	"LAST_DEPLOYMENT_DATE" date
   ) ;


CREATE TABLE "WB_RT_CONSTANTS_TABLE" 
(	
  "CONSTANT_NAME" VARCHAR(32), 
  "CONSTANT_NUM" NUMERIC, 
  "CONSTANT_VARCHAR" VARCHAR(32)
);


Insert into WB_RT_CONSTANTS_TABLE (CONSTANT_NAME,CONSTANT_NUM,CONSTANT_VARCHAR) values ('EVENT_TYPE_UNIT_OP_START',1001,'START');
Insert into WB_RT_CONSTANTS_TABLE (CONSTANT_NAME,CONSTANT_NUM,CONSTANT_VARCHAR) values ('EVENT_TYPE_UNIT_OP_COMPLETE',1002,'COMPLETE');
Insert into WB_RT_CONSTANTS_TABLE (CONSTANT_NAME,CONSTANT_NUM,CONSTANT_VARCHAR) values ('EVENT_TYPE_EXEC_OP_START',1003,'START');
Insert into WB_RT_CONSTANTS_TABLE (CONSTANT_NAME,CONSTANT_NUM,CONSTANT_VARCHAR) values ('EVENT_TYPE_EXEC_OP_COMPLETE',1004,'COMPLETE');
Insert into WB_RT_CONSTANTS_TABLE (CONSTANT_NAME,CONSTANT_NUM,CONSTANT_VARCHAR) values ('EVENT_TYPE_SCRIPT_RUN_BEGIN',1005,'BEGIN');
Insert into WB_RT_CONSTANTS_TABLE (CONSTANT_NAME,CONSTANT_NUM,CONSTANT_VARCHAR) values ('EVENT_TYPE_SCRIPT_RUN_END',1006,'END');
Insert into WB_RT_CONSTANTS_TABLE (CONSTANT_NAME,CONSTANT_NUM,CONSTANT_VARCHAR) values ('EVENT_TYPE_TASK_BEGIN',1007,'BEGIN');
Insert into WB_RT_CONSTANTS_TABLE (CONSTANT_NAME,CONSTANT_NUM,CONSTANT_VARCHAR) values ('EVENT_TYPE_TASK_END',1008,'END');
Insert into WB_RT_CONSTANTS_TABLE (CONSTANT_NAME,CONSTANT_NUM,CONSTANT_VARCHAR) values ('EVENT_TYPE_FILE',1009,'FILE');
Insert into WB_RT_CONSTANTS_TABLE (CONSTANT_NAME,CONSTANT_NUM,CONSTANT_VARCHAR) values ('EVENT_TYPE_INFORMATIONAL',1010,'INFORMATIONAL');
Insert into WB_RT_CONSTANTS_TABLE (CONSTANT_NAME,CONSTANT_NUM,CONSTANT_VARCHAR) values ('EVENT_TYPE_WARNING',1011,'WARNING');
Insert into WB_RT_CONSTANTS_TABLE (CONSTANT_NAME,CONSTANT_NUM,CONSTANT_VARCHAR) values ('EVENT_TYPE_ERROR',1012,'ERROR');
Insert into WB_RT_CONSTANTS_TABLE (CONSTANT_NAME,CONSTANT_NUM,CONSTANT_VARCHAR) values ('EVENT_TYPE_RECOVERY',1013,'RECOVERY');
Insert into WB_RT_CONSTANTS_TABLE (CONSTANT_NAME,CONSTANT_NUM,CONSTANT_VARCHAR) values ('EVENT_TYPE_PREPARED',1014,'PREPARED');
Insert into WB_RT_CONSTANTS_TABLE (CONSTANT_NAME,CONSTANT_NUM,CONSTANT_VARCHAR) values ('EVENT_TYPE_UNPREPARED',1015,'UNPREPARED');
Insert into WB_RT_CONSTANTS_TABLE (CONSTANT_NAME,CONSTANT_NUM,CONSTANT_VARCHAR) values ('EVENT_TYPE_TIMEOUT',1016,'TIMEOUT');
Insert into WB_RT_CONSTANTS_TABLE (CONSTANT_NAME,CONSTANT_NUM,CONSTANT_VARCHAR) values ('PARAM_KIND_SYSTEM',4001,'SYSTEM');
Insert into WB_RT_CONSTANTS_TABLE (CONSTANT_NAME,CONSTANT_NUM,CONSTANT_VARCHAR) values ('PARAM_KIND_CUSTOM',4002,'CUSTOM');
Insert into WB_RT_CONSTANTS_TABLE (CONSTANT_NAME,CONSTANT_NUM,CONSTANT_VARCHAR) values ('PARAM_TYPE_BOOLEAN',2001,'BOOLEAN');
Insert into WB_RT_CONSTANTS_TABLE (CONSTANT_NAME,CONSTANT_NUM,CONSTANT_VARCHAR) values ('PARAM_TYPE_CHAR',2002,'CHAR');
Insert into WB_RT_CONSTANTS_TABLE (CONSTANT_NAME,CONSTANT_NUM,CONSTANT_VARCHAR) values ('PARAM_TYPE_DATE',2003,'DATE');
Insert into WB_RT_CONSTANTS_TABLE (CONSTANT_NAME,CONSTANT_NUM,CONSTANT_VARCHAR) values ('PARAM_TYPE_FLOAT',2004,'FLOAT');
Insert into WB_RT_CONSTANTS_TABLE (CONSTANT_NAME,CONSTANT_NUM,CONSTANT_VARCHAR) values ('PARAM_TYPE_NUMBER',2005,'NUMBER');
Insert into WB_RT_CONSTANTS_TABLE (CONSTANT_NAME,CONSTANT_NUM,CONSTANT_VARCHAR) values ('PARAM_TYPE_VARCHAR',2006,'VARCHAR');
Insert into WB_RT_CONSTANTS_TABLE (CONSTANT_NAME,CONSTANT_NUM,CONSTANT_VARCHAR) values ('PARAM_TYPE_VARCHAR2',2007,'VARCHAR2');
Insert into WB_RT_CONSTANTS_TABLE (CONSTANT_NAME,CONSTANT_NUM,CONSTANT_VARCHAR) values ('PARAM_TYPE_OPERATING_MODE',2008,'OPERATING_MODE');
Insert into WB_RT_CONSTANTS_TABLE (CONSTANT_NAME,CONSTANT_NUM,CONSTANT_VARCHAR) values ('PARAM_TYPE_AUDIT_LEVEL',2009,'AUDIT_LEVEL');
Insert into WB_RT_CONSTANTS_TABLE (CONSTANT_NAME,CONSTANT_NUM,CONSTANT_VARCHAR) values ('PARAM_TYPE_TIMESTAMP',2010,'TIMESTAMP');
Insert into WB_RT_CONSTANTS_TABLE (CONSTANT_NAME,CONSTANT_NUM,CONSTANT_VARCHAR) values ('PARAM_TYPE_TIMESTAMP_TZ',2011,'TIMESTAMP_TZ');
Insert into WB_RT_CONSTANTS_TABLE (CONSTANT_NAME,CONSTANT_NUM,CONSTANT_VARCHAR) values ('PARAM_TYPE_BINARY_INTEGER',2012,'BINARY_INTEGER');
Insert into WB_RT_CONSTANTS_TABLE (CONSTANT_NAME,CONSTANT_NUM,CONSTANT_VARCHAR) values ('PARAM_TYPE_PLS_INTEGER',2013,'PLS_INTEGER');
Insert into WB_RT_CONSTANTS_TABLE (CONSTANT_NAME,CONSTANT_NUM,CONSTANT_VARCHAR) values ('PARAM_TYPE_ANY',2014,'ANYTYPE');
Insert into WB_RT_CONSTANTS_TABLE (CONSTANT_NAME,CONSTANT_NUM,CONSTANT_VARCHAR) values ('PARAM_TYPE_LOCATION_UOID',2015,'LOCATION_UOID');
Insert into WB_RT_CONSTANTS_TABLE (CONSTANT_NAME,CONSTANT_NUM,CONSTANT_VARCHAR) values ('PARAM_TYPE_BINARY_DOUBLE',2016,'BINARY_DOUBLE');
Insert into WB_RT_CONSTANTS_TABLE (CONSTANT_NAME,CONSTANT_NUM,CONSTANT_VARCHAR) values ('PARAM_TYPE_BINARY_FLOAT',2017,'BINARY_FLOAT');
Insert into WB_RT_CONSTANTS_TABLE (CONSTANT_NAME,CONSTANT_NUM,CONSTANT_VARCHAR) values ('PARAM_TYPE_INTERVAL_DY_TO_SEC',2018,'INTERVAL_DY_TO_SEC');
Insert into WB_RT_CONSTANTS_TABLE (CONSTANT_NAME,CONSTANT_NUM,CONSTANT_VARCHAR) values ('PARAM_TYPE_INTERVAL_YR_TO_MO',2019,'INTERVAL_YR_TO_MO');
Insert into WB_RT_CONSTANTS_TABLE (CONSTANT_NAME,CONSTANT_NUM,CONSTANT_VARCHAR) values ('PARAM_TYPE_TIMESTAMP_LTZ',2020,'TIMESTAMP_LTZ');
Insert into WB_RT_CONSTANTS_TABLE (CONSTANT_NAME,CONSTANT_NUM,CONSTANT_VARCHAR) values ('PARAM_TYPE_VARCHAR2_TF',2021,'VARCHAR2_TRUE_FALSE');
Insert into WB_RT_CONSTANTS_TABLE (CONSTANT_NAME,CONSTANT_NUM,CONSTANT_VARCHAR) values ('PARAM_TYPE_XMLTYPE',2022,'XML_TYPE');
Insert into WB_RT_CONSTANTS_TABLE (CONSTANT_NAME,CONSTANT_NUM,CONSTANT_VARCHAR) values ('PARAM_TYPE_CLOB',2023,'CLOB');
Insert into WB_RT_CONSTANTS_TABLE (CONSTANT_NAME,CONSTANT_NUM,CONSTANT_VARCHAR) values ('PARAM_TYPE_BLOB',2024,'BLOB');
Insert into WB_RT_CONSTANTS_TABLE (CONSTANT_NAME,CONSTANT_NUM,CONSTANT_VARCHAR) values ('PARAM_MODE_IN',3001,'IN');
Insert into WB_RT_CONSTANTS_TABLE (CONSTANT_NAME,CONSTANT_NUM,CONSTANT_VARCHAR) values ('PARAM_MODE_OUT',3002,'OUT');
Insert into WB_RT_CONSTANTS_TABLE (CONSTANT_NAME,CONSTANT_NUM,CONSTANT_VARCHAR) values ('PARAM_MODE_INOUT',3003,'INOUT');
Insert into WB_RT_CONSTANTS_TABLE (CONSTANT_NAME,CONSTANT_NUM,CONSTANT_VARCHAR) values ('PARAM_MODE_VARIABLE',3004,'VARIABLE');
Insert into WB_RT_CONSTANTS_TABLE (CONSTANT_NAME,CONSTANT_NUM,CONSTANT_VARCHAR) values ('ACTION_CREATE',6001,'CREATE');
Insert into WB_RT_CONSTANTS_TABLE (CONSTANT_NAME,CONSTANT_NUM,CONSTANT_VARCHAR) values ('ACTION_DROP',6002,'DROP');
Insert into WB_RT_CONSTANTS_TABLE (CONSTANT_NAME,CONSTANT_NUM,CONSTANT_VARCHAR) values ('ACTION_UPGRADE',6003,'UPGRADE');
Insert into WB_RT_CONSTANTS_TABLE (CONSTANT_NAME,CONSTANT_NUM,CONSTANT_VARCHAR) values ('ACTION_REPORT',6004,'REPORT');
Insert into WB_RT_CONSTANTS_TABLE (CONSTANT_NAME,CONSTANT_NUM,CONSTANT_VARCHAR) values ('RESULT_CATEGORY_SUCCESS',5001,'SUCCESS');
Insert into WB_RT_CONSTANTS_TABLE (CONSTANT_NAME,CONSTANT_NUM,CONSTANT_VARCHAR) values ('RESULT_CATEGORY_WARNING',5002,'WARNING');
Insert into WB_RT_CONSTANTS_TABLE (CONSTANT_NAME,CONSTANT_NUM,CONSTANT_VARCHAR) values ('RESULT_CATEGORY_FAILURE',5003,'FAILURE');
Insert into WB_RT_CONSTANTS_TABLE (CONSTANT_NAME,CONSTANT_NUM,CONSTANT_VARCHAR) values ('SEVERITY_INFORMATIONAL',7001,'INFORMATIONAL');
Insert into WB_RT_CONSTANTS_TABLE (CONSTANT_NAME,CONSTANT_NUM,CONSTANT_VARCHAR) values ('SEVERITY_WARNING',7002,'WARNING');
Insert into WB_RT_CONSTANTS_TABLE (CONSTANT_NAME,CONSTANT_NUM,CONSTANT_VARCHAR) values ('SEVERITY_ERROR',7003,'ERROR');
Insert into WB_RT_CONSTANTS_TABLE (CONSTANT_NAME,CONSTANT_NUM,CONSTANT_VARCHAR) values ('SEVERITY_RECOVERY',7004,'RECOVERY');
Insert into WB_RT_CONSTANTS_TABLE (CONSTANT_NAME,CONSTANT_NUM,CONSTANT_VARCHAR) values ('OBJECT_STATUS_VALID',10001,'VALID');
Insert into WB_RT_CONSTANTS_TABLE (CONSTANT_NAME,CONSTANT_NUM,CONSTANT_VARCHAR) values ('OBJECT_STATUS_INVALID',10002,'INVALID');
Insert into WB_RT_CONSTANTS_TABLE (CONSTANT_NAME,CONSTANT_NUM,CONSTANT_VARCHAR) values ('OBJECT_STATUS_REMOVED',10003,'REMOVED');
Insert into WB_RT_CONSTANTS_TABLE (CONSTANT_NAME,CONSTANT_NUM,CONSTANT_VARCHAR) values ('OBJECT_STATUS_UNCERTAIN',10004,'UNCERTAIN');
Insert into WB_RT_CONSTANTS_TABLE (CONSTANT_NAME,CONSTANT_NUM,CONSTANT_VARCHAR) values ('OPERATION_DEPLOY',9001,'DEPLOY');
Insert into WB_RT_CONSTANTS_TABLE (CONSTANT_NAME,CONSTANT_NUM,CONSTANT_VARCHAR) values ('OPERATION_UNDO',9002,'UNDO');
Insert into WB_RT_CONSTANTS_TABLE (CONSTANT_NAME,CONSTANT_NUM,CONSTANT_VARCHAR) values ('UNIT_STATUS_INACTIVE',13001,'INACTIVE');
Insert into WB_RT_CONSTANTS_TABLE (CONSTANT_NAME,CONSTANT_NUM,CONSTANT_VARCHAR) values ('UNIT_STATUS_READY',13002,'READY');
Insert into WB_RT_CONSTANTS_TABLE (CONSTANT_NAME,CONSTANT_NUM,CONSTANT_VARCHAR) values ('UNIT_STATUS_BUSY_PREPARE',13003,'BUSY_PREPARE');
Insert into WB_RT_CONSTANTS_TABLE (CONSTANT_NAME,CONSTANT_NUM,CONSTANT_VARCHAR) values ('UNIT_STATUS_BUSY_UNPREPARE',13004,'BUSY_UNPREPARE');
Insert into WB_RT_CONSTANTS_TABLE (CONSTANT_NAME,CONSTANT_NUM,CONSTANT_VARCHAR) values ('UNIT_STATUS_BUSY_DEPLOY',13005,'BUSY_DEPLOY');
Insert into WB_RT_CONSTANTS_TABLE (CONSTANT_NAME,CONSTANT_NUM,CONSTANT_VARCHAR) values ('UNIT_STATUS_BUSY_UNDO',13006,'BUSY_UNDO');
Insert into WB_RT_CONSTANTS_TABLE (CONSTANT_NAME,CONSTANT_NUM,CONSTANT_VARCHAR) values ('UNIT_STATUS_BUSY_FINALIZE',13007,'BUSY_FINALIZE');
Insert into WB_RT_CONSTANTS_TABLE (CONSTANT_NAME,CONSTANT_NUM,CONSTANT_VARCHAR) values ('UNIT_STATUS_COMPLETE',13008,'COMPLETE');
Insert into WB_RT_CONSTANTS_TABLE (CONSTANT_NAME,CONSTANT_NUM,CONSTANT_VARCHAR) values ('DEPLOYMENT_STATUS_INACTIVE',12001,'INACTIVE');
Insert into WB_RT_CONSTANTS_TABLE (CONSTANT_NAME,CONSTANT_NUM,CONSTANT_VARCHAR) values ('DEPLOYMENT_STATUS_READY',12002,'READY');
Insert into WB_RT_CONSTANTS_TABLE (CONSTANT_NAME,CONSTANT_NUM,CONSTANT_VARCHAR) values ('DEPLOYMENT_STATUS_COMPLETE',12003,'COMPLETE');
Insert into WB_RT_CONSTANTS_TABLE (CONSTANT_NAME,CONSTANT_NUM,CONSTANT_VARCHAR) values ('SCRIPT_RUN_STATUS_BUSY',15001,'BUSY');
Insert into WB_RT_CONSTANTS_TABLE (CONSTANT_NAME,CONSTANT_NUM,CONSTANT_VARCHAR) values ('SCRIPT_RUN_STATUS_COMPLETE',15002,'COMPLETE');
Insert into WB_RT_CONSTANTS_TABLE (CONSTANT_NAME,CONSTANT_NUM,CONSTANT_VARCHAR) values ('SCRIPT_RUN_STATUS_UNCERTAIN',15003,'UNCERTAIN');
Insert into WB_RT_CONSTANTS_TABLE (CONSTANT_NAME,CONSTANT_NUM,CONSTANT_VARCHAR) values ('SCRIPT_RUN_STATUS_FAILED',15004,'FAILED');
Insert into WB_RT_CONSTANTS_TABLE (CONSTANT_NAME,CONSTANT_NUM,CONSTANT_VARCHAR) values ('SCRIPT_RUN_STATUS_INACTIVE',15005,'INACTIVE');
Insert into WB_RT_CONSTANTS_TABLE (CONSTANT_NAME,CONSTANT_NUM,CONSTANT_VARCHAR) values ('SCRIPT_STATUS_INACTIVE',14001,'INACTIVE');
Insert into WB_RT_CONSTANTS_TABLE (CONSTANT_NAME,CONSTANT_NUM,CONSTANT_VARCHAR) values ('SCRIPT_STATUS_BUSY_DEPLOYING',14002,'BUSY_DEPLOYING');
Insert into WB_RT_CONSTANTS_TABLE (CONSTANT_NAME,CONSTANT_NUM,CONSTANT_VARCHAR) values ('SCRIPT_STATUS_BUSY_UNDOING',14003,'BUSY_UNDOING');
Insert into WB_RT_CONSTANTS_TABLE (CONSTANT_NAME,CONSTANT_NUM,CONSTANT_VARCHAR) values ('EXECUTION_STATUS_INACTIVE',16001,'INACTIVE');
Insert into WB_RT_CONSTANTS_TABLE (CONSTANT_NAME,CONSTANT_NUM,CONSTANT_VARCHAR) values ('EXECUTION_STATUS_BUSY',16002,'BUSY');
Insert into WB_RT_CONSTANTS_TABLE (CONSTANT_NAME,CONSTANT_NUM,CONSTANT_VARCHAR) values ('EXECUTION_STATUS_READY',16003,'READY');
Insert into WB_RT_CONSTANTS_TABLE (CONSTANT_NAME,CONSTANT_NUM,CONSTANT_VARCHAR) values ('EXECUTION_STATUS_COMPLETE',16004,'COMPLETE');
Insert into WB_RT_CONSTANTS_TABLE (CONSTANT_NAME,CONSTANT_NUM,CONSTANT_VARCHAR) values ('REQUEST_TYPE_PREPARE_UNIT',17001,'PREPARE_UNIT');
Insert into WB_RT_CONSTANTS_TABLE (CONSTANT_NAME,CONSTANT_NUM,CONSTANT_VARCHAR) values ('REQUEST_TYPE_UNPREPARE_UNIT',17002,'UNPREPARE_UNIT');
Insert into WB_RT_CONSTANTS_TABLE (CONSTANT_NAME,CONSTANT_NUM,CONSTANT_VARCHAR) values ('REQUEST_TYPE_DEPLOY_UNIT',17003,'DEPLOY_UNIT');
Insert into WB_RT_CONSTANTS_TABLE (CONSTANT_NAME,CONSTANT_NUM,CONSTANT_VARCHAR) values ('REQUEST_TYPE_UNDO_UNIT',17004,'UNDO_UNIT');
Insert into WB_RT_CONSTANTS_TABLE (CONSTANT_NAME,CONSTANT_NUM,CONSTANT_VARCHAR) values ('REQUEST_TYPE_FINALIZE_UNIT',17005,'FINALIZE_UNIT');
Insert into WB_RT_CONSTANTS_TABLE (CONSTANT_NAME,CONSTANT_NUM,CONSTANT_VARCHAR) values ('REQUEST_TYPE_EXECUTE',17006,'EXECUTE');
Insert into WB_RT_CONSTANTS_TABLE (CONSTANT_NAME,CONSTANT_NUM,CONSTANT_VARCHAR) values ('REQUEST_TYPE_ABORT',17007,'ABORT');
Insert into WB_RT_CONSTANTS_TABLE (CONSTANT_NAME,CONSTANT_NUM,CONSTANT_VARCHAR) values ('REQUEST_TYPE_COMPLETE',17008,'COMPLETE');
Insert into WB_RT_CONSTANTS_TABLE (CONSTANT_NAME,CONSTANT_NUM,CONSTANT_VARCHAR) values ('REQUEST_TYPE_CLOSEDOWN',17009,'CLOSEDOWN');
Insert into WB_RT_CONSTANTS_TABLE (CONSTANT_NAME,CONSTANT_NUM,CONSTANT_VARCHAR) values ('REQUEST_TYPE_TIMEOUT',17010,'TIMEOUT');
Insert into WB_RT_CONSTANTS_TABLE (CONSTANT_NAME,CONSTANT_NUM,CONSTANT_VARCHAR) values ('FILE_ATTACHMENT_UNIT',19001,'UNIT');
Insert into WB_RT_CONSTANTS_TABLE (CONSTANT_NAME,CONSTANT_NUM,CONSTANT_VARCHAR) values ('FILE_ATTACHMENT_SCRIPT_RUN',19002,'SCRIPT_RUN');
Insert into WB_RT_CONSTANTS_TABLE (CONSTANT_NAME,CONSTANT_NUM,CONSTANT_VARCHAR) values ('FILE_ATTACHMENT_EXECUTION',19003,'EXECUTION');
Insert into WB_RT_CONSTANTS_TABLE (CONSTANT_NAME,CONSTANT_NUM,CONSTANT_VARCHAR) values ('STARTUP_KIND_AUTOMATIC',18001,'AUTOMATIC');
Insert into WB_RT_CONSTANTS_TABLE (CONSTANT_NAME,CONSTANT_NUM,CONSTANT_VARCHAR) values ('STARTUP_KIND_MANUAL',18002,'MANUAL');
Insert into WB_RT_CONSTANTS_TABLE (CONSTANT_NAME,CONSTANT_NUM,CONSTANT_VARCHAR) values ('STARTUP_KIND_SKIP_VERS_CHECK',18003,'SKIP_VERS_CHECK');
Insert into WB_RT_CONSTANTS_TABLE (CONSTANT_NAME,CONSTANT_NUM,CONSTANT_VARCHAR) values ('COMMAND_RETRY',22001,'RETRY');
Insert into WB_RT_CONSTANTS_TABLE (CONSTANT_NAME,CONSTANT_NUM,CONSTANT_VARCHAR) values ('COMMAND_STOP',22002,'STOP');
Insert into WB_RT_CONSTANTS_TABLE (CONSTANT_NAME,CONSTANT_NUM,CONSTANT_VARCHAR) values ('COMMAND_CONTINUE',22003,'CONTINUE');
Insert into WB_RT_CONSTANTS_TABLE (CONSTANT_NAME,CONSTANT_NUM,CONSTANT_VARCHAR) values ('COMMAND_DEFAULT',22004,'DEFAULT');
Insert into WB_RT_CONSTANTS_TABLE (CONSTANT_NAME,CONSTANT_NUM,CONSTANT_VARCHAR) values ('ACK_TYPE_NONE',20001,'NONE');
Insert into WB_RT_CONSTANTS_TABLE (CONSTANT_NAME,CONSTANT_NUM,CONSTANT_VARCHAR) values ('ACK_TYPE_RECOVERIES',20002,'RECOVERIES');
Insert into WB_RT_CONSTANTS_TABLE (CONSTANT_NAME,CONSTANT_NUM,CONSTANT_VARCHAR) values ('ACK_TYPE_ERRORS',20003,'ERRORS');
Insert into WB_RT_CONSTANTS_TABLE (CONSTANT_NAME,CONSTANT_NUM,CONSTANT_VARCHAR) values ('ACK_TYPE_WARNINGS',20004,'WARNINGS');
Insert into WB_RT_CONSTANTS_TABLE (CONSTANT_NAME,CONSTANT_NUM,CONSTANT_VARCHAR) values ('UNIT_OPS_NONE',21001,'NONE');
Insert into WB_RT_CONSTANTS_TABLE (CONSTANT_NAME,CONSTANT_NUM,CONSTANT_VARCHAR) values ('UNIT_OPS_PREPARE',21002,'PREPARE');
Insert into WB_RT_CONSTANTS_TABLE (CONSTANT_NAME,CONSTANT_NUM,CONSTANT_VARCHAR) values ('UNIT_OPS_DEPLOY',21003,'DEPLOY');
Insert into WB_RT_CONSTANTS_TABLE (CONSTANT_NAME,CONSTANT_NUM,CONSTANT_VARCHAR) values ('UNIT_OPS_DEPLOY_OR_UNPREPARE',21004,'DEPLOY_OR_UNPREPARE');
Insert into WB_RT_CONSTANTS_TABLE (CONSTANT_NAME,CONSTANT_NUM,CONSTANT_VARCHAR) values ('UNIT_OPS_UNDO_OR_FINALIZE',21005,'UNDO_OR_FINALIZE');
Insert into WB_RT_CONSTANTS_TABLE (CONSTANT_NAME,CONSTANT_NUM,CONSTANT_VARCHAR) values ('UNIT_OPS_DEPLOY_OR_FINALIZE',21006,'DEPLOY_OR_FINALIZE');
Insert into WB_RT_CONSTANTS_TABLE (CONSTANT_NAME,CONSTANT_NUM,CONSTANT_VARCHAR) values ('UNIT_OPS_UNPREPARE',21007,'UNPREPARE');
Insert into WB_RT_CONSTANTS_TABLE (CONSTANT_NAME,CONSTANT_NUM,CONSTANT_VARCHAR) values ('UNIT_OPS_FINALIZE',21008,'FINALIZE');
Insert into WB_RT_CONSTANTS_TABLE (CONSTANT_NAME,CONSTANT_NUM,CONSTANT_VARCHAR) values ('FORMAT_TEXT',23001,'TEXT');
Insert into WB_RT_CONSTANTS_TABLE (CONSTANT_NAME,CONSTANT_NUM,CONSTANT_VARCHAR) values ('FORMAT_HTML',23002,'HTML');
Insert into WB_RT_CONSTANTS_TABLE (CONSTANT_NAME,CONSTANT_NUM,CONSTANT_VARCHAR) values ('FORMAT_OTHER',23003,'OTHER');
Insert into WB_RT_CONSTANTS_TABLE (CONSTANT_NAME,CONSTANT_NUM,CONSTANT_VARCHAR) values ('VALUE_KIND_LITERAL',24001,'LITERAL');
Insert into WB_RT_CONSTANTS_TABLE (CONSTANT_NAME,CONSTANT_NUM,CONSTANT_VARCHAR) values ('VALUE_KIND_EXPRESSION',24002,'EXPRESSION');
Insert into WB_RT_CONSTANTS_TABLE (CONSTANT_NAME,CONSTANT_NUM,CONSTANT_VARCHAR) values ('VALUE_KIND_EVAL_EXPR',24003,'EVAL_EXPR');
Insert into WB_RT_CONSTANTS_TABLE (CONSTANT_NAME,CONSTANT_NUM,CONSTANT_VARCHAR) values ('VALUE_KIND_NOT_SET',24004,'NOT_SET');
Insert into WB_RT_CONSTANTS_TABLE (CONSTANT_NAME,CONSTANT_NUM,CONSTANT_VARCHAR) values ('VALUE_VALUE_INPUT',26001,'INPUT');
Insert into WB_RT_CONSTANTS_TABLE (CONSTANT_NAME,CONSTANT_NUM,CONSTANT_VARCHAR) values ('VALUE_VALUE_OUTPUT',26002,'OUTPUT');
Insert into WB_RT_CONSTANTS_TABLE (CONSTANT_NAME,CONSTANT_NUM,CONSTANT_VARCHAR) values ('JOB_MODE_NORMAL',25001,'NORMAL');
Insert into WB_RT_CONSTANTS_TABLE (CONSTANT_NAME,CONSTANT_NUM,CONSTANT_VARCHAR) values ('JOB_MODE_SEMI_AUTOMATIC',25002,'SEMI_AUTOMATIC');
Insert into WB_RT_CONSTANTS_TABLE (CONSTANT_NAME,CONSTANT_NUM,CONSTANT_VARCHAR) values ('JOB_MODE_FULLY_AUTOMATIC',25003,'FULLY_AUTOMATIC');
Insert into WB_RT_CONSTANTS_TABLE (CONSTANT_NAME,CONSTANT_NUM,CONSTANT_VARCHAR) values ('MESSAGE_ATTACHMENT_UNIT',27001,'UNIT');
Insert into WB_RT_CONSTANTS_TABLE (CONSTANT_NAME,CONSTANT_NUM,CONSTANT_VARCHAR) values ('MESSAGE_ATTACHMENT_SCRIPT_RUN',27002,'SCRIPT_RUN');
Insert into WB_RT_CONSTANTS_TABLE (CONSTANT_NAME,CONSTANT_NUM,CONSTANT_VARCHAR) values ('MESSAGE_ATTACHMENT_EXECUTION',27003,'EXECUTION');
Insert into WB_RT_CONSTANTS_TABLE (CONSTANT_NAME,CONSTANT_NUM,CONSTANT_VARCHAR) values ('PARAM_SCOPE_GLOBAL',28001,'GLOBAL');
Insert into WB_RT_CONSTANTS_TABLE (CONSTANT_NAME,CONSTANT_NUM,CONSTANT_VARCHAR) values ('PARAM_SCOPE_SHARED',28002,'SHARED');
Insert into WB_RT_CONSTANTS_TABLE (CONSTANT_NAME,CONSTANT_NUM,CONSTANT_VARCHAR) values ('PARAM_SCOPE_PARAMETER',28003,'PARAMETER');
Insert into WB_RT_CONSTANTS_TABLE (CONSTANT_NAME,CONSTANT_NUM,CONSTANT_VARCHAR) values ('PARAM_SCOPE_LOCAL',28004,'LOCAL');
Insert into WB_RT_CONSTANTS_TABLE (CONSTANT_NAME,CONSTANT_NUM,CONSTANT_VARCHAR) values ('PARAM_SCOPE_INNER',28005,'INNER');
Insert into WB_RT_CONSTANTS_TABLE (CONSTANT_NAME,CONSTANT_NUM,CONSTANT_VARCHAR) values ('STORAGE_TEXT',29001,'TEXT');
Insert into WB_RT_CONSTANTS_TABLE (CONSTANT_NAME,CONSTANT_NUM,CONSTANT_VARCHAR) values ('STORAGE_BINARY',29002,'BINARY');
Insert into WB_RT_CONSTANTS_TABLE (CONSTANT_NAME,CONSTANT_NUM,CONSTANT_VARCHAR) values ('RESULT_NUMBER_SUCCESS',1,'OK');
Insert into WB_RT_CONSTANTS_TABLE (CONSTANT_NAME,CONSTANT_NUM,CONSTANT_VARCHAR) values ('RESULT_NUMBER_WARNING',2,'OK_WITH_WARNINGS');
Insert into WB_RT_CONSTANTS_TABLE (CONSTANT_NAME,CONSTANT_NUM,CONSTANT_VARCHAR) values ('RESULT_NUMBER_FAILURE',3,'FAILURE');


CREATE VIEW "RAB_RT_EXEC_PROCESS" (PROCESS_UOID, PROCESS_TYPE, PROCESS_TYPE_SYMBOL, PROCESS_NAME, EXECUTION_NAME, AUDIT_EXECUTION_ID, RUN_ID_TYPE, SCOPE_AUDIT_EXECUTION_ID, TOOL_NAME, TOOL_VERSION, EXECUTION_STORE_UOID, EXECUTION_STORE_NAME, RESULT_CODE, RESULT_NUMBER, RUN_STATUS, RUN_STATUS_FILTER, RUN_STATUS_SYMBOL, EXTERNAL_AUDIT_ID, START_TIME, END_TIME, ELAPSE_TIME, CREATED_BY, UPDATED_DATE, UPDATED_BY) AS
select
e.phase_uoid as process_uoid,
e.phase_type as process_type, 
rt.symbol as process_type_symbol,
(case when upper(e.phase_name) = 'EXECUTE' then j.jndi_name else e.phase_name end) as process_name,
j.jndi_name as execution_name,
e.phase_audit_id as audit_execution_id,
'P' as run_id_type,
cast(null as numeric (22,0)) as scope_audit_execution_id,
i.installation_name as tool_name,
i.installed_version as tool_version,
'{1}' as execution_store_uoid,
'JRT' as execution_store_name,
0 as result_code,
e.phase_audit_status as result_number, 
e.phase_execution_status as run_status,
cast(cast(e.phase_execution_status as char(5)) as varchar(5)) || ':' || cast(cast(e.phase_audit_status as char(5)) as varchar(5)) as run_status_filter,
(case when e.phase_return_result is null then c.CONSTANT_VARCHAR else c.CONSTANT_VARCHAR || '_' || upper(e.phase_return_result) end) as run_status_symbol,
cast(null as varchar(64)) as external_audit_id,
e.start_time as start_time,
e.start_time + (e.elapse_time/86400) days as end_time,
e.elapse_time as elapse_time,
e.created_by as created_by,
e.updated_on as updated_date,
e.updated_by as updated_by
from 
rab_rt_installations i,
all_rv_phase_executions e
join all_rv_job_executions j on e.job_audit_id = j.job_audit_id
left outer join rab_rt_rep_types rt on upper(e.phase_type) = rt.obj_type
left outer join WB_RT_CONSTANTS_TABLE c on e.PHASE_EXECUTION_STATUS = c.CONSTANT_NUM
join (select phase_uoid, phase_type, phase_name, max(phase_audit_id) as max_exec_id
        from all_rv_phase_executions
       where parent_phase_audit_id is null
       group by phase_uoid, phase_type, phase_name) mx
  on e.phase_uoid = mx.phase_uoid and
     e.phase_type = mx.phase_type and
     e.phase_name = mx.phase_name and
     e.phase_audit_id = mx.max_exec_id
;


CREATE VIEW "RAB_RT_EXEC_PROC_HIER" (AUDIT_EXECUTION_ID, RUN_ID_TYPE, PARENT_AUDIT_EXECUTION_ID, PAR_ID_TYPE, TOP_LEVEL_AUDIT_EXECUTION_ID, TOP_ID_TYPE) AS  
select
  p.phase_audit_id as audit_execution_id,
  'P' as run_id_type,
  p.parent_phase_audit_id as parent_audit_execution_id,
  'P' as par_id_type,
  coalesce(p.top_level_phase_audit_id, p.phase_audit_id) as top_level_audit_execution_id,
  'P' as top_id_type
from all_rv_phase_executions p
union all
select
  t.task_audit_id as audit_execution_id,
  'T' as run_id_type,
  coalesce(t.parent_task_audit_id, p.phase_audit_id) as parent_audit_execution_id,
  (case when t.parent_task_audit_id is null then 'P' else 'T' end) as par_id_type,
  coalesce(p.top_level_phase_audit_id, p.phase_audit_id) as top_level_audit_execution_id,
  'P' as top_id_type
from all_rv_task_executions t
join all_rv_phase_executions p on t.phase_audit_id = p.phase_audit_id
union all
select
s.step_audit_id as audit_execution_id,
'S' as run_id_type,
t.task_audit_id as parent_audit_execution_id,
'T' as par_id_type,
coalesce(p.top_level_phase_audit_id, p.phase_audit_id) as top_level_audit_execution_id,
'P' as top_id_type
from all_rv_step_executions s
join all_rv_task_executions t on s.task_audit_id = t.task_audit_id
join all_rv_phase_executions p  on t.phase_audit_id = p.phase_audit_id
;


CREATE VIEW "RAB_RT_EXEC_PROCESS_RUNS" (PROCESS_UOID, PROCESS_TYPE, PROCESS_TYPE_SYMBOL, PROCESS_NAME, EXECUTION_NAME, AUDIT_EXECUTION_ID, RUN_ID_TYPE, PARENT_AUDIT_EXECUTION_ID, PAR_ID_TYPE, TOP_LEVEL_AUDIT_EXECUTION_ID, TOP_ID_TYPE, SCOPE_AUDIT_EXECUTION_ID, TOOL_NAME, TOOL_VERSION, EXECUTION_STORE_UOID, EXECUTION_STORE_NAME, RESULT_CODE, RESULT_NUMBER, RUN_STATUS, RUN_STATUS_FILTER, RUN_STATUS_SYMBOL, EXTERNAL_AUDIT_ID, START_TIME, END_TIME, ELAPSE_TIME, CREATED_BY, UPDATED_DATE, UPDATED_BY) AS  
select
p.phase_uoid as process_uoid,
p.phase_type as process_type,
rt.symbol as process_type_symbol,
(case when upper(p.phase_name) = 'EXECUTE' then j.jndi_name else p.phase_name end) as process_name,
(case when p.parent_phase_audit_id is null then j.jndi_name else cast(null as varchar(80)) end) as execution_name,
p.phase_audit_id as audit_execution_id,
'P' as run_id_type,
p.parent_phase_audit_id as parent_audit_execution_id,
'P' as par_id_type,
coalesce(p.top_level_phase_audit_id, p.phase_audit_id) as top_level_audit_execution_id,
'P' as top_id_type,
cast(null as numeric (22,0)) as scope_audit_execution_id,
i.installation_name as tool_name,
i.installed_version as tool_version,
'{1}' as execution_store_uoid,
'JRT' as execution_store_name,
0 as result_code,
p.phase_audit_status as result_number,
p.phase_execution_status as run_status,
cast(cast(p.phase_execution_status as char(5)) as varchar(5)) || ':' || cast(cast(p.phase_audit_status as char(5)) as varchar(5)) as run_status_filter,
(case when p.phase_return_result is null then c.CONSTANT_VARCHAR else c.CONSTANT_VARCHAR || '_' || upper(p.phase_return_result) end) as run_status_symbol,
cast(null as varchar(64)) as external_audit_id,
p.start_time as start_time,
p.start_time + (p.elapse_time/86400) days as end_time,
p.elapse_time as elapse_time,
p.created_by as created_by,
p.updated_on as updated_date,
p.updated_by as updated_by
from 
rab_rt_installations i,
all_rv_phase_executions p
join all_rv_job_executions j on p.job_audit_id = j.job_audit_id
left outer join rab_rt_rep_types rt on upper(p.phase_type) = rt.obj_type
left outer join WB_RT_CONSTANTS_TABLE c on p.phase_execution_status = c.CONSTANT_NUM
union all
select
t.task_uoid as process_uoid,
t.task_type as process_type,
rt.symbol as process_type_symbol,
t.task_name as process_name,
cast(null as varchar(80)) as execution_name,
t.task_audit_id as audit_execution_id,
'T' as run_id_type,
coalesce(t.parent_task_audit_id, p.phase_audit_id) as parent_audit_execution_id,
(case when t.parent_task_audit_id is null then 'P' else 'T' end) as par_id_type,
coalesce(p.top_level_phase_audit_id, p.phase_audit_id) as top_level_audit_execution_id,
'P' as top_id_type,
cast(null as numeric (22,0)) as scope_audit_execution_id,
i.installation_name as tool_name,
i.installed_version as tool_version,
'{1}' as execution_store_uoid,
'JRT' as execution_store_name,
0 as result_code,
t.task_audit_status as result_number,
t.task_execution_status as run_status,
cast(cast(t.task_execution_status as char(5)) as varchar(5)) || ':' || cast(cast(t.task_audit_status as char(5)) as varchar(5)) as run_status_filter,
(case when t.task_return_result is null then c.CONSTANT_VARCHAR else c.CONSTANT_VARCHAR || '_' || upper(t.task_return_result) end) as run_status_symbol,
cast(null as varchar(64)) as external_audit_id,
t.start_time as start_time,
t.start_time + (t.elapse_time/86400) days as end_time,
t.elapse_time as elapse_time,
t.created_by as created_by,
t.updated_on as updated_date,
t.updated_by as updated_by
from 
rab_rt_installations i,
all_rv_task_executions t
join all_rv_phase_executions p on t.phase_audit_id = p.phase_audit_id
join all_rv_job_executions j on p.job_audit_id = j.job_audit_id
left outer join rab_rt_rep_types rt on upper(t.task_type) = rt.obj_type
left outer join WB_RT_CONSTANTS_TABLE c on p.phase_execution_status = c.CONSTANT_NUM
union all
select
s.step_uoid as process_uoid,
s.step_type as process_type,
rt.symbol as process_type_symbol,
s.step_name as process_name,
cast(null as varchar(80)) as execution_name,
s.step_audit_id as audit_execution_id,
'S' as run_id_type,
t.task_audit_id as parent_audit_execution_id,
'T' as par_id_type,
coalesce(p.top_level_phase_audit_id, p.phase_audit_id) as top_level_audit_execution_id,
'P' as top_id_type,
cast(null as numeric (22,0)) as scope_audit_execution_id,
i.installation_name as tool_name,
i.installed_version as tool_version,
'{1}' as execution_store_uoid,
'JRT' as execution_store_name,
0 as result_code,
s.step_audit_status as result_number,
s.step_execution_status as run_status,
cast(cast(s.step_execution_status as char(5)) as varchar(5)) || ':' || cast(cast(s.step_audit_status as char(5)) as varchar(5)) as run_status_filter,
(case when s.step_return_result is null then c.CONSTANT_VARCHAR else c.CONSTANT_VARCHAR || '_' || upper(s.step_return_result) end) as run_status_symbol,
cast(null as varchar(64)) as external_audit_id,
s.start_time as start_time,
s.start_time + (s.elapse_time/86400) days as end_time,
s.elapse_time as elapse_time,
s.created_by as created_by,
s.updated_on as updated_date,
s.updated_by as updated_by
from 
rab_rt_installations i,
all_rv_step_executions s
join all_rv_task_executions t on s.task_audit_id = t.task_audit_id
join all_rv_phase_executions p  on t.phase_audit_id = p.phase_audit_id
join all_rv_job_executions j on  p.job_audit_id = j.job_audit_id
left outer join rab_rt_rep_types rt on upper(t.task_type) = rt.obj_type
left outer join WB_RT_CONSTANTS_TABLE c on p.phase_execution_status = c.CONSTANT_NUM
;


CREATE VIEW "RAB_RT_EXEC_PROC_RUN_COUNTS" (PROCESS_UOID, PROCESS_TYPE, PROCESS_TYPE_SYMBOL, PROCESS_NAME, EXECUTION_NAME, AUDIT_EXECUTION_ID, RUN_ID_TYPE, PARENT_AUDIT_EXECUTION_ID, PAR_ID_TYPE, TOP_LEVEL_AUDIT_EXECUTION_ID, TOP_ID_TYPE, SCOPE_AUDIT_EXECUTION_ID, TOOL_NAME, TOOL_VERSION, EXECUTION_STORE_UOID, EXECUTION_STORE_NAME, RESULT_CODE, RESULT_NUMBER, RUN_STATUS, RUN_STATUS_FILTER, RUN_STATUS_SYMBOL, EXTERNAL_AUDIT_ID, START_TIME, END_TIME, ELAPSE_TIME, CREATED_BY, UPDATED_DATE, UPDATED_BY, NUMBER_ERRORS, NUMBER_LOGICAL_ERRORS) AS  
select
p.phase_uoid as process_uoid,
p.phase_type as process_type,
rt.symbol as process_type_symbol,
(case when upper(p.phase_name) = 'EXECUTE' then j.jndi_name else p.phase_name end) as process_name,
(case when p.parent_phase_audit_id is null then j.jndi_name else cast(null as varchar(80)) end) as execution_name,
p.phase_audit_id as audit_execution_id,
'P' as run_id_type,
p.parent_phase_audit_id as parent_audit_execution_id,
'P' as par_id_type,
coalesce(p.top_level_phase_audit_id, p.phase_audit_id) as top_level_audit_execution_id,
'P' as top_id_type,
cast(null as numeric (22,0)) as scope_audit_execution_id,
i.installation_name as tool_name,
i.installed_version as tool_version,
'{1}' as execution_store_uoid,
'JRT' as execution_store_name,
0 as result_code,
p.phase_audit_status as result_number,
p.phase_execution_status as run_status,
cast(cast(p.phase_execution_status as char(5)) as varchar(5)) || ':' || cast(cast(p.phase_audit_status as char(5)) as varchar(5)) as run_status_filter,
(case when p.phase_return_result is null then c.CONSTANT_VARCHAR else c.CONSTANT_VARCHAR || '_' || upper(p.phase_return_result) end) as run_status_symbol,
cast(null as varchar(64)) as external_audit_id,
p.start_time as start_time,
p.start_time + (p.elapse_time/86400) days as end_time,
p.elapse_time as elapse_time,
p.created_by as created_by,
p.updated_on as updated_date,
p.updated_by as updated_by,
p.number_errors as number_errors,
0 as number_logical_errors
from 
rab_rt_installations i,
all_rv_phase_executions p
join all_rv_job_executions j on p.job_audit_id = j.job_audit_id
left outer join rab_rt_rep_types rt on upper(p.phase_type) = rt.obj_type
left outer join WB_RT_CONSTANTS_TABLE c on p.phase_execution_status = c.CONSTANT_NUM
union all
select
t.task_uoid as process_uoid,
t.task_type as process_type,
rt.symbol as process_type_symbol,
t.task_name as process_name,
cast(null as varchar(80)) as execution_name,
t.task_audit_id as audit_execution_id,
'T' as run_id_type,
coalesce(t.parent_task_audit_id, p.phase_audit_id) as parent_audit_execution_id,
(case when t.parent_task_audit_id is null then 'P' else 'T' end) as par_id_type,
coalesce(p.top_level_phase_audit_id, p.phase_audit_id) as top_level_audit_execution_id,
'P' as top_id_type,
cast(null as numeric (22,0)) as scope_audit_execution_id,
i.installation_name as tool_name,
i.installed_version as tool_version,
'{1}' as execution_store_uoid,
'JRT' as execution_store_name,
0 as result_code,
t.task_audit_status as result_number,
t.task_execution_status as run_status,
cast(cast(t.task_execution_status as char(5)) as varchar(5)) || ':' || cast(cast(t.task_audit_status as char(5)) as varchar(5)) as run_status_filter,
(case when t.task_return_result is null then c.CONSTANT_VARCHAR else c.CONSTANT_VARCHAR || '_' || upper(t.task_return_result) end) as run_status_symbol,
cast(null as varchar(64)) as external_audit_id,
t.start_time as start_time,
t.start_time + (t.elapse_time/86400) days as end_time,
t.elapse_time as elapse_time,
t.created_by as created_by,
t.updated_on as updated_date,
t.updated_by as updated_by,
t.number_errors as number_errors,
0 as number_logical_errors
from 
rab_rt_installations i,
all_rv_task_executions t
join all_rv_phase_executions p on t.phase_audit_id = p.phase_audit_id
join all_rv_job_executions j on p.job_audit_id = j.job_audit_id
left outer join rab_rt_rep_types rt on upper(t.task_type) = rt.obj_type
left outer join WB_RT_CONSTANTS_TABLE c on p.phase_execution_status = c.CONSTANT_NUM
union all
select
s.step_uoid as process_uoid,
s.step_type as process_type,
rt.symbol as process_type_symbol,
s.step_name as process_name,
cast(null as varchar(80)) as execution_name,
s.step_audit_id as audit_execution_id,
'S' as run_id_type,
t.task_audit_id as parent_audit_execution_id,
'T' as par_id_type,
coalesce(p.top_level_phase_audit_id, p.phase_audit_id) as top_level_audit_execution_id,
'P' as top_id_type,
cast(null as numeric (22,0)) as scope_audit_execution_id,
i.installation_name as tool_name,
i.installed_version as tool_version,
'{1}' as execution_store_uoid,
'JRT' as execution_store_name,
0 as result_code,
s.step_audit_status as result_number,
s.step_execution_status as run_status,
cast(cast(s.step_execution_status as char(5)) as varchar(5)) || ':' || cast(cast(s.step_audit_status as char(5)) as varchar(5)) as run_status_filter,
(case when s.step_return_result is null then c.CONSTANT_VARCHAR else c.CONSTANT_VARCHAR || '_' || upper(s.step_return_result) end) as run_status_symbol,
cast(null as varchar(64)) as external_audit_id,
s.start_time as start_time,
s.start_time + (s.elapse_time/86400) days as end_time,
s.elapse_time as elapse_time,
s.created_by as created_by,
s.updated_on as updated_date,
s.updated_by as updated_by,
s.number_errors as number_errors,
0 as number_logical_errors
from 
rab_rt_installations i,
all_rv_step_executions s
join all_rv_task_executions t on s.task_audit_id = t.task_audit_id
join all_rv_phase_executions p  on t.phase_audit_id = p.phase_audit_id
join all_rv_job_executions j on  p.job_audit_id = j.job_audit_id
left outer join rab_rt_rep_types rt on upper(t.task_type) = rt.obj_type
left outer join WB_RT_CONSTANTS_TABLE c on p.phase_execution_status = c.CONSTANT_NUM
;


CREATE VIEW "RAB_RT_EXEC_PROC_RUN_METRICS" (PROCESS_UOID, PROCESS_TYPE, PROCESS_TYPE_SYMBOL, PROCESS_NAME, EXECUTION_NAME, AUDIT_EXECUTION_ID, RUN_ID_TYPE, PARENT_AUDIT_EXECUTION_ID, PAR_ID_TYPE, TOP_LEVEL_AUDIT_EXECUTION_ID, TOP_ID_TYPE, SCOPE_AUDIT_EXECUTION_ID, TOOL_NAME, TOOL_VERSION, EXECUTION_STORE_UOID, EXECUTION_STORE_NAME, RESULT_CODE, RESULT_NUMBER, RUN_STATUS, RUN_STATUS_FILTER, RUN_STATUS_SYMBOL, EXTERNAL_AUDIT_ID, START_TIME, END_TIME, ELAPSE_TIME, CREATED_BY, UPDATED_DATE, UPDATED_BY, NUMBER_APPROX, NUMBER_ERRORS, NUMBER_LOGICAL_ERRORS, NUMBER_RECORDS_SELECTED, NUMBER_RECORDS_INSERTED, NUMBER_RECORDS_UPDATED, NUMBER_RECORDS_DELETED, NUMBER_RECORDS_DISCARDED, NUMBER_RECORDS_MERGED, NUMBER_RECORDS_CORRECTED) AS  
select
p.phase_uoid as process_uoid,
p.phase_type as process_type,
rt.symbol as process_type_symbol,
(case when upper(p.phase_name) = 'EXECUTE' then j.jndi_name else p.phase_name end) as process_name,
(case when p.parent_phase_audit_id is null then j.jndi_name else cast(null as varchar(80)) end) as execution_name,
p.phase_audit_id as audit_execution_id,
'P' as run_id_type,
p.parent_phase_audit_id as parent_audit_execution_id,
'P' as par_id_type,
coalesce(p.top_level_phase_audit_id, p.phase_audit_id) as top_level_audit_execution_id,
'P' as top_id_type,
cast(null as numeric (22,0)) as scope_audit_execution_id,
i.installation_name as tool_name,
i.installed_version as tool_version,
'{1}' as execution_store_uoid,
'JRT' as execution_store_name,
0 as result_code,
p.phase_audit_status as result_number,
p.phase_execution_status as run_status,
cast(cast(p.phase_execution_status as char(5)) as varchar(5)) || ':' || cast(cast(p.phase_audit_status as char(5)) as varchar(5)) as run_status_filter,
(case when p.phase_return_result is null then c.CONSTANT_VARCHAR else c.CONSTANT_VARCHAR || '_' || upper(p.phase_return_result) end) as run_status_symbol,
cast(null as varchar(64)) as external_audit_id,
p.start_time as start_time,
p.start_time + (p.elapse_time/86400) days as end_time,
p.elapse_time as elapse_time,
p.created_by as created_by,
p.updated_on as updated_date,
p.updated_by as updated_by,
0 as number_approx,
p.number_errors as number_errors,
0 as number_logical_errors,
coalesce(x.sel, 0) as number_records_selected,
coalesce(x.ins, 0) as number_records_inserted,
coalesce(x.upd, 0) as number_records_updated,
coalesce(x.del, 0) as number_records_deleted,
0 as number_records_discarded,
coalesce(x.mer, 0) as number_records_merged,
0 as number_records_corrected
from 
rab_rt_installations i,
all_rv_phase_executions p
join all_rv_job_executions j on p.job_audit_id = j.job_audit_id
left outer join rab_rt_rep_types rt on upper(p.phase_type) = rt.obj_type
left outer join WB_RT_CONSTANTS_TABLE c on p.phase_execution_status = c.CONSTANT_NUM
left outer join all_rv_task_executions t on p.phase_audit_id = t.phase_audit_id
left outer join (select xs.task_audit_id,
                        sum(xs.NUMBER_RECORDS_SELECTED) as sel,
                        sum(xs.NUMBER_RECORDS_INSERTED) as ins,
                        sum(xs.NUMBER_RECORDS_UPDATED) as upd,
                        sum(xs.NUMBER_RECORDS_DELETED) as del,
                        sum(xs.NUMBER_RECORDS_MERGED) as mer
                   from all_rv_step_executions xs
                  group by xs.task_audit_id) x
                     on t.task_audit_id = x.task_audit_id
union all
select
t.task_uoid as process_uoid,
t.task_type as process_type,
rt.symbol as process_type_symbol,
t.task_name as process_name,
cast(null as varchar(80)) as execution_name,
t.task_audit_id as audit_execution_id,
'T' as run_id_type,
coalesce(t.parent_task_audit_id, p.phase_audit_id) as parent_audit_execution_id,
(case when t.parent_task_audit_id is null then 'P' else 'T' end) as par_id_type,
coalesce(p.top_level_phase_audit_id, p.phase_audit_id) as top_level_audit_execution_id,
'P' as top_id_type,
cast(null as numeric (22,0)) as scope_audit_execution_id,
i.installation_name as tool_name,
i.installed_version as tool_version,
'{1}' as execution_store_uoid,
'JRT' as execution_store_name,
0 as result_code,
t.task_audit_status as result_number,
t.task_execution_status as run_status,
cast(cast(t.task_execution_status as char(5)) as varchar(5)) || ':' || cast(cast(t.task_audit_status as char(5)) as varchar(5)) as run_status_filter,
(case when t.task_return_result is null then c.CONSTANT_VARCHAR else c.CONSTANT_VARCHAR || '_' || upper(t.task_return_result) end) as run_status_symbol,
cast(null as varchar(64)) as external_audit_id,
t.start_time as start_time,
t.start_time + (t.elapse_time/86400) days as end_time,
t.elapse_time as elapse_time,
t.created_by as created_by,
t.updated_on as updated_date,
t.updated_by as updated_by,
0 as number_approx,
t.number_errors as number_errors,
0 as number_logical_errors,
coalesce(x.sel, 0) as number_records_selected,
coalesce(x.ins, 0) as number_records_inserted,
coalesce(x.upd, 0) as number_records_updated,
coalesce(x.del, 0) as number_records_deleted,
0 as number_records_discarded,
coalesce(x.mer, 0) as number_records_merged,
0 as number_records_corrected
from 
rab_rt_installations i,
all_rv_task_executions t
join all_rv_phase_executions p on t.phase_audit_id = p.phase_audit_id
join all_rv_job_executions j on p.job_audit_id = j.job_audit_id
left outer join rab_rt_rep_types rt on upper(t.task_type) = rt.obj_type
left outer join WB_RT_CONSTANTS_TABLE c on p.phase_execution_status = c.CONSTANT_NUM
left outer join (select xs.task_audit_id,
                        sum(xs.NUMBER_RECORDS_SELECTED) as sel,
                        sum(xs.NUMBER_RECORDS_INSERTED) as ins,
                        sum(xs.NUMBER_RECORDS_UPDATED) as upd,
                        sum(xs.NUMBER_RECORDS_DELETED) as del,
                        sum(xs.NUMBER_RECORDS_MERGED) as mer
                   from all_rv_step_executions xs
                  group by xs.task_audit_id) x
                     on t.task_audit_id = x.task_audit_id
union all
select
s.step_uoid as process_uoid,
s.step_type as process_type,
rt.symbol as process_type_symbol,
s.step_name as process_name,
cast(null as varchar(80)) as execution_name,
s.step_audit_id as audit_execution_id,
'S' as run_id_type,
t.task_audit_id as parent_audit_execution_id,
'T' as par_id_type,
coalesce(p.top_level_phase_audit_id, p.phase_audit_id) as top_level_audit_execution_id,
'P' as top_id_type,
cast(null as numeric (22,0)) as scope_audit_execution_id,
i.installation_name as tool_name,
i.installed_version as tool_version,
'{1}' as execution_store_uoid,
'JRT' as execution_store_name,
0 as result_code,
s.step_audit_status as result_number,
s.step_execution_status as run_status,
cast(cast(s.step_execution_status as char(5)) as varchar(5)) || ':' || cast(cast(s.step_audit_status as char(5)) as varchar(5)) as run_status_filter,
(case when s.step_return_result is null then c.CONSTANT_VARCHAR else c.CONSTANT_VARCHAR || '_' || upper(s.step_return_result) end) as run_status_symbol,
cast(null as varchar(64)) as external_audit_id,
s.start_time as start_time,
s.start_time + (s.elapse_time/86400) days as end_time,
s.elapse_time as elapse_time,
s.created_by as created_by,
s.updated_on as updated_date,
s.updated_by as updated_by,
0 as number_approx,
s.number_errors as number_errors,
0 as number_logical_errors,
s.number_records_selected as number_records_selected,
s.number_records_inserted as number_records_inserted,
s.number_records_updated as number_records_updated,
s.number_records_deleted as number_records_deleted,
0 as number_records_discarded,
s.number_records_merged as number_records_merged,
0 as number_records_corrected
from 
rab_rt_installations i,
all_rv_step_executions s
join all_rv_task_executions t on s.task_audit_id = t.task_audit_id
join all_rv_phase_executions p  on t.phase_audit_id = p.phase_audit_id
join all_rv_job_executions j on  p.job_audit_id = j.job_audit_id
left outer join rab_rt_rep_types rt on upper(t.task_type) = rt.obj_type
left outer join WB_RT_CONSTANTS_TABLE c on p.phase_execution_status = c.CONSTANT_NUM
;


CREATE VIEW "RAB_RT_EXEC_PROCESS_RUN_ERRORS" ("AUDIT_EXECUTION_ID", "RUN_ID_TYPE", "MAP_RUN_ID", "MAP_ID_TYPE", "RUN_ERROR_ID", "CURSOR_ROWKEY", "RUN_ERROR_NUMBER", "RUN_ERROR_MESSAGE", "TARGET_UOID", "TARGET_NAME", "TARGET_TYPE", "TARGET_TYPE_SYMBOL", "FIRST_TARGET", "FIRST_DBLINK", "TARGET_COLUMN", "CREATED_BY", "ERROR_TIME") AS 
select
  e.task_audit_id as audit_execution_id,
  'T' as run_id_type,
  e.task_audit_id as map_run_id,
  'T' as map_id_type,
  e.run_error_id as run_error_id,
  e.cursor_rowkey as cursor_rowkey,
  e.error_number as run_error_number,
  e.error_message as run_error_message,
  cast(null as varchar(32)) as target_uoid,
  e.target_name as target_name,
  cast(null as varchar(32)) as target_type,
  cast(null as varchar(32)) as target_type_symbol,
  e.target_name as first_target,
  cast(null as varchar(32)) as first_dblink,
  e.target_column as target_column,
  e.created_by as created_by,
  e.created_on as error_time
from 
  all_rv_audit_run_errors e
where 
  e.task_audit_id is not null 
;


CREATE VIEW "RAB_RT_EXEC_ACT_RUN_ERRORS" ("AUDIT_EXECUTION_ID", "RUN_ID_TYPE", "MAP_RUN_ID", "MAP_ID_TYPE", "MAP_STEP", "STEP_ID", "RUN_ERROR_ID", "CURSOR_ROWKEY", "ROW_IDENT", "RUN_ERROR_NUMBER", "RUN_ERROR_MESSAGE", "TARGET_UOID", "TARGET_NAME", "TARGET_TYPE", "TARGET_TYPE_SYMBOL", "FIRST_TARGET", "FIRST_DBLINK", "TARGET_COLUMN", "ERROR_TIME", "COLUMN_VALUE", "STATEMENT", "CORRECTION", "CREATED_BY", "ROLE", "ACTION", "KEYS") AS 
select
  e.step_audit_id as audit_execution_id,
  'S' as run_id_type,
  e.step_audit_id as map_run_id,
  'S' as map_id_type,
  0 as map_step,
  e.step_audit_id as step_id,
  e.run_error_id as run_error_id,
  e.cursor_rowkey as cursor_rowkey,
  cast(null as varchar(32)) as row_ident,
  e.error_number as run_error_number,
  e.error_message as run_error_message,
  cast(null as varchar(32)) as target_uoid,
  e.target_name as target_name,
  cast(null as varchar(32)) as target_type,
  cast(null as varchar(32)) as target_type_symbol,
  e.target_name as first_target,
  cast(null as varchar(32)) as first_dblink,
  e.target_column as target_column,
  e.created_on as error_time,
  cast(null as varchar(32)) as column_value,
  e.statement as statement,
  cast(null as varchar(32)) as correction,
  e.created_by as created_by,
  cast(null as varchar(32)) as role,
  f.statement as action,
  f.trace_value as keys
from
  all_rv_audit_run_errors e
  join all_rv_step_executions s
  on e.step_audit_id = s.step_audit_id
  left outer join all_rv_audit_step_run_trace f
  on e.run_error_id = f.run_error_id 
where 
  e.step_audit_id is not null 
;


CREATE VIEW "RAB_RT_EXECUTION_MESSAGES" (AUDIT_EXECUTION_ID, RUN_ID_TYPE, AUDIT_MESSAGE_ID, SEVERITY, SEVERITY_SYMBOL, CREATED_ON, LINE_NUMBER, LINE_TEXT ) AS 
select
  e.task_audit_id as audit_execution_id,
  'T' as run_id_type,
  e.run_error_id as audit_message_id,
  e.error_severity as severity,
  c.CONSTANT_VARCHAR as severity_symbol,
  e.created_on as created_on,
  1 as line_number,
  e.error_message as line_text
from
  all_rv_audit_run_errors e
  left outer join WB_RT_CONSTANTS_TABLE c
  on e.error_severity = c.CONSTANT_NUM
where
  e.task_audit_id is not null
;


CREATE VIEW "RAB_RT_EXEC_PROC_RUN_PARAMS" ("AUDIT_EXECUTION_ID", "RUN_ID_TYPE", "PROCESS_UOID", "PARAMETER_NAME", "PARAMETER_NAME_SYMBOL", "PARAMETER_TYPE", "PARAMETER_TYPE_SYMBOL", "PARAMETER_KIND", "PARAMETER_KIND_SYMBOL", "PARAMETER_MODE", "PARAMETER_MODE_SYMBOL", "PARAMETER_SCOPE", "PARAMETER_SCOPE_SYMBOL", "TYPE_LENGTH", "TYPE_SCALE", "TYPE_PRECISION", "PARAMETER_VALUE_KIND", "PARAMETER_VALUE_KIND_SYMBOL", "PARAMETER_VALUE", "IS_OUTPUT_VALUE") AS 
select
  p.phase_audit_id as audit_execution_id,
  'P' as run_id_type,
  p.phase_uoid as process_uoid,
  r.param_name as parameter_name,
  upper(r.param_name) as parameter_name_symbol,
  r.param_type as parameter_type,
  (select constant_varchar from WB_RT_CONSTANTS_TABLE c where r.param_type = c.constant_num) as parameter_type_symbol,
  r.param_kind as parameter_kind,
  (select constant_varchar from WB_RT_CONSTANTS_TABLE c where r.param_kind = c.constant_num) as parameter_kind_symbol,
  r.param_mode as parameter_mode,
  (select constant_varchar from WB_RT_CONSTANTS_TABLE c where r.param_mode = c.constant_num) as parameter_mode_symbol,
  r.param_scope as parameter_scope,
  (select constant_varchar from WB_RT_CONSTANTS_TABLE c where r.param_scope = c.constant_num) as parameter_scope_symbol,
  r.type_length as type_length,
  r.type_scale as type_scale,
  r.type_precision as type_precision,
  r.value_kind as parameter_value_kind,
  (select constant_varchar from WB_RT_CONSTANTS_TABLE c where r.param_kind = c.constant_num) as parameter_value_kind_symbol,
  r.value as parameter_value,
  (case when r.value_mode = (select constant_num from WB_RT_CONSTANTS_TABLE where constant_name = 'PARAM_VALUE_OUTPUT') then 'true' else 'false' end) as is_output_value
from
  all_rv_audit_parameters r
  join all_rv_phase_executions p on r.phase_audit_id = p.phase_audit_id
where r.param_scope = (select constant_num from WB_RT_CONSTANTS_TABLE where constant_name = 'PARAM_SCOPE_PARAM')
;


CREATE VIEW "RAB_RT_EXEC_PARAM_VALUES" ("TYPE", "CODE", "NAME", "SYMBOL") AS 
select (select constant_num from WB_RT_CONSTANTS_TABLE where constant_varchar = 'BOOLEAN') as type, '0' as code,
'No' as name, 'NO' as symbol from dual
union select (select constant_num from WB_RT_CONSTANTS_TABLE where constant_varchar = 'BOOLEAN') as type, '1' as code,
'Yes' as name, 'YES' as symbol from dual
union select (select constant_num from WB_RT_CONSTANTS_TABLE where constant_varchar = 'AUDIT_LEVEL') as type, '0' as code,
'None' as name, 'NONE' as symbol from dual
union select (select constant_num from WB_RT_CONSTANTS_TABLE where constant_varchar = 'AUDIT_LEVEL') as type, '1' as code,
'Statistics' as name, 'STATISTICS' as symbol from dual
union select (select constant_num from WB_RT_CONSTANTS_TABLE where constant_varchar = 'AUDIT_LEVEL') as type, '2' as code,
'Error Details' as name, 'ERROR_DETAILS' as symbol from dual
union select (select constant_num from WB_RT_CONSTANTS_TABLE where constant_varchar = 'AUDIT_LEVEL') as type, '3' as code,
'Complete' as name, 'COMPLETE' as symbol from dual
union select (select constant_num from WB_RT_CONSTANTS_TABLE where constant_varchar = 'OPERATING_MODE') as type, '0' as code,
'Set based' as name, 'SET_BASED' as symbol from dual
union select (select constant_num from WB_RT_CONSTANTS_TABLE where constant_varchar = 'OPERATING_MODE') as type, '1' as code,
'Row Based' as name, 'ROW_BASED' as symbol from dual
union select (select constant_num from WB_RT_CONSTANTS_TABLE where constant_varchar = 'OPERATING_MODE') as type, '2' as code,
'Row Based (Target Only)' as name, 'ROW_BASED_TARGET_ONLY' as symbol from dual
union select (select constant_num from WB_RT_CONSTANTS_TABLE where constant_varchar = 'OPERATING_MODE') as type, '3' as code,
'Set Based Fail Over to Row Based' as name,
'SET_BASED_FAIL_OVER_TO_ROW_BASED' as symbol from dual
union select (select constant_num from WB_RT_CONSTANTS_TABLE where constant_varchar = 'OPERATING_MODE') as type, '4' as code,
'Set Based Fail Over to Row Based (Target Only)' as name,
'SET_BASED_FAIL_OVER_TO_ROW_BASED_TARGET_ONLY' as symbol from dual
;


CREATE VIEW "WB_RTV_EXECUTION_STORES" ("AUDIT_EXECUTION_ID", "STORE_UOID") AS 
select job_audit_id as audit_execution_id,
       '{1}' as store_uoid
from all_rv_job_executions
;


CREATE TABLE "WB_RTV_STORES" (
  "STORE_ID" NUMERIC(22,0), 
  "STORE_TYPE_ID" NUMERIC(22,0), 
  "STORE_UOID" VARCHAR(32), 
  "STORE_NAME" VARCHAR(64), 
  "VERSION_TAG" VARCHAR(80), 
  "IS_DEPLOYMENT_TARGET" NUMERIC(1,0), 
  "OWNER_UOID" VARCHAR(32), 
  "IS_LOCAL_TO_REPOS" NUMERIC(1,0)
);


Insert into WB_RTV_STORES (STORE_ID,STORE_TYPE_ID,STORE_UOID,STORE_NAME,VERSION_TAG,IS_DEPLOYMENT_TARGET,OWNER_UOID,IS_LOCAL_TO_REPOS) values (1,1,'{0}','PlatformSchema',null,1,null,0);
Insert into WB_RTV_STORES (STORE_ID,STORE_TYPE_ID,STORE_UOID,STORE_NAME,VERSION_TAG,IS_DEPLOYMENT_TARGET,OWNER_UOID,IS_LOCAL_TO_REPOS) values (2,2,'{1}','JRTSchema',null,2,null,0);


CREATE TABLE "RAB_RT_FILE_TYPES"(
  "TYPE" VARCHAR(64), 
  "SYMBOL" VARCHAR(64)
) ;


Insert into RAB_RT_FILE_TYPES (TYPE,SYMBOL) values ('JVMErrorStream','JVMERRORSTREAM');
Insert into RAB_RT_FILE_TYPES (TYPE,SYMBOL) values ('JVMOutputStream','JVMOUTPUTSTREAM');
Insert into RAB_RT_FILE_TYPES (TYPE,SYMBOL) values ('SQLLoaderOutputStream','SQLLOADEROUTPUTSTREAM');
Insert into RAB_RT_FILE_TYPES (TYPE,SYMBOL) values ('DiscoLogFile','DISCOLOGFILE');
Insert into RAB_RT_FILE_TYPES (TYPE,SYMBOL) values ('DiscoUpgradeLogFile','DISCOUPGRADELOGFILE');
Insert into RAB_RT_FILE_TYPES (TYPE,SYMBOL) values ('SQLLoaderErrorStream','SQLLOADERERRORSTREAM');
Insert into RAB_RT_FILE_TYPES (TYPE,SYMBOL) values ('SQLPlusDirectOutputStream','SQLPLUSDIRECTOUTPUTSTREAM');
Insert into RAB_RT_FILE_TYPES (TYPE,SYMBOL) values ('JavaErrorStream','JAVAERRORSTREAM');
Insert into RAB_RT_FILE_TYPES (TYPE,SYMBOL) values ('OMBPlusOutputStream','OMBPLUSOUTPUTSTREAM');
Insert into RAB_RT_FILE_TYPES (TYPE,SYMBOL) values ('PLSQLMapLogFile','PLSQLMAPLOGFILE');
Insert into RAB_RT_FILE_TYPES (TYPE,SYMBOL) values ('SQLPlusDirectErrorStream','SQLPLUSDIRECTERRORSTREAM');
Insert into RAB_RT_FILE_TYPES (TYPE,SYMBOL) values ('FTPErrorStream','FTPERRORSTREAM');
Insert into RAB_RT_FILE_TYPES (TYPE,SYMBOL) values ('FTPOutputStream','FTPOUTPUTSTREAM');
Insert into RAB_RT_FILE_TYPES (TYPE,SYMBOL) values ('JavaOutputStream','JAVAOUTPUTSTREAM');
Insert into RAB_RT_FILE_TYPES (TYPE,SYMBOL) values ('OdbLogFile','ODBLOGFILE');
Insert into RAB_RT_FILE_TYPES (TYPE,SYMBOL) values ('OMBPlusErrorStream','OMBPLUSERRORSTREAM');
Insert into RAB_RT_FILE_TYPES (TYPE,SYMBOL) values ('SQLPlusErrorStream','SQLPLUSERRORSTREAM');
Insert into RAB_RT_FILE_TYPES (TYPE,SYMBOL) values ('SQLPlusOutputStream','SQLPLUSOUTPUTSTREAM');
Insert into RAB_RT_FILE_TYPES (TYPE,SYMBOL) values ('SQLLoaderLogFile','SQLLOADERLOGFILE');
Insert into RAB_RT_FILE_TYPES (TYPE,SYMBOL) values ('SQLPlusDirectLogFile','SQLPLUSDIRECTLOGFILE');
Insert into RAB_RT_FILE_TYPES (TYPE,SYMBOL) values ('ShellErrorStream','SHELLERRORSTREAM');
Insert into RAB_RT_FILE_TYPES (TYPE,SYMBOL) values ('ShellOutputStream','SHELLOUTPUTSTREAM');


CREATE VIEW "RAB_RT_AUDIT_LOCATION_PARAMS" ("STORE_ID", "STORE_UOID", "STORE_NAME", "STORE_TYPE", "STORE_TYPE_SYMBOL", "STORE_TYPE_VERSION", "PARAMETER_NAME", "PARAMETER_NAME_SYMBOL", "PARAMETER_VALUE") AS
select
s.store_id as store_id,
s.store_uoid as store_uoid,
s.store_name as store_name,
cast(null as varchar(32)) as store_type,
cast(null as varchar(32)) as store_type_symbol,
cast(null as varchar(32)) as store_type_version,
cast(null as varchar(32)) as parameter_name,
cast(null as varchar(32)) as parameter_name_symbol,
cast(null as varchar(32)) as parameter_value
from
wb_rtv_stores s;


CREATE VIEW "RAB_RT_EXECUTION_FILES" ("AUDIT_EXECUTION_ID", "RUN_ID_TYPE", "FILE_ID", "FILE_CLOB", "FILE_BLOB", "FORMAT", "MIME_TYPE", "ENCODING_TYPE", "FILE_TYPE", "FILE_TYPE_SYMBOL", "CREATED_ON") AS 
select
  coalesce(f.task_audit_id, f.step_audit_id) as audit_execution_id,
  (case when f.task_audit_id is null then 'S' else 'T' end) as run_id_type,
  f.file_audit_id as file_id,
  f.file_text as file_clob,
  cast(null as numeric(22,0)) as file_blob,
  f.format as format,
  cast(null as numeric(22,0)) as mime_type,
  cast(null as numeric(22,0)) as encoding_type,
  f.file_type as file_type,
  ot.symbol as file_type_symbol,
  f.created_on as created_on
from
  all_rv_audit_exec_files f
  left outer join rab_rt_file_types ot
    on ot.type = f.file_type;


CREATE TABLE "WB_RT_DEF_OPERATOR_RESULTS" (
OPERATOR_RESULT_ID numeric(22, 0),
EXECUTION_OPERATOR_ID numeric(22, 0),
RETURN_RESULT varchar(64),
RETURN_RESULT_NUMBER numeric(10, 0),
RESULT_CATEGORY numeric(8, 0)
);


CREATE VIEW "RAB_RT_EXEC_ACT_RESULTS" ("RESULT_NUMBER", "RESULT_VALUE", "RESULT_CATEGORY", "RESULT_CODE", "AUDIT_EXECUTION_ID", "RUN_ID_TYPE") AS 
select 
pe.phase_audit_status as result_number,
pe.phase_return_result as result_value,
(case cp.CONSTANT_NAME when 'RESULT_NUMBER_SUCCESS' then cp1.CONSTANT_NUM
                       when 'RESULT_NUMBER_WARNING' then cp2.CONSTANT_NUM
                       when 'RESULT_NUMBER_FAILURE' then cp3.CONSTANT_NUM
                       else cp1.CONSTANT_NUM end) as result_category,
(case cp.CONSTANT_NAME when 'RESULT_NUMBER_SUCCESS' then 1
                       when 'RESULT_NUMBER_WARNING' then 2
                       when 'RESULT_NUMBER_FAILURE' then 3
                       else 1 end) as result_code,
pe.phase_audit_id as audit_execution_id,
'P' as run_id_type
from 
   all_rv_phase_executions pe
   left outer join WB_RT_CONSTANTS_TABLE cp
   on cp.CONSTANT_NUM = pe.phase_audit_status
   join WB_RT_CONSTANTS_TABLE cp1 on cp1.CONSTANT_NAME = 'RESULT_CATEGORY_SUCCESS'
   join WB_RT_CONSTANTS_TABLE cp2 on cp2.CONSTANT_NAME = 'RESULT_CATEGORY_WARNING'
   join WB_RT_CONSTANTS_TABLE cp3 on cp3.CONSTANT_NAME = 'RESULT_CATEGORY_FAILURE'
union all
select 
te.task_audit_status as result_number,
te.task_return_result as result_value,
(case ct.CONSTANT_NAME when 'RESULT_NUMBER_SUCCESS' then ct1.CONSTANT_NUM
                       when 'RESULT_NUMBER_WARNING' then ct2.CONSTANT_NUM
                       when 'RESULT_NUMBER_FAILURE' then ct3.CONSTANT_NUM
                       else ct1.CONSTANT_NUM end) as result_category,
(case ct.CONSTANT_NAME when 'RESULT_NUMBER_SUCCESS' then 1
                       when 'RESULT_NUMBER_WARNING' then 2
                       when 'RESULT_NUMBER_FAILURE' then 3
                       else 1 end) as result_code,
te.task_audit_id as audit_execution_id,
'T' as run_id_type
from 
   all_rv_task_executions te
   left outer join WB_RT_CONSTANTS_TABLE ct
   on ct.CONSTANT_NUM = te.task_audit_status
   join WB_RT_CONSTANTS_TABLE ct1 on ct1.CONSTANT_NAME = 'RESULT_CATEGORY_SUCCESS'
   join WB_RT_CONSTANTS_TABLE ct2 on ct2.CONSTANT_NAME = 'RESULT_CATEGORY_WARNING'
   join WB_RT_CONSTANTS_TABLE ct3 on ct3.CONSTANT_NAME = 'RESULT_CATEGORY_FAILURE'
union all
select 
se.step_audit_status as result_number,
se.step_return_result as result_value,
(case cs.CONSTANT_NAME when 'RESULT_NUMBER_SUCCESS' then cs1.CONSTANT_NUM
                       when 'RESULT_NUMBER_WARNING' then cs2.CONSTANT_NUM
                       when 'RESULT_NUMBER_FAILURE' then cs3.CONSTANT_NUM
                       else cs1.CONSTANT_NUM end) as result_category,
(case cs.CONSTANT_NAME when 'RESULT_NUMBER_SUCCESS' then 1
                       when 'RESULT_NUMBER_WARNING' then 2
                       when 'RESULT_NUMBER_FAILURE' then 3
                       else 1 end) as result_code,
se.step_audit_id as audit_execution_id,
'S' as run_id_type
from 
   all_rv_step_executions se
   left outer join WB_RT_CONSTANTS_TABLE cs
   on cs.CONSTANT_NUM = se.step_audit_status
   join WB_RT_CONSTANTS_TABLE cs1 on cs1.CONSTANT_NAME = 'RESULT_CATEGORY_SUCCESS'
   join WB_RT_CONSTANTS_TABLE cs2 on cs2.CONSTANT_NAME = 'RESULT_CATEGORY_WARNING'
   join WB_RT_CONSTANTS_TABLE cs3 on cs3.CONSTANT_NAME = 'RESULT_CATEGORY_FAILURE'
;


CREATE VIEW "RAB_RT_EXEC_ACT_RUN_SOURCES" ("AUDIT_EXECUTION_ID", "RUN_ID_TYPE", "MAP_UOID", "MAP_NAME", "MAP_TYPE", "MAP_TYPE_SYMBOL", "MAP_RUN_ID", "MAP_ID_TYPE", "SOURCE_UOID", "SOURCE_NAME", "SOURCE_TYPE", "SOURCE_TYPE_SYMBOL", "SOURCE_DBLINK" ) AS 
select 
se.step_audit_id as audit_execution_id,
'S' as run_id_type,
se.step_uoid as map_uoid,
se.step_name as map_name,
se.step_type as map_type,
st.symbol as map_type_symbol,
se.step_audit_id as map_run_id,
'S' as map_id_type,
ss.object_uoid as source_uoid,
ss.object_name as source_name,
ss.object_type as source_type,
ot.symbol as source_type_symbol,
cast(null as varchar(30)) as source_dblink
from all_rv_step_structs ss
join all_rv_step_executions se
  on se.step_audit_id = ss.step_audit_id
left outer join rab_rt_rep_types ot
  on ot.obj_type = ss.object_type
left outer join rab_rt_rep_types st
  on st.obj_type = se.step_type
where ss.struct_info = '<OBJECT USED AS="SRC"/>';


CREATE VIEW "RAB_RT_EXEC_ACT_RUN_TARGETS" ("AUDIT_EXECUTION_ID", "RUN_ID_TYPE", "MAP_UOID", "MAP_NAME", "MAP_TYPE", "MAP_TYPE_SYMBOL", "MAP_RUN_ID", "MAP_ID_TYPE", "TARGET_UOID", "TARGET_NAME", "TARGET_TYPE", "TARGET_TYPE_SYMBOL", "TARGET_DBLINK" ) AS 
select 
se.step_audit_id as audit_execution_id,
'S' as run_id_type,
se.step_uoid as map_uoid,
se.step_name as map_name,
se.step_type as map_type,
st.symbol as map_type_symbol,
se.step_audit_id as map_run_id,
'S' as map_id_type,
ss.object_uoid as target_uoid,
ss.object_name as target_name,
ss.object_type as target_type,
ot.symbol as target_type_symbol,
cast(null as varchar(30)) as target_dblink
from all_rv_step_structs ss
join all_rv_step_executions se
  on se.step_audit_id = ss.step_audit_id
left outer join rab_rt_rep_types ot
  on ot.obj_type = ss.object_type
left outer join rab_rt_rep_types st
  on st.obj_type = se.step_type
where ss.struct_info = '<OBJECT USED AS="TGT"/>';


CREATE VIEW "RAB_RT_EXEC_ACT_STEP_SOURCES" ("MAP_RUN_ID", "RUN_ID_TYPE", "MAP_STEP", "STEP_ID", "STEP_ID_TYPE", "STEP_NAME", "STEP_TYPE", "STEP_TYPE_SYMBOL", "SOURCE_UOID", "SOURCE_NAME", "SOURCE_TYPE", "SOURCE_TYPE_SYMBOL", "SOURCE_DBLINK" ) AS 
select 
se.step_audit_id as map_run_id,
'S' as run_id_type,
0 as map_step,
se.step_audit_id as step_id,
'S' as step_id_type,
se.step_name as step_name,
se.step_type as step_type,
st.symbol as step_type_symbol,
ss.object_uoid as source_uoid,
ss.object_name as source_name,
ss.object_type as source_type,
ot.symbol as source_type_symbol,
cast(null as varchar(30)) as source_dblink
from all_rv_step_structs ss
join all_rv_step_executions se
  on se.step_audit_id = ss.step_audit_id
left outer join rab_rt_rep_types ot
  on ot.obj_type = ss.object_type
left outer join rab_rt_rep_types st
  on st.obj_type = se.step_type
where ss.struct_info = '<OBJECT USED AS="SRC"/>';


CREATE VIEW "RAB_RT_EXEC_ACT_STEP_TARGETS" ("MAP_RUN_ID", "RUN_ID_TYPE", "MAP_STEP", "STEP_ID", "STEP_ID_TYPE", "STEP_NAME", "STEP_TYPE", "STEP_TYPE_SYMBOL", "TARGET_UOID", "TARGET_NAME", "TARGET_TYPE", "TARGET_TYPE_SYMBOL", "TARGET_DBLINK" ) AS 
select 
se.step_audit_id as map_run_id,
'S' as run_id_type,
0 as map_step,
se.step_audit_id as step_id,
'S' as step_id_type,
se.step_name as step_name,
se.step_type as step_type,
st.symbol as step_type_symbol,
ss.object_uoid as target_uoid,
ss.object_name as target_name,
ss.object_type as target_type,
ot.symbol as target_type_symbol,
cast(null as varchar(30)) as target_dblink
from all_rv_step_structs ss
join all_rv_step_executions se
  on se.step_audit_id = ss.step_audit_id
left outer join rab_rt_rep_types ot
  on ot.obj_type = ss.object_type
left outer join rab_rt_rep_types st
  on st.obj_type = se.step_type
where ss.struct_info = '<OBJECT USED AS="TGT"/>';


create view RAB_RT_EXEC_ACT_STEP_STRUCTS as
select
ss.struct_audit_id as struct_id,
ss.step_audit_id as step_id,
'S' as step_id_type,
ss.step_audit_id as map_run_id,
'S' as map_id_type,
ss.step_audit_id as audit_execution_id,
'S' as run_id_type,
ss.parent_operator_uoid as parent_operator_uoid,
ss.parent_object_uoid as parent_object_uoid,
ss.parent_object_type as parent_object_type,
pt.symbol as parent_object_type_symbol,
ss.parent_object_loc_uoid as parent_object_location_uoid,
ss.parent_object_name as parent_object_name,
ss.object_uoid as object_uoid,
ss.object_type as object_type,
ot.symbol as object_type_symbol,
ss.object_loc_uoid as object_location_uoid,
ss.object_name as object_name
from all_rv_step_structs ss
left outer join rab_rt_rep_types ot
  on ot.obj_type = ss.object_type
left outer join rab_rt_rep_types pt
  on pt.obj_type = ss.parent_object_type
where ss.struct_info = '<RELATIONSHIP="REPR"/>' or ss.struct_info = '<RELATIONSHIP="IMPL"/>';


create view RAB_RT_EXEC_ACT_STEPS as
select
d.step_audit_id as audit_execution_id,
'S' as run_id_type,
d.step_uoid as map_uoid,
d.step_name as map_name,
d.step_audit_id as map_run_id,
'S' as map_id_type,
0 as map_step,
d.step_audit_id as step_id,
'S' as step_id_type,
d.step_name as step_name,
d.step_type as step_type,
st.symbol as step_type_symbol,
d.start_time as start_time,
d.start_time + (d.elapse_time/86400) days as end_time,
d.elapse_time as elapse_time,
d.step_audit_status as run_status,
d.step_execution_result as run_status_symbol,
cast(null as varchar(32)) as statement,
d.step_info as info,
cast(null as varchar(32)) as when_clause,
d.number_errors as number_errors,
0 as number_logical_errors,
d.number_records_selected as number_records_selected,
d.number_records_inserted as number_records_inserted,
d.number_records_updated as number_records_updated,
d.number_records_deleted as number_records_deleted,
0 as number_records_discarded,
d.number_records_merged as number_records_merged,
0 as number_records_corrected
from all_rv_step_executions d
left outer join rab_rt_rep_types st
  on st.obj_type = d.step_type;


CREATE VIEW "RAB_RT_EXEC_ACT_RUN_PARAMS" ("AUDIT_EXECUTION_ID", "RUN_ID_TYPE", "MAP_UOID", "PARAMETER_NAME", "PARAMETER_NAME_SYMBOL", "PARAMETER_TYPE", "PARAMETER_TYPE_SYMBOL", "PARAMETER_KIND", "PARAMETER_KIND_SYMBOL", "PARAMETER_MODE", "PARAMETER_MODE_SYMBOL", "PARAMETER_SCOPE", "PARAMETER_SCOPE_SYMBOL", "TYPE_LENGTH", "TYPE_SCALE", "TYPE_PRECISION", "PARAMETER_VALUE_KIND", "PARAMETER_VALUE_KIND_SYMBOL", "PARAMETER_VALUE", "IS_OUTPUT_VALUE") AS 
select
cast(0 as numeric(22,0)) as audit_execution_id,
cast(null as varchar(1)) as run_id_type,
cast(null as varchar(32)) as map_uoid,
cast(null as varchar(32)) as parameter_name,
cast(null as varchar(32)) as parameter_name_symbol,
cast(null as numeric(10,0)) as parameter_type,
cast(null as varchar(32)) as parameter_type_symbol,
cast(null as numeric(10,0)) as parameter_kind,
cast(null as varchar(32)) as parameter_kind_symbol,
cast(null as numeric(10,0)) as parameter_mode,
cast(null as varchar(32)) as parameter_mode_symbol,
cast(null as numeric(10,0)) as parameter_scope,
cast(null as varchar(32)) as parameter_scope_symbol,
cast(null as numeric(10,0)) as type_length,
cast(null as numeric(10,0)) as type_scale,
cast(null as numeric(10,0)) as type_precision,
cast(null as numeric(10,0)) as parameter_value_kind,
cast(null as varchar(32)) as parameter_value_kind_symbol,
cast(null as varchar(32)) as parameter_value,
cast(null as varchar(5)) as is_output_value
from dual;


create view RAB_RT_EXEC_ACT_RUN_TRACES as
select
a.step_audit_id as audit_execution_id,
'S' as run_id_type,
f.step_audit_id as map_run_id,
'S' as map_id_type,
0 as map_step,
f.trace_audit_id as trace_id,
0 as rowkey,
cast(null as varchar(32)) as row_ident,
(case f.trace_info when '<TRACE="NEW"/>' then 'NEW'
                   when '<TRACE="ERR"/>' then 'ERROR'
                   else cast(null as varchar(32)) end) as status,
(case f.trace_info when '<TRACE="SRC"/>' then 'S'
                   when '<TRACE="TGT"/>' then 'T'
                   else cast(null as varchar(32)) end) as role,
f.statement as action,
f.table_name as table_name,
f.table_name as first_table,
cast(null as varchar(32)) as first_dblink,
f.trace_value as keys,
f.created_on as trace_time
from all_rv_audit_step_run_trace f
join all_rv_step_executions a
  on f.step_audit_id = a.step_audit_id;


CREATE VIEW RAB_RT_EXEC_ERROR_SOURCES ("RUN_ERROR_ID", "CURSOR_ROWKEY", "SOURCE_COLUMN_ID", "SOURCE_COLUMN", "SOURCE_COLUMN_INSTANCE", "SOURCE_COLUMN_VALUE", "SOURCE_UOID", "SOURCE_NAME", "SOURCE_TYPE", "SOURCE_TYPE_SYMBOL", "SOURCE_DBLINK", "ROLE", "CREATED_BY") AS 
  select
c.run_error_id as run_error_id,
cast(null as numeric(22,0)) as cursor_rowkey,
c.run_error_source_id as source_column_id,
c.column_name as source_column,
c.column_seq as source_column_instance,
c.column_value as source_column_value,
cast(null as varchar(32)) as source_uoid,
c.table_name as source_name,
cast(null as varchar(30)) as source_type,
cast(null as varchar(30)) as source_type_symbol,
cast(null as varchar(30)) as source_dblink,
(case c.error_source_info when '<TABLE USED AS="SRC"/>' then 'S'
                          when '<TABLE USED AS="TGT"/>' then 'T'
                          else cast(null as varchar(1)) end) as role,
c.created_by as created_by
from ALL_RV_AUDIT_RUN_ERROR_SOURCES c;


/* uab views created for OWBSYS implementation */
CREATE VIEW uab_rt_exec_process AS select * from rab_rt_exec_process;
CREATE VIEW uab_rt_exec_process_runs AS select * from rab_rt_exec_process_runs;
CREATE VIEW uab_rt_exec_proc_hier AS select * from rab_rt_exec_proc_hier;
CREATE VIEW uab_rt_exec_proc_run_counts AS select * from rab_rt_exec_proc_run_counts;
CREATE VIEW uab_rt_exec_proc_run_metrics AS select * from rab_rt_exec_proc_run_metrics;
CREATE VIEW uab_rt_exec_proc_run_params AS select * from rab_rt_exec_proc_run_params;
CREATE VIEW uab_rt_exec_process_run_errors AS select * from rab_rt_exec_process_run_errors;
CREATE VIEW uab_rt_execution_messages AS select * from rab_rt_execution_messages;
CREATE VIEW uab_rt_exec_act_run_errors AS select * from rab_rt_exec_act_run_errors;
CREATE VIEW uab_rt_exec_act_results AS select * from rab_rt_exec_act_results;
CREATE VIEW uab_rt_exec_act_run_sources AS select * from rab_rt_exec_act_run_sources;
CREATE VIEW uab_rt_exec_act_run_targets AS select * from rab_rt_exec_act_run_targets;
CREATE VIEW uab_rt_exec_act_step_sources AS select * from rab_rt_exec_act_step_sources;
CREATE VIEW uab_rt_exec_act_step_targets AS select * from rab_rt_exec_act_step_targets;
CREATE VIEW uab_rt_exec_act_step_structs AS select * from rab_rt_exec_act_step_structs;
CREATE VIEW uab_rt_exec_act_steps AS select * from rab_rt_exec_act_steps;
CREATE VIEW uab_rt_exec_act_run_params AS select * from rab_rt_exec_act_run_params;
CREATE VIEW uab_rt_exec_act_run_traces AS select * from rab_rt_exec_act_run_traces;
CREATE VIEW uab_rt_execution_stores AS select * from wb_rtv_execution_stores;
CREATE VIEW uab_rt_stores AS select * from wb_rtv_stores;


commit;