create or replace package wmp_ui as

	procedure render_new_line(p_number in number := 1);
	procedure render_contents_table(p_type_name in varchar2, p_id in number, p_repository_id in number, p_role in varchar2, p_sheet in number, p_action in varchar2 := null, p_is_portlet in varchar2 := null, p_back_url in varchar2 := null, p_reference_path in varchar2 := null);
	procedure render_related_objects_table(p_type_name in varchar2, p_id in number, p_repository_id in number, p_role in varchar2, p_sheet in number, p_action in varchar2 := null, p_is_portlet in varchar2 := null, p_back_url in varchar2 := null, p_reference_path in varchar2 := null);
	procedure render_path(p_type_name in varchar2, p_id in number, p_is_portlet in varchar2 := null, p_back_url in varchar2 := null, p_reference_path in varchar2 := null);
	procedure render_properties_row(p_type_name in varchar2, p_id in number, p_repository_id in number, p_role in varchar2, p_sheet in number, p_action in varchar2 := null, p_is_portlet in varchar2 := null, p_back_url in varchar2 := null, p_reference_path in varchar2 := null);
	procedure render_extended_properties_row(p_type_name in varchar2, p_id in number, p_repository_id in number, p_role in varchar2, p_sheet in number, p_action in varchar2 := null, p_is_portlet in varchar2 := null, p_back_url in varchar2 := null, p_reference_path in varchar2 := null);
	procedure render_title(p_type_name in varchar2, p_id in number, p_is_portlet in varchar2 := null, p_back_url in varchar2 := null, p_reference_path in varchar2 := null);
	procedure render_description(p_type_name in varchar2, p_id in number, p_is_portlet in varchar2 := null, p_back_url in varchar2 := null, p_reference_path in varchar2 := null);
	procedure render_reports_list(p_type_name in varchar2, p_id in number, p_repository_id in number, p_role in varchar2, p_sheet in number, p_action in varchar2 := null, p_is_portlet in varchar2 := null, p_back_url in varchar2 := null, p_reference_path in varchar2 := null);
	procedure render_links_list(p_type_name in varchar2, p_id in number, p_repository_id in number, p_role in varchar2, p_sheet in number, p_action in varchar2 := null, p_is_portlet in varchar2 := null, p_back_url in varchar2 := null, p_reference_path in varchar2 := null);

	procedure render_type_select_list(p_select_name in varchar2, p_selected_type in varchar2 := null, p_default_all in boolean := false);
	procedure render_repository_select_list(p_select_name in varchar2, p_selected_repository_id in varchar2 := null, p_default_all in boolean := false, p_accesible in boolean := false);
	procedure render_role_select_list(p_select_name in varchar2, p_selected_role in varchar2 := null, p_default_all in boolean := false, p_accesible in boolean := false);
	procedure render_refresh_select_list(p_select_name in varchar2, p_selected_option in varchar2 := null);

	function render_refresh_select_list(p_select_name in varchar2, p_selected_option in varchar2 := null, p_option_prefix in varchar2 := null) return varchar2;
	function render_mls_select_list(p_repository in varchar2, p_select_name in varchar2, p_selected_option in varchar2 := null, p_option_prefix in varchar2 := null) return varchar2;
	procedure render_mls_select_list(p_repository in varchar2, p_select_name in varchar2, p_selected_option in varchar2 := null, p_option_prefix in varchar2 := null);

	function render_content_actions(
		p_text in varchar2, 
		p_repository_id in number, 
		p_role_name in varchar2, 
		p_type_name in varchar2, 
		p_id in number, 
		p_is_portlet in varchar2 := null, 
		p_back_url in varchar2 := null, 
		p_reference_path in varchar2 := null
		) 
	return varchar2;

end wmp_ui;
