create or replace package wmp_pages as

	procedure show_navigation_page(
    p_repository_id in number, 
    p_role in varchar2, 
    p_sheet in number, 
    p_type_name in varchar2, 
		p_id in number, 
    p_action in varchar2 := null, 
    p_is_portlet in varchar2 := null, 
    p_back_url in varchar2 := null, 
    p_reference_path in varchar2 := null, 
    p_request in varchar2 := null
    );
		
	procedure show_report_page(
		p_repository_id in number, 
		p_role in varchar2, 
		p_sheet in number, 
		p_type_name in varchar2, 
		p_id in number, 
		p_helper in varchar2, 
		p_category in varchar2 := null, 
		p_is_portlet in varchar2 := null, 
		p_back_url in varchar2 := null, 
		p_reference_path in varchar2 := null,
		p_preference_path in varchar2 := null
		);

	procedure show_customize(
		p_error in varchar2 := null,
		p_repository_id in number := null, 
		p_role in varchar2 := null, 
		p_sheet in number := null, 
		p_type_name in varchar2 := null, 
		p_id in number := null, 
		p_is_portlet in varchar2 := null, 
		p_back_url in varchar2 := null, 
		p_reference_path in varchar2 := null
		);

	procedure save_customized_options (
		p_repository_id in number := null, 
		p_role in varchar2 := null, 
		p_sheet in number := null, 
		p_type_name in varchar2 := null, 
		p_id in number := null,
		p_request in varchar2 := null,
		P_DISPLAY_COUNT in varchar2 := null,
		P_DISPLAY_LIMIT in varchar2 := null,
		P_DISPLAY_DESC in varchar2 := null,
		P_DISPLAY_PATH in varchar2 := null,
		p_repository in varchar2 := null,
		p_is_portlet in varchar2 := null,
		p_back_url in varchar2 := null, 
		p_reference_path in varchar2 := null
		);

	procedure show (
		p_page	in varchar2  := null,
		p_repository in varchar2 := null,
		p_role_name in varchar := null,
		p_type in varchar := null,
		p_id in number := null,
		p_is_portlet in varchar2 := null,
		p_back_url in varchar2 := null, 
		p_reference_path in varchar2 := null,
		p_display_name in varchar2 := null,
		p_url in varchar2 := null,
		p_desc in varchar2 := null,
		p_scope in varchar2 := null,
		p_is_public in varchar2 := null,
		p_is_action in varchar2 := null,
		p_is_owb_object in varchar2 := null,
		p_error in varchar2 := null,
		p_link_id in varchar2 := null
		);

	procedure save_link (
		p_request in varchar2  := null,
		p_repository in varchar2 := null,
		p_role_name in varchar := null,
		p_type in varchar := null,
		p_id in number := null,
		p_is_portlet in varchar2 := null,
		p_back_url in varchar2 := null, 
		p_reference_path in varchar2 := null,
		p_display_name in varchar2 := null,
		p_url in varchar2 := null,
		p_desc in varchar2 := null,
		p_scope in varchar2 := wmp_api_session.ID,
		p_is_public in varchar2 := null,
		p_is_action in varchar2 := null,
		p_is_owb_object in varchar2 := null,
		p_link_id in varchar2 := null
		);

	procedure show_refresh (
		p_repository in varchar2 := null,
		p_is_portlet in varchar2 := null,
		p_back_url in varchar2 := null, 
		p_reference_path in varchar2 := null,
		p_error in varchar2 := null,
		p_role_name in varchar2 := null
		);

	procedure refresh (
		p_repository in varchar2 := null,
		p_is_portlet in varchar2 := null,
		p_back_url in varchar2 := null,
		p_reference_path in varchar2 := null
		);

	procedure purge_log (
		p_repository in varchar2 := null,
		p_is_portlet in varchar2 := null,
		p_back_url in varchar2 := null,
		p_reference_path in varchar2 := null
		);

	procedure redirect_url(
		p_url in varchar2, 
		p_request in varchar2 := null
		);

	procedure show_mls_options(
		p_repository in varchar2 := null,
		p_role_name in varchar2 := null,
		p_is_portlet in varchar2 := null, 
		p_back_url in varchar2 := null, 
		p_reference_path in varchar2 := null
		);

	procedure save_mls_options (
		p_request in varchar2 := null,
		p_repository in varchar2 := null,
		p_role_name in varchar2 := null,
		p_is_portlet in varchar2 := null,
		p_back_url in varchar2 := null,
		p_reference_path in varchar2 := null,
		p_option in wmp_api_session.option_array 
		);

end wmp_pages;
