create or replace package wmp_portal 
as
	
  AMERICAN varchar2(10) := 'us';
  USER_LEVEL_TYPE varchar2(10) := 'U';
  SYSTEM_LEVEL_TYPE varchar2(10) := 'S';
	SYSTEM_LEVEL_ID number := 0;
  CLIENTSESSIONID number := 1;
  CLIENTUSERID number := 0;
  CLIENTGROUPID number := 0;
  CLIENTGROUPNAME varchar2(128) := 'ADMINISTRATORS';
  CLIENTDBLINK varchar2(128) := 'localhost';
  CLIENTHOST varchar2(128) := 'localhost';
  CLIENTDEFAULTROLE varchar2(128) := 'wmp_user';
  OWBREPOSITORY varchar2(128) := null;
  
  type list_record is record (
    group_id number,
    siteid number,
    name varchar2(256),
    description VARCHAR2(500)
    );
  type list_array is table of list_record index by binary_integer;  
  
  function get_string (
      p_domain in varchar2,
      p_sub_domain varchar2 default 'all',
      p_name in varchar2,
      p_language in varchar2
  )
  return varchar2;

  function add_string (
      p_domain in varchar2,
      p_sub_domain in varchar2 default 'all',
      p_name in varchar2,
      p_language in varchar2,
      p_text in varchar2
  )
  return number;

  procedure set_string (
      p_domain in varchar2,
      p_sub_domain in varchar2 default 'all',
      p_name in varchar2,
      p_language in varchar2,
      p_text in varchar2
  );
  
  procedure remove_string (
      p_domain in varchar2,
      p_sub_domain in varchar2 default 'all',
      p_name in varchar2,
      p_language in varchar2
  );

  function portlet_heading (
    p_string in varchar2,
    p_level in number
   )
  return varchar2;

  function portlet_text (
    p_string in varchar2,
    p_level in number
   )
  return varchar2;
  
  function get_nls_language return varchar2;

  function get_logout_url return varchar2;

	function is_user_in_group(p_user_id in number, p_group_id in number) return boolean;

  function id(
    p_user_name in varchar2 := null
    )
  return number;

  function group_id(
    p_name in varchar2 := null
    )
  return number;  

  function get_product_version return varchar2;
  
  function get_user return varchar2;
  function get_user_id return number;

  function get_proc_path (
    p_url in varchar2,
    p_schema in varchar2 := wmp_constants.USER_SCHEMA
    )
  return varchar2;
  
	function group_exists(p_group_id in number) return boolean;
	function user_exists(p_user_id in number) return boolean;

	function group_id_list(p_user_name in varchar2) return varchar2;

  function check_if_logged_on (
    p_requested_url in varchar2 := null
    )
  return boolean;

  function get_sessionid return NUMBER;

  function is_logged_on return Boolean;

  function group_name (
    p_group_id in number
    )
  return varchar2;

  function user_name (
    p_id in number
    )
  return varchar2;

  procedure render_css;

  function get_home_url return varchar2;
  function get_home_image return varchar2;
  function get_help_image return varchar2;
  function get_background_image return varchar2;
  function get_pobtrans_image return varchar2;
  function get_image (p_image in varchar2) return varchar2;

  procedure logout;

	procedure set_value (
		p_name in varchar2,
		p_value in varchar2
		);

	function get_value (
		p_name in varchar2
		)
	return varchar2;

  function get_browser_schema return varchar2;
  
end wmp_portal;
