create or replace package wmp_provider
is

    LAUNCHER_PORTLET constant integer := 1;
    NAVIGATOR_PORTLET constant integer :=2;
    REPORTS_PORTLET constant integer :=3;
    FAVORITES_PORTLET constant integer :=4;
    ADMINISTRATOR_PORTLET constant integer :=5;

    function get_api_version
    (
        p_provider_id in integer
    )
    return integer;


    procedure register_provider
    (
        p_provider_id in integer
    );


    procedure deregister_provider
    (
        p_provider_id in integer
    );


    procedure do_login
    (
         p_provider_id in integer
        ,p_browser_cookies in wwpro_api_provider.cookie_table
        ,p_provider_cookies out wwpro_api_provider.cookie_table
    );


    function get_portlet
    (
         p_provider_id in integer
        ,p_portlet_id in integer
        ,p_language in varchar2
    )
    return wwpro_api_provider.portlet_record;
    

    function get_portlet_list
    (
         p_provider_id in integer
        ,p_start_row in integer
        ,p_rowcount in integer
        ,p_language in varchar2
        ,p_security_level in boolean
        ,p_type in integer
    )
    return wwpro_api_provider.portlet_table;


    procedure show_portlet
    (
        p_portlet_record in out wwpro_api_provider.portlet_runtime_record
    );


    procedure copy_portlet
    (
         p_copy_portlet_info in wwpro_api_provider.copy_portlet_record
    );

    function is_portlet_runnable
    (
        p_portlet_instance in wwpro_api_provider.portlet_instance_record
    )
    return boolean;
    
    function describe_portlet_parameters
    (
         p_provider_id in integer
        ,p_portlet_id in integer
        ,p_language in varchar2
    )
    return wwpro_api_provider.portlet_parameter_table;
    
    procedure register_portlet
    (
        p_portlet_instance in wwpro_api_provider.portlet_instance_record
    );


    procedure deregister_portlet
    (
        p_portlet_instance in wwpro_api_provider.portlet_instance_record
    );

       
end wmp_provider;
