create or replace package wmp_reports_portlet is
	
	function get_portlet_info (
		p_provider_id in integer
		,p_portlet_id in integer
        	,p_language in varchar2
	    	)
	    return wwpro_api_provider.portlet_record;

   
	procedure show(
		p_portlet_record wwpro_api_provider.portlet_runtime_record
		);   
   
	procedure redirect(
		p_reference_path in varchar2, 
		p_back_url in varchar2 := null,
		p_repository_id in varchar2 := null, 
		p_role_name in varchar2 := null,
		p_sheet in varchar2 := null,
		p_type_name in varchar2 := null,
		p_id in varchar2 := null,
		p_helper in varchar2 :=null,
		p_category in varchar2 := null
		);
		
	function customize_report_hlink(
		p_is_default in varchar2,
		p_favorite_id in number,
		p_back_url in varchar2 := null, 
		p_reference_path in varchar2 := null
		) 
	return varchar2;

	procedure make_default_report(
		p_favorite_id in number, 
		p_back_url in varchar2 := null, 
		p_reference_path in varchar2 := null
		);

	procedure reset_default_report(
		p_favorite_id in number, 
		p_back_url in varchar2 := null, 
		p_reference_path in varchar2 := null
		);
		
	procedure mode_show_edit(p_reference_path in varchar2, p_back_url in varchar2 := null);
	procedure mode_show_help;
	procedure mode_show_about(
		p_back_url in varchar2 := null
		);    

	procedure register (
		p_portlet_instance in wwpro_api_provider.portlet_instance_record
		);
    
	procedure deregister (
		p_portlet_instance in wwpro_api_provider.portlet_instance_record
		);

	procedure customize_report_favorites(
		p_reference_path in varchar2 := null, 
		p_back_url in varchar2 := null,
		p_second_loading in varchar2 := null
		);
    
end wmp_reports_portlet;
