begin 

declare 
	type CurType is ref cursor;
	
	procedure lp_create_style(p_style in varchar2) 
	is
		l_count number := 0;
		l_cur CurType;
		sql_stml varchar2(300);
	begin
		begin
			open l_cur for 'select count(*) from ~portalSchema.WWPOB_STYLE$';
			fetch l_cur into l_count;
			close l_cur;	
						
		exception
			when others then
				close l_cur;
				l_count := 0;
		end;
		
		if l_count > 0
		then
			/* IAS V1.2 */
			execute immediate '
				declare
					l_style_id number := 0;
				begin	 
					l_style_id :=wwpob_api_style.create_style (
					:1,
					''IMPORTANT: Do NOT delete or rename this public style. Please refer to Oracle Portal Help on customization of public style before ''
					, 1 
					,''us''
					,1 
					,null ,null ,1 ,null
					);
					
					wwpob_app_style.save_editstyle(
						p_name=>''bannertitle'', 
						p_style_id=>l_style_id,
						p_color=>''#FFFFFF'', 
						p_font_name=>''Arial, Helvetica'', 
						p_font_size=>''18pt''); 
					
					wwpob_app_style.save_editstyle(p_name=>''bannercolor'', p_style_id=>l_style_id, p_color=>''#9999CC'');
					
					if :1 = ''OWB_Browser_Navigation_Style_~userSchema'' then
						wwpob_app_style.save_editstyle(p_name=>''portletheaderbg'', p_style_id=>l_style_id, p_color=>''#336699'');
						wwpob_app_style.save_editstyle(p_name=>''portletheadertext'', p_style_id=>l_style_id, p_color=>''#FFFFFF'', p_font_name=>''Arial, Helvetica'', p_font_size=>''10pt'');
						wwpob_app_style.save_editstyle(p_name=>''portletheaderlink'', p_style_id=>l_style_id, p_color=>''#FFFFFF'', p_font_name=>''Arial, Helvetica'', p_font_size=>''8pt'');

					elsif :1 = ''OWB_Browser_Report_Style_~userSchema'' then
						wwpob_app_style.save_editstyle(p_name=>''portletheaderbg'', p_style_id=>l_style_id, p_color=>''#CCCC99'');
						wwpob_app_style.save_editstyle(p_name=>''portletheadertext'', p_style_id=>l_style_id, p_color=>''#336699'', p_font_name=>''Arial, Helvetica'', p_font_size=>''10pt'');
						wwpob_app_style.save_editstyle(p_name=>''portletheaderlink'', p_style_id=>l_style_id, p_color=>''#663300'', p_font_name=>''Arial, Helvetica'', p_font_size=>''8pt'');
					end if;

						wwpob_app_style.save_editstyle(p_name=>''portletsubheaderbg'', p_style_id=>l_style_id, p_color=>''#F7F7E7'');
						wwpob_app_style.save_editstyle(p_name=>''portletsubheadertext'', p_style_id=>l_style_id, p_color=>''#336699'', p_font_name=>''Arial, Helvetica'', p_font_size=>''10pt'');
						wwpob_app_style.save_editstyle(p_name=>''portletsubheaderlink'', p_style_id=>l_style_id, p_color=>''#663300'', p_font_name=>''Arial, Helvetica'', p_font_size=>''8pt'');


						wwpob_app_style.save_editstyle(p_name=>''tabfgcolor'', p_style_id=>l_style_id, p_color=>''#336699'');

						wwpob_app_style.save_editstyle(p_name=>''tabbgcolor'', p_style_id=>l_style_id, p_color=>''#CCCC99'');
						wwpob_app_style.save_editstyle(p_name=>''tabbgtext'', p_style_id=>l_style_id, p_color=>''#003366'', p_font_name=>''Arial, Helvetica'', p_font_size=>''10pt'', p_font_style=>''text-decoration: none'');
				end;' 
				using p_style;
			
			
		else
		
			/* IAS V2 */
					
			execute immediate ' 
				declare
				l_style_id number := 0;
				begin
					l_style_id := wwv_settingsdb.addset (
				 	 p_name=> :1,
					 p_title=> :1,
					 p_ispublic=> true,
					 p_siteidto=> 0
					);
					
					if :1 = ''OWB_Browser_Navigation_Style_~userSchema'' 
				then

					wwv_settingsdb.modify(
						p_settingssetid=> l_style_id,
						p_type=> ''Portlet'',
						p_name=> ''PortletHeaderColor'',
						p_valuetype=> ''Background-Color'',
						p_oldvalue=> null,
						p_newvalue=> ''#336699'',
						p_siteid=>0
						);
					
					
					wwv_settingsdb.modify(
						p_settingssetid=> l_style_id,
						p_type=> ''Portlet'',
						p_name=> ''PortletHeaderText'',
						p_valuetype=> ''Color'',
						p_oldvalue=> null,
						p_newvalue=> ''#FFFFFF'',
						p_siteid=>0
						);
			
					wwv_settingsdb.modify(
						p_settingssetid=> l_style_id,
						p_type=> ''Portlet'',
						p_name=> ''PortletHeaderText'',
						p_valuetype=> ''Font-Family'',
						p_oldvalue=> null,
						p_newvalue=> ''Arial, Helvetica'',
						p_siteid=>0
						);	
				
					wwv_settingsdb.modify(
						p_settingssetid=> l_style_id,
						p_type=> ''Portlet'',
						p_name=> ''PortletHeaderText'',
						p_valuetype=> ''Font-Size'',
						p_oldvalue=> null,
						p_newvalue=> ''10pt'',
						p_siteid=>0
						);
					
					wwv_settingsdb.modify(
						p_settingssetid=> l_style_id,
						p_type=> ''Portlet'',
						p_name=> ''PortletHeaderLink'',
						p_valuetype=> ''Color'',
						p_oldvalue=> null,
						p_newvalue=> ''#FFFFFF'',
						p_siteid=>0
						);
					
					wwv_settingsdb.modify(
						p_settingssetid=> l_style_id,
						p_type=> ''Portlet'',
						p_name=> ''PortletHeaderLink'',
						p_valuetype=> ''Font-Family'',
						p_oldvalue=> null,
						p_newvalue=> ''Arial, Helvetica'',
						p_siteid=>0
						);
				
					wwv_settingsdb.modify(
						p_settingssetid=> l_style_id,
						p_type=> ''Portlet'',
						p_name=> ''PortletHeaderLink'',
						p_valuetype=> ''Font-Size'',
						p_oldvalue=> null,
						p_newvalue=> ''8pt'',
						p_siteid=>0
						);

						
				elsif :1 = ''OWB_Browser_Report_Style_~userSchema'' then
					wwv_settingsdb.modify(
						p_settingssetid=> l_style_id,
						p_type=> ''Portlet'',
						p_name=> ''PortletHeaderColor'',
						p_valuetype=> ''Background-Color'',
						p_oldvalue=> null,
						p_newvalue=> ''#CCCC99'',
						p_siteid=>0
						);
					

					wwv_settingsdb.modify(
						p_settingssetid=> l_style_id,
						p_type=> ''Portlet'',
						p_name=> ''PortletHeaderText'',
						p_valuetype=> ''Color'',
						p_oldvalue=> null,
						p_newvalue=> ''#336699'',
						p_siteid=>0
						);
					
					wwv_settingsdb.modify(
						p_settingssetid=> l_style_id,
						p_type=> ''Portlet'',
						p_name=> ''PortletHeaderText'',
						p_valuetype=> ''Font-Family'',
						p_oldvalue=> null,
						p_newvalue=> ''Arial, Helvetica'',
						p_siteid=>0
						);
				
					wwv_settingsdb.modify(
						p_settingssetid=> l_style_id,
						p_type=> ''Portlet'',
						p_name=> ''PortletHeaderText'',
						p_valuetype=> ''Font-Size'',
						p_oldvalue=> null,
						p_newvalue=> ''10pt'',
						p_siteid=>0
						);
					
					
					wwv_settingsdb.modify(
						p_settingssetid=> l_style_id,
						p_type=> ''Portlet'',
						p_name=> ''PortletHeaderLink'',
						p_valuetype=> ''Color'',
						p_oldvalue=> null,
						p_newvalue=> ''#663300'',
						p_siteid=>0
						);
					
					wwv_settingsdb.modify(
						p_settingssetid=> l_style_id,
						p_type=> ''Portlet'',
						p_name=> ''PortletHeaderLink'',
						p_valuetype=> ''Font-Family'',
						p_oldvalue=> null,
						p_newvalue=> ''Arial, Helvetica'',
						p_siteid=>0
						);
				
					wwv_settingsdb.modify(
						p_settingssetid=> l_style_id,
						p_type=> ''Portlet'',
						p_name=> ''PortletHeaderLink'',
						p_valuetype=> ''Font-Size'',
						p_oldvalue=> null,
						p_newvalue=> ''8pt'',
						p_siteid=>0
						);
	
				end if;
				
				wwv_settingsdb.modify(
					p_settingssetid=> l_style_id,
					p_type=> ''Portlet'',
					p_name=> ''PortletSubHeaderColor'',
					p_valuetype=> ''Background-Color'',
					p_oldvalue=> null,
					p_newvalue=> ''#F7F7E7'',
					p_siteid=>0
					);
					
				wwv_settingsdb.modify(
					p_settingssetid=> l_style_id,
					p_type=> ''Portlet'',
					p_name=> ''PortletSubHeaderText'',
					p_valuetype=> ''Color'',
					p_oldvalue=> null,
					p_newvalue=> ''#336699'',
					p_siteid=>0
					);
					
				wwv_settingsdb.modify(
					p_settingssetid=> l_style_id,
					p_type=> ''Portlet'',
					p_name=> ''PortletSubHeaderText'',
					p_valuetype=> ''Font-Family'',
					p_oldvalue=> null,
					p_newvalue=> ''Arial, Helvetica'',
					p_siteid=>0
					);
				
				wwv_settingsdb.modify(
					p_settingssetid=> l_style_id,
					p_type=> ''Portlet'',
					p_name=> ''PortletSubHeaderText'',
					p_valuetype=> ''Font-Size'',
					p_oldvalue=> null,
					p_newvalue=> ''10pt'',
					p_siteid=>0
					);
					
				wwv_settingsdb.modify(
					p_settingssetid=> l_style_id,
					p_type=> ''Portlet'',
					p_name=> ''PortletSubHeaderLink'',
					p_valuetype=> ''Color'',
					p_oldvalue=> null,
					p_newvalue=> ''#663300'',
					p_siteid=>0
					);
					
				wwv_settingsdb.modify(
					p_settingssetid=> l_style_id,
					p_type=> ''Portlet'',
					p_name=> ''PortletSubHeaderLink'',
					p_valuetype=> ''Font-Family'',
					p_oldvalue=> null,
					p_newvalue=> ''Arial, Helvetica'',
					p_siteid=>0
					);
				
				wwv_settingsdb.modify(
					p_settingssetid=> l_style_id,
					p_type=> ''Portlet'',
					p_name=> ''PortletSubHeaderLink'',
					p_valuetype=> ''Font-Size'',
					p_oldvalue=> null,
					p_newvalue=> ''8pt'',
					p_siteid=>0
					);
					

				wwv_settingsdb.modify(
					p_settingssetid=> l_style_id,
					p_type=> ''Tab'',
					p_name=> ''TabForegroundColor'',
					p_valuetype=> ''Background-Color'',
					p_oldvalue=> null,
					p_newvalue=> ''#336699'',
					p_siteid=>0
					);
					

				wwv_settingsdb.modify(
					p_settingssetid=> l_style_id,
					p_type=> ''Tab'',
					p_name=> ''TabBackgroundColor'',
					p_valuetype=> ''Background-Color'',
					p_oldvalue=> null,
					p_newvalue=> ''#CCCC99'',
					p_siteid=>0
					);
					
				wwv_settingsdb.modify(
					p_settingssetid=> l_style_id,
					p_type=> ''Tab'',
					p_name=> ''TabBackgroundText'',
					p_valuetype=> ''Color'',
					p_oldvalue=> null,
					p_newvalue=> ''#003366'',
					p_siteid=>0
					);
					
				wwv_settingsdb.modify(
					p_settingssetid=> l_style_id,
					p_type=> ''Tab'',
					p_name=> ''TabBackgroundText'',
					p_valuetype=> ''Font-Family'',
					p_oldvalue=> null,
					p_newvalue=> ''Arial, Helvetica'',
					p_siteid=>0
					);
			
				wwv_settingsdb.modify(
					p_settingssetid=> l_style_id,
					p_type=> ''Tab'',
					p_name=> ''TabBackgroundText'',
					p_valuetype=> ''Font-Size'',
					p_oldvalue=> null,
					p_newvalue=> ''10pt'',
					p_siteid=>0
					);	
				
				wwv_settingsdb.modify(
				       p_settingssetid=> l_style_id,
				       p_type=> ''Portlet'',
				       p_name=> ''PortletHeading1'',
				       p_valuetype=> ''Font-Decoration'',
				       p_oldvalue=> ''Underline'',
				       p_newvalue=> ''None'',
				       p_siteid=>0
				       );


				end; ' using p_style;
				
		end if;		
		
	exception
	when others then
		return;
	end;


begin
	lp_create_style('OWB_Browser_Navigation_Style_~userSchema');
	lp_create_style('OWB_Browser_Report_Style_~userSchema');
end;

end;