# $Header: wfinst.mk 26.1 2003/04/21 23:58:19 kma ship $
#/*=====================================================================+
# |  Copyright (c) 1995, 2003 Oracle Corporation, California, USA       |
# |                          All rights reserved.                       |
# +=====================================================================+
# | FILENAME
# |  wf.mk
# |
# | DESCRIPTION
# |  Links all Oracle Workflow stand-alone programs
# |
# | NOTES
# |
# | HISTORY
# |  14 Dec 1995  G Buzsaki  Creaded (from fnd.mk fnd 7.5)
# |  10 Mar 1997  R Sheh     Modified to work with Oralce installer on Unix
# |  21 Apr 2003  K Ma       Removed mailer related link lines
# *=====================================================================*/

buildnone :
	@$(ECHO) "== No Target Specified =="

include $(ORACLE_HOME)/rdbms/lib/env_rdbms.mk

SHELL = /bin/sh
CHMOD = chmod
MCS = mcs -d

APPLLIB = lib

WF_TOP = $(ORACLE_HOME)/wf

ORACLE_LINK= $(LLIBCLNTSH) $(NAUTAB) $(NAETAB) $(NAEDHS) $(NALDFLAGSLIST) $(LLIBSQL) $(NETLIBS) $(LLIBORA) $(NETLIBS) $(LIBMM) $(LIBEPC)  $(CORELIBS) $(LLIBRDBMS_CLT) $(CORELIBS) $(LDLIBS) $(DEF_OPT) $(SSBBDED)

LWFLIB = $(WF_TOP)/$(APPLLIB)/libwf.a

# *****************************************************
# List of modules
# *****************************************************

# Self Test
WFTEST		  = wftest

# Resource Generator
WFRESGEN  	  = wfresgen

# Loader
WFLOAD    	  = wfload

# *****************************************************
# List of modules to link
# *****************************************************
MODULES = $(WFTEST) $(WFRESGEN) $(WFLOAD) 
wfall:	$(MODULES)

# *****************************************************
# How to link each module
# *****************************************************

$(WFTEST): $(WF_TOP)/$(APPLLIB)/wftest.o $(LWFLIB)
	$(LINK) $(LDFLAGS) $(WF_TOP)/$(APPLLIB)/wftest.o \
		$(LWFLIB) $(ORACLE_LINK)
	$(CHMOD) 755 $@
	$(MCS) $@

$(WFRESGEN): $(WF_TOP)/$(APPLLIB)/wfresgen.o $(LWFLIB)
	$(LINK) $(LDFLAGS) $(WF_TOP)/$(APPLLIB)/wfresgen.o \
		$(LWFLIB) $(ORACLE_LINK)
	$(CHMOD) 755 $@
	$(MCS) $@
	-mv wfresgen $(ORACLE_HOME)/bin/wfresgen

$(WFLOAD): $(WF_TOP)/$(APPLLIB)/wfload.o $(LWFLIB)
	$(LINK) $(LDFLAGS) $(WF_TOP)/$(APPLLIB)/wfload.o \
		$(LWFLIB) $(ORACLE_LINK)
	$(CHMOD) 755 $@
	$(MCS) $@
	-mv wfload $(ORACLE_HOME)/bin/wfload

