# ------------------------------------------------------------------------
# Define connection Setup for OWB 11g
# Note:  Import MDL files into OWB 11g
# You must logon as repository owner and specify the workspace
# ------------------------------------------------------------------------
set repOwnerUserName owbrep
set repOwnerPassword owbrep
set host repos.us.oracle.com
set port 1521
set service ora1020.us.oracle.com
set workspace workspaceName


# ------------------------------------------------------------------------
# Define directory to read the MDL data files.
# The MDL data files were created by ExportEntireRepos.tcl
# IMPORTANT:  This exportdir should be the same as the exportdir defined in ExportEntireRepos.tcl
# ------------------------------------------------------------------------
set exportdir /data/upgrade


# ------------------------------------------------------------------------
# Define directory to read the generated Import tcl script 
# and create the import log files
# IMPORTANT:  This importdir should be the same as the importdir defined in ExportEntireRepos.tcl
# ------------------------------------------------------------------------
set importdir /data/upgrade


# ------------------------------------------------------------------------
# Do NOT make any changes below this line
# ------------------------------------------------------------------------

proc connectToOWB {} {
  global repOwnerUserName
  global repOwnerPassword
  global host
  global port
  global service
  global workspace

  log "\nConnecting to OWB... in single user mode \n"
  OMBCONNECT $repOwnerUserName/$repOwnerPassword@$host:$port:$service USE WORKSPACE '$repOwnerUserName.$workspace' USE SINGLE_USER_MODE
}


proc disconnectFromOWB {} {
  OMBDISCONNECT
  log "Disconnecting from OWB..."
} 


proc processOMBImportCommand {} {
   global importFile
   global importdir
   global exportdir

   while {[gets $importFile ombImportCmd] >= 0} {

	set ombImportCmd [ subst $ombImportCmd]

      log "     $ombImportCmd\n"

      set mdlfilename [lindex $ombImportCmd 2] 
      set mdlfilename [string trim $mdlfilename ']
      
      set logfilename [lindex $ombImportCmd end]
      set logfilename [string trim $logfilename ']
      

      if {[catch {
         eval $ombImportCmd
      } result]} {
                log "    $result"                
                log "    Error occurred importing file: $mdlfilename"
                if {[file exists $logfilename]} {
                   log "       Check log file for details: $logfilename \n"
                } else {
                   log "\n"
                }
      } else {             
                # Normal completion
                log "    Imported mdl file:  $mdlfilename"
                log "       Created log file $logfilename \n"
      }
   }

}


proc getCurrentTime {} {
  return [clock format [clock seconds] -format {%a %b %d %H:%M:%S %Z %Y}]
}


proc getMDLFileName {filename type} {
  set mdlfilename $filename\_10_0.mdl
  return $mdlfilename
}


proc getMDLLogName {filename type} {
  set logfilename $filename\_10_0_$type.log
  return $logfilename
}


proc openMDLImportFile {} {
  global importdir
  set ImportScriptName $importdir/OWB_10_Repos_MDLImportFiles.tcl 

#  log "Opening MDL Import Script File:  $ImportScriptName"

  if { [catch {set fileHandle [open $ImportScriptName r]} FileError] } {
     log "Could not open $ImportScriptName for reading\n$FileError"
     exit(1)
  }

  return $fileHandle
}


proc closeMDLImportFile {} {
  global importFile
  close $importFile
}


proc createLogFile {} {
  global importdir
  set LogFileName $importdir/ImportEntireRepos.log

#  puts "Creating Log File:  $LogFileName"

  if { [catch {set fileHandle [open $LogFileName w]} FileError] } {
     puts "Could not open $LogFileName for writing\n$FileError"
     exit(1)
  }

  return $fileHandle
}


proc log {info} {
  global logFile
  
  puts "$info"
  puts $logFile "$info"

  flush $logFile
}


proc closeLogFile {} {
  global logFile
  close $logFile
}


proc ldelete {list value} {
  set ndx [lsearch -exact $list $value]
  if {$ndx >=0} {
     return [lreplace $list $ndx $ndx]
  } else {
     return $list
  }
}


# ------------------------------------------------------------------------
# Main processing begins here
# ------------------------------------------------------------------------


set importFile [openMDLImportFile]
set logFile [createLogFile]

connectToOWB

log "Import started at [getCurrentTime] \n"

processOMBImportCommand

log "Import ended at [getCurrentTime] \n"

closeMDLImportFile

disconnectFromOWB

closeLogFile

