#!/bin/sh

PLATF=`/bin/uname -s`
case $PLATF in
  HP-UX) JAVA64FLAG="-d64";;
  SunOS) JAVA64FLAG="-d64";;
  *) JAVA64FLAG="";;
esac

if [ "$1" = "help" ] || [ "$1" = "-help" ]
then
  echo Usage: NAStop.sh [repos connect string] [-h host] [-p port] [-i]
  echo Host and port specify the location of the name/address server.
  echo If host and port are ommitted, localhost is assumed and the port is
  echo read from NameAddr.properties.
  echo The repository connection string is of the form user/pwd@host:port:service, where
  echo host, port and service name specify the OWB repository database, and
  echo user specifies the OWB repository owner.
  echo -i specifies an immediate shutdown, without waiting for clients to disconnect
else
  cd ../admin
  JAVAPATH=../../../jdk/jre
  JARS=../../lib/int/nasvr.jar:../../lib/int/namsg.jar:../../lib/int/naclient.jar:../../lib/int/rts.jar:../../lib/int/rts2.jar
  $JAVAPATH/bin/java $JAVA64FLAG -cp $JARS oracle.wh.nas.svr.NASvrStop $@
  cd ../unix
fi
