#! /bin/sh
eval `cat setowbenv.sh`

CLASSPATH_LAUNCHER="-classpath ../admin:../admin/launcher.jar:$OWB_HOME/cobertura/cobertura.jar:$CLASSPATH -DOWB_HOME=$OWB_HOME -DJDK_HOME=$JDK_HOME -DORA_HOME=$ORA_HOME -DOEM_HOME=$OEM_HOME -DIAS_HOME=$IAS_HOME -Doracle.net.tns_admin=$ORA_HOME/network/admin Launcher ../admin/owb.classpath"

cd ../admin

PLATF=`/bin/uname -s`
if [ "$PLATF" != "OSF1" ] ; then
  MAXPERMSIZE="-XX:MaxPermSize=256M"
fi
DEBUG_OPTS=""
if [ "$1" = "-debug" ] ; then
  DEBUG_OPTS="-client -Xdebug -Xrunjdwp:transport=dt_socket,server=y,address=4000"
  shift
fi

LOGGER_OPTS=""
if [ "$1" = "-jdbcTrace" ] ; then
  LOGGER_OPTS="-Doracle.jdbc.Trace=true -Djava.util.logging.config.file=OracleLog.properties"
  shift
fi

#JAVA_OPTS="-Xms128M -Xmx2048M"
JAVA_OPTS="-Xms128M -Xmx768M"

DEFINES="-DORACLE_HOME=$ORACLE_HOME -DOWBCC_HOME=$OWBCC_HOME -DTCLLIBPATH=\"$TCLLIBPATH\""
DEFINES="$DEFINES -DMARATHON_RETRY_COUNT=$MARATHON_RETRY_COUNT -DMARATHON_RETRY_INTERVAL=$MARATHON_RETRY_INTERVAL"
DEFINES="$DEFINES -Dide.conf=\"$OWBCC_HOME/owb/bin/owb.conf\" -Dide.startingcwd=\"$OWBCC_HOME/owb/bin\""
DEFINES="$DEFINES -Dide.user.dir=\"$HOME/owbhome-fcp\""
DEFINES="$DEFINES -Dnet.sourceforge.cobertura.datafile=./cobertura.ser"
while [ "-D" = "`expr substr ${1:-"  "} 1 2`" ] ; do
  DEFINES="$DEFINES $1"
  shift
done

OMBSHELL=oracle.owb.scripting.OMBShell

$JAVAPATH/bin/java $JAVA64FLAG $DEBUG_OPTS $JAVA_OPTS $MAXPERMSIZE $LOGGER_OPTS $DEFINES $CLASSPATH_LAUNCHER $OMBSHELL $*

#$OWB_HOME/cobertura/cobertura_report.sh

cd ../unix
