#! /bin/sh
eval `cat setowbenv.sh`
cd ../admin

PLATF=`/bin/uname -s`
if [ "$PLATF" != "OSF1" ] ; then
  MAXPERMSIZE="-XX:MaxPermSize=256M"
fi

DEBUG_OPTS=""
if [ "$1" = "-debug" ] ; then
  DEBUG_OPTS="-client -Xdebug -Xrunjdwp:transport=dt_socket,server=y,address=4000"
  shift
fi

LOGGER_OPTS=""
if [ "$1" = "-jdbcTrace" ] ; then
  LOGGER_OPTS="-Doracle.jdbc.Trace=true -Djava.util.logging.config.file=OracleLog.properties"
  shift
fi

$JAVAPATH/bin/java $JAVA64FLAG $DEBUG_OPTS -Xms64M -Xmx768M $MAXPERMSIZE -XX:+DisableExplicitGC $LOGGER_OPTS -Dlimit=768M -DORACLE_HOME=$ORACLE_HOME -DOWBCC_HOME=$OWBCC_HOME -DTCLLIBPATH="$TCLLIBPATH" -DMARATHON_RETRY_COUNT="$MARATHON_RETRY_COUNT" -DMARATHON_RETRY_INTERVAL="$MARATHON_RETRY_INTERVAL" -Dide.conf="$OWBCC_HOME/owb/bin/owb.conf" -Dide.startingcwd="$OWBCC_HOME/owb/bin" -Dide.user.dir=$HOME/owbhome-fcp $CLASSPATH_LAUNCHER_ANT oracle.owb.scripting.OMBShell $*
cd ../unix
