#! /bin/sh
umask 0027
# Usage: OMBPlus.sh [-debug] [-jdbcTrace] [-Da=b [-Dc=d ...]] [OMBShell args]


eval `cat setowbenv.sh`
cd ../admin

PLATF=`/bin/uname -s`
if [ "$PLATF" != "OSF1" ] ; then
  MAXPERMSIZE="-XX:MaxPermSize=256M"
fi

DEBUG_OPTS=""
if [ "$1" = "-debug" ] ; then
  DEBUG_OPTS="-client -Xdebug -Xrunjdwp:transport=dt_socket,server=y,address=4000"
  shift
fi

LOGGER_OPTS=""
if [ "$1" = "-jdbcTrace" ] ; then
  LOGGER_OPTS="-Doracle.jdbc.Trace=true -Djava.util.logging.config.file=OracleLog.properties"
  shift
fi

#JAVA_OPTS="-Xms128M -Xmx2048M"
JAVA_OPTS="-Xms128M -Xmx1024M"

DEFINES="-DORACLE_HOME=$ORACLE_HOME -DOWBCC_HOME=$OWBCC_HOME -DTCLLIBPATH=\"$TCLLIBPATH\""
DEFINES="$DEFINES -DMARATHON_RETRY_COUNT=$MARATHON_RETRY_COUNT -DMARATHON_RETRY_INTERVAL=$MARATHON_RETRY_INTERVAL"
DEFINES="$DEFINES -Dide.conf=\"$OWBCC_HOME/owb/bin/owb.conf\" -Dide.startingcwd=\"$OWBCC_HOME/owb/bin\""
DEFINES="$DEFINES -Dide.user.dir=\"$HOME/owbhome-fcp\""
while [ "-D" = "`expr substr ${1:-"  "} 1 2`" ] ; do
  DEFINES="$DEFINES $1"
  shift
done

OMBSHELL=oracle.owb.scripting.omu.OMBShellw

$JAVAPATH/bin/java $JAVA64FLAG $DEBUG_OPTS $JAVA_OPTS $MAXPERMSIZE $LOGGER_OPTS $DEFINES $CLASSPATH_LAUNCHER $OMBSHELL $*

cd ../unix
