#!/bin/sh

# Note: $1 must be the URL to be displayed

# Note: the following list is the order of 'searching' for a browser to use
#       the $PATH environment variable will be searched to find a executable matching the name specified here
#       first one found 'wins'
BrowserList="netscape mozilla kbrowser opera"

# Fix up the $PATH variable so that it is 'processable' using the 'for' statement
#   Substitute a leading : with .:
#   Substitute any :: with :.:
#   Substitute a trailing : with :.
#   Substitute any : with space

Dirs=`echo $PATH | sed -e 's/^:/\.:/; s/::/:\.:/g; s/:$/:\./; s/:/ /g'`

# Attempt to find for each browser 
for browser in $BrowserList ; do
  for dir in $Dirs; do
    if [ -x $dir/$browser ] ; then
      val=`$dir/$browser $1 > /dev/null 2> /dev/null &`

      if [ $? -eq 0 ] ; then
        exit 0
      fi
    fi
  done
done
