#! /bin/sh
DIR=`expr $0 : '\(.*\)/'`
pushd $DIR
eval `cat $DIR/setowbenv.sh`

RTHOME=$OWB_HOME
PATH=${RTHOME}/bin:${PATH}
export PATH

PLATFORM=`/bin/uname`
case $PLATFORM in 
HP-UX) SHLIB_PATH=${RTHOME}/lib32:${SHLIB_PATH}
       export SHLIB_PATH
       LD_LIBRARY_PATH=${RTHOME}/lib:${LD_LIBRARY_PATH}
       export LD_LIBRARY_PATH
       ;;
AIX) LIBPATH=${RTHOME}/lib32:${LIBPATH}
     export LIBPATH
     ;;
Linux) LD_LIBRARY_PATH=${RTHOME}/lib:${LD_LIBRARY_PATH}
       export LD_LIBRARY_PATH
       ;;
SunOS) MACH_HARDWARE=`/bin/uname -i`
       case ${MACH_HARDWARE} in
       i86pc)
	 LD_LIBRARY_PATH=${RTHOME}/lib:${LD_LIBRARY_PATH}
         export LD_LIBRARY_PATH
         ;;
       *)
	 LD_LIBRARY_PATH=${RTHOME}/lib32:${LD_LIBRARY_PATH}
         export LD_LIBRARY_PATH
         LD_LIBRARY_PATH_64=${RTHOME}/lib:${LD_LIBRARY_PATH_64}
	 export LD_LIBRARY_PATH_64
         ;;
      esac
      ;;
OSF1) LD_LIBRARY_PATH=${RTHOME}/lib:${LD_LIBRARY_PATH}
      export LD_LIBRARY_PATH
      ;;
*)    if [ -d ${RTHOME}/lib32 ];
      then
        LD_LIBRARY_PATH=${RTHOME}/lib32:${LD_LIBRARY_PATH}
      else
        LD_LIBRARY_PATH=${RTHOME}/lib:${LD_LIBRARY_PATH}
      fi
      export LD_LIBRARY_PATH
      ;;
esac

ORACLE_HOME=${RTHOME}
export ORACLE_HOME

$JAVAPATH/bin/java $JAVA64FLAG $CLASSPATH_LAUNCHER oracle.wh.ui.runtime.admin.localService.LocalServiceApp -RUNTIMEHOME ${RTHOME}

popd
