#!/bin/sh

while test -n "$1"  
do
case $1 in
    -u) echo "USAGE: openRAB.sh [-b browser_path] [-h localhost_name] | [-u]";
        exit 1
        ;;
    -b) if test -x "$2"
        then
          browser=$2
        else
          echo "error:the browser path you specified does not exist or you do not have a enough permission to run that program"
          exit 2;
        fi
        shift; shift;;
    -h) if test -n "$2"
        then
         hostname=$2
        else
         echo "error:wrong argument . -u for hep"
         exit 3;
        fi
        shift; shift;;            
    -*) echo "error: wrong argument. -u for help";
        exit 4;;
     *) echo "error: wrong argument. -u for help";
        exit 5;;
esac
done

if test ! -x "$browser" 
then
 if test -x  "$OWB_DEFAULT_WEB_BROWSER"
 then
  browser=$OWB_DEFAULT_WEB_BROWSER
 else
  if test -x "/usr/local/bin/netscape"
  then
   browser=/usr/local/bin/netscape
  else
   echo 'please input the full path of your web browser:(for example: /usr/local/bin/netscape)'
   read browser
  fi
 fi
fi

if test ! -n "$hostname"
then
 domain=`domainname`
 localhost=`/bin/uname -n`
 if test -n "$domain"
 then
  dotcount=`echo $domain | sed 's/[^\.]//g' | wc -w`
  if test $dotcount -gt  "0"
  then 
    hostname=$localhost.$domain
  else
    hostname=$localhost
  fi
 else
  hostname=$localhost
 fi
fi

echo 'local browser path: '$browser
echo 'local host name: '$hostname
$browser 'https://'$hostname':8999/owbb/RABLogin.uix?mode=runtime&def_host=&def_port=1521&def_service=&def_net_service='







