
CREATE MATERIALIZED VIEW owb_compparam_mv
  BUILD IMMEDIATE
  AS
           SELECT  /*+ INDEX (depcomp  idx_elementid)
                       INDEX (depgroup idx_elementid)
                       INDEX (depparm  idx_elementid)
                       INDEX (parm     idx_elementid)
                       INDEX (grp      idx_elementid)
                       INDEX (comp     idx_elementid) */
           distinct
           OWM_VIEW_UTILITIES.owb_comp_id(comp.elementid) AS comp_id,
	   OWM_VIEW_UTILITIES.owb_param_id(parm.elementid) AS parm_id,
	   OWM_VIEW_UTILITIES.owb_param_id(depparm.elementid) AS depparm_id,
	   OWM_VIEW_UTILITIES.owb_comp_id(depcomp.elementid) AS depcomp_id
           FROM
           cmpmapoperator_v depcomp,
           cmpmapattributegroup_v depgroup,
           cmpmapattribute_v depparm,
           cmpmapattribute_v parm,
           cmpmapattributegroup_v grp,
           cmpmapoperator_v comp
           WHERE
           comp.elementid=grp.attributegroupowner AND
           grp.elementid=parm.attributegroup AND
           depparm.elementid=parm.connectfrom AND
           depgroup.elementid=depparm.attributegroup AND
           depcomp.elementid=depgroup.attributegroupowner;

CREATE INDEX mv_ix_compid ON owb_compparam_mv(comp_id);

CREATE INDEX mv_ix_depcompid ON owb_compparam_mv(depcomp_id);

CREATE INDEX mv_ix_parmid ON owb_compparam_mv(parm_id);

CREATE INDEX mv_ix_depparmid ON owb_compparam_mv(depparm_id);

CREATE TABLE lia_xml_table (objectid NUMBER(9) NOT NULL, liatype VARCHAR2(10) NOT NULL, xml CLOB);
