<?xml version='1.0'?> 

<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">

<xsl:output method="html" indent="no" encoding="UTF8"/>

<xsl:variable name="desc" select="TREE/@Description"/>

<xsl:variable name="prefixURL" select="substring-before($desc, '|')"/>

<xsl:variable name="reposID" select="substring-after(substring-before($desc, '||'), '|')"/>

<xsl:variable name="imageSize" select="substring-after($desc, '||')"/>
              
<xsl:template match="TREE">
	  <xsl:element name="table">
	    <xsl:attribute name="border">0</xsl:attribute>
		<xsl:attribute name="cellspacing">0</xsl:attribute>
		<xsl:attribute name="cellpadding">0</xsl:attribute>
		<xsl:choose>
			<xsl:when test="count(DEPENDENCY/OBJECT)=1">
				<xsl:call-template name="addFirstObject">
				   <xsl:with-param name="object" select="DEPENDENCY/OBJECT"/>
				   <xsl:with-param name="N" select="1"/>
                </xsl:call-template>
			</xsl:when>
			<xsl:otherwise>
				<xsl:text disable-output-escaping="yes">&lt;tr&gt;</xsl:text>
					<xsl:element name="td">
						<xsl:element name="font">
							<xsl:attribute name="class">PortletText2</xsl:attribute>
							<xsl:text>This object doesn't have impact dependencies.</xsl:text>
						</xsl:element>
					</xsl:element>
			</xsl:otherwise>
		</xsl:choose>
		<xsl:text disable-output-escaping="yes">&lt;/tr&gt;</xsl:text>
      </xsl:element>
</xsl:template>

<xsl:template name="addFirstObject">
	<xsl:param name="object"/>
	<xsl:param name="N"/>
	<xsl:text disable-output-escaping="yes">&lt;tr&gt;</xsl:text>
	  <xsl:element name="td">
	    <xsl:element name="table">
		   <xsl:attribute name="border">0</xsl:attribute>
		   <xsl:attribute name="cellspacing">0</xsl:attribute>
		   <xsl:attribute name="cellpadding">0</xsl:attribute>
		   <xsl:element name="tr">
		     <xsl:element name="td"/>
		     <xsl:element name="td">
			    <xsl:attribute name="align">right</xsl:attribute>
				<xsl:attribute name="valign">bottom</xsl:attribute>
				<xsl:element name="a">
					<xsl:attribute name="href">
						<xsl:value-of select="concat($prefixURL, 'wmp_pages.show_navigation_page?p_repository_id=', $reposID, '&#38;p_role=wmp_user&#38;p_sheet=2&#38;p_type_name=', $object/PARENT/TYPE, '&#38;p_id=', $object/PARENT/ID)"/>
					</xsl:attribute>
					<xsl:element name="font">
						<xsl:attribute name="class">PortletText3</xsl:attribute>
					    <xsl:value-of select="$object/PARENT/NAME"/>
					</xsl:element>
				</xsl:element>
			 </xsl:element>
		   </xsl:element>
		   <xsl:element name="tr">
		     <xsl:element name="td"/>
		     <xsl:element name="td">
			    <xsl:attribute name="align">right</xsl:attribute>
				<xsl:attribute name="valign">bottom</xsl:attribute>
				<xsl:element name="a">
				 <xsl:attribute name="href">
					<xsl:value-of select="concat($prefixURL, 'wmp_pages.show_report_page?p_repository_id=', $reposID, '&#38;p_role=wmp_user&#38;p_sheet=4&#38;p_type_name=', $object/TYPE, '&#38;p_id=', $object/ID, '&#38;p_helper=wmp_rh_impact_analysis&#38;p_category=Impact_Diagram')"/>
				 </xsl:attribute>
				   <xsl:element name="img">
					<xsl:attribute name="src">
						<xsl:value-of select="concat($prefixURL, 'lia_client.show_binary_doc?p_doc_name=', $object/TYPE)"/>
					</xsl:attribute>
					<xsl:attribute name="alt">
						<xsl:value-of select="concat(substring-before($object/PARENT/DESCRIPTION, '.'), '.', $object/DESCRIPTION)"/>
					</xsl:attribute>
					<xsl:attribute name="width">
						<xsl:value-of select="$imageSize"/>
					</xsl:attribute>
					<xsl:attribute name="height">
						<xsl:value-of select="$imageSize"/>
					</xsl:attribute>
					<xsl:attribute name="border">0</xsl:attribute>
				  </xsl:element>
				</xsl:element>
			 </xsl:element>
		   </xsl:element>
		   <xsl:element name="tr">
			 <xsl:element name="td">
				<xsl:attribute name="align">center</xsl:attribute>
				<xsl:attribute name="valign">bottom</xsl:attribute>
				<xsl:element name="img">
					<xsl:attribute name="src">
						<xsl:value-of select="concat($prefixURL, 'wmp_api_doc.show_binary_doc?p_doc_name=connector0.gif')"/>
					</xsl:attribute>
					<xsl:attribute name="width">
						<xsl:value-of select="$imageSize"/>
					</xsl:attribute>
					<xsl:attribute name="height">
						<xsl:value-of select="$imageSize"/>
					</xsl:attribute>
					<xsl:attribute name="hspace">0</xsl:attribute>
					<xsl:attribute name="vspace">0</xsl:attribute>
				</xsl:element>
			 </xsl:element>
		     <xsl:element name="td">
			    <xsl:attribute name="align">right</xsl:attribute>
				<xsl:attribute name="valign">up</xsl:attribute>
				<xsl:element name="a">
					<xsl:attribute name="href">
						<xsl:value-of select="concat($prefixURL, 'wmp_pages.show_navigation_page?p_repository_id=', $reposID, '&#38;p_role=wmp_user&#38;p_sheet=2&#38;p_type_name=', $object/TYPE, '&#38;p_id=', $object/ID)"/>
					</xsl:attribute>
					<xsl:element name="font">
						<xsl:attribute name="class">PortletText3</xsl:attribute>
					    <xsl:value-of select="$object/NAME"/>
					</xsl:element>
				</xsl:element>
			 </xsl:element>
		   </xsl:element>
		</xsl:element>
	  </xsl:element>
	  <xsl:call-template name="addDependencies">
		<xsl:with-param name="object" select="$object"/>
		<xsl:with-param name="N" select="$N"/>
	  </xsl:call-template>
</xsl:template>

<xsl:template name="addSameRowObject">
	<xsl:param name="object"/>
	<xsl:param name="N"/>
	<xsl:param name="S"/>
	  <xsl:element name="td">
	  <xsl:attribute name="align">left</xsl:attribute>
	  <xsl:choose>
		<xsl:when test="position()=1">
			<xsl:attribute name="valign">bottom</xsl:attribute>
		</xsl:when>
		<xsl:otherwise>
			<xsl:choose>
				<xsl:when test="position()=last()">
					<xsl:attribute name="valign">top</xsl:attribute>
				</xsl:when>
				<xsl:otherwise>
					<xsl:attribute name="valign">middle</xsl:attribute>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:otherwise>
	   </xsl:choose>
	  
		<xsl:element name="table">
		<xsl:attribute name="border">0</xsl:attribute>
		<xsl:attribute name="cellspacing">0</xsl:attribute>
		<xsl:attribute name="cellpadding">0</xsl:attribute>
		   <xsl:element name="tr">
			 <xsl:element name="td">
			    <xsl:attribute name="align">center</xsl:attribute>
				<xsl:if test="$S=3 or $S=2">
				    <xsl:element name="img">
						<xsl:attribute name="src">
							<xsl:value-of select="concat($prefixURL, 'wmp_api_doc.show_binary_doc?p_doc_name=connector2.gif')"/>
						</xsl:attribute>
						<xsl:attribute name="width">
							<xsl:value-of select="$imageSize"/>
						</xsl:attribute>
						<xsl:attribute name="height">
							<xsl:value-of select="$imageSize"/>
						</xsl:attribute>
						<xsl:attribute name="hspace">0</xsl:attribute>
						<xsl:attribute name="vspace">0</xsl:attribute>
					</xsl:element>
				</xsl:if>
			 </xsl:element>
		     <xsl:element name="td">
			    <xsl:attribute name="align">right</xsl:attribute>
				<xsl:attribute name="valign">bottom</xsl:attribute>
				<xsl:element name="a">
					<xsl:attribute name="href">
						<xsl:value-of select="concat($prefixURL, 'wmp_pages.show_navigation_page?p_repository_id=', $reposID, '&#38;p_role=wmp_user&#38;p_sheet=2&#38;p_type_name=', $object/PARENT/TYPE, '&#38;p_id=', $object/PARENT/ID)"/>
					</xsl:attribute>
					<xsl:element name="font">
						<xsl:attribute name="class">PortletText3</xsl:attribute>
					    <xsl:value-of select="$object/PARENT/NAME"/>
					</xsl:element>
				</xsl:element>
			 </xsl:element>
		   </xsl:element>
		   <xsl:element name="tr">
		     <xsl:element name="td">
				<xsl:attribute name="align">center</xsl:attribute>
				<xsl:attribute name="valign">bottom</xsl:attribute>
				<xsl:element name="img">
				    <xsl:choose>
						<xsl:when test="$S=0">
							<xsl:attribute name="src">
								<xsl:value-of select="concat($prefixURL, 'wmp_api_doc.show_binary_doc?p_doc_name=connector3.gif')"/>
							</xsl:attribute>
						</xsl:when>
						<xsl:when test="$S=1">
							<xsl:attribute name="src">
								<xsl:value-of select="concat($prefixURL, 'wmp_api_doc.show_binary_doc?p_doc_name=connector4.gif')"/>
							</xsl:attribute>
						</xsl:when>
						<xsl:when test="$S=2">
							<xsl:attribute name="src">
								<xsl:value-of select="concat($prefixURL, 'wmp_api_doc.show_binary_doc?p_doc_name=connector8.gif')"/>
							</xsl:attribute>
						</xsl:when>
						<xsl:when test="$S=3">
							<xsl:attribute name="src">
								<xsl:value-of select="concat($prefixURL, 'wmp_api_doc.show_binary_doc?p_doc_name=connector5.gif')"/>
							</xsl:attribute>
						</xsl:when>	
				    </xsl:choose>
					<xsl:attribute name="width">
						<xsl:value-of select="$imageSize"/>
					</xsl:attribute>
					<xsl:attribute name="height">
						<xsl:value-of select="$imageSize"/>
					</xsl:attribute>
					<xsl:attribute name="hspace">0</xsl:attribute>
					<xsl:attribute name="vspace">0</xsl:attribute>
				</xsl:element>
			 </xsl:element>
		     <xsl:element name="td">
			    <xsl:attribute name="align">right</xsl:attribute>
				<xsl:attribute name="valign">bottom</xsl:attribute>
				<xsl:element name="a">
				 <xsl:attribute name="href">
					<xsl:value-of select="concat($prefixURL, 'wmp_pages.show_report_page?p_repository_id=', $reposID, '&#38;p_role=wmp_user&#38;p_sheet=4&#38;p_type_name=', $object/TYPE, '&#38;p_id=', $object/ID, '&#38;p_helper=wmp_rh_impact_analysis&#38;p_category=Impact_Diagram')"/>
				 </xsl:attribute>
				  <xsl:element name="img">
					<xsl:attribute name="src">
						<xsl:value-of select="concat($prefixURL, 'lia_client.show_binary_doc?p_doc_name=', $object/TYPE)"/>
					</xsl:attribute>
					<xsl:attribute name="alt">
						<xsl:value-of select="concat(substring-before($object/PARENT/DESCRIPTION, '.'), '.', $object/DESCRIPTION)"/>
					</xsl:attribute>
					<xsl:attribute name="width">
						<xsl:value-of select="$imageSize"/>
					</xsl:attribute>
					<xsl:attribute name="height">
						<xsl:value-of select="$imageSize"/>
					</xsl:attribute>
					<xsl:attribute name="border">0</xsl:attribute>
					<xsl:attribute name="hspace">0</xsl:attribute>
					<xsl:attribute name="vspace">0</xsl:attribute>
				  </xsl:element>
				</xsl:element>
			 </xsl:element>
		   </xsl:element>
		   <xsl:element name="tr">
		     <xsl:element name="td">
				<xsl:attribute name="align">center</xsl:attribute>
				<xsl:attribute name="valign">bottom</xsl:attribute>
				<xsl:choose>
				  <xsl:when test="$S=1 or $S=2">
				    <xsl:element name="img">
						<xsl:attribute name="src">
							<xsl:value-of select="concat($prefixURL, 'wmp_api_doc.show_binary_doc?p_doc_name=connector2.gif')"/>
						</xsl:attribute>
						<xsl:attribute name="width">
							<xsl:value-of select="$imageSize"/>
						</xsl:attribute>
					    <xsl:attribute name="height">
							<xsl:value-of select="$imageSize"/>
						</xsl:attribute>
						<xsl:attribute name="hspace">0</xsl:attribute>
						<xsl:attribute name="vspace">0</xsl:attribute>
					</xsl:element>
				  </xsl:when>
				  <xsl:otherwise>
					<xsl:element name="img">
						<xsl:attribute name="src">
							<xsl:value-of select="concat($prefixURL, 'wmp_api_doc.show_binary_doc?p_doc_name=connector0.gif')"/>
						</xsl:attribute>
						<xsl:attribute name="width">
							<xsl:value-of select="$imageSize"/>
						</xsl:attribute>
						<xsl:attribute name="height">
							<xsl:value-of select="$imageSize"/>
						</xsl:attribute>
						<xsl:attribute name="hspace">0</xsl:attribute>
						<xsl:attribute name="vspace">0</xsl:attribute>
					</xsl:element>
				  </xsl:otherwise>
				</xsl:choose>
			 </xsl:element>
		     <xsl:element name="td">
			    <xsl:attribute name="align">right</xsl:attribute>
				<xsl:attribute name="valign">up</xsl:attribute>
				<xsl:element name="a">
					<xsl:attribute name="href">
						<xsl:value-of select="concat($prefixURL, 'wmp_pages.show_navigation_page?p_repository_id=', $reposID, '&#38;p_role=wmp_user&#38;p_sheet=2&#38;p_type_name=', $object/TYPE, '&#38;p_id=', $object/ID)"/>
					</xsl:attribute>
				    <xsl:element name="font">
						<xsl:attribute name="class">PortletText3</xsl:attribute>
						<xsl:choose>
							<xsl:when test="count($object/DEPENDENCY)=1">
								<xsl:choose>
									<xsl:when test="$object/DEPENDENCY/@Complete='YES'">
										<xsl:value-of select="$object/NAME"/>
									</xsl:when>
									<xsl:otherwise>
										<xsl:value-of select="concat($object/NAME, '*')"/>
									</xsl:otherwise>
								</xsl:choose>
							</xsl:when>
							<xsl:otherwise>
								<xsl:value-of select="$object/NAME"/>
							</xsl:otherwise>
						</xsl:choose>			
					</xsl:element>
				</xsl:element>
			 </xsl:element>
		   </xsl:element>
		</xsl:element>
	  </xsl:element>
	  <xsl:call-template name="addDependencies">
		<xsl:with-param name="object" select="$object"/>
		<xsl:with-param name="N" select="$N"/>
	  </xsl:call-template>
</xsl:template>

<xsl:template name="addFollowingEmptyCell">
    <xsl:param name="m_object"/>
	<xsl:param name="N"/>
	<xsl:param name="M"/>

	<xsl:if test="$N>0">
		<xsl:element name="td">
			<xsl:variable name="last" select="count($m_object[$M]/DEPENDENCY/OBJECT)"/>
			<xsl:for-each select="$m_object[$M]/DEPENDENCY/OBJECT">
				<xsl:if test="ID=$m_object[$M +1]/ID">
					<xsl:variable name="current" select="position()"/>
					<xsl:if test="$last!=$current">
					   <xsl:element name="table">
					   <xsl:attribute name="border">0</xsl:attribute>
					   <xsl:attribute name="cellspacing">0</xsl:attribute>
					   <xsl:attribute name="cellpadding">0</xsl:attribute>
					     <xsl:element name="tr">
						   <xsl:element name="td">
							<xsl:element name="img">
								<xsl:attribute name="src">
									<xsl:value-of select="concat($prefixURL, 'wmp_api_doc.show_binary_doc?p_doc_name=connector2.gif')"/>
								</xsl:attribute>
								<xsl:attribute name="width">
									<xsl:value-of select="$imageSize"/>
								</xsl:attribute>
								<xsl:attribute name="height">
									<xsl:value-of select="$imageSize"/>
								</xsl:attribute>
								<xsl:attribute name="hspace">0</xsl:attribute>
								<xsl:attribute name="vspace">0</xsl:attribute>
							</xsl:element>
						   </xsl:element>
						  </xsl:element>
						  <xsl:element name="tr">
						   <xsl:element name="td">
							<xsl:element name="img">
								<xsl:attribute name="src">
									<xsl:value-of select="concat($prefixURL, 'wmp_api_doc.show_binary_doc?p_doc_name=connector2.gif')"/>
								</xsl:attribute>
								<xsl:attribute name="width">
									<xsl:value-of select="$imageSize"/>
								</xsl:attribute>
								<xsl:attribute name="height">
									<xsl:value-of select="$imageSize"/>
								</xsl:attribute>
								<xsl:attribute name="hspace">0</xsl:attribute>
								<xsl:attribute name="vspace">0</xsl:attribute>
							</xsl:element>
						   </xsl:element>
						  </xsl:element>
						  <xsl:element name="tr">
						   <xsl:element name="td">
							<xsl:element name="img">
								<xsl:attribute name="src">
									<xsl:value-of select="concat($prefixURL, 'wmp_api_doc.show_binary_doc?p_doc_name=connector2.gif')"/>
								</xsl:attribute>
								<xsl:attribute name="width">
									<xsl:value-of select="$imageSize"/>
								</xsl:attribute>
								<xsl:attribute name="height">
									<xsl:value-of select="$imageSize"/>
								</xsl:attribute>
								<xsl:attribute name="hspace">0</xsl:attribute>
								<xsl:attribute name="vspace">0</xsl:attribute>
							</xsl:element>
						   </xsl:element>
						  </xsl:element>
					   </xsl:element>	
					</xsl:if>
				</xsl:if>
			</xsl:for-each>
		</xsl:element>
		<xsl:call-template name="addFollowingEmptyCell">
		    <xsl:with-param name="m_object" select="$m_object"/>
			<xsl:with-param name="N" select="$N -1"/>
			<xsl:with-param name="M" select="$M +1"/>
		</xsl:call-template>
	</xsl:if>
</xsl:template>

<xsl:template name="addFirstEmptyCell">
    <xsl:param name="m_object"/>
	<xsl:param name="N"/>

	<xsl:element name="td"/>
	<xsl:call-template name="addFollowingEmptyCell">
		<xsl:with-param name="m_object" select="$m_object"/>
		<xsl:with-param name="N" select="$N -1"/>
		<xsl:with-param name="M" select="1"/>
	</xsl:call-template>
</xsl:template>

<xsl:template name="addDependencies">
	<xsl:param name="object"/>
	<xsl:param name="N"/>   
	<xsl:choose>
	  <xsl:when test="count($object/DEPENDENCY/OBJECT)=0">
         <xsl:element name="td"> 
			<xsl:attribute name="align">center</xsl:attribute>
			<xsl:attribute name="valign">bottom</xsl:attribute>
			<xsl:element name="img">
					<xsl:attribute name="src">
						<xsl:value-of select="concat($prefixURL, 'wmp_api_doc.show_binary_doc?p_doc_name=connector0.gif')"/>
					</xsl:attribute>
					<xsl:attribute name="width">
						<xsl:value-of select="$imageSize"/>
					</xsl:attribute>
					<xsl:attribute name="height">
						<xsl:value-of select="$imageSize"/>
					</xsl:attribute>
					<xsl:attribute name="hspace">0</xsl:attribute>
					<xsl:attribute name="vspace">0</xsl:attribute>
			</xsl:element>
		 </xsl:element>
		 <xsl:text disable-output-escaping="yes">&lt;/tr&gt;</xsl:text>
         <xsl:text disable-output-escaping="yes">&lt;tr&gt;</xsl:text>
	  </xsl:when>
	  <xsl:otherwise>
		<xsl:for-each select="$object/DEPENDENCY/OBJECT">
			
			<xsl:if test="position() != 1">
			<xsl:call-template name="addFirstEmptyCell">
			    <xsl:with-param name="m_object" select="ancestor::*[name()='OBJECT']"/>
				<xsl:with-param name="N" select="$N"/>
			</xsl:call-template>
			</xsl:if>
			
			<xsl:variable name="status">
				<xsl:choose>
					<xsl:when test="count(../../DEPENDENCY/OBJECT)=1">0</xsl:when>
					<xsl:otherwise>
					   <xsl:choose>
						 <xsl:when test="position()=1">1</xsl:when>
						 <xsl:when test="position()=last()">3</xsl:when>
						 <xsl:otherwise>2</xsl:otherwise>
					   </xsl:choose>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:variable>

		    <xsl:call-template name="addSameRowObject">
			  <xsl:with-param name="object" select="."/>
			  <xsl:with-param name="N" select="$N+1"/>
			  <xsl:with-param name="S" select="$status"/>
		    </xsl:call-template>
	    </xsl:for-each>
	  </xsl:otherwise>
	</xsl:choose>
</xsl:template>


</xsl:stylesheet>

