rem
rem This script can be used to abort an execution that is currently busy.
rem
rem USAGE
rem Logon as WorkspaceOwner or WorkspaceUser with Admin privilege
rem    
rem    @<OWB-HOME>/owb/rtp/sql/abort_exec_request.sql <auditid> <workspace>
rem
rem For a given audit-id which represents a execution job, this script will
rem abort the job in a managed way. The audit-id may have been obtained by
rem using the list_requests.sql script
rem
rem The given workspace is the one in which the job is running
rem <workspace> should be declared as workspaceOwner.workspaceName
rem if only workspaceName is given, workspaceOwner will be defaulted to user
rem

set serveroutput on;
set verify off;

set role OWB_USER;
call owbsys.wb_rt_script_util.set_workspace('&2.');

declare

  l_audit_id number;

begin

  l_audit_id := &1.;
  owbsys.wb_rt_script_util.abort_exec_request(l_audit_id);

end;
/
