rem
rem This script can be used to display the value of a platform property. These
rem properties control how the Control Center Service behaves.
rem
rem USAGE
rem Logon as the OWB Repository Owner (OWBSYS)
rem    
rem    @<OWB-HOME>/owb/rtp/sql/display_platform_property.sql <prop-name>
rem
rem This script displays the value of the property with the given name.
rem
rem Note that the script assumes that at most one property with the given name
rem must exist.
rem
rem See also the script called set_platform_property.sql
rem

set serveroutput on;

set echo off
set verify off
set role OWB_USER;

define PROPERTY_PATH = &1.

declare
  l_clob clob;
  l_length number;
  l_buffer varchar2(250);
  l_amount number;
  l_start number;
begin

  l_clob := owbsys.wb_rt_script_util.get_platform_property('&PROPERTY_PATH.');
    
  dbms_lob.open(l_clob, dbms_lob.lob_readonly);
  l_length := dbms_lob.getlength(l_clob);
  l_start := 1;
  
  dbms_output.enable(100000);
  
  dbms_output.new_line;

  while l_start <= l_length
  loop
    l_amount := 250;
    dbms_lob.read(l_clob, l_amount, l_start, l_buffer);
    dbms_output.put_line(l_buffer);
    l_start := l_start + 250;
  end loop;

  dbms_output.new_line;

  dbms_lob.close(l_clob);

end;
/


