rem
rem This script can be used to expedite an execution job.
rem
rem USAGE
rem Logon as WorkspaceOwner or WorkspaceUser with Execute/Deploy/Admin privilege
rem    
rem    @<OWB-HOME>/owb/rtp/sql/expedite_exec_request.sql <auditid> <return-number> <return-code> <workspace>
rem
rem For a given audit-id which represents a execution job, this script will
rem expedite the job in a managed way. The audit-id may have been obtained by
rem using the list_requests.sql script
rem
rem The return-number and return-code are the result values assigned to the job
rem
rem     return_number should have values:-
rem         1   meaning     OK
rem         2   meaning     OK_WITH_WARNINGS
rem         3   meaning     FAILURE
rem
rem     return_code is what the Operating System return code might be
rem        e.g  >0   normally means Failure
rem             =0   normally means Success 
rem
rem The given workspace is the one in which the job is running
rem <workspace> should be declared as workspaceOwner.workspaceName
rem if only workspaceName is given, workspaceOwner will be defaulted to user
rem

set verify off;

set role OWB_USER;
call owbsys.wb_rt_script_util.set_workspace('&4.');

declare
  l_audit_id number;
  l_return_number number;
  l_return_code number;

begin
  l_audit_id := &1.;
  l_return_number := &2.;
  l_return_code := &3.;
  
  owbsys.wb_rt_script_util.expedite_exec_request(l_audit_id, l_return_number, l_return_code);

end;
/
