REM 
REM This script reports on the configuration data for a Control Center and
REM its Registered Locations
REM
REM Logon as the OWB Repository Owner (OWBSYS)
REM
REM This script displays the details of the Control Center and its
REM Registered Locations. It can be used to provide upfront information before
REM using the location_util.bat script to alter some of the stored credentials.
REM
REM The following section describes how the separate sections can be used.
REM
REM Notes
REM ---------------------------------------------------------------
REM (1) This represents the host-name of the machine hosting the 
REM     database.
REM     It is displayed for information only. In normal circumstances
REM     any host referenced in connection credentials will normally
REM     refer to this value.
REM
REM (2) This data represents the credentials for the current Runtime
REM     Repository
REM        Version -- this represents the version number of this Runtime
REM        Connection -- this represents connection details either as
REM                      host:port:servicename or NetServiceName
REM                      Note that the host name should be the same as
REM                      (1) or be localhost. This can be changed using the
REM                      location_util.bat script
REM        ServerSideHome - this represents the OWB Home of the ServerSide
REM        InstallHome - this represents the installation home for this
REM                      version of the Control Center.
REM                      Note that InstallHome and ServerSideHome are usually
REM                      the same but can be different. If they are different
REM                      then the ServerSideHome will be made equal to
REM                      InstallHome the next time the Server is started.
REM
REM       Control Center Rules
REM       ------------------------
REM          These homes MUST be on a disk that is available to the hosting
REM          database at startup time. This can be verified using location_util.bat
REM          These homes can be changed using the location_util.bat script.
REM
REM
REM (3) This data represents the details of each registered location
REM        LocName -- this represents the name of the location
REM        LocationVersion -- this represents its type and its version
REM        Connection -- this represents its connection details either as
REM                      host:port:servicename or NetServiceName
REM        DeployType -- this is either Source, Target or Unknown.
REM                      Source is for a location that is not used for Deployment
REM                      Target is for a location that has been already Deployed to
REM                      Unknown is for a location that might be used as for Deployment
REM                                 but has currently got no objects in it.
REM        Workspace  -- this is the workspace in which the location is registered
REM      Location Rules
REM      --------------
REM       (3.1) A TARGET Oracle Database location MUST be within the same database
REM                      instance as its owning Control Center (so its credentials
REM                      should be the same as its owning Control Center)
REM       (3.2) An UNKNOWN Oracle Database location might be a Source or a Target.
REM                   If it is a Source then it could be within a Remote Database.
REM                   If it is a Target then it MUST conform to rule (3.1)
REM          The location_util.bat script can be used to change the connection
REM              credentials of an Oracle Database location
REM
REM v1.0.0
REM ----------------------------------------------------------------------------------

set serveroutput on
set echo off
set verify off

set role OWB_USER;

column Version format a12
column Host format a22
column Port format a5
column Service format a22
column NetServiceName format a22
column Notes format a20
column Connection format a48
column ServerSideHome format a48
column InstallHome format a48
column LocName format a22
column LocationVersion format a22
column DeployType format a10
column Workspace format a22

declare
  l_host  varchar2(128);
  l_nodes owbsys.wb_rt_script_util.RTREPOS_NODES_TAB;
  l_locs  owbsys.wb_rt_script_util.RTREPOS_LOCATIONS_TAB;

  l_version_col          char(12) := 'Version.....';
  l_connection_col       char(48) := 'Connection......................................';
  l_server_side_home_col char(48) := 'ServerSideHome..................................';
  l_install_home_col     char(48) := 'InstallHome.....................................';
  l_notes2_col           char(20) := 'Notes...............';
  l_version          char(12);
  l_connection       char(48);
  l_server_side_home char(48);
  l_install_home     char(48);
  l_notes2           char(20);

  l_loc_name_col    char(22) := 'LocName...............';
  l_loc_version_col char(22) := 'LocationVersion.......';
  l_loc_connect_col char(48) := 'Connection......................................';
  l_deploy_type_col char(10) := 'DeployType';
  l_workspace_col   char(22) := 'Workspace.............';
  l_notes3_col      char(20) := 'Notes...............';
  l_loc_name    char(22);
  l_loc_version char(22);
  l_loc_connect char(48);
  l_deploy_type char(10);
  l_workspace   char(22);
  l_notes3      char(20);

begin
  begin
    select host_name into l_host from v$instance;

    DBMS_OUTPUT.PUT_LINE('====================');
    DBMS_OUTPUT.PUT_LINE('HOST MACHINE');
    DBMS_OUTPUT.PUT_LINE('====================');
    DBMS_OUTPUT.PUT_LINE('Host name is ' || l_host || '      Notes (1)');
  end;

  l_nodes := owbsys.wb_rt_script_util.get_rtrepos_nodes();

  DBMS_OUTPUT.PUT_LINE('====================');
  DBMS_OUTPUT.PUT_LINE('SERVICE DETAILS');
  DBMS_OUTPUT.PUT_LINE('====================');
  if l_nodes is not null and l_nodes.COUNT > 0
  then
    DBMS_OUTPUT.PUT_LINE(l_version_col || ' ' || l_connection_col || ' ' ||
                         l_server_side_home_col || ' ' || l_install_home_col || ' ' ||
                         l_notes2_col);

    for i in l_nodes.FIRST .. l_nodes.LAST
    loop
      l_version          := substr(l_nodes(i).rt_version,1,12);
      l_connection       := substr(l_nodes(i).rt_connection,1,48);
      l_server_side_home := substr(l_nodes(i).server_side_home,1,48);
      l_install_home     := substr(l_nodes(i).install_home,1,48);
      l_notes2           := '(2)';

      DBMS_OUTPUT.PUT_LINE(l_version || ' ' || l_connection || ' ' ||
                           l_server_side_home || ' ' || l_install_home || ' ' ||
                           l_notes2);
    end loop;
  end if;

  l_locs := owbsys.wb_rt_script_util.get_rtrepos_locations();

  DBMS_OUTPUT.PUT_LINE('====================');
  DBMS_OUTPUT.PUT_LINE('REGISTERED LOCATIONS');
  DBMS_OUTPUT.PUT_LINE('====================');
  if l_locs is not null and l_locs.COUNT > 0
  then
    DBMS_OUTPUT.PUT_LINE(l_loc_name_col || ' ' || l_loc_version_col || ' ' ||
                         l_loc_connect_col || ' ' || l_deploy_type_col || ' ' ||
                         l_workspace_col || ' ' || l_notes3_col);

    for j in l_locs.FIRST .. l_locs.LAST
    loop
      l_loc_name    := substr(l_locs(j).loc_name,1,12);
      l_loc_version := substr(l_locs(j).loc_type_version,1,12);
      l_loc_connect := substr(l_locs(j).loc_connection,1,48);
      l_deploy_type := substr(l_locs(j).deploy_type,1,48);
      l_workspace   := substr(l_locs(j).workspace,1,48);
      l_notes3      := '(3)';

      DBMS_OUTPUT.PUT_LINE(l_loc_name || ' ' || l_loc_version || ' ' ||
                           l_loc_connect || ' ' || l_deploy_type || ' ' ||
                           l_workspace || ' ' || l_notes3);
    end loop;
  end if;

  commit;
end;
/

