rem
rem This script can be used to set the properties associated with a Control Center Service.
rem These properties need to be set so that the Control Center Service knows where to pick up the
rem Instance Number, Runtime Version and Server Side Home from, since these are not included in an
rem OWB Installation when the "Allow Local Control Center Service" option is set.
rem
rem USAGE
rem Logon as the OWB Repository Owner (OWBSYS)
rem    
rem   @<OWB-HOME>/owb/rtp/sql/set_ccs_home.sql <instance-number> <owb-version> <server-side-home>
rem
rem <instance-number>  This represents the service node instance that you are updating
rem
rem <owb-version>      This represents the OWB version that you are using, values such as:-
rem                    11.0.0.1.3
rem
rem <server-side-home> This represents the OWB Home on the server machine where the OWB install
rem                    components will be picked up from
rem
rem EXAMPLE
rem   sqlplus user/password@tns_name @set_ccs_home.sql 1 "11.0.0.1.3" "/ade/owb_17472/oracle"
rem 

set echo off
set verify off
set role OWB_USER;

define SV_NODE = &1.
define RT_VERS = &2.
define SS_HOME = &3.

declare
  l_instance number(22) := '&SV_NODE.';
  l_version varchar2(32) := '&RT_VERS.';
  l_home varchar2(255) := '&SS_HOME.';

begin
  owbsys.wb_rt_script_util.set_ccs_home(l_instance, l_version, l_home);

end;
/

