rem
rem This script can be used to set the value of a platform property. These
rem properties control how the Control Center Service behaves.
rem
rem USAGE
rem Logon as the Control Center Owner
rem    
rem    @<OWB-HOME>/owb/rtp/sql/set_platform_property.sql <prop-name> <directory-name> <file-name>
rem
rem This script sets the property with the given name to the contents of the give 
rem filename as found in the given directory.
rem
rem Note that the script assumes that the specified property must exist and
rem must be changable
rem

set serveroutput on;

set echo off
set verify off

define PROPERTY_PATH = '&1.'
define DIRECTORY_NAME = '&2.'
define FILE_NAME = '&3.'

DECLARE
  fHandler UTL_FILE.FILE_TYPE;
  buf      varchar2(128);
  clobvar CLOB := EMPTY_CLOB;
  l_property_path varchar2(4000) := 'property.%' || '&PROPERTY_PATH.';
BEGIN
  fHandler := UTL_FILE.FOPEN('&DIRECTORY_NAME.', '&FILE_NAME.', 'r');  
  
  dbms_lob.createtemporary(clobvar, TRUE);
  dbms_lob.open(clobvar, dbms_lob.lob_readwrite);
  
  begin   
    LOOP 
      UTL_FILE.GET_LINE(fHandler, buf);    
      
      IF buf is null THEN       
        buf:= chr(10);
      ELSE
        buf := buf || chr(10);
      END IF;
      
      dbms_lob.writeappend(clobvar, length(buf), buf);
           
    END LOOP;   
  EXCEPTION
    WHEN NO_DATA_FOUND THEN UTL_FILE.FCLOSE (fHandler);
    WHEN utl_file.invalid_path THEN
      raise_application_error(-20000, 'Invalid path.');
  end;
  
  dbms_lob.close(clobvar);     
  --dbms_output.put_line(clobvar); 
  
  update wb_rt_platform_properties set
    property_value = clobvar 
  where
    property_path like l_property_path;  
    
END;
/

commit;
