rem
rem This script can be used to start a Control Center Service that is managed
rem by the database.
rem 
rem A Control Center Service provides access to the deployment and execution
rem features of an OWB Repository and one must be available in order to enable
rem the deployment and execution features,
rem
rem This service is either Available or Unavailable and this script can be used
rem to make it Available.
rem
rem When the service is invoked using this script, a monitoring job is created.
rem This job monitors the service and will restart it if the service fails. This
rem monitoring job will also automatically start the service if the database
rem is brought back online.
rem
rem Alternatively, a Control Center Service can be started in a different OWB
rem Home on a different host. When working in this mode, the Service will only
rem be available when that host is available and when the Service has been started
rem and has not been stopped. A Service can be started/stopped in this mode by
rem using the script:-
rem
rem  <owb-home>/owb/bin/[win32|unix]/local_service_login.[bat|sh]
rem         [-startup|-closedown] <owb-home>
rem
rem
rem USAGE
rem Logon as the OWB Repository Owner (OWBSYS)
rem    
rem    @<OWB-HOME>/owb/rtp/sql/start_service.sql
rem
rem This script will display
rem     "Available"     if the Control Center service is up and Available
rem     "Not Available" if the Control Center service is Not Available
rem                        (if this happens you could try using the
rem                         service_doctor.sql to determine why the service did not
rem                         start)
rem
rem Please use the scripts show_service.sql and stop_service.sql to show the status or
rem stop the service respectively.
rem
rem

set serveroutput on;
set role OWB_USER;

declare
  l_service owbsys.wb_rt_script_util.START_SERVICE_REC;
  l_job_procs number;

begin
  l_job_procs := owbsys.wb_rt_script_util.count_job_queue_processes();
  if l_job_procs >= 2
  then
      l_service := owbsys.wb_rt_script_util.start_service();
  end if;
  
  if l_service.available <> 0
  then
    dbms_output.put_line('Available');  
    dbms_output.put_line(owbsys.wb_rt_script_util.service_status);
  
  else
    dbms_output.put_line('Not Available');
    dbms_output.put_line('Diagnostics:');

    if l_job_procs < 2
    then
      dbms_output.put_line('job_queue_processes is ' || l_job_procs || 
        ' whereas it must be at least 2 for owb.');

    else
      declare
        l_next number := 1;
        l_length number := length(l_service.message);
        l_fraglen number;
      begin
        while l_next <= l_length
        loop
          l_fraglen := l_length - l_next + 1;
          if l_fraglen > 79
          then
            l_fraglen := 79;
          end if;
          dbms_output.put_line(substr(l_service.message, l_next, l_fraglen));
          l_next := l_next + l_fraglen;
        end loop;          
      end;
    end if;
  
    dbms_output.put_line('please invoke [owbhome]/owb/rtp/sql/service_doctor.sql for more information');
    
  end if;

end;
/

