rem
rem This script can be used to stop a Control Center Service that is managed by
rem the database.
rem 
rem A Control Center Service provides access to the deployment and execution
rem features of an OWB Repository and one must be available in order to enable
rem the deployment and execution features.
rem
rem This service is either Available or Unavailable and this script can be
rem used to make it Unavailable.
rem
rem When the service is stopped using this script, the monitoring job is removed.
rem This means that the service will remain stopped and disabled until it is
rem started by using the start_service.sql script.
rem
rem Alternatively, a Control Center Service can be started in a different OWB
rem Home on a different host. When working in this mode, the Service can be 
rem stopped using the script:-
rem
rem  <owb-home>/owb/bin/[win32|unix]/local_service_login.[bat|sh]
rem         -closedown <owb-home>
rem
rem USAGE
rem Logon as the OWB Repository Owner (OWBSYS)
rem    
rem    @<OWB-HOME>/owb/rtp/sql/stop_service.sql
rem
rem This script will display
rem     "Available"     if the Control Center service is up and Available
rem     "Not Available" if the Control Center service is Not Available
rem
rem Please use the scripts show_service.sql and start_service.sql to show the status or
rem start the service respectively

set serveroutput on;
set role OWB_USER;

declare
  l_available number(22);

begin
  l_available := owbsys.wb_rt_script_util.stop_service();

  if l_available <> 0
  then
    dbms_output.put_line('Available');
    dbms_output.put_line(owbsys.wb_rt_script_util.service_status);
  else
    dbms_output.put_line('Not Available');
  end if;
end;
/

