-- set signature keys, add NLS_CHARACTERSET, ABAP_REPORT_NAME

update wbprimitiveproperty_v
set value = 'STAGING_FILE_DIRECTORY,DATA_FILE_NAME,CONTROL_FILE_NAME,LOG_FILE_NAME,FILE_DELIMITER_FOR_STAGING_FILE,SQL_JOIN_COLLAPSING,NESTED_LOOP,USE_SELECT_SINGLE,PRIMARY_FOREIGN_KEY_FOR_JOIN,SAP_LOCATION,BACKGROUND,NLS_CHARACTERSET,ABAP_REPORT_NAME'
where elementid = 
(select w1.elementid 
from wbprimitiveproperty_v w1,
     wbprimitiveproperty_v w2,
  classdefinition_v c1
where w1.owner = w2.elementid
and w1.name = 'SIGNATURE_KEYS'
and w2.name = 'IMPLEMENTATION_OPTION_ABAP'
and w2.owner = c1.elementid
and c1.name = 'oracle.wh.repos.impl.mapping.CMPBatchMap')




-- set default value handler for: CONTROL_FILE_NAME, DATA_FILE_NAME, LOG_FILE_NAME

declare
    classId number;
    propertySetId number;
    propertyUsageId number;
    defaultValueId number;
    dynamicDefaultId number;

    begin
        select elementid into classId from classdefinition_v
        where name='oracle.wh.repos.impl.mapping.CMPBatchMap';
      
        select elementid into propertySetId from propertysetdefinition_v
        where classdefinition=classId and name='ABAP'
        and propertytype=2; -- configuration property

	-- CONTROL_FILE_NAME
        select elementid into propertyUsageId from propertyusagedefinition_v
        where propertysetdefinition=propertySetId and name='CONTROL_FILE_NAME';

        select elementid into defaultValueId from wbprimitiveproperty_v
        where owner=propertyUsageId and name='DefaultValue';

        delete wbprimitiveproperty_v
        where elementid=defaultValueId;

        insert into wbprimitiveproperty_v (
          LOADINGPARENT
          , DELETIONPARENT
          , AGGREGATEDSIGNATURE
          , CLASSNAME
          , COMPLETED
          , CREATEDBY
          , CREATIONTIMESTAMP
          , CUSTOMERDELETABLE
          , CUSTOMEREDITABLE
          , CUSTOMERRENAMABLE
          , DESCRIPTION
          , DISABLED
          , EDITABLE
          , ELEMENTID
          , FROZEN
          , GENERATED
          , IMPORTED
          , LOGICALNAME
          , METADATASIGNATURE
          , NAME
          , NOTE
          , NOTM
          , PERSISTENT
          , SEEDED
          , UOID
          , UPDATEDBY
          , UPDATETIMESTAMP
          , VERSION
          , ISLOADINGPARENT
          , OWNER
          , DATATYPE
          , POSITION
          , HASNAME
          , HASPOSITION
          , VALUE
        )
        values (
          classId
          , 0
          , null
          , 'WBPrimitiveProperty'
          , 0
          , (select createdby from cmpinstallation_v)
          , (select creationtimestamp from cmpinstallation_v)
          , 0
          , 0
          , 0
          , null
          , 0
          , 0
          , cwmseq.nextval
          , 0
          , 0
          , 0
          , 'DynamicDefault'
          , 'cd39a8ee0c663bd403ca4aeff217b7a8'
          , 'DynamicDefault'
          , null
          , 0
          , null
          , 1
          , '1E4E7C225637491BE040578CB80A0C4A'
          , (select updatedby from cmpinstallation_v)
          , sysdate
          , null
          , 0
          , propertyUsageId
          , 106
          , 0
          , 1
          , 0
          , 'oracle.wh.service.impl.generation.sap.ABAPDefaultFileName'
        );


	-- DATA_FILE_NAME
        select elementid into propertyUsageId from propertyusagedefinition_v
        where propertysetdefinition=propertySetId and name='DATA_FILE_NAME';

        select elementid into defaultValueId from wbprimitiveproperty_v
        where owner=propertyUsageId and name='DefaultValue';

        delete wbprimitiveproperty_v
        where elementid=defaultValueId;

        insert into wbprimitiveproperty_v (
          LOADINGPARENT
          , DELETIONPARENT
          , AGGREGATEDSIGNATURE
          , CLASSNAME
          , COMPLETED
          , CREATEDBY
          , CREATIONTIMESTAMP
          , CUSTOMERDELETABLE
          , CUSTOMEREDITABLE
          , CUSTOMERRENAMABLE
          , DESCRIPTION
          , DISABLED
          , EDITABLE
          , ELEMENTID
          , FROZEN
          , GENERATED
          , IMPORTED
          , LOGICALNAME
          , METADATASIGNATURE
          , NAME
          , NOTE
          , NOTM
          , PERSISTENT
          , SEEDED
          , UOID
          , UPDATEDBY
          , UPDATETIMESTAMP
          , VERSION
          , ISLOADINGPARENT
          , OWNER
          , DATATYPE
          , POSITION
          , HASNAME
          , HASPOSITION
          , VALUE
        )
        values (
          classId
          , 0
          , null
          , 'WBPrimitiveProperty'
          , 0
          , (select createdby from cmpinstallation_v)
          , (select creationtimestamp from cmpinstallation_v)
          , 0
          , 0
          , 0
          , null
          , 0
          , 0
          , cwmseq.nextval
          , 0
          , 0
          , 0
          , 'DynamicDefault'
          , 'cd39a8ee0c663bd403ca4aeff217b7a8'
          , 'DynamicDefault'
          , null
          , 0
          , null
          , 1
          , '1E4E7C225633491BE040578CB80A0C4A'
          , (select updatedby from cmpinstallation_v)
          , sysdate
          , null
          , 0
          , propertyUsageId
          , 106
          , 0
          , 1
          , 0
          , 'oracle.wh.service.impl.generation.sap.ABAPDefaultFileName'
        );


	-- LOG_FILE_NAME
        select elementid into propertyUsageId from propertyusagedefinition_v
        where propertysetdefinition=propertySetId and name='LOG_FILE_NAME';

        select elementid into defaultValueId from wbprimitiveproperty_v
        where owner=propertyUsageId and name='DefaultValue';

        delete wbprimitiveproperty_v
        where elementid=defaultValueId;

        insert into wbprimitiveproperty_v (
          LOADINGPARENT
          , DELETIONPARENT
          , AGGREGATEDSIGNATURE
          , CLASSNAME
          , COMPLETED
          , CREATEDBY
          , CREATIONTIMESTAMP
          , CUSTOMERDELETABLE
          , CUSTOMEREDITABLE
          , CUSTOMERRENAMABLE
          , DESCRIPTION
          , DISABLED
          , EDITABLE
          , ELEMENTID
          , FROZEN
          , GENERATED
          , IMPORTED
          , LOGICALNAME
          , METADATASIGNATURE
          , NAME
          , NOTE
          , NOTM
          , PERSISTENT
          , SEEDED
          , UOID
          , UPDATEDBY
          , UPDATETIMESTAMP
          , VERSION
          , ISLOADINGPARENT
          , OWNER
          , DATATYPE
          , POSITION
          , HASNAME
          , HASPOSITION
          , VALUE
        )
        values (
          classId
          , 0
          , null
          , 'WBPrimitiveProperty'
          , 0
          , (select createdby from cmpinstallation_v)
          , (select creationtimestamp from cmpinstallation_v)
          , 0
          , 0
          , 0
          , null
          , 0
          , 0
          , cwmseq.nextval
          , 0
          , 0
          , 0
          , 'DynamicDefault'
          , 'cd39a8ee0c663bd403ca4aeff217b7a8'
          , 'DynamicDefault'
          , null
          , 0
          , null
          , 1
          , '1E4E7C225635491BE040578CB80A0C4A'
          , (select updatedby from cmpinstallation_v)
          , sysdate
          , null
          , 0
          , propertyUsageId
          , 106
          , 0
          , 1
          , 0
          , 'oracle.wh.service.impl.generation.sap.ABAPDefaultFileName'
        );

end;
/

-- add new property and propertyUsage: ABAP_REPORT_NAME
-- add new propertyUsage: NLS_CHARACTERSET


declare
    classId number;
    propertySetId number;
    propertyGroupId number;
    propertyId number;
    propertyUsageId number;

    begin
        select elementid into classId from classdefinition_v
        where name='oracle.wh.repos.impl.mapping.CMPBatchMap';
      
        select elementid into propertySetId from propertysetdefinition_v
        where classdefinition=classId and name='ABAP'
        and propertytype=2; 

        select elementid into propertyGroupId from propertygroupdefinition_v
        where groupowner=classId and name='ABAP_RUNTIME_PARAMETERS';

	-- add new property: ABAP_REPORT_NAME
        insert into propertydefinition_v (
          LOADINGPARENT
          ,DELETIONPARENT
          ,AGGREGATEDSIGNATURE
          ,CLASSNAME
          ,COMPLETED
          ,CREATEDBY
          ,CREATIONTIMESTAMP
          ,CUSTOMERDELETABLE
          ,CUSTOMEREDITABLE
          ,CUSTOMERRENAMABLE
          ,DESCRIPTION
          ,DISABLED
          ,EDITABLE
          ,ELEMENTID
          ,FROZEN
          ,GENERATED
          ,IMPORTED
          ,LOGICALNAME
          ,METADATASIGNATURE
          ,NAME
          ,NOTE
          ,NOTM
          ,PERSISTENT
          ,SEEDED
          ,UOID
          ,UPDATEDBY
          ,UPDATETIMESTAMP
          ,VERSION
          ,ISLOADINGPARENT
          ,PROPERTYTYPE
          ,DEFINITIONKEY
          ,EXPORTCONTROL
          ,OVERRIDE
          ,POSITION
          ,CLASSDEFINITION
          ,DATATYPE
          ,ISROLE
          ,ROLEDEFINITION
          ,TRANSLATABLE
          ,ISPASSWORD
          ,HIDDEN
          ,PROPERTYREADONLY
          ,NAMECHECKED
          ,USERCHOICEALLOWED
          ,DYNAMICDEFAULT
          ,INPLACEEDITOR
          ,CUSTOMEDITOR
          ,PROPERTYGROUPDEFINITION
        )
        values (
          classId
          , 0
          , null
          , 'PropertyDefinition'
          , 0
          , (select createdby from cmpinstallation_v)
          , (select creationtimestamp from cmpinstallation_v)
          , 0
          , 0
          , 0
          , 'ABAP report name'
          , 0
          , 0
          , cwmseq.nextval
          , 0
          , 0
          , 0
          , 'ABAP_REPORT_NAME'
          , '941943839c4005dfc7d95d895748de56'
          , 'ABAP_REPORT_NAME'
          , null
          , 0
          , null
          , 1
          , '1E4E7C2255A8491BE040578CB80A0C4A'
          , (select updatedby from cmpinstallation_v)
          , sysdate
          , null
          , 0
          , 2 
          , 'abapReportName' 
          , 0
          , 0
          , 66
          , classId
          , 106 
          , 0
          , 0
          , 0
          , 0
          , 0
          , 0
          , 0
          , 0
          , null
          , null
          , null
          , propertyGroupId
        );

        select elementid into propertyId from propertydefinition_v
        where classdefinition=classId and name='ABAP_REPORT_NAME';

        insert into propertyusagedefinition_v (
          LOADINGPARENT
          , DELETIONPARENT
          , AGGREGATEDSIGNATURE
          , CLASSNAME
          , COMPLETED
          , CREATEDBY
          , CREATIONTIMESTAMP
          , CUSTOMERDELETABLE
          , CUSTOMEREDITABLE
          , CUSTOMERRENAMABLE
          , DESCRIPTION
          , DISABLED
          , EDITABLE
          , ELEMENTID
          , FROZEN
          , GENERATED
          , IMPORTED
          , LOGICALNAME
          , METADATASIGNATURE
          , NAME
          , NOTE
          , NOTM
          , PERSISTENT
          , SEEDED
          , UOID
          , UPDATEDBY
          , UPDATETIMESTAMP
          , VERSION
          , ISLOADINGPARENT
          , PROPERTYSETDEFINITION
          , PROPERTYDEFINITION
          , DEFINITIONKEY
        )
        values (
          classId
          , 0
          , null
          , 'PropertyUsageDefinition'
          , 0
          , (select createdby from cmpinstallation_v)
          , (select creationtimestamp from cmpinstallation_v)
          , 0
          , 0
          , 0
          , 'ABAP report name'
          , 0
          , 0
          , cwmseq.nextval
          , 0
          , 0
          , 0
          , 'ABAP_REPORT_NAME'
          , 'a91329eaaf32960f334921366ae7ae85'
          , 'ABAP_REPORT_NAME'
          , null
          , 0
          , null
          , 1
          , '1E4E7C225647491BE040578CB80A0C4A'
          , (select updatedby from cmpinstallation_v)
          , sysdate
          , null
          , 0
          , propertySetId
          , propertyId
          , '8i.MAPPINGS.ABAPSTEP.RUNTIMEPARAMS.ABAP_REPORT_NAME'
        );

	-- Add new propertyUsage: NLS_CHARACTERSET

        select elementid into propertyId from propertydefinition_v
        where classdefinition=classId and name='NLS_CHARACTERSET';

        insert into propertyusagedefinition_v (
          LOADINGPARENT
          , DELETIONPARENT
          , AGGREGATEDSIGNATURE
          , CLASSNAME
          , COMPLETED
          , CREATEDBY
          , CREATIONTIMESTAMP
          , CUSTOMERDELETABLE
          , CUSTOMEREDITABLE
          , CUSTOMERRENAMABLE
          , DESCRIPTION
          , DISABLED
          , EDITABLE
          , ELEMENTID
          , FROZEN
          , GENERATED
          , IMPORTED
          , LOGICALNAME
          , METADATASIGNATURE
          , NAME
          , NOTE
          , NOTM
          , PERSISTENT
          , SEEDED
          , UOID
          , UPDATEDBY
          , UPDATETIMESTAMP
          , VERSION
          , ISLOADINGPARENT
          , PROPERTYSETDEFINITION
          , PROPERTYDEFINITION
          , DEFINITIONKEY
        )
        values (
          classId
          , 0
          , null
          , 'PropertyUsageDefinition'
          , 0
          , (select createdby from cmpinstallation_v)
          , (select creationtimestamp from cmpinstallation_v)
          , 0
          , 0
          , 0
          , 'NLS characterset'
          , 0
          , 0
          , cwmseq.nextval
          , 0
          , 0
          , 0
          , 'NLS_CHARACTERSET'
          , '0d1d7d14d3e5ae5073f8c5a3f8789421'
          , 'NLS_CHARACTERSET'
          , null
          , 0
          , null
          , 1
          , '1E4E7C225648491BE040578CB80A0C4A'
          , (select updatedby from cmpinstallation_v)
          , sysdate
          , null
          , 0
          , propertySetId
          , propertyId
          , '8i.MAPPINGS.SQLLOADERSTEP.SQLLOADERPARAMS.CHARACTERSET'
        );
end;
/
commit;
