SET SERVEROUTPUT ON
SET LINESIZE 500
SET ECHO OFF;
SET HEADING OFF;
SET FEEDBACK OFF;

-- ##########################################################################
DECLARE -- Outer block for utility functions/variables
-- ##########################################################################

-- **************************************************************************
-- **************************************************************************
--                      Defined Variables
-- **************************************************************************
-- **************************************************************************

  IsFound        NUMBER := 0;

-- ##########################################################################
-- ##########################################################################
BEGIN --    Outer block - utility functions/variables now defined
-- ##########################################################################
-- ##########################################################################

  -- =======================================================
  BEGIN -- Initialize constants and lookup tables
  -- =======================================================
  --  DBMS_OUTPUT.put_line('Initialize constants and lookup tables BEG...');

    select 1 into IsFound from wb_rt_def_system_parameters where parameter_name = 'ABAP_REPORT_NAME';
    --DBMS_OUTPUT.put_line('Status of search : [' || IsFound || ']...');

  EXCEPTION
    WHEN NO_DATA_FOUND THEN
    BEGIN
       --DBMS_OUTPUT.put_line('NO DATA FOUND');

       -- new Task parameter: ABAP_REPORT_NAME
       insert into wb_rt_def_system_parameters
       (
          system_parameter_id,
          execution_operator_id,
          parameter_name,
          parameter_type,
          parameter_mode,
          parameter_scope,
          bound_to_name,
          bound_to_kind,
          bound_to_scope,
          is_fixed,
          is_required,
          default_value_kind,
          default_value,
          type_length,
          type_scale,
          type_precision
       )
       select
          wb_rt_system_metadata_seq.nextval,
          eo.execution_operator_id,
          'ABAP_REPORT_NAME',
          2007,
          3001,
          null,
          null,
          null,
      null,
      0,
      0,
      24004,
      null,
      null,
      null,
      null
       from
          wb_rt_def_execution_operators eo
       where
          eo.operator_name = 'SAP';
    END; -- NO_DATA_FOUND

commit;
end;
-- ##########################################################################
END; -- Outer block for utility functions/variables
-- ##########################################################################
/