-- set signature keys, add NLS_CHARACTERSET, ABAP_REPORT_NAME, SAP_FTP

update wbprimitiveproperty_v
set value = 'STAGING_FILE_DIRECTORY,DATA_FILE_NAME,CONTROL_FILE_NAME,LOG_FILE_NAME,FILE_DELIMITER_FOR_STAGING_FILE,SQL_JOIN_COLLAPSING,NESTED_LOOP,USE_SELECT_SINGLE,PRIMARY_FOREIGN_KEY_FOR_JOIN,SAP_LOCATION,BACKGROUND,NLS_CHARACTERSET,ABAP_REPORT_NAME,SAP_FTP'
where elementid = 
(select w1.elementid 
from wbprimitiveproperty_v w1,
     wbprimitiveproperty_v w2,
	 classdefinition_v c1
where w1.owner = w2.elementid
and w1.name = 'SIGNATURE_KEYS'
and w2.name = 'IMPLEMENTATION_OPTION_ABAP'
and w2.owner = c1.elementid
and c1.name = 'oracle.wh.repos.impl.mapping.CMPBatchMap')






-- add new property and propertyUsage: SAP_FTP



declare
    classId number;
    propertySetId number;
    propertyGroupId number;
    propertyId number;
    propertyUsageId number;

    begin
        select elementid into classId from classdefinition_v
        where name='oracle.wh.repos.impl.mapping.CMPBatchMap';
      
        select elementid into propertySetId from propertysetdefinition_v
        where classdefinition=classId and name='ABAP'
        and propertytype=2; 

        select elementid into propertyGroupId from propertygroupdefinition_v
        where groupowner=classId and name='ABAP_RUNTIME_PARAMETERS';


	-- add new property: SAP_FTP
        insert into propertydefinition_v (
          LOADINGPARENT
          ,DELETIONPARENT
          ,AGGREGATEDSIGNATURE
          ,CLASSNAME
          ,COMPLETED
          ,CREATEDBY
          ,CREATIONTIMESTAMP
          ,CUSTOMERDELETABLE
          ,CUSTOMEREDITABLE
          ,CUSTOMERRENAMABLE
          ,DESCRIPTION
          ,DISABLED
          ,EDITABLE
          ,ELEMENTID
          ,FROZEN
          ,GENERATED
          ,IMPORTED
          ,LOGICALNAME
          ,METADATASIGNATURE
          ,NAME
          ,NOTE
          ,NOTM
          ,PERSISTENT
          ,SEEDED
          ,UOID
          ,UPDATEDBY
          ,UPDATETIMESTAMP
          ,VERSION
          ,ISLOADINGPARENT
          ,PROPERTYTYPE
          ,DEFINITIONKEY
          ,EXPORTCONTROL
          ,OVERRIDE
          ,POSITION
          ,CLASSDEFINITION
          ,DATATYPE
          ,ISROLE
          ,ROLEDEFINITION
          ,TRANSLATABLE
          ,ISPASSWORD
          ,HIDDEN
          ,PROPERTYREADONLY
          ,NAMECHECKED
          ,USERCHOICEALLOWED
          ,DYNAMICDEFAULT
          ,INPLACEEDITOR
          ,CUSTOMEDITOR
          ,PROPERTYGROUPDEFINITION
        )
        values (
          classId
          , 0
          , null
          , 'PropertyDefinition'
          , 0
          , (select createdby from cmpinstallation_v)
          , (select creationtimestamp from cmpinstallation_v)
          , 0
          , 0
          , 0
          , 'SAP ftp'
          , 0
          , 0
          , cwmseq.nextval
          , 0
          , 0
          , 0
          , 'SAP_FTP'
          , '989610aedf77a61e38f2b90e84ee4a1b'
          , 'SAP_FTP'
          , null
          , 0
          , null
          , 1
          , '32FEEA459748A76AE040578CF884012D'
          , (select updatedby from cmpinstallation_v)
          , sysdate
          , null
          , 0
          , 2 
          , 'sapftp' 
          , 0
          , 0
          , 67
          , classId
          , 113
          , 0
          , 0
          , 0
          , 0
          , 0
          , 0
          , 0
          , 0
          , null
          , null
          , null
          , propertyGroupId
        );

        select elementid into propertyId from propertydefinition_v
        where classdefinition=classId and name='SAP_FTP';

        insert into propertyusagedefinition_v (
          LOADINGPARENT
          , DELETIONPARENT
          , AGGREGATEDSIGNATURE
          , CLASSNAME
          , COMPLETED
          , CREATEDBY
          , CREATIONTIMESTAMP
          , CUSTOMERDELETABLE
          , CUSTOMEREDITABLE
          , CUSTOMERRENAMABLE
          , DESCRIPTION
          , DISABLED
          , EDITABLE
          , ELEMENTID
          , FROZEN
          , GENERATED
          , IMPORTED
          , LOGICALNAME
          , METADATASIGNATURE
          , NAME
          , NOTE
          , NOTM
          , PERSISTENT
          , SEEDED
          , UOID
          , UPDATEDBY
          , UPDATETIMESTAMP
          , VERSION
          , ISLOADINGPARENT
          , PROPERTYSETDEFINITION
          , PROPERTYDEFINITION
          , DEFINITIONKEY
        )
        values (
          classId
          , 0
          , null
          , 'PropertyUsageDefinition'
          , 0
          , (select createdby from cmpinstallation_v)
          , (select creationtimestamp from cmpinstallation_v)
          , 0
          , 0
          , 0
          , 'SAP ftp'
          , 0
          , 0
          , cwmseq.nextval
          , 0
          , 0
          , 0
          , 'SAP_FTP'
          , '364da317ded8cef0affaf83dd9f88fca'
          , 'SAP_FTP'
          , null
          , 0
          , null
          , 1
          , '32FEEA459748A76AE040578CF884012D'
          , (select updatedby from cmpinstallation_v)
          , sysdate
          , null
          , 0
          , propertySetId
          , propertyId
          , '8i.MAPPINGS.ABAPSTEP.RUNTIMEPARAMS.SAP_FTP'
        );
        -- old uoid           , '1E4E7C225647491BE040578CB80A0C4A'
end;
/





commit;
