--
-- $Header: whdev/2.0/owb/shiphome/owb/reposasst/upg/property_upgrade_102to10205.sql /main/1 2008/12/16 11:42:15 rspaul Exp $
--
-- property_upgrade_102to10205.sql
--
-- Copyright (c) 2008, Oracle and/or its affiliates.All rights reserved. 
--
--   NAME
--     property_upgrade_102to10205.sql - PL/SQL Package to add new properties in 
--                                       a 10.2.0.x -> 10.2.0.5 in-place repository
--                                       migration
--
--   DESCRIPTION
--     A PL/SQL Package to add new properties in a 10.2.0.x -> 10.2.0.5 in-place
--     repository migration.
--
--   RETURNS
--
--   NOTES
--     
--
--   MODIFIED   (MM/DD/YY)
--   csantelm    11/25/08 - Creation
--
-- Example of how to create sql in-place upgrade patch for some up.xml
-- property changes. The sql will be shown (as much as possible) in-line with
-- the associated up.xml. The xml will be set off from the sql by commenting
-- each line with "--up.xml->". Search on that 'symbol' for beginning of 'user'
-- code. WARNING: Do not use ampersand ANYWHERE - it is interpreted as bind var
--
-- Bug #'s/Properties added
--
-- bug 7536066 : FORCE_COPY_DATA 
--
--SET SERVEROUTPUT ON
--SET LINESIZE 500
-- ##########################################################################
DECLARE -- Outer block for utility functions/variables BUGBUG: Should these be packagized (uprop_util)
-- ##########################################################################

  SCRIPTID CONSTANT VARCHAR2(30) := 'property_upgrade_102_to_10205'; -- For output logging
  EOL      CONSTANT VARCHAR2(01) := CHR(10); -- new line
  TRACEON  CONSTANT BOOLEAN      := TRUE; -- Provide function level trace output
  OUTINITED         BOOLEAN      := FALSE; -- Flag indicating output has been enabled

  -- useful 'constants'
  PropertyTypeCORE    NUMBER := 0;
  PropertyTypeLOGICAL NUMBER := 1;
  PropertyTypeCONFIG  NUMBER := 2;
  PropertyTypeUSERDEF NUMBER := 3;
  CreateNew           BOOLEAN := FALSE;

  -- types for lookup lists
  TYPE NameList  IS TABLE OF VARCHAR2(32);
  TYPE IdForName IS TABLE OF NUMBER INDEX BY VARCHAR2(32);

  -- some useful lookups/'translators' from xml type names to coded ids
  -- will work like functions i.e., id := propertytypeIdOf('logical');
  propertytypeIdOf IdForName; -- initialized below
  datatypeIdOf     IdForName; -- initialized below

  -- will use original install user as create/update id for new records so
  -- make record to hold info
-- ==========================================================================
  TYPE AuditInfo_rec IS RECORD (
-- ==========================================================================
     CREATEDBY               CMPInstallation_v.CREATEDBY%TYPE               DEFAULT null
    ,CREATIONTIMESTAMP       CMPInstallation_v.CREATIONTIMESTAMP%TYPE       DEFAULT null
    ,UPDATEDBY               CMPInstallation_v.UPDATEDBY%TYPE               DEFAULT null
    ,UPDATETIMESTAMP         CMPInstallation_v.UPDATETIMESTAMP%TYPE         DEFAULT null
  );
  g_auditInfo AuditInfo_rec;

  -- Record definitions for the various views
  -- Handy sql to make record definitions (some hand editing required (in sqlworksheet anyway)
  -- search/replace 'PropertyDefinition' with type you need
  -- after cut/paste results here, delete headings, echo, etc
  -- CHECK THE RELATED JAVA CLASSES to pick up additional defaults if any.
  -- repos/impl/domain for domain and XxxType
  -- repos/impl/metaModel for XxxDefinition
/*
-- rectype_from_user_tab_columns.sql
SET SERVEROUTPUT ON;
SET LINESIZE 200;
SET ECHO OFF;
SET HEADING OFF;
SET FEEDBACK OFF;
    column ColumnName format a10;
    column ColumnType format a10;
    column ColumnDflt format a10;
    column Type       format a4;

    select ('-- ==========================================================================' || CHR(10)
         || '  TYPE' || ' PropertyDefinition IS RECORD (' || CHR(10)
         || '-- ==========================================================================')
         "a" from dual;
-- BUGBUG: Depending on LOADINGPARENT to be 1st column.
    select
        (   DECODE(column_name
                ,'LOADINGPARENT', '     '
                ,'    ,'
            ) || column_name
        ) "ColumnName"
        ,('PropertyDefinition' || '_v.' || column_name || '%TYPE') "ColumnType"
        ,('DEFAULT ' ||
            DECODE(column_name
                ,'SEEDED', '   1'
                ,'CLASSNAME', '''PropertyDefinition'''
                ,DECODE(data_type
                    ,'NUMBER', '   0'
                    ,'null'
                )
            )
        ) "ColumnDflt"
        ,('-- ' || data_type ||
            DECODE(data_type
                ,'NUMBER', ('(' || data_precision || ',' || data_scale || ')')
                ,'DATE', ''
                ,('(' || data_length || ')')
            )
        ) "Type"
    from user_tab_columns
    where table_name = UPPER('PropertyDefinition' || '_v')
    order by column_id;

*/

-- ==========================================================================
  TYPE PropertyDefinition IS RECORD (
-- ==========================================================================
     LOADINGPARENT                  PropertyDefinition_v.LOADINGPARENT%TYPE                  DEFAULT    0                 -- NUMBER(9,0)
    ,DELETIONPARENT                 PropertyDefinition_v.DELETIONPARENT%TYPE                 DEFAULT    0                 -- NUMBER(9,0)
    ,AGGREGATEDSIGNATURE            PropertyDefinition_v.AGGREGATEDSIGNATURE%TYPE            DEFAULT null                 -- VARCHAR2(255)
    ,CLASSNAME                      PropertyDefinition_v.CLASSNAME%TYPE                      DEFAULT 'PropertyDefinition' -- VARCHAR2(255)
    ,COMPLETED                      PropertyDefinition_v.COMPLETED%TYPE                      DEFAULT    0                 -- CHAR(1)
    ,CREATEDBY                      PropertyDefinition_v.CREATEDBY%TYPE                      DEFAULT null                 -- VARCHAR2(40)
    ,CREATIONTIMESTAMP              PropertyDefinition_v.CREATIONTIMESTAMP%TYPE              DEFAULT null                 -- DATE
    ,CUSTOMERDELETABLE              PropertyDefinition_v.CUSTOMERDELETABLE%TYPE              DEFAULT    0                 -- CHAR(1)
    ,CUSTOMEREDITABLE               PropertyDefinition_v.CUSTOMEREDITABLE%TYPE               DEFAULT    0                 -- CHAR(1)
    ,CUSTOMERRENAMABLE              PropertyDefinition_v.CUSTOMERRENAMABLE%TYPE              DEFAULT    0                 -- CHAR(1)
    ,DESCRIPTION                    PropertyDefinition_v.DESCRIPTION%TYPE                    DEFAULT null                 -- VARCHAR2(4000)
    ,DISABLED                       PropertyDefinition_v.DISABLED%TYPE                       DEFAULT    0                 -- CHAR(1)
    ,EDITABLE                       PropertyDefinition_v.EDITABLE%TYPE                       DEFAULT    0                 -- CHAR(1)
    ,ELEMENTID                      PropertyDefinition_v.ELEMENTID%TYPE                      DEFAULT    0                 -- NUMBER(9,0)
    ,FROZEN                         PropertyDefinition_v.FROZEN%TYPE                         DEFAULT    0                 -- CHAR(1)
    ,GENERATED                      PropertyDefinition_v.GENERATED%TYPE                      DEFAULT    0                 -- CHAR(1)
    ,IMPORTED                       PropertyDefinition_v.IMPORTED%TYPE                       DEFAULT    0                 -- CHAR(1)
    ,LOGICALNAME                    PropertyDefinition_v.LOGICALNAME%TYPE                    DEFAULT null                 -- VARCHAR2(1000)
    ,METADATASIGNATURE              PropertyDefinition_v.METADATASIGNATURE%TYPE              DEFAULT null                 -- VARCHAR2(255)
    ,NAME                           PropertyDefinition_v.NAME%TYPE                           DEFAULT null                 -- VARCHAR2(255)
    ,NOTE                           PropertyDefinition_v.NOTE%TYPE                           DEFAULT null                 -- VARCHAR2(4000)
    ,NOTM                           PropertyDefinition_v.NOTM%TYPE                           DEFAULT    0                 -- NUMBER(9,0)
    ,PERSISTENT                     PropertyDefinition_v.PERSISTENT%TYPE                     DEFAULT null                 -- CHAR(1)
    ,SEEDED                         PropertyDefinition_v.SEEDED%TYPE                         DEFAULT    1                 -- CHAR(1)
    ,UOID                           PropertyDefinition_v.UOID%TYPE                           DEFAULT null                 -- VARCHAR2(255)
    ,UPDATEDBY                      PropertyDefinition_v.UPDATEDBY%TYPE                      DEFAULT null                 -- VARCHAR2(40)
    ,UPDATETIMESTAMP                PropertyDefinition_v.UPDATETIMESTAMP%TYPE                DEFAULT null                 -- DATE
    ,VERSION                        PropertyDefinition_v.VERSION%TYPE                        DEFAULT null                 -- VARCHAR2(40)
    ,ISLOADINGPARENT                PropertyDefinition_v.ISLOADINGPARENT%TYPE                DEFAULT    0                 -- CHAR(1)
    ,PROPERTYTYPE                   PropertyDefinition_v.PROPERTYTYPE%TYPE                   DEFAULT    0                 -- NUMBER(9,0)
    ,DEFINITIONKEY                  PropertyDefinition_v.DEFINITIONKEY%TYPE                  DEFAULT null                 -- VARCHAR2(255)
    ,EXPORTCONTROL                  PropertyDefinition_v.EXPORTCONTROL%TYPE                  DEFAULT    0                 -- NUMBER(9,0)
    ,OVERRIDE                       PropertyDefinition_v.OVERRIDE%TYPE                       DEFAULT    0                 -- CHAR(1)
    ,POSITION                       PropertyDefinition_v.POSITION%TYPE                       DEFAULT    0                 -- NUMBER(9,0)
    ,CLASSDEFINITION                PropertyDefinition_v.CLASSDEFINITION%TYPE                DEFAULT    0                 -- NUMBER(9,0)
    ,DATATYPE                       PropertyDefinition_v.DATATYPE%TYPE                       DEFAULT    0                 -- NUMBER(9,0)
    ,ISROLE                         PropertyDefinition_v.ISROLE%TYPE                         DEFAULT    0                 -- CHAR(1)
    ,ROLEDEFINITION                 PropertyDefinition_v.ROLEDEFINITION%TYPE                 DEFAULT    0                 -- NUMBER(9,0)
    ,TRANSLATABLE                   PropertyDefinition_v.TRANSLATABLE%TYPE                   DEFAULT    0                 -- CHAR(1)
    ,ISPASSWORD                     PropertyDefinition_v.ISPASSWORD%TYPE                     DEFAULT    0                 -- CHAR(1)
    ,HIDDEN                         PropertyDefinition_v.HIDDEN%TYPE                         DEFAULT    0                 -- CHAR(1)
    ,PROPERTYREADONLY               PropertyDefinition_v.PROPERTYREADONLY%TYPE               DEFAULT    0                 -- CHAR(1)
    ,NAMECHECKED                    PropertyDefinition_v.NAMECHECKED%TYPE                    DEFAULT    0                 -- CHAR(1)
    ,USERCHOICEALLOWED              PropertyDefinition_v.USERCHOICEALLOWED%TYPE              DEFAULT    0                 -- CHAR(1)
    ,DYNAMICDEFAULT                 PropertyDefinition_v.DYNAMICDEFAULT%TYPE                 DEFAULT null                 -- VARCHAR2(255)
    ,INPLACEEDITOR                  PropertyDefinition_v.INPLACEEDITOR%TYPE                  DEFAULT null                 -- VARCHAR2(255)
    ,CUSTOMEDITOR                   PropertyDefinition_v.CUSTOMEDITOR%TYPE                   DEFAULT null                 -- VARCHAR2(255)
    ,PROPERTYGROUPDEFINITION        PropertyDefinition_v.PROPERTYGROUPDEFINITION%TYPE        DEFAULT    0                 -- NUMBER(9,0)
  );

-- ==========================================================================
  TYPE PropertyUsageDefinition IS RECORD (
-- ==========================================================================
     LOADINGPARENT                  PropertyUsageDefinition_v.LOADINGPARENT%TYPE                  DEFAULT    0                      -- NUMBER(9,0)
    ,DELETIONPARENT                 PropertyUsageDefinition_v.DELETIONPARENT%TYPE                 DEFAULT    0                      -- NUMBER(9,0)
    ,AGGREGATEDSIGNATURE            PropertyUsageDefinition_v.AGGREGATEDSIGNATURE%TYPE            DEFAULT null                      -- VARCHAR2(255)
    ,CLASSNAME                      PropertyUsageDefinition_v.CLASSNAME%TYPE                      DEFAULT 'PropertyUsageDefinition' -- VARCHAR2(255)
    ,COMPLETED                      PropertyUsageDefinition_v.COMPLETED%TYPE                      DEFAULT null                      -- CHAR(1)
    ,CREATEDBY                      PropertyUsageDefinition_v.CREATEDBY%TYPE                      DEFAULT null                      -- VARCHAR2(40)
    ,CREATIONTIMESTAMP              PropertyUsageDefinition_v.CREATIONTIMESTAMP%TYPE              DEFAULT null                      -- DATE
    ,CUSTOMERDELETABLE              PropertyUsageDefinition_v.CUSTOMERDELETABLE%TYPE              DEFAULT null                      -- CHAR(1)
    ,CUSTOMEREDITABLE               PropertyUsageDefinition_v.CUSTOMEREDITABLE%TYPE               DEFAULT null                      -- CHAR(1)
    ,CUSTOMERRENAMABLE              PropertyUsageDefinition_v.CUSTOMERRENAMABLE%TYPE              DEFAULT null                      -- CHAR(1)
    ,DESCRIPTION                    PropertyUsageDefinition_v.DESCRIPTION%TYPE                    DEFAULT null                      -- VARCHAR2(4000)
    ,DISABLED                       PropertyUsageDefinition_v.DISABLED%TYPE                       DEFAULT null                      -- CHAR(1)
    ,EDITABLE                       PropertyUsageDefinition_v.EDITABLE%TYPE                       DEFAULT null                      -- CHAR(1)
    ,ELEMENTID                      PropertyUsageDefinition_v.ELEMENTID%TYPE                      DEFAULT    0                      -- NUMBER(9,0)
    ,FROZEN                         PropertyUsageDefinition_v.FROZEN%TYPE                         DEFAULT null                      -- CHAR(1)
    ,GENERATED                      PropertyUsageDefinition_v.GENERATED%TYPE                      DEFAULT null                      -- CHAR(1)
    ,IMPORTED                       PropertyUsageDefinition_v.IMPORTED%TYPE                       DEFAULT null                      -- CHAR(1)
    ,LOGICALNAME                    PropertyUsageDefinition_v.LOGICALNAME%TYPE                    DEFAULT null                      -- VARCHAR2(1000)
    ,METADATASIGNATURE              PropertyUsageDefinition_v.METADATASIGNATURE%TYPE              DEFAULT null                      -- VARCHAR2(255)
    ,NAME                           PropertyUsageDefinition_v.NAME%TYPE                           DEFAULT null                      -- VARCHAR2(255)
    ,NOTE                           PropertyUsageDefinition_v.NOTE%TYPE                           DEFAULT null                      -- VARCHAR2(4000)
    ,NOTM                           PropertyUsageDefinition_v.NOTM%TYPE                           DEFAULT    0                      -- NUMBER(9,0)
    ,PERSISTENT                     PropertyUsageDefinition_v.PERSISTENT%TYPE                     DEFAULT null                      -- CHAR(1)
    ,SEEDED                         PropertyUsageDefinition_v.SEEDED%TYPE                         DEFAULT    1                      -- CHAR(1)
    ,UOID                           PropertyUsageDefinition_v.UOID%TYPE                           DEFAULT null                      -- VARCHAR2(255)
    ,UPDATEDBY                      PropertyUsageDefinition_v.UPDATEDBY%TYPE                      DEFAULT null                      -- VARCHAR2(40)
    ,UPDATETIMESTAMP                PropertyUsageDefinition_v.UPDATETIMESTAMP%TYPE                DEFAULT null                      -- DATE
    ,VERSION                        PropertyUsageDefinition_v.VERSION%TYPE                        DEFAULT null                      -- VARCHAR2(40)
    ,ISLOADINGPARENT                PropertyUsageDefinition_v.ISLOADINGPARENT%TYPE                DEFAULT null                      -- CHAR(1)
    ,PROPERTYSETDEFINITION          PropertyUsageDefinition_v.PROPERTYSETDEFINITION%TYPE          DEFAULT    0                      -- NUMBER(9,0)
    ,PROPERTYDEFINITION             PropertyUsageDefinition_v.PROPERTYDEFINITION%TYPE             DEFAULT    0                      -- NUMBER(9,0)
    ,DEFINITIONKEY                  PropertyUsageDefinition_v.DEFINITIONKEY%TYPE                  DEFAULT null                      -- VARCHAR2(255)
  );

-- ==========================================================================
  TYPE WBPrimitiveProperty IS RECORD (
-- ==========================================================================
     LOADINGPARENT                  WBPrimitiveProperty_v.LOADINGPARENT%TYPE                  DEFAULT    0                  -- NUMBER(9,0)
    ,DELETIONPARENT                 WBPrimitiveProperty_v.DELETIONPARENT%TYPE                 DEFAULT    0                  -- NUMBER(9,0)
    ,AGGREGATEDSIGNATURE            WBPrimitiveProperty_v.AGGREGATEDSIGNATURE%TYPE            DEFAULT null                  -- VARCHAR2(255)
    ,CLASSNAME                      WBPrimitiveProperty_v.CLASSNAME%TYPE                      DEFAULT 'WBPrimitiveProperty' -- VARCHAR2(255)
    ,COMPLETED                      WBPrimitiveProperty_v.COMPLETED%TYPE                      DEFAULT null                  -- CHAR(1)
    ,CREATEDBY                      WBPrimitiveProperty_v.CREATEDBY%TYPE                      DEFAULT null                  -- VARCHAR2(40)
    ,CREATIONTIMESTAMP              WBPrimitiveProperty_v.CREATIONTIMESTAMP%TYPE              DEFAULT null                  -- DATE
    ,CUSTOMERDELETABLE              WBPrimitiveProperty_v.CUSTOMERDELETABLE%TYPE              DEFAULT null                  -- CHAR(1)
    ,CUSTOMEREDITABLE               WBPrimitiveProperty_v.CUSTOMEREDITABLE%TYPE               DEFAULT null                  -- CHAR(1)
    ,CUSTOMERRENAMABLE              WBPrimitiveProperty_v.CUSTOMERRENAMABLE%TYPE              DEFAULT null                  -- CHAR(1)
    ,DESCRIPTION                    WBPrimitiveProperty_v.DESCRIPTION%TYPE                    DEFAULT null                  -- VARCHAR2(4000)
    ,DISABLED                       WBPrimitiveProperty_v.DISABLED%TYPE                       DEFAULT null                  -- CHAR(1)
    ,EDITABLE                       WBPrimitiveProperty_v.EDITABLE%TYPE                       DEFAULT null                  -- CHAR(1)
    ,ELEMENTID                      WBPrimitiveProperty_v.ELEMENTID%TYPE                      DEFAULT    0                  -- NUMBER(9,0)
    ,FROZEN                         WBPrimitiveProperty_v.FROZEN%TYPE                         DEFAULT null                  -- CHAR(1)
    ,GENERATED                      WBPrimitiveProperty_v.GENERATED%TYPE                      DEFAULT null                  -- CHAR(1)
    ,IMPORTED                       WBPrimitiveProperty_v.IMPORTED%TYPE                       DEFAULT null                  -- CHAR(1)
    ,LOGICALNAME                    WBPrimitiveProperty_v.LOGICALNAME%TYPE                    DEFAULT null                  -- VARCHAR2(1000)
    ,METADATASIGNATURE              WBPrimitiveProperty_v.METADATASIGNATURE%TYPE              DEFAULT null                  -- VARCHAR2(255)
    ,NAME                           WBPrimitiveProperty_v.NAME%TYPE                           DEFAULT null                  -- VARCHAR2(255)
    ,NOTE                           WBPrimitiveProperty_v.NOTE%TYPE                           DEFAULT null                  -- VARCHAR2(4000)
    ,NOTM                           WBPrimitiveProperty_v.NOTM%TYPE                           DEFAULT    0                  -- NUMBER(9,0)
    ,PERSISTENT                     WBPrimitiveProperty_v.PERSISTENT%TYPE                     DEFAULT null                  -- CHAR(1)
    ,SEEDED                         WBPrimitiveProperty_v.SEEDED%TYPE                         DEFAULT    1                  -- CHAR(1)
    ,UOID                           WBPrimitiveProperty_v.UOID%TYPE                           DEFAULT null                  -- VARCHAR2(255)
    ,UPDATEDBY                      WBPrimitiveProperty_v.UPDATEDBY%TYPE                      DEFAULT null                  -- VARCHAR2(40)
    ,UPDATETIMESTAMP                WBPrimitiveProperty_v.UPDATETIMESTAMP%TYPE                DEFAULT null                  -- DATE
    ,VERSION                        WBPrimitiveProperty_v.VERSION%TYPE                        DEFAULT null                  -- VARCHAR2(40)
    ,ISLOADINGPARENT                WBPrimitiveProperty_v.ISLOADINGPARENT%TYPE                DEFAULT null                  -- CHAR(1)
    ,OWNER                          WBPrimitiveProperty_v.OWNER%TYPE                          DEFAULT    0                  -- NUMBER(9,0)
    ,DATATYPE                       WBPrimitiveProperty_v.DATATYPE%TYPE                       DEFAULT    0                  -- NUMBER(9,0)
    ,POSITION                       WBPrimitiveProperty_v.POSITION%TYPE                       DEFAULT    0                  -- NUMBER(9,0)
    ,HASNAME                        WBPrimitiveProperty_v.HASNAME%TYPE                        DEFAULT null                  -- CHAR(1)
    ,HASPOSITION                    WBPrimitiveProperty_v.HASPOSITION%TYPE                    DEFAULT null                  -- CHAR(1)
    ,VALUE                          WBPrimitiveProperty_v.VALUE%TYPE                          DEFAULT null                  -- VARCHAR2(4000)
  );

-- ==========================================================================
  TYPE WBDomain IS RECORD (
-- ==========================================================================
     LOADINGPARENT                  WBDomain_v.LOADINGPARENT%TYPE                  DEFAULT    0       -- NUMBER(9,0)
    ,DELETIONPARENT                 WBDomain_v.DELETIONPARENT%TYPE                 DEFAULT    0       -- NUMBER(9,0)
    ,AGGREGATEDSIGNATURE            WBDomain_v.AGGREGATEDSIGNATURE%TYPE            DEFAULT null       -- VARCHAR2(255)
    ,CLASSNAME                      WBDomain_v.CLASSNAME%TYPE                      DEFAULT 'WBDomain' -- VARCHAR2(255)
    ,COMPLETED                      WBDomain_v.COMPLETED%TYPE                      DEFAULT null       -- CHAR(1)
    ,CREATEDBY                      WBDomain_v.CREATEDBY%TYPE                      DEFAULT null       -- VARCHAR2(40)
    ,CREATIONTIMESTAMP              WBDomain_v.CREATIONTIMESTAMP%TYPE              DEFAULT null       -- DATE
    ,CUSTOMERDELETABLE              WBDomain_v.CUSTOMERDELETABLE%TYPE              DEFAULT null       -- CHAR(1)
    ,CUSTOMEREDITABLE               WBDomain_v.CUSTOMEREDITABLE%TYPE               DEFAULT null       -- CHAR(1)
    ,CUSTOMERRENAMABLE              WBDomain_v.CUSTOMERRENAMABLE%TYPE              DEFAULT null       -- CHAR(1)
    ,DESCRIPTION                    WBDomain_v.DESCRIPTION%TYPE                    DEFAULT null       -- VARCHAR2(4000)
    ,DISABLED                       WBDomain_v.DISABLED%TYPE                       DEFAULT null       -- CHAR(1)
    ,EDITABLE                       WBDomain_v.EDITABLE%TYPE                       DEFAULT null       -- CHAR(1)
    ,ELEMENTID                      WBDomain_v.ELEMENTID%TYPE                      DEFAULT    0       -- NUMBER(9,0)
    ,FROZEN                         WBDomain_v.FROZEN%TYPE                         DEFAULT null       -- CHAR(1)
    ,GENERATED                      WBDomain_v.GENERATED%TYPE                      DEFAULT null       -- CHAR(1)
    ,IMPORTED                       WBDomain_v.IMPORTED%TYPE                       DEFAULT null       -- CHAR(1)
    ,LOGICALNAME                    WBDomain_v.LOGICALNAME%TYPE                    DEFAULT null       -- VARCHAR2(1000)
    ,METADATASIGNATURE              WBDomain_v.METADATASIGNATURE%TYPE              DEFAULT null       -- VARCHAR2(255)
    ,NAME                           WBDomain_v.NAME%TYPE                           DEFAULT null       -- VARCHAR2(255)
    ,NOTE                           WBDomain_v.NOTE%TYPE                           DEFAULT null       -- VARCHAR2(4000)
    ,NOTM                           WBDomain_v.NOTM%TYPE                           DEFAULT    0       -- NUMBER(9,0)
    ,PERSISTENT                     WBDomain_v.PERSISTENT%TYPE                     DEFAULT null       -- CHAR(1)
    ,SEEDED                         WBDomain_v.SEEDED%TYPE                         DEFAULT    1       -- CHAR(1)
    ,UOID                           WBDomain_v.UOID%TYPE                           DEFAULT null       -- VARCHAR2(255)
    ,UPDATEDBY                      WBDomain_v.UPDATEDBY%TYPE                      DEFAULT null       -- VARCHAR2(40)
    ,UPDATETIMESTAMP                WBDomain_v.UPDATETIMESTAMP%TYPE                DEFAULT null       -- DATE
    ,VERSION                        WBDomain_v.VERSION%TYPE                        DEFAULT null       -- VARCHAR2(40)
    ,ISLOADINGPARENT                WBDomain_v.ISLOADINGPARENT%TYPE                DEFAULT null       -- CHAR(1)
    ,COMPARATOR                     WBDomain_v.COMPARATOR%TYPE                     DEFAULT 'PropertyNameComparator'       -- VARCHAR2(255)
    ,DATATYPE                       WBDomain_v.DATATYPE%TYPE                       DEFAULT    0       -- NUMBER(9,0)
  );

-- ==========================================================================
  TYPE WBRange IS RECORD (
-- ==========================================================================
     LOADINGPARENT                  WBRange_v.LOADINGPARENT%TYPE                  DEFAULT    0      -- NUMBER(9,0)
    ,DELETIONPARENT                 WBRange_v.DELETIONPARENT%TYPE                 DEFAULT    0      -- NUMBER(9,0)
    ,AGGREGATEDSIGNATURE            WBRange_v.AGGREGATEDSIGNATURE%TYPE            DEFAULT null      -- VARCHAR2(255)
    ,CLASSNAME                      WBRange_v.CLASSNAME%TYPE                      DEFAULT 'WBRange' -- VARCHAR2(255)
    ,COMPLETED                      WBRange_v.COMPLETED%TYPE                      DEFAULT null      -- CHAR(1)
    ,CREATEDBY                      WBRange_v.CREATEDBY%TYPE                      DEFAULT null      -- VARCHAR2(40)
    ,CREATIONTIMESTAMP              WBRange_v.CREATIONTIMESTAMP%TYPE              DEFAULT null      -- DATE
    ,CUSTOMERDELETABLE              WBRange_v.CUSTOMERDELETABLE%TYPE              DEFAULT null      -- CHAR(1)
    ,CUSTOMEREDITABLE               WBRange_v.CUSTOMEREDITABLE%TYPE               DEFAULT null      -- CHAR(1)
    ,CUSTOMERRENAMABLE              WBRange_v.CUSTOMERRENAMABLE%TYPE              DEFAULT null      -- CHAR(1)
    ,DESCRIPTION                    WBRange_v.DESCRIPTION%TYPE                    DEFAULT null      -- VARCHAR2(4000)
    ,DISABLED                       WBRange_v.DISABLED%TYPE                       DEFAULT null      -- CHAR(1)
    ,EDITABLE                       WBRange_v.EDITABLE%TYPE                       DEFAULT null      -- CHAR(1)
    ,ELEMENTID                      WBRange_v.ELEMENTID%TYPE                      DEFAULT    0      -- NUMBER(9,0)
    ,FROZEN                         WBRange_v.FROZEN%TYPE                         DEFAULT null      -- CHAR(1)
    ,GENERATED                      WBRange_v.GENERATED%TYPE                      DEFAULT null      -- CHAR(1)
    ,IMPORTED                       WBRange_v.IMPORTED%TYPE                       DEFAULT null      -- CHAR(1)
    ,LOGICALNAME                    WBRange_v.LOGICALNAME%TYPE                    DEFAULT null      -- VARCHAR2(1000)
    ,METADATASIGNATURE              WBRange_v.METADATASIGNATURE%TYPE              DEFAULT null      -- VARCHAR2(255)
    ,NAME                           WBRange_v.NAME%TYPE                           DEFAULT null      -- VARCHAR2(255)
    ,NOTE                           WBRange_v.NOTE%TYPE                           DEFAULT null      -- VARCHAR2(4000)
    ,NOTM                           WBRange_v.NOTM%TYPE                           DEFAULT    0      -- NUMBER(9,0)
    ,PERSISTENT                     WBRange_v.PERSISTENT%TYPE                     DEFAULT null      -- CHAR(1)
    ,SEEDED                         WBRange_v.SEEDED%TYPE                         DEFAULT    1      -- CHAR(1)
    ,UOID                           WBRange_v.UOID%TYPE                           DEFAULT null      -- VARCHAR2(255)
    ,UPDATEDBY                      WBRange_v.UPDATEDBY%TYPE                      DEFAULT null      -- VARCHAR2(40)
    ,UPDATETIMESTAMP                WBRange_v.UPDATETIMESTAMP%TYPE                DEFAULT null      -- DATE
    ,VERSION                        WBRange_v.VERSION%TYPE                        DEFAULT null      -- VARCHAR2(40)
    ,ISLOADINGPARENT                WBRange_v.ISLOADINGPARENT%TYPE                DEFAULT null      -- CHAR(1)
    ,DOMAIN                         WBRange_v.DOMAIN%TYPE                         DEFAULT    0      -- NUMBER(9,0)
    ,MINVALUEINCLUSIVE              WBRange_v.MINVALUEINCLUSIVE%TYPE              DEFAULT null      -- CHAR(1)
    ,MAXVALUEINCLUSIVE              WBRange_v.MAXVALUEINCLUSIVE%TYPE              DEFAULT null      -- CHAR(1)
  );


-- **************************************************************************
-- **************************************************************************
--                      Useful functions/procedures
-- **************************************************************************
-- **************************************************************************

-- ==========================================================================
-- put message to output (uses DBMS_OUTPUT)
  PROCEDURE put(msg VARCHAR2) IS
-- ==========================================================================
  BEGIN
    IF NOT OUTINITED THEN
      OUTINITED := TRUE;
      DBMS_OUTPUT.ENABLE(200000);
      put('DBMS_OUTPUT Enabled.');
    END IF;
    
    IF (LENGTH(msg) + LENGTH(SCRIPTID) + 2) > 255 THEN
      -- 10.1 database can't handle messages with length > 255
      --DBMS_OUTPUT.put_line('Message length > 255');
      --DBMS_OUTPUT.put_line(SUBSTR(msg, 0, 255));
      -- Break the string up into lines or 255-byte chunks
      DECLARE
        l_msg_line VARCHAR2(255);
        l_eol_index NUMBER;
        l_curr_index NUMBER;
        l_msg_len NUMBER := LENGTH(msg);
        l_loop_index NUMBER := 0;
      BEGIN
        DBMS_OUTPUT.PUT_LINE(SCRIPTID || ':');
        l_eol_index := 1;
        l_curr_index := 1;
        l_loop_index := 0;
        WHILE (l_curr_index < l_msg_len AND l_loop_index < 10) LOOP
          l_eol_index := INSTR(msg, EOL, l_curr_index);
          --DBMS_OUTPUT.put_line('l_eol_index = ' || TO_CHAR(l_eol_index));
          IF (l_eol_index <= 0) OR (l_eol_index - l_curr_index) > 255 THEN
            l_msg_line := SUBSTR(msg, l_curr_index, 255);
            l_curr_index := l_curr_index + 255;
          ELSE 
            l_msg_line := SUBSTR(msg, l_curr_index, l_eol_index - l_curr_index);
            l_curr_index := l_eol_index + 1;
          END IF;
          DBMS_OUTPUT.PUT_LINE(l_msg_line);        
          l_loop_index := l_loop_index + 1;
        END LOOP;
      EXCEPTION WHEN OTHERS THEN
        DBMS_OUTPUT.PUT_LINE(SQLERRM);
      END;
    ELSE 
      DBMS_OUTPUT.put_line(SCRIPTID || ': ' || msg);
    END IF;  

  END;

-- ==========================================================================
-- put message to output controlled by TRACEON variable (uses put)
  PROCEDURE putTrace(msg VARCHAR2) IS
-- ==========================================================================
  BEGIN
    IF TRACEON THEN
      put(msg);
    END IF;
  END;

-- ==========================================================================
-- return next element id for new objects
  FUNCTION getNextElementId RETURN NUMBER
-- ==========================================================================
  IS
    l_id NUMBER;
  BEGIN
      SELECT cwmseq.nextval
        INTO l_id
        FROM DUAL;
      RETURN l_id;
  END;

-- ==========================================================================
-- return the id (elementid) for the (fully qualified) class name passed in
  FUNCTION addNewClassId(
     p_className IN VARCHAR2
  ) RETURN NUMBER
-- ==========================================================================
  IS
    l_className VARCHAR2(255) := p_className;
    l_classId NUMBER;
  BEGIN

      putTrace('Creating classIdOf(' || l_className || ')');
      
      insert into ClassDefinition_v
      (
       LOADINGPARENT                                                                                                                                                                                      
      ,DELETIONPARENT                                                                                                                                                                                     
      ,AGGREGATEDSIGNATURE                                                                                                                                                                                
      ,CLASSNAME                                                                                                                                                                                          
      ,COMPLETED                                                                                                                                                                                          
      ,CREATEDBY                                                                                                                                                                                          
      ,CREATIONTIMESTAMP                                                                                                                                                                                  
      ,CUSTOMERDELETABLE                                                                                                                                                                                  
      ,CUSTOMEREDITABLE                                                                                                                                                                                   
      ,CUSTOMERRENAMABLE                                                                                                                                                                                  
      ,DESCRIPTION                                                                                                                                                                                        
      ,DISABLED                                                                                                                                                                                           
      ,EDITABLE                                                                                                                                                                                           
      ,ELEMENTID                                                                                                                                                                                          
      ,FROZEN                                                                                                                                                                                             
      ,GENERATED                                                                                                                                                                                          
      ,IMPORTED                                                                                                                                                                                           
      ,LOGICALNAME                                                                                                                                                                                        
      ,METADATASIGNATURE                                                                                                                                                                                  
      ,NAME                                                                                                                                                                                               
      ,NOTE                                                                                                                                                                                               
      ,NOTM                                                                                                                                                                                               
      ,PERSISTENT                                                                                                                                                                                         
      ,SEEDED                                                                                                                                                                                             
      ,UOID                                                                                                                                                                                               
      ,UPDATEDBY                                                                                                                                                                                          
      ,UPDATETIMESTAMP                                                                                                                                                                                    
      ,VERSION                                                                                                                                                                                            
      ,ISLOADINGPARENT                                                                                                                                                                                    
      ,COMPARATOR                                                                                                                                                                                         
      ,EXTENSIBLE                                                                                                                                                                                         
      ,WEAKLYTYPED                                                                                                                                                                                        
      ,STEREOTYPE                                                                                                                                                                                         
      ,GENERATABLE                                                                                                                                                                                        
      ,ABSTRACT                                                                                                                                                                                           
      ,PACKAGENAME                                                                                                                                                                                        
      ,PROPERTYPARENT                                                                                                                                                                                     
      ,COMPONENTDEFINITION                                                                                                                                                                                
      ,CLASSPERSISTENT                                                                                                                                                                                    
      ,NAMESPACEPARENT                                                                                                                                                                                    
      ,NAMESPACEDOMAIN          
      )      
   VALUES
      (
       0                                           --LOADINGPARENT                                                                                                                                                                                 
      ,0                                           --DELETIONPARENT                                                                                                                                                                                
      ,null                                        --AGGREGATEDSIGNATURE                                                                                                                                                                           
      ,'ClassDefinition'                           --CLASSNAME                                                                                                                                                                                     
      ,0                                           --COMPLETED                                                                                                                                                                                     
      ,(select createdby from cmpinstallation_v)   --CREATEDBY                                                                                                                                                                                     
      ,SYSDATE                                     --CREATIONTIMESTAMP                                                                                                                                                                             
      ,0                                           --CUSTOMERDELETABLE                                                                                                                                                                             
      ,0                                           --CUSTOMEREDITABLE                                                                                                                                                                              
      ,0                                           --CUSTOMERRENAMABLE                                                                                                                                                                             
      ,null                                        --DESCRIPTION                                                                                                                                                                                   
      ,0                                           --DISABLED                                                                                                                                                                                      
      ,0                                           --EDITABLE                                                                                                                                                                                      
      ,cwmseq.nextval                              --ELEMENTID                                                                                                                                                                                     
      ,0                                           --FROZEN                                                                                                                                                                                        
      ,0                                           --GENERATED                                                                                                                                                                                     
      ,0                                           --IMPORTED                                                                                                                                                                                      
      ,p_className                                 --LOGICALNAME                                                                                                                                                                                   
      ,'77a52e43592fbeb4deadee4429001df0'          --METADATASIGNATURE                                                                                                                                                                             
      ,p_className                                 --NAME                                                                                                                                                                                          
      ,null                                        --NOTE                                                                                                                                                                                          
      ,1                                           --NOTM                                                                                                                                                                                          
      ,null                                        --PERSISTENT                                                                                                                                                                                    
      ,1                                           --SEEDED                                                                                                                                                                                        
      ,'D390EF61CD2245A2A0E71CF02FC25D76'          --UOID                                                                                                                                                                                          
      ,null                                        --UPDATEDBY                                                                                                                                                                                     
      ,sysdate                                     --UPDATETIMESTAMP                                                                                                                                                                               
      ,null                                        --VERSION                                                                                                                                                                                       
      ,1                                           --ISLOADINGPARENT                                                                                                                                                                               
      ,'ElementNameComparator'                     --COMPARATOR                                                                                                                                                                                    
      ,1                                           --EXTENSIBLE                                                                                                                                                                                    
      ,1                                           --WEAKLYTYPED                                                                                                                                                                                   
      ,2                                           --STEREOTYPE                                                                                                                                                                                    
      ,0                                           --GENERATABLE                                                                                                                                                                                   
      ,0                                           --ABSTRACT                                                                                                                                                                                      
      ,p_className                                 --PACKAGENAME                                                                                                                                                                                   
      ,0                                           --PROPERTYPARENT                                                                                                                                                                                
      ,0                                           --COMPONENTDEFINITION                                                                                                                                                                           
      ,1                                           --CLASSPERSISTENT                                                                                                                                                                               
      ,null                                        --NAMESPACEPARENT                                                                                                                                                                               
      ,null                                        --NAMESPACEDOMAIN     
      );      
      
      SELECT ELEMENTID
        INTO l_classId
        FROM ClassDefinition_v
        WHERE NAME=l_className;
      putTrace('  RETURN ' || l_classId || EOL);

    RETURN l_classId;

  END addNewClassId;


-- ==========================================================================
-- return the id (elementid) for the (fully qualified) class name passed in
  FUNCTION classIdOf(
     p_className IN VARCHAR2
  ) RETURN NUMBER
-- ==========================================================================
  IS
    l_className VARCHAR2(255) := p_className;
    l_classId NUMBER;
  BEGIN

      putTrace('classIdOf(' || l_className || ')');
      SELECT ELEMENTID
        INTO l_classId
        FROM ClassDefinition_v
        WHERE NAME=l_className;
      putTrace('  RETURN ' || l_classId || EOL);

    RETURN l_classId;
    
  EXCEPTION
    WHEN NO_DATA_FOUND THEN
    BEGIN
       -- This is currently only setup to satisfy the error raised for 
       -- bug 6045890 - Adding class 'oracle.wh.service.impl.mapping.component.dimension.Dimension'
       putTrace('  Not found - will create');
       RETURN addNewClassId('oracle.wh.service.impl.mapping.component.dimension.Dimension');
    END; -- NO_DATA_FOUND

    
  END classIdOf;

-- ==========================================================================
-- return the id (elementid) for the property set defined by the input parameters
  FUNCTION addNewPropertySet(
      p_classId  IN NUMBER
     ,p_psetType IN NUMBER
     ,p_psetName IN VARCHAR2 DEFAULT 'DEFAULT'
  ) RETURN NUMBER
-- ==========================================================================
  IS
    l_classId  NUMBER := p_classId;
    l_psetType NUMBER := p_psetType;
    l_psetName VARCHAR2(255) := p_psetName;
    l_psetId   NUMBER;
    l_newDesc  VARCHAR2(255);
  BEGIN

   -- Form the correct description 
   l_newDesc := '#' || l_psetName;
   
   insert into PropertySetDefinition_v
   ( LOADINGPARENT                         
    ,DELETIONPARENT                     
    ,AGGREGATEDSIGNATURE                
    ,CLASSNAME                          
    ,COMPLETED                          
    ,CREATEDBY                                                               
    ,CREATIONTIMESTAMP                  
    ,CUSTOMERDELETABLE                  
    ,CUSTOMEREDITABLE                   
    ,CUSTOMERRENAMABLE                   
    ,DESCRIPTION                        
    ,DISABLED                           
    ,EDITABLE                                  
    ,ELEMENTID                          
    ,FROZEN                             
    ,GENERATED                          
    ,IMPORTED                              
    ,LOGICALNAME                        
    ,METADATASIGNATURE                  
    ,NAME                               
    ,NOTE                               
    ,NOTM                               
    ,PERSISTENT                         
    ,SEEDED                             
    ,UOID                               
    ,UPDATEDBY                          
    ,UPDATETIMESTAMP                    
    ,VERSION                            
    ,ISLOADINGPARENT                    
    ,DEFINITIONKEY                      
    ,CLASSDEFINITION                    
    ,PROPERTYTYPE                       
    ,PARENTPROPERTYSETDEFINITION        
    ,PARENTCLASSDEFINITION              
    ,SUPERPROPERTYSETDEFINITION         
    ,SUPERCLASSDEFINITION               
    ,REALPROPERTYSETDEFINITION          
    )
   VALUES
   ( l_classId                                     -- LOADINGPARENT                         
     ,0                                            -- DELETIONPARENT             
     ,null                                         -- AGGREGATEDSIGNATURE        
     ,'PropertySetDefinition'                      -- CLASSNAME                  
     ,0                                            -- COMPLETED                  
     ,(select createdby from cmpinstallation_v)    -- CREATEDBY                  
     ,SYSDATE                                      -- CREATIONTIMESTAMP          
     ,0                                            -- CUSTOMERDELETABLE          
     ,0                                            -- CUSTOMEREDITABLE           
     ,0                                            -- CUSTOMERRENAMABLE          
     ,l_newDesc                                    -- DESCRIPTION                
     ,0                                            -- DISABLED                   
     ,0                                            -- EDITABLE                   
     ,cwmseq.nextval                               -- ELEMENTID                  
     ,0                                            -- FROZEN                     
     ,0                                            -- GENERATED                  
     ,0                                            -- IMPORTED                   
     ,l_psetName                                   -- LOGICALNAME                
     ,'e6318362119f88e5d6b74b1618430f81'           -- METADATASIGNATURE          
     ,l_psetName                                   -- NAME                       
     ,null                                         -- NOTE                       
     ,0                                            -- NOTM                       
     ,null                                         -- PERSISTENT                 
     ,1                                            -- SEEDED                     
     ,'44A138292EDF0BB8E040578CB00A31BC'           -- UOID                       
     ,null                                         -- UPDATEDBY                  
     ,SYSDATE                                      -- UPDATETIMESTAMP               
     ,null                                         -- VERSION                    
     ,0                                            -- ISLOADINGPARENT            
     ,'DIMENSION.PLSQL.PHYSICAL'                   -- DEFINITIONKEY              
     ,l_classId                                    -- CLASSDEFINITION            
     ,l_psetType                                   -- PROPERTYTYPE               
     ,0                                            -- PARENTPROPERTYSETDEFINITION
     ,0                                            -- PARENTCLASSDEFINITION      
     ,0                                            -- SUPERPROPERTYSETDEFINITION 
     ,0                                            -- SUPERCLASSDEFINITION       
     ,0                                            -- REALPROPERTYSETDEFINITION  
    );
 
    SELECT ELEMENTID
      INTO l_psetId
      FROM PropertySetDefinition_v
      WHERE CLASSDEFINITION=l_classId
        AND NAME=l_psetName
        AND PROPERTYTYPE=l_psetType;
    putTrace('  RETURN ' || l_psetId || EOL);
    
    RETURN l_psetId;

  END addNewPropertySet;
 
-- ==========================================================================
-- return the id (elementid) for the property set defined by the input parameters
  FUNCTION psetIdOf(
      p_classId  IN NUMBER
     ,p_psetType IN NUMBER
     ,p_psetName IN VARCHAR2 DEFAULT 'DEFAULT'
  ) RETURN NUMBER
-- ==========================================================================
  IS
    l_classId  NUMBER := p_classId;
    l_psetType NUMBER := p_psetType;
    l_psetName VARCHAR2(255) := p_psetName;
    l_psetId   NUMBER;
  BEGIN
 
      putTrace('psetIdOf(' || l_classId || ', ' || l_psetType || ', ' || l_psetName || ')');
      SELECT ELEMENTID
        INTO l_psetId
        FROM PropertySetDefinition_v
        WHERE CLASSDEFINITION=l_classId
          AND NAME=l_psetName
          AND PROPERTYTYPE=l_psetType;
      putTrace('  RETURN ' || l_psetId || EOL);
    
    RETURN l_psetId;
          
  EXCEPTION
    WHEN NO_DATA_FOUND THEN
    BEGIN
       -- This is currently only setup to satisfy the error raised for 
       -- bug 6045890 - Adding PropertySet='DIMENSION.PLSQL.PHYSICAL'
       IF CreateNew THEN
         putTrace('  Not found - will create');
         RETURN addNewPropertySet(p_classId, p_psetType, p_psetName);
       ELSE
         putTrace('  Not found - return NO_DATA_FOUND');
       END IF;
    END; -- NO_DATA_FOUND

  END psetIdOf;
  
  -- ==========================================================================
-- return the id (elementid) for the property set defined by the input parameters
  FUNCTION psetIdOf_DefKey(
      p_classId  IN NUMBER
     ,p_psetType IN NUMBER
     ,p_psetDefKey IN VARCHAR2
  ) RETURN NUMBER
-- ==========================================================================
  IS
    l_classId    NUMBER := p_classId;
    l_psetType   NUMBER := p_psetType;
    l_psetDefKey VARCHAR2(255) := p_psetDefKey;
    l_psetId     NUMBER;
  BEGIN
 
      putTrace('psetIdOf_DefKey(' || l_classId || ', ' || l_psetType || ', ' || l_psetDefKey || ')');
      SELECT ELEMENTID
        INTO l_psetId
        FROM PropertySetDefinition_v
        WHERE CLASSDEFINITION=l_classId
          AND DEFINITIONKEY=l_psetDefKey
          AND PROPERTYTYPE=l_psetType;
      putTrace('  RETURN ' || l_psetId || EOL);
    
    RETURN l_psetId;
          
  END psetIdOf_DefKey;

-- ==========================================================================
-- return the id (elementid) for the property group defined by the input parameters
  FUNCTION addNewPropertyGroup(
      p_ownerId   IN NUMBER
     ,p_groupName IN VARCHAR2
  ) RETURN NUMBER
-- ==========================================================================
  IS
    l_ownerId  NUMBER := p_ownerId;
    l_groupName VARCHAR2(255) := p_groupName;
    l_groupId   NUMBER;
  BEGIN

      putTrace('groupIdOf(' || l_ownerId || ', ' || l_groupName || ')');
      
	-- add new property group: HINTS
        insert into PropertyGroupDefinition_v 
        ( LOADINGPARENT      
         ,DELETIONPARENT     
         ,AGGREGATEDSIGNATURE
         ,CLASSNAME          
         ,COMPLETED          
         ,CREATEDBY          
         ,CREATIONTIMESTAMP  
         ,CUSTOMERDELETABLE  
         ,CUSTOMEREDITABLE   
         ,CUSTOMERRENAMABLE  
         ,DESCRIPTION        
         ,DISABLED           
         ,EDITABLE           
         ,ELEMENTID          
         ,FROZEN             
         ,GENERATED          
         ,IMPORTED           
         ,LOGICALNAME        
         ,METADATASIGNATURE  
         ,NAME               
         ,NOTE               
         ,NOTM               
         ,PERSISTENT         
         ,SEEDED             
         ,UOID               
         ,UPDATEDBY          
         ,UPDATETIMESTAMP    
         ,VERSION            
         ,ISLOADINGPARENT    
         ,DEFINITIONKEY      
         ,HIDDEN
         ,GROUPOWNER         
        ) 
        VALUES
        (
         l_ownerId                                     -- LOADINGPARENT      
         ,0                                            -- DELETIONPARENT     
         ,null                                         -- AGGREGATEDSIGNATURE
         ,'PropertyGroupDefinition'                    -- CLASSNAME          
         ,0                                            -- COMPLETED          
         ,(select createdby from cmpinstallation_v)    -- CREATEDBY                              
         ,SYSDATE                                      -- CREATIONTIMESTAMP                           
         ,0                                            -- CUSTOMERDELETABLE  
         ,0                                            -- CUSTOMEREDITABLE   
         ,0                                            -- CUSTOMERRENAMABLE  
         ,null                                         -- DESCRIPTION        
         ,0                                            -- DISABLED           
         ,0                                            -- EDITABLE           
         ,cwmseq.nextval                               -- ELEMENTID          
         ,0                                            -- FROZEN             
         ,0                                            -- GENERATED          
         ,0                                            -- IMPORTED           
         ,p_groupName                                  -- LOGICALNAME        
         ,'12787767a32e28ab4cb26ebe76a2f660'           -- METADATASIGNATURE  
         ,p_groupName                                  -- NAME               
         ,null                                         -- NOTE               
         ,0                                            -- NOTM               
         ,null                                         -- PERSISTENT         
         ,1                                            -- SEEDED             
         ,'44A138292EC70BB8E040578CB00A31BC'           -- UOID               
         ,null                                         -- UPDATEDBY          
         ,SYSDATE                                      -- UPDATETIMESTAMP    
         ,null                                         -- VERSION            
         ,0                                            -- ISLOADINGPARENT    
         ,'DATAENTITY.HINTS'                           -- DEFINITIONKEY      
         ,0                                            -- HIDDEN             
         ,l_ownerId                                    -- GROUPOWNER         
        );

      SELECT ELEMENTID
        INTO l_groupId
        FROM PropertyGroupDefinition_v
        WHERE GROUPOWNER=l_ownerId
          AND NAME=l_groupName;
      putTrace('  RETURN ' || l_groupId || EOL);

    RETURN l_groupId;
    
  END addNewPropertyGroup;
  
-- ==========================================================================
-- return the id (elementid) for the property group defined by the input parameters
  FUNCTION groupIdOf(
      p_ownerId   IN NUMBER
     ,p_groupName IN VARCHAR2
  ) RETURN NUMBER
-- ==========================================================================
  IS
    l_ownerId  NUMBER := p_ownerId;
    l_groupName VARCHAR2(255) := p_groupName;
    l_groupId   NUMBER;
  BEGIN

      putTrace('groupIdOf(' || l_ownerId || ', ' || l_groupName || ')');
      SELECT ELEMENTID
        INTO l_groupId
        FROM PropertyGroupDefinition_v
        WHERE GROUPOWNER=l_ownerId
          AND NAME=l_groupName;
      putTrace('  RETURN ' || l_groupId || EOL);

    RETURN l_groupId;
    
  EXCEPTION
    WHEN NO_DATA_FOUND THEN
    BEGIN
       -- This is currently only setup to satisfy the error raised for 
       -- bug 6045890 - Adding PropertyGroup='DATAENTITY.HINTS'
       IF CreateNew THEN
          putTrace('  Not found - will create');
          RETURN addNewPropertyGroup(p_ownerId, p_groupName); -- groupIdOf(12514, HINTS)
       ELSE
          putTrace('  Not found - return NO_DATA_FOUND');
       END IF;
    END; -- NO_DATA_FOUND

  END groupIdOf;

-- **************************************************************************
-- **************************************************************************
--                      Record handling functions/procedures
-- new<Recordtype> - create initialized record instance
-- toString        - debug 'pretty print' similar to java
-- getInitFor      - print pl/sql initialization for columns thqat need to be
--                  carried over from a live installation (METADATASIGNATURE,
--                  UOID, ...)
-- add<RecordType> - find or create row represented by this record in the OWB
--                  repository. Calls getInitFor if row already exists.
-- **************************************************************************
-- **************************************************************************


-- ==========================================================================
--                         PropertyDefinition
-- ==========================================================================

-- ==========================================================================
-- return PropertyDefinition record with given info and audit block initialized
  FUNCTION newPropertyDefinition(
     propertyName IN VARCHAR2 DEFAULT null
    ,classId      IN NUMBER   DEFAULT 0
  ) RETURN PropertyDefinition
-- ==========================================================================
  IS
    pdef PropertyDefinition;
  BEGIN
    pdef.NAME              := propertyName;
    pdef.LOGICALNAME       := propertyName;
    pdef.CLASSDEFINITION   := classId;
    pdef.LOADINGPARENT     := classId;

    pdef.CREATEDBY         := g_auditInfo.CREATEDBY;
    pdef.CREATIONTIMESTAMP := g_auditInfo.CREATIONTIMESTAMP;
    pdef.UPDATEDBY         := g_auditInfo.UPDATEDBY;
    pdef.UPDATETIMESTAMP   := g_auditInfo.UPDATETIMESTAMP;

    RETURN pdef;
  END newPropertyDefinition;

-- ==========================================================================
-- similar to Object.toString() in Java - return a string representation of the record
  FUNCTION toString(
    p_pdef PropertyDefinition
  )
  RETURN VARCHAR2
-- ==========================================================================
  IS
    l_str VARCHAR2(255) := '(PropertyDefinition)' || p_pdef.NAME || '/id=' ||
                          p_pdef.ELEMENTID;
  BEGIN
    RETURN l_str;
  END;

-- ==========================================================================
-- return pl/sql required to initialize additional PropertyDefinition fields for
-- insert (Used when running against new repos to get attributes created by the
-- OWB framework during during the install.)
  FUNCTION getInitFor(
     pdef IN PropertyDefinition
  ) RETURN VARCHAR2
-- ==========================================================================
  IS
    initsql VARCHAR2(2000);
  BEGIN

    initsql := '' || EOL ||
      '     -- getInitFor(' || toString(pdef) || ') =' || EOL ||
      '        pdef.METADATASIGNATURE := ''' || pdef.METADATASIGNATURE || ''';' || EOL ||
      '        pdef.UOID              := ''' || pdef.UOID              || ''';' || EOL ||
      '        pdef.POSITION          := '   || pdef.POSITION          || ';'   || EOL ;
--let caller decide    putTrace('  RETURN ' || initsql);

    RETURN initsql;
  END getInitFor;

-- ==========================================================================
-- add record to repository (or say existing one was found)
  PROCEDURE addPropertyDefinition(
      pdef IN OUT PropertyDefinition
  )
-- ==========================================================================
  IS
    l_datatype NUMBER;
  BEGIN
    -- This one will trigger NO_DATA_FOUND if the property does not yet exist
    -- BUGBUG: Technically we should be chasing up the heirarchy looking for this
    --        but since we need uoid etc from real install - will find out when
    --        looking for it then. HEY DUMMY- why don't you use the nifty property
    --        definition query functions you wrote for paris!! (Oooops)
    --        NOT NEEDED for this one so defer doing this for now
    l_datatype := pdef.DATATYPE; -- save the new datatype
    SELECT *
      INTO pdef
      FROM PropertyDefinition_v
     WHERE CLASSDEFINITION=pdef.CLASSDEFINITION
       AND NAME=pdef.NAME;
    put('Found (' || toString(pdef) || ')' || getInitFor(pdef));
    
    IF (l_datatype <> pdef.DATATYPE) THEN 
      put ('Update DATATYPE for ' || toString(pdef) || ' to ' || l_datatype);
      -- Domain or datatype has changed, update it in old property def
      UPDATE PropertyDefinition_v
        SET DATATYPE = l_datatype
        WHERE CLASSDEFINITION=pdef.CLASSDEFINITION
          AND NAME=pdef.NAME;
    END IF;          

  EXCEPTION
    WHEN NO_DATA_FOUND THEN
    BEGIN
      -- new def so need new element id
      pdef.ELEMENTID := getNextElementId();

      put('Creating (' || toString(pdef) || ')');
      INSERT
        INTO PropertyDefinition_v
      VALUES pdef;

      put('Requery after create...');
      SELECT *
        INTO pdef
        FROM PropertyDefinition_v
       WHERE CLASSDEFINITION=pdef.CLASSDEFINITION
         AND NAME=pdef.NAME;
      put('Created (' || toString(pdef) || ')');
    END; -- NO_DATA_FOUND
  END addPropertyDefinition;

-- ==========================================================================
--                     PropertyUsageDefinition
-- ==========================================================================

-- ==========================================================================
-- return PropertyUsageDefinition record with given info and audit block initialized
  FUNCTION newPropertyUsageDefinition(
     psetId   IN NUMBER
    ,pdef     IN PropertyDefinition
  ) RETURN PropertyUsageDefinition
-- ==========================================================================
  IS
    puse PropertyUsageDefinition;
  BEGIN
    puse.LOADINGPARENT         := pdef.LOADINGPARENT;
    puse.NAME                  := pdef.NAME;
    puse.LOGICALNAME           := pdef.LOGICALNAME;
    puse.PROPERTYSETDEFINITION := psetId;
    puse.PROPERTYDEFINITION    := pdef.ELEMENTID;
    puse.DESCRIPTION           := pdef.DESCRIPTION;

    puse.CREATEDBY         := g_auditInfo.CREATEDBY;
    puse.CREATIONTIMESTAMP := g_auditInfo.CREATIONTIMESTAMP;
    puse.UPDATEDBY         := g_auditInfo.UPDATEDBY;
    puse.UPDATETIMESTAMP   := g_auditInfo.UPDATETIMESTAMP;

    RETURN puse;
  END newPropertyUsageDefinition;

-- ==========================================================================
-- similar to Object.toString() in Java - return a string representation of the record
  FUNCTION toString(
    p_puse PropertyUsageDefinition
  )
  RETURN VARCHAR2
-- ==========================================================================
  IS
    l_str VARCHAR2(255) := '(PropertyUsageDefinition)' || p_puse.NAME || '/id=' ||
                          p_puse.ELEMENTID || '/pdef=' || p_puse.PROPERTYDEFINITION;
  BEGIN
    RETURN l_str;
  END;

-- ==========================================================================
-- return pl/sql required to initialize additional PropertyDefinition fields for
-- insert (Used when running against new repos to get attributes created by the
-- OWB framework during during the install.)
  FUNCTION getInitFor(
     puse IN PropertyUsageDefinition
  ) RETURN VARCHAR2
-- ==========================================================================
  IS
    initsql VARCHAR2(2000);
  BEGIN

    initsql := '' || EOL ||
      '     -- getInitFor(' || toString(puse) || ') =' || EOL ||
      '        puse.METADATASIGNATURE := ''' || puse.METADATASIGNATURE || ''';' || EOL ||
      '        puse.UOID              := ''' || puse.UOID              || ''';' || EOL ;
--let caller decide    putTrace('  RETURN ' || initsql);

    RETURN initsql;
  END getInitFor;

-- ==========================================================================
-- add record to repository (or say existing one was found)
  PROCEDURE addPropertyUsageDefinition(
      puse IN OUT PropertyUsageDefinition
  )
-- ==========================================================================
  IS
  BEGIN
    -- This one will trigger NO_DATA_FOUND if the property does not yet exist
    SELECT *
      INTO puse
      FROM PropertyUsageDefinition_v
     WHERE PROPERTYSETDEFINITION=puse.PROPERTYSETDEFINITION
       AND PROPERTYDEFINITION=puse.PROPERTYDEFINITION;
    put('Found (' || toString(puse) || ')' || getInitFor(puse));

  EXCEPTION
    WHEN NO_DATA_FOUND THEN
    BEGIN
      -- new def so need new element id
      puse.ELEMENTID := getNextElementId();

      put('Creating (' || toString(puse) || ')');
      INSERT
        INTO PropertyUsageDefinition_v
      VALUES puse;

      put('Requery after create...');
    SELECT *
      INTO puse
      FROM PropertyUsageDefinition_v
     WHERE PROPERTYSETDEFINITION=puse.PROPERTYSETDEFINITION
       AND PROPERTYDEFINITION=puse.PROPERTYDEFINITION;
      put('Created (' || toString(puse) || ')');
    END; -- NO_DATA_FOUND
  END addPropertyUsageDefinition;

-- ==========================================================================
--                        WBPrimitiveProperty
-- ==========================================================================

-- ==========================================================================
-- return WBPrimitiveProperty record with given info and audit block initialized
  FUNCTION newWBPrimitiveProperty(
     classId       IN NUMBER
    ,ownerId       IN NUMBER
    ,datatype      IN NUMBER
    ,propertyName  IN VARCHAR2 DEFAULT NULL
    ,propertyValue IN VARCHAR2 DEFAULT NULL
  ) RETURN WBPrimitiveProperty
-- ==========================================================================
  IS
    prim WBPrimitiveProperty;
  BEGIN
    prim.NAME          := propertyName;
    prim.LOGICALNAME   := propertyName;
    prim.OWNER         := ownerId;
    prim.LOADINGPARENT := classId;
    prim.DATATYPE      := datatype;
    prim.VALUE         := propertyValue;

    prim.CREATEDBY         := g_auditInfo.CREATEDBY;
    prim.CREATIONTIMESTAMP := g_auditInfo.CREATIONTIMESTAMP;
    prim.UPDATEDBY         := g_auditInfo.UPDATEDBY;
    prim.UPDATETIMESTAMP   := g_auditInfo.UPDATETIMESTAMP;
    
    IF (propertyName IS NOT NULL) THEN
      prim.HASNAME     := 1;
    ELSE 
      prim.HASNAME     := 0;
    END IF;  

    RETURN prim;
  END newWBPrimitiveProperty;

-- similar to Object.toString() in Java - return a string representation of the record
  FUNCTION toString(
    p_meta WBPrimitiveProperty
  )
  RETURN VARCHAR2
  IS
    l_str VARCHAR2(255) := '(WBPrimitiveProperty)' || NVL(p_meta.NAME,'NULL') ||
                           '/id=' || p_meta.ELEMENTID || '/owner=' ||
                           p_meta.OWNER || '/value=''' || p_meta.VALUE || '''';
  BEGIN
    RETURN l_str;
  END;

-- ==========================================================================
-- return pl/sql required to initialize additional WBPrimitiveProperty fields for
-- insert (Used when running against new repos to get attributes created by the
-- OWB framework during during the install.)
  FUNCTION getInitFor(
     prim IN WBPrimitiveProperty
  ) RETURN VARCHAR2
-- ==========================================================================
  IS
    initsql VARCHAR2(2000);
  BEGIN

    initsql := '' || EOL ||
      '     -- getInitFor(' || toString(prim) || ') =' || EOL ||
      '        prim.METADATASIGNATURE := ''' || prim.METADATASIGNATURE || ''';' || EOL ||
      '        prim.UOID              := ''' || prim.UOID              || ''';' || EOL ;
--      '        prim.HASNAME           := ''' || prim.HASNAME           || ''';' || EOL ||
--      '        prim.HASPOSITION       := ''' || prim.HASPOSITION       || ''';' || EOL ||
--      '        prim.POSITION          := '   || prim.POSITION          || ';'   || EOL ;
--let caller decide    putTrace('  RETURN ' || initsql);

    RETURN initsql;
  END getInitFor;

-- ==========================================================================
-- add record to repository (or say existing one was found)
  PROCEDURE addWBPrimitiveProperty(
      prim IN OUT WBPrimitiveProperty
  )
-- ==========================================================================
  IS
    l_inputValue VARCHAR(4000) := prim.VALUE;
  BEGIN
    -- This one will trigger NO_DATA_FOUND if the property does not yet exist
    -- BUGBUG: Technically we should be chasing up the heirarchy looking for this
    --        but since we need uoid etc from real install - will find out when
    --        looking for it then. HEY DUMMY- why don't you use the nifty property
    --        definition query functions you wrote for paris!! (Oooops)
    --        NOT NEEDED for this one so defer doing this for now
    IF prim.NAME IS NULL THEN
    put('Looking for primitive with owner = ' || prim.OWNER || ' and value = ' || prim.VALUE || ' and name = ' || prim.NAME);
      SELECT *
        INTO prim
        FROM WBPrimitiveProperty_v
       WHERE OWNER=prim.OWNER
         AND VALUE=prim.VALUE
         AND NAME IS NULL
         AND ROWNUM = 1;
      -- indent values ...
      put('...Found (' || toString(prim) || ')');

      put('...Update HASNAME for (' || toString(prim) || ')');
      UPDATE WBPrimitiveProperty_v
        SET HASNAME = 0 
        WHERE OWNER = prim.OWNER 
          AND VALUE = prim.VALUE
          AND NAME IS NULL;
      IF prim.UOID IS NULL THEN    
        put('...Update UOID for (' || toString(prim) || ')');
        UPDATE WBPrimitiveProperty_v
          SET UOID = RAWTOHEX(SYS_GUID())
          WHERE OWNER = prim.OWNER 
            AND VALUE = prim.VALUE
            AND NAME IS NULL;
      END IF;      
    ELSE
      put('Looking for primitive with owner = ' || prim.OWNER || ' and name = ' || prim.NAME);
      SELECT *
        INTO prim
        FROM WBPrimitiveProperty_v
       WHERE OWNER=prim.OWNER
         AND NAME=prim.NAME
         AND ROWNUM = 1;
      put('Found (' || toString(prim) || ')' || getInitFor(prim));

      put('...Update HASNAME for (' || toString(prim) || ')');
      UPDATE WBPrimitiveProperty_v
        SET HASNAME = 1
        WHERE OWNER = prim.OWNER 
          AND NAME = prim.NAME;
      put('...Update VALUE for (' || toString(prim) || ')');
      put('new value = ' || l_inputValue);
      UPDATE WBPrimitiveProperty_v
        SET VALUE = l_inputValue
        WHERE OWNER = prim.OWNER 
          AND NAME = prim.NAME;
    END IF;
    
      


  EXCEPTION
    WHEN NO_DATA_FOUND THEN
    BEGIN
      -- new def so need new element id
      prim.ELEMENTID := getNextElementId();
      
      -- Create new UOID, for case where we don't have one already (value list)
      if (prim.UOID IS NULL) THEN
        SELECT RAWTOHEX(SYS_GUID()) INTO prim.UOID FROM DUAL;
      END IF;  

      put('Creating (' || toString(prim) || ')');
      INSERT
        INTO WBPrimitiveProperty_v
      VALUES prim;

      put('Requery after create...');
      IF prim.NAME IS NULL THEN
        SELECT *
          INTO prim
          FROM WBPrimitiveProperty_v
         WHERE OWNER=prim.OWNER
           AND VALUE=prim.VALUE
           AND NAME IS NULL;
        -- indent values ...
        put('...Created (' || toString(prim) || ')');
      ELSE
        SELECT *
          INTO prim
          FROM WBPrimitiveProperty_v
         WHERE OWNER=prim.OWNER
           AND NAME=prim.NAME;
        put('Created (' || toString(prim) || ')');
      END IF;
    END; -- NO_DATA_FOUND
  END addWBPrimitiveProperty;

-- ==========================================================================
--                        WBDomain
-- ==========================================================================

-- ==========================================================================
-- return WBDomain record with given info and audit block initialized
  FUNCTION newWBDomain(
     name     IN VARCHAR2
    ,datatype IN NUMBER
  ) RETURN WBDomain
-- ==========================================================================
  IS
    domn WBDomain;
  BEGIN
    domn.NAME          := name;
    domn.LOGICALNAME   := name;
    domn.DATATYPE      := datatype;

    domn.CREATEDBY         := g_auditInfo.CREATEDBY;
    domn.CREATIONTIMESTAMP := g_auditInfo.CREATIONTIMESTAMP;
    domn.UPDATEDBY         := g_auditInfo.UPDATEDBY;
    domn.UPDATETIMESTAMP   := g_auditInfo.UPDATETIMESTAMP;

    RETURN domn;
  END newWBDomain;

-- similar to Object.toString() in Java - return a string representation of the record
  FUNCTION toString(
    domn WBDomain
  )
  RETURN VARCHAR2
  IS
    l_str VARCHAR2(255) := '(WBDomain)' || domn.NAME || '/id=' ||
                          domn.ELEMENTID;
  BEGIN
    RETURN l_str;
  END;

-- ==========================================================================
-- return pl/sql required to initialize additional WBDomain fields for
-- insert (Used when running against new repos to get attributes created by the
-- OWB framework during during the install.)
  FUNCTION getInitFor(
     domn IN WBDomain
  ) RETURN VARCHAR2
-- ==========================================================================
  IS
    initsql VARCHAR2(2000);
  BEGIN

    initsql := '' || EOL ||
      '     -- getInitFor(' || toString(domn) || ') =' || EOL ||
      '        domn.METADATASIGNATURE := ''' || domn.METADATASIGNATURE || ''';' || EOL ||
      '        domn.UOID              := ''' || domn.UOID              || ''';' || EOL ;
--      '        domn.HASNAME           := ''' || domn.HASNAME           || ''';' || EOL ||
--      '        domn.HASPOSITION       := ''' || domn.HASPOSITION       || ''';' || EOL ||
--      '        domn.POSITION          := '   || domn.POSITION          || ';'   || EOL ;
--let caller decide    putTrace('  RETURN ' || initsql);

    RETURN initsql;
  END getInitFor;

-- ==========================================================================
-- add record to repository (or say existing one was found)
-- also find/add choices (in dlst) as we don't need to keep UIOD, etc
  PROCEDURE addWBDomain(
     domn IN OUT WBDomain
    ,dlst IN NameList
  )
-- ==========================================================================
  IS
    prim WBPrimitiveProperty;
  BEGIN
    BEGIN -- need to wrap exception catching block
      -- This one will trigger NO_DATA_FOUND if the property does not yet exist
      -- BUGBUG: Technically we should be chasing up the heirarchy looking for this
      --        but since we need uoid etc from real install - will find out when
      --        looking for it then. HEY DUMMY- why don't you use the nifty property
      --        definition query functions you wrote for paris!! (Oooops)
      --        NOT NEEDED for this one so defer doing this for now
      SELECT *
        INTO domn
        FROM WBDomain_v
       WHERE NAME=domn.NAME;
      put('Found (' || toString(domn) || ')' || getInitFor(domn));

    EXCEPTION
      WHEN NO_DATA_FOUND THEN
      BEGIN
        -- new def so need new element id
        domn.ELEMENTID := getNextElementId();

        put('Creating (' || toString(domn) || ')');
        INSERT
          INTO WBDomain_v
        VALUES domn;

        put('Requery after create...');
      SELECT *
        INTO domn
        FROM WBDomain_v
       WHERE NAME=domn.NAME;
        put('Created (' || toString(domn) || ')');
      END; -- NO_DATA_FOUND
    END;

    -- dlst is list of choices - saved as unnamed WBPrimitiveProperty children
    IF dlst IS NULL THEN
      put('addWBDomain(' || toString(domn) || ', NULL) - no choices to process.' || EOL);
    ELSE
      put('addWBDomain(' || toString(domn) || ', dlst) processing ' || dlst.COUNT || ' choices...');
      FOR i IN dlst.FIRST .. dlst.LAST
      LOOP
        prim := newWBPrimitiveProperty(
                   classId       => domn.ELEMENTID
                  ,ownerId       => domn.ELEMENTID
                  ,datatype      => domn.DATATYPE
                  ,propertyName  => NULL
                  ,propertyValue => dlst(i)
                );

        addWBPrimitiveProperty(prim);
      END LOOP;
      put('addWBDomain(' || toString(domn) || ', dlst) processing ' || dlst.COUNT || ' choices finished.' || EOL);
    END IF;
  END addWBDomain;

-- ##########################################################################
-- ##########################################################################
BEGIN --    Outer block - utility functions/variables now defined
-- ##########################################################################
-- ##########################################################################

  -- =======================================================
  BEGIN -- Initialize constants and lookup tables
  -- =======================================================
    put('Initialize constants and lookup tables BEG...');

    putTrace('-- propertytypeIdOf');
    --------------------------------
    propertytypeIdOf('core')          := 0;
    propertytypeIdOf('configuration') := 2;
    propertytypeIdOf('logical')       := 1;
    propertytypeIdOf('physical')      := 2;
    propertytypeIdOf('userdefined')   := 3;

    putTrace('-- datatypeIdOf');
    ----------------------------
    DECLARE
      datatypenames NameList := NameList('String','Integer','Long','Float','Double','Timestamp','Date','Boolean');
      -- Note: String[] was stringArray in 9.2.0.4
    BEGIN
      FOR i IN datatypenames.FIRST .. datatypenames.LAST
      LOOP
        SELECT ELEMENTID INTO datatypeIdOf(datatypenames(i)) FROM WBPrimitiveType_v
        WHERE NAME=datatypenames(i);
      END LOOP;
      -- add special cases
      datatypeIdOf('int') := datatypeIdOf('Integer');
      SELECT ELEMENTID INTO datatypeIdOf('String[]') FROM WBArrayType_v
      WHERE NAME='String[]';
    END;

    putTrace('-- g_auditInfo');
    ---------------------------
    DECLARE
      CURSOR c1 IS
        SELECT CREATEDBY, CREATIONTIMESTAMP, UPDATEDBY, UPDATETIMESTAMP
        FROM CMPInstallation_v;
   -- info and g_auditInfo have different types. But because info is based on a
   -- %ROWTYPE, we can assign it to g_auditInfo as long as they have the right
   -- number of fields and the fields have the right datatypes.
      info c1%ROWTYPE;
    BEGIN
      -- audit info (just set update timestamp once for all updates.)
      SELECT CREATEDBY, CREATIONTIMESTAMP, UPDATEDBY, UPDATETIMESTAMP
      INTO info
      FROM CMPInstallation_v;
      g_auditInfo := info;
      -- Replace installations update timestamp with current sysdate
      SELECT SYSDATE INTO g_auditInfo.UPDATETIMESTAMP FROM DUAL;
    END;
    put('Initialize constants and lookup tables END.' || EOL);
  -- =======================================================
  END; -- Initialize constants and lookup tables
  -- =======================================================


  -- =======================================================
  DECLARE -- Inner block for utility function/variable usage
          -- aka 'user' declarations
  -- =======================================================
--up.xml->  <!-- definition class for slowly changing entity loading parameter properties only -->
-- We will need to determine the context hierarchy for our changes so set up
-- local variables from the class definition on down (could use record types
-- but that seems overkill as we only need the id's.

    className VARCHAR2(255);
    classId   NUMBER(9,0);

    propertySetName VARCHAR2(255);
    propertySetDefKey VARCHAR2(255);
    propertySetType NUMBER(9,0);
    propertySetId   NUMBER(9,0);

    propertyGroupName VARCHAR2(255);
    propertyGroupId   NUMBER(9,0);

-- =======================================================
   BEGIN -- Set heirarchy navigation variables
-- =======================================================

-- *****************************************************************************
-- *****************************************************************************
-- * Start Bug# 7536066
-- *****************************************************************************
-- *****************************************************************************

    BEGIN 
      dbms_output.put_line('.');
      dbms_output.put_line('.');
      dbms_output.put_line('.');
      dbms_output.put_line('.');
      dbms_output.put_line('-----------------------------------------------------------------------------');
      dbms_output.put_line('Begin class oracle.wh.repos.impl.dataProfile.CMPProfile');
      dbms_output.put_line('-----------------------------------------------------------------------------');

--up.xml->  <Class name='oracle.wh.repos.impl.dataProfile.CMPProfile'
      className := 'oracle.wh.repos.impl.dataProfile.CMPProfile';
      classId   := classIdOf(className);

--up.xml->  <PropertySet 
--up.xml->    Position='0' 
--up.xml->    definitionKey='8i.PROFILES' 
--up.xml->    name='DEFAULT' 
--up.xml->    propertyType='logical'
--up.xml->  >
      propertySetDefKey := '8i.PROFILES';
      propertySetType   := propertytypeIdOf('logical');
      propertySetId     := psetIdOf_DefKey(classId, propertySetType, propertySetDefKey);
      
--up.xml->    <PropertyGroup 
--up.xml->      definitionKey="8i.PROFILES.LOAD_CONFIGURATION"
--up.xml->      name="LOAD_CONFIGURATION"
--up.xml->    >
      
      propertyGroupName := 'LOAD_CONFIGURATION';
      propertyGroupId   := groupIdOf(classId, propertyGroupName);
      
    END;

    DECLARE -- update property 
      domn WBDomain;
      dlst NameList;
      pdef PropertyDefinition;
      puse PropertyUsageDefinition;
      dflt WBPrimitiveProperty;
    BEGIN
      dbms_output.put_line('--------------------------------------------------');
      dbms_output.put_line('Begin property FORCE_COPY_DATA');
      dbms_output.put_line('--------------------------------------------------');
--up.xml->      <Attribute
--up.xml->        Position='1'
--up.xml->        dataType='boolean'
--up.xml->        definitionKey='8i.PROFILES.LOAD_CONFIGURATION.FORCE_COPY_DATA'
--up.xml->        description='Always force a Profile.'
--up.xml->        exportControl='public'
--up.xml->        initValue='false'
--up.xml->        name='FORCE_COPY_DATA'
--up.xml->        />
--up.xml->
        pdef := newPropertyDefinition('FORCE_COPY_DATA', classId);
        pdef.PROPERTYGROUPDEFINITION := propertyGroupId; -- set 'other' parent
        pdef.PROPERTYTYPE            := propertySetType; -- and what kind of property

        pdef.DATATYPE      := datatypeIdOf('Boolean');
        pdef.DEFINITIONKEY := '8i.PROFILES.LOAD_CONFIGURATION.FORCE_COPY_DATA'; 
        pdef.DESCRIPTION   := 'Always force a Profile.';
        pdef.EXPORTCONTROL := 0; -- If this ever really gets used, make exportControlIdOf() function
        pdef.ISPASSWORD    := 0; -- is making function booleanIdOf() worth it?
        pdef.TRANSLATABLE  := 0;

        -- get real values for these by running against new install
        -- then come back and put values here
        pdef.METADATASIGNATURE := '843887a7c8cf8008eb40987a55f3d147';
        pdef.UOID              := '5C8895522F5A457CE040578CB00A4E6D';
        pdef.POSITION          := 0;

        addPropertyDefinition(pdef);

        puse := newPropertyUsageDefinition(propertySetId, pdef);

        puse.DEFINITIONKEY := '8i.PROFILES.LOAD_CONFIGURATION.FORCE_COPY_DATA';

        -- as above, get real values for these by running against new install
        -- then come back and put values here
        puse.METADATASIGNATURE := 'a57224a55ac174a95f5130a291ddd4e7';
        puse.UOID              := '5C8895522FE8457CE040578CB00A4E6D';

        addPropertyUsageDefinition(puse);

--up.xml->          initValue='false'
        dflt := newWBPrimitiveProperty(
                   classId       => puse.LOADINGPARENT
                  ,ownerId       => puse.ELEMENTID
                  ,datatype      => pdef.DATATYPE
                  ,propertyName  => 'DefaultValue'
                  ,propertyValue => 'false'
                );

        -- you guessed it, get real values for these by running against new install
        -- then come back and put values here
        dflt.METADATASIGNATURE := 'a1554f1d2c506c4c817ab7f456f7a684';
        dflt.UOID              := '5C8895522FE9457CE040578CB00A4E6D';

        addWBPrimitiveProperty(dflt);

--up.xml->        </Attribute>
    END; -- new property 

   
    BEGIN 
      dbms_output.put_line('.');
      dbms_output.put_line('.');
      dbms_output.put_line('.');
      dbms_output.put_line('.');
      dbms_output.put_line('-----------------------------------------------------------------------------');
      dbms_output.put_line('Begin class oracle.wh.repos.impl.dataProfile.CMPProfileTable');
      dbms_output.put_line('-----------------------------------------------------------------------------');

--up.xml->  <Class name='oracle.wh.repos.impl.dataProfile.CMPProfileTable'
      className := 'oracle.wh.repos.impl.dataProfile.CMPProfileTable';
      classId   := classIdOf(className);

--up.xml->  <PropertySet 
--up.xml->    Position='0' 
--up.xml->    definitionKey='8i.PROFILE_TABLES' 
--up.xml->    name='DEFAULT' 
--up.xml->    propertyType='logical'
--up.xml->  >
      propertySetDefKey := '8i.PROFILE_TABLES';
      propertySetType   := propertytypeIdOf('logical');
      propertySetId     := psetIdOf_DefKey(classId, propertySetType, propertySetDefKey);
      
--up.xml->    <PropertyGroup 
--up.xml->      definitionKey="8i.PROFILE_TABLES.LOAD_CONFIGURATION"
--up.xml->      name="LOAD_CONFIGURATION"
--up.xml->    >
      
      propertyGroupName := 'LOAD_CONFIGURATION';
      propertyGroupId   := groupIdOf(classId, propertyGroupName);
      
    END;

    DECLARE -- update property 
      domn WBDomain;
      dlst NameList;
      pdef PropertyDefinition;
      puse PropertyUsageDefinition;
      dflt WBPrimitiveProperty;
    BEGIN
      dbms_output.put_line('--------------------------------------------------');
      dbms_output.put_line('Begin property FORCE_COPY_DATA');
      dbms_output.put_line('--------------------------------------------------');
--up.xml->      <Attribute
--up.xml->        Position='6'
--up.xml->        dataType='boolean'
--up.xml->        definitionKey='8i.PROFILE_TABLES.LOAD_CONFIGURATION.FORCE_COPY_DATA'
--up.xml->        description='Determines whether to force a profile.'
--up.xml->        exportControl='public'
--up.xml->        initValue='false'
--up.xml->        name='FORCE_COPY_DATA'
--up.xml->        />
--up.xml->
        pdef := newPropertyDefinition('FORCE_COPY_DATA', classId);
        pdef.PROPERTYGROUPDEFINITION := propertyGroupId; -- set 'other' parent
        pdef.PROPERTYTYPE            := propertySetType; -- and what kind of property

        pdef.DATATYPE      := datatypeIdOf('Boolean');
        pdef.DEFINITIONKEY := '8i.PROFILE_TABLES.LOAD_CONFIGURATION.FORCE_COPY_DATA'; 
        pdef.DESCRIPTION   := 'Always force a Profile.';
        pdef.EXPORTCONTROL := 0; -- If this ever really gets used, make exportControlIdOf() function
        pdef.ISPASSWORD    := 0; -- is making function booleanIdOf() worth it?
        pdef.TRANSLATABLE  := 0;

        -- get real values for these by running against new install
        -- then come back and put values here
        pdef.METADATASIGNATURE := '9724505149ebc844f4b83b447e6864d9';
        pdef.UOID              := '5C8895523157457CE040578CB00A4E6D';

        pdef.POSITION          := 0;

        addPropertyDefinition(pdef);

        puse := newPropertyUsageDefinition(propertySetId, pdef);

        puse.DEFINITIONKEY := '8i.PROFILE_TABLES.LOAD_CONFIGURATION.FORCE_COPY_DATA';

        -- as above, get real values for these by running against new install
        -- then come back and put values here
        puse.METADATASIGNATURE := 'a57224a55ac174a95f5130a291ddd4e7';
        puse.UOID              := '5C889552317D457CE040578CB00A4E6D';

        addPropertyUsageDefinition(puse);

--up.xml->          initValue='false'
        dflt := newWBPrimitiveProperty(
                   classId       => puse.LOADINGPARENT
                  ,ownerId       => puse.ELEMENTID
                  ,datatype      => pdef.DATATYPE
                  ,propertyName  => 'DefaultValue'
                  ,propertyValue => 'false'
                );

        -- you guessed it, get real values for these by running against new install
        -- then come back and put values here
        dflt.METADATASIGNATURE := 'a1554f1d2c506c4c817ab7f456f7a684';
        dflt.UOID              := '5C889552317E457CE040578CB00A4E6D';

        addWBPrimitiveProperty(dflt);

--up.xml->        </Attribute>
    END; -- new property 
   
-- *****************************************************************************
-- *****************************************************************************
-- * End Bug# 7536066
-- *****************************************************************************
-- *****************************************************************************
   
    dbms_output.put_line('--------------------------------------------------');
    dbms_output.put_line('All Done');
    dbms_output.put_line('--------------------------------------------------');

    -- Commit all of the work.
    commit;

  EXCEPTION WHEN OTHERS THEN
    put(SQLERRM);
  
  -- =======================================================
  END; -- Inner block for utility function/variable usage
  -- =======================================================
-- ##########################################################################
END; -- Outer block for utility functions/variables
-- ##########################################################################
/






