# this is used to create pulic icon set, public expert and public transformations for consuming web service within mapping
# Make sure X11 DISAPLY is enabled when run this script
# Please refer to readme.txt for more details

#---------------------------------------------------------------
# simple proc for output
#---------------------------------------------------------------
 proc try_to_do {body} {
   set status [catch {eval $body} err_info]
   if {$status!=0} {
      puts "FAILED----$err_info"
   } else {
      puts "SUCCESS"
   }
 }

global repos_user repos_pswd repos_host repos_port repos_service
global icon_home
global impl1 impl2 pre1 main1 pre2 main2 npre1 nmain1 npre2 nmain2

#---------------------------------------------------------------
# Environment Configuration: Put your own settings here
#---------------------------------------------------------------
   puts -nonewline [format "%-43.43s" "Init................................................"]
   set repos_user "soademo"
   set repos_pswd "soademo"
   set repos_host "localhost"
   set repos_port "1521"
   set repos_service "ora111.us.oracle.com"
   set icon_home [file dirname [info script]]
   puts "SUCCESS"

#---------------------------------------------------------------
# 1. Login repository (connection info specified in cfg file)
#---------------------------------------------------------------
   puts -nonewline [format "%-43.43s" "Login...................................................."]
   try_to_do {
     global repos_user repos_pswd repos_host repos_port repos_service
     OMBCONNECT  $repos_user/$repos_pswd@$repos_host:$repos_port:$repos_service
   }

#---------------------------------------------------------------
# 2. Create icon set
#---------------------------------------------------------------
   puts -nonewline [format "%-43.43s" "Create icon set...................................................."]
   try_to_do {
      global icon_home
      OMBCC '/PUBLIC_PROJECT'
      if {[lsearch -exact [OMBLIST ICONSETS] "WS_IMAGES"]>=0} {
          OMBDROP ICONSET 'WS_IMAGES'
      }
      OMBCREATE ICONSET 'WS_IMAGES' SET PROPERTIES(CANVAS_ICON, PALETTE_ICON, TREE_ICON) VALUES ('$icon_home/C_WebService_TF.gif','$icon_home/E_WebService.gif','$icon_home/T_WebService.gif')
      OMBCOMMIT
   }

#---------------------------------------------------------------
# 3. Create Public Transformations
#---------------------------------------------------------------
set impl1 "  ws_call varchar2(30000)\;\n  soap_request varchar2(30000)\;\n  soap_respond varchar2(30000)\;\n  http_req utl_http.req\;\n  http_resp utl_http.resp\;\n  resp XMLType\;\n  i integer\;\n  rslt CLOB\;\nBEGIN\n  ws_call := ''<''||operation||'' xmlns=\"''||NAMESPACE||''\"> </''||operation||''>''\;\n  soap_request:= ''<?xml version =\"1.0\" encoding =\"UTF-8\"?> <SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\"> <SOAP-ENV:Body>'' || ws_call || ''</SOAP-ENV:Body> </SOAP-ENV:Envelope>'' \;\n http_req:= utl_http.begin_request\n            ( service_address\n            , ''POST''\n            , ''HTTP/1.1''\n            )\;\n  utl_http.set_header(http_req, ''Content-Type'', ''text/xml'')\;\n  utl_http.set_header(http_req, ''Content-Length'', length(soap_request))\;\n  utl_http.set_header(http_req, ''SOAPAction'', soap_action_uri)\;\n  utl_http.write_text(http_req, soap_request)\;\n  http_resp:= utl_http.get_response(http_req)\;\n  BEGIN\n    DBMS_LOB.CREATETEMPORARY(rslt,false)\;\n    LOOP\n      utl_http.read_line(http_resp, soap_respond)\;\n      dbms_lob.writeappend(rslt, length(soap_respond), soap_respond)\;\n    END LOOP\;\n  EXCEPTION\n    WHEN utl_http.end_of_body THEN\n    utl_http.end_response(http_resp)\;\n  END\;\n\n  resp:= XMLType.createXML(rslt)\;\n  DBMS_LOB.FREETEMPORARY(rslt)\;\n  resp:= resp.extract(''/soap:Envelope/soap:Body/child::node()''\n                   , ''xmlns:soap=http://schemas.xmlsoap.org/soap/envelope/''\n                   )\;\n  return resp\;\nEND\;"

set impl2 "  ws_call varchar2(30000)\;\n  soap_request varchar2(30000)\;\n  soap_respond varchar2(30000)\;\n  http_req utl_http.req\;\n  http_resp utl_http.resp\;\n  resp XMLType\;\n  i integer\;\n  rslt CLOB\;\nBEGIN\n  ws_call := ''<''||operation||'' xmlns=\"''||NAMESPACE||''\">'' || parameters ||'' </''||operation||''>''\;\n  soap_request:= ''<?xml version =\"1.0\" encoding =\"UTF-8\"?> <SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\"> <SOAP-ENV:Body>'' || ws_call || ''</SOAP-ENV:Body> </SOAP-ENV:Envelope>'' \;\n http_req:= utl_http.begin_request\n            ( service_address\n            , ''POST''\n            , ''HTTP/1.1''\n            )\;\n  utl_http.set_header(http_req, ''Content-Type'', ''text/xml'')\;\n  utl_http.set_header(http_req, ''Content-Length'', length(soap_request))\;\n  utl_http.set_header(http_req, ''SOAPAction'', soap_action_uri)\;\n  utl_http.write_text(http_req, soap_request)\;\n  http_resp:= utl_http.get_response(http_req)\;\n  BEGIN\n    DBMS_LOB.CREATETEMPORARY(rslt,false)\;\n    LOOP\n      utl_http.read_line(http_resp, soap_respond)\;\n      dbms_lob.writeappend(rslt, length(soap_respond), soap_respond)\;\n    END LOOP\;\n  EXCEPTION\n    WHEN utl_http.end_of_body THEN\n    utl_http.end_response(http_resp)\;\n  END\;\n\n  resp:= XMLType.createXML(rslt)\;\n  DBMS_LOB.FREETEMPORARY(rslt)\;\n  resp:= resp.extract(''/soap:Envelope/soap:Body/child::node()''\n                   , ''xmlns:soap=http://schemas.xmlsoap.org/soap/envelope/''\n                   )\;\n  return resp\;\nEND\;"

   puts -nonewline [format "%-43.43s" "Create WB_WEBSERVICE package...................................................."]
   try_to_do {
      OMBCC 'WB_CUSTOM_TRANS'
      if {[lsearch -exact [OMBLIST PACKAGES] "WB_WEBSERVICE"]>=0} {
          OMBDROP PACKAGE 'WB_WEBSERVICE'
      }
      OMBCREATE PACKAGE 'WB_WEBSERVICE' SET PROPERTIES(DESCRIPTION) VALUES('This package is used to execute web service through UTL_HTTP package')
   }

   puts -nonewline [format "%-36.36s" "Create HTTP_SET_PROXY procedure...................................................."]
   try_to_do {
      OMBCC 'WB_WEBSERVICE'
      OMBCREATE PROCEDURE 'HTTP_SET_PROXY' SET PROPERTIES(DESCRIPTION) VALUES('This procedure set the http proxy, used as pre-mapping process in mapping')

      OMBALTER PROCEDURE 'HTTP_SET_PROXY' ADD PARAMETER 'HOSTNAME' SET PROPERTIES(DATATYPE,IN_OUT) VALUES('VARCHAR2','IN') \
          ADD PARAMETER 'PORT' SET PROPERTIES(DATATYPE,IN_OUT) VALUES('VARCHAR2','IN')
      OMBALTER PROCEDURE 'HTTP_SET_PROXY' SET PROPERTIES(IMPLEMENTATION) VALUES('BEGIN \n UTL_HTTP.SET_PROXY(HOSTNAME||'':''||PORT,NULL)\;\n END\;')
   }

   puts -nonewline [format "%-36.36s" "Create WS_INVOKE function...................................................."]
   try_to_do {
      global impl1
      OMBCREATE FUNCTION 'WS_INVOKE' SET PROPERTIES(DESCRIPTION) VALUES('This function call web service without parameters')

      OMBALTER FUNCTION 'WS_INVOKE' ADD PARAMETER 'SERVICE_ADDRESS' SET PROPERTIES(DATATYPE,IN_OUT) VALUES('VARCHAR2','IN') \
        ADD PARAMETER 'SOAP_ACTION_URI' SET PROPERTIES(DATATYPE,IN_OUT) VALUES('VARCHAR2','IN') \
        ADD PARAMETER 'OPERATION' SET PROPERTIES(DATATYPE,IN_OUT) VALUES('VARCHAR2','IN') \
        ADD PARAMETER 'NAMESPACE' SET PROPERTIES(DATATYPE,IN_OUT) VALUES('VARCHAR2','IN')
      OMBALTER FUNCTION 'WS_INVOKE' SET PROPERTIES(RETURN_TYPE,IMPLEMENTATION) VALUES('XMLTYPE','$impl1')
   }

   puts -nonewline [format "%-36.36s" "Create WS_INVOKE_P function...................................................."]
   try_to_do {
      global impl2
      OMBCREATE FUNCTION 'WS_INVOKE_P' SET PROPERTIES(DESCRIPTION) VALUES('This function call web service with parameters')

      OMBALTER FUNCTION 'WS_INVOKE_P' ADD PARAMETER 'SERVICE_ADDRESS' SET PROPERTIES(DATATYPE,IN_OUT) VALUES('VARCHAR2','IN') \
        ADD PARAMETER 'SOAP_ACTION_URI' SET PROPERTIES(DATATYPE,IN_OUT) VALUES('VARCHAR2','IN') \
        ADD PARAMETER 'OPERATION' SET PROPERTIES(DATATYPE,IN_OUT) VALUES('VARCHAR2','IN') \
        ADD PARAMETER 'NAMESPACE' SET PROPERTIES(DATATYPE,IN_OUT) VALUES('VARCHAR2','IN') \
        ADD PARAMETER 'PARAMETERS' SET PROPERTIES(DATATYPE,IN_OUT) VALUES('VARCHAR2','IN')
      OMBALTER FUNCTION 'WS_INVOKE_P' SET PROPERTIES(RETURN_TYPE,IMPLEMENTATION) VALUES('XMLTYPE','$impl2')
   }

   OMBCOMMIT

#---------------------------------------------------------------
# 4. Create Public Expert 1
#---------------------------------------------------------------
set pre1 "OMBCC ''\$OMB_CURRENT_PROJECT/WB_CUSTOM_TRANS''\n set packageList \[OMBLIST PACKAGES]\n set PACKAGE_FOLDERS \"FOLDER_1\"\n foreach fold \$packageList {\n   append PACKAGE_FOLDERS \",\"\n   append PACKAGE_FOLDERS \$fold\n }"

set main1 "OMUPROMPT DIALOG ''DLG1'' SET PROPERTIES(TITLE, LINE_WRAP, OPTIONS, DEFAULT_OPTION, CANCEL_OPTION) VALUES(''Select Package Folder'', 2, ''OK,Cancel'', ''OK'', ''Cancel'') ADD COMBO_BOX ''COMP1'' SET PROPERTIES(MESSAGE_TEXT,CONTENT,SELECTION) VALUES(''Package Folder:'',''\$PACKAGE_FOLDERS'',''FOLDER_1'')"

set pre2 " global FOLD_NAME\n set fold \[string toupper \[lindex \[lindex \$FOLD_NAME 1] 1] ]\n catch {\n    OMBCREATE PACKAGE ''\$fold''\n }\n OMBCC ''\$fold''"

set main2 "# generate metadata according to specified function\n\n# create function\nproc createFunction { service_address soap_action_uri oper_name name_space param_list } {\n    set p_oper_name \[string toupper \$oper_name]\n\n    OMBCREATE FUNCTION ''\$p_oper_name'' SET PROPERTIES (RETURN_TYPE) VALUES (''XMLTYPE'')\n    set param_impl \"\"\n    foreach param \$param_list {\n        set param_name \[string toupper \$param]\n        OMBALTER FUNCTION ''\$p_oper_name'' ADD PARAMETER ''\$param_name'' SET PROPERTIES (DATATYPE) VALUES(''VARCHAR2'')\n        append param_impl \"<\$param>''''||\$param_name||''''</\$param>\"\n    }\n    OMBALTER FUNCTION ''\$p_oper_name'' SET PROPERTIES (IMPLEMENTATION) VALUES(''BEGIN  return WB_WEBSERVICE.WS_INVOKE_P(''''\$service_address'''',''''\$soap_action_uri'''',''''\$oper_name'''',''''\$name_space'''',''''\$param_impl'''')\\; END\\;'')\n    #set icon set\n    set ics \[OMBLIST ICONSETS]\n    set xmlexists \[lsearch \$ics WS_IMAGES]\n    if {\$xmlexists != -1} {\n       OMBALTER FUNCTION ''\$p_oper_name'' SET REF ICONSET ''WS_IMAGES''\n    }\n}\n\nset wsdl \[lindex \[lindex \$RET_VAL 1] 1]\nset pdlg \[java::new oracle.wh.ui.processflow.editor.WebServicePopupDialog \$wsdl]\nset chooseComplete \[\$pdlg {runDialog  boolean} true]\nif { \$chooseComplete } {\n    set num \[\$pdlg countSelectedNodes]\n    \n    for {set idx 0} {\$idx<\$num} {incr idx} {\n      set service_address \[\$pdlg getServiceAddress \$idx]\n      set soap_action_uri \[\$pdlg getSoapActionURI \$idx]\n      set name_space \[\$pdlg getNameSpace]\n      set oper_name \[\$pdlg getFullSignature \$idx]\n\n      #oper_name is a full name with operation name and parameter list\n      set oper_list \[split \$oper_name \"()\"]\n      set oper_name \[lindex \$oper_list 0]\n      set param_str \"\"\n      if {\[llength \$oper_list]>2} {\n          set param_list \[lindex \$oper_list 1]\n          set param_list \[split \$param_list \",\"]\n          foreach node \$param_list {\n            set attr_list \[split \$node \" \"]\n            set attr \[lindex \$attr_list 1]\n            lappend param_str \$attr\n          }\n      }\n\n      createFunction \$service_address \$soap_action_uri \$oper_name \$name_space \$param_str\n    }\n}\n"

   puts -nonewline [format "%-43.43s" "Create WSDL_ETL module...................................................."]
   try_to_do {
      OMBCC '/PUBLIC_PROJECT'
      if {[lsearch -exact [OMBLIST EXPERT_MODULES] "WSDL_ETL"]>=0} {
          OMBDROP EXPERT_MODULE 'WSDL_ETL'
      }
      OMBCREATE EXPERT_MODULE 'WSDL_ETL' SET PROPERTIES(DESCRIPTION) VALUES('Hold experts for manipulate WSDL')
   }

   puts -nonewline [format "%-36.36s" "CREATE_FUNCTION_FROM_WSDL...................................................."]
   try_to_do {
      OMBCC 'WSDL_ETL'
      OMBCREATE EXPERT 'CREATE_FUNCTION_FROM_WSDL' SET PROPERTIES(BUSINESS_NAME, DESCRIPTION) VALUES('CREATE_FUNCTION_FROM_WSDL','This is used to create functions from WSDL file')
      OMBALTER EXPERT 'CREATE_FUNCTION_FROM_WSDL' ADD VARIABLE 'FOLD_NAME' ADD VARIABLE 'RET_VAL' ADD VARIABLE 'PACKAGE_FOLDERS'

      OMBALTER EXPERT 'CREATE_FUNCTION_FROM_WSDL' \
        ADD CUSTOM_DIALOG TASK 'SELECT_WSDL' SET PROPERTIES(MAIN) VALUES('OMUPROMPT DIALOG ''DLG1'' SET PROPERTIES(TITLE,LINE_WRAP, OPTIONS, DEFAULT_OPTION, CANCEL_OPTION) VALUES(''Select WSDL File'', 2, ''OK,Cancel'', ''OK'', ''Cancel'') ADD FILE_CHOOSER ''COMP1'' SET PROPERTIES(CONTENT,SELECTION) VALUES(''WSDL File:'',''FILES_AND_DIRECTORIES'')')

      global pre1 main1
      OMBALTER EXPERT 'CREATE_FUNCTION_FROM_WSDL' ADD CUSTOM_DIALOG TASK 'SELECT_FOLDER' SET PROPERTIES(PREPROCESSING,MAIN) VALUES('$pre1','$main1')
      OMBALTER EXPERT 'CREATE_FUNCTION_FROM_WSDL' MODIFY PARAMETER 'RETURN_VALUE' OF TASK 'SELECT_FOLDER' BIND TO VARIABLE 'FOLD_NAME' \
          MODIFY PARAMETER 'RETURN_VALUE' OF TASK 'SELECT_WSDL' BIND TO VARIABLE 'RET_VAL'
      
      global pre2 main2
      OMBALTER EXPERT 'CREATE_FUNCTION_FROM_WSDL' ADD OMB TASK 'CREATE_FUNCTION' SET PROPERTIES(PREPROCESSING,MAIN) VALUES('$pre2','$main2')

      OMBALTER EXPERT 'CREATE_FUNCTION_FROM_WSDL' ADD TRANSITION 'T1' FROM TASK 'START_TASK' TO 'SELECT_WSDL'\
          ADD TRANSITION 'T2' FROM TASK 'SELECT_WSDL' TO 'SELECT_FOLDER' SET PROPERTIES(TRANSITION_CONDITION) VALUES('SUCCESS') \
          ADD TRANSITION 'T3' FROM TASK 'SELECT_WSDL' TO 'END_TASK' SET PROPERTIES(TRANSITION_CONDITION) VALUES('ERROR') \
          ADD TRANSITION 'T4' FROM TASK 'SELECT_FOLDER' TO 'CREATE_FUNCTION' SET PROPERTIES(TRANSITION_CONDITION) VALUES('SUCCESS') \
          ADD TRANSITION 'T5' FROM TASK 'SELECT_FOLDER' TO 'END_TASK' SET PROPERTIES(TRANSITION_CONDITION) VALUES('ERROR') \
          ADD TRANSITION 'T6' FROM TASK 'CREATE_FUNCTION' TO 'END_TASK'
   }

   OMBCOMMIT

#---------------------------------------------------------------
# 5. Create Public Expert 2
#---------------------------------------------------------------
set npre1 "OMBCC ''\$OMB_CURRENT_PROJECT''\n set packageList \[OMBLIST PLUGGABLE_MAPPING_FOLDERS]\n set PACKAGE_FOLDERS \"FOLDER_1\"\n foreach fold \$packageList {\n   append PACKAGE_FOLDERS \",\"\n   append PACKAGE_FOLDERS \$fold\n }"

set nmain1 "OMUPROMPT DIALOG ''DLG1'' SET PROPERTIES(TITLE, LINE_WRAP, OPTIONS, DEFAULT_OPTION, CANCEL_OPTION) VALUES(''Select Pluggable Mapping Folder'', 2, ''OK,Cancel'', ''OK'', ''Cancel'') ADD COMBO_BOX ''COMP1'' SET PROPERTIES(MESSAGE_TEXT,CONTENT,SELECTION) VALUES(''Pluggable Mapping Folder:'',''\$PACKAGE_FOLDERS'',''FOLDER_1'')"

set npre2 " global FOLD_NAME\n set fold \[string toupper \[lindex \[lindex \$FOLD_NAME 1] 1] ]\n catch {\n    OMBCREATE PLUGGABLE_MAPPING_FOLDER ''\$fold''\n }\n OMBCC ''\$fold''"

set nmain2 "# \n# This depends on the Oracle XML Schema API to traverse the XML schema \n# and generate the OWB pluggable mappings. \n#\n# This depends on the Oracle WSDL API to traverse the WSDL.\n#\n# Notes: \n# The name generation is not fantastic, compressing XML schema names to 30 chars\n# \nglobal PLUGNAMES \nglobal PLUGNAMECNT \nglobal FUNCNAMECNT\nglobal HASHNAMES \nglobal HASHNAMECNT \nglobal XMLSCHEMAPACKAGE\nglobal schemaNS\nglobal jxml_schema_object\nglobal jdefinition\nglobal TYPETOOWBMAP\nglobal OutputMap\nglobal NameSpaceValue \nset XMLSCHEMAPACKAGE \"oracle.xml.parser.schema\"\n#\n#   ATTRIBUTE processing\n#\nproc processAttribute {item xe pplug plug_name} {\n  global HASHNAMES \n  global HASHNAMECNT \n  global PLUGNAMES \n  global PLUGNAMECNT \n  global XMLSCHEMAPACKAGE\n  global NameSpaceValue \n\n  catch {\n            set xmlAttName \"\"\n            if {\[java::instanceof \[\$xe getType\] \$XMLSCHEMAPACKAGE.XSDComplexType\] == 1} { \n              set xmlAttName \[\$xe getName\] \n            } else {\n              set xmlAttName \[\$xe getName\] \n            }\n            set attName \[string range \[string toupper \$xmlAttName\] 0 28\] \n \n            set attName \[string map {\"-\" \"\"} \$attName\] \n            set exists \[\$HASHNAMES get \$attName\] \n            # Generate a unique name for the att \n            while {\[java::isnull \$exists\] != 1} { \n              incr HASHNAMECNT \n              set attName \[string range \[string toupper \$xmlAttName\] 0 26\] \n              set attName \"\$attName\$HASHNAMECNT\" \n              set attName \[string map {\"-\" \"\"} \$attName\] \n              set exists \[\$HASHNAMES get \$attName\] \n            } \n            \$HASHNAMES put \$attName 1\n\n            # Define an attribute for attribute, or for a composite complex item \n            # shawn added - if maxOccurs>0, add Iterator operator\n            set xpath \"/\[\$item getName\]\" \n            if {\[\$xe getMaxOccurs\]>1} {\n              OMBALTER PLUGGABLE_MAPPING ''\$pplug'' ADD EXPRESSION OPERATOR ''XS_\$plug_name''\n              OMBALTER PLUGGABLE_MAPPING ''\$pplug'' ADD ITERATOR OPERATOR ''IT_\$plug_name''\n              OMBALTER PLUGGABLE_MAPPING ''\$pplug'' ADD ATTRIBUTE ''XML_SOURCE'' OF GROUP ''INGRP1'' OF OPERATOR ''XS_\$plug_name'' SET PROPERTIES (DATATYPE, BUSINESS_NAME) VALUES (''XMLTYPE'', ''XML Source'') \n              OMBALTER PLUGGABLE_MAPPING ''\$pplug'' ADD ATTRIBUTE ''XML_COLLECTION'' OF GROUP ''OUTGRP1'' OF OPERATOR ''XS_\$plug_name'' SET PROPERTIES (DATATYPE, EXPRESSION, BUSINESS_NAME) VALUES (''SYS.XMLSEQUENCETYPE'', ''XMLSEQUENCE(extract(INGRP1.XML_SOURCE,''''\$xpath/\$xmlAttName'''', ''''\$NameSpaceValue''''))'', ''XML Collection'')\n              OMBALTER PLUGGABLE_MAPPING ''\$pplug''  DELETE CONNECTION FROM OPERATOR ''INPUT_SIGNATURE'' TO OPERATOR ''EX_\$plug_name''\n            OMBCOMMIT\n              OMBALTER PLUGGABLE_MAPPING ''\$pplug''  ADD CONNECTION FROM ATTRIBUTE ''XML_SOURCE'' OF GROUP ''INGRP1'' OF OPERATOR ''INPUT_SIGNATURE'' TO ATTRIBUTE ''XML_SOURCE'' OF GROUP ''INGRP1'' OF OPERATOR ''XS_\$plug_name''\n              OMBALTER PLUGGABLE_MAPPING ''\$pplug''  ADD CONNECTION FROM ATTRIBUTE ''XML_COLLECTION'' OF GROUP ''OUTGRP1'' OF OPERATOR ''XS_\$plug_name'' TO GROUP ''INGRP1'' OF OPERATOR ''IT_\$plug_name''\n              OMBALTER PLUGGABLE_MAPPING ''\$pplug''  ADD CONNECTION FROM ATTRIBUTE ''XML_COLLECTION'' OF GROUP ''OUTGRP1'' OF OPERATOR ''IT_\$plug_name'' TO ATTRIBUTE ''XML_SOURCE'' OF GROUP ''INGRP1'' OF OPERATOR ''EX_\$plug_name''\n\n            if {\[java::instanceof \[\$xe getType\] \$XMLSCHEMAPACKAGE.XSDComplexType\] == 1} {\n                OMBALTER PLUGGABLE_MAPPING ''\$pplug'' ADD ATTRIBUTE ''\$attName'' OF GROUP ''OUTGRP1'' OF OPERATOR ''EX_\$plug_name'' SET PROPERTIES (DATATYPE, EXPRESSION, BUSINESS_NAME) VALUES (''XMLTYPE'', ''extract(INGRP1.XML_SOURCE, ''''/\$xmlAttName'''', ''''\$NameSpaceValue'''')'', ''\$xmlAttName'') \n            } else {\n                OMBALTER PLUGGABLE_MAPPING ''\$pplug'' ADD ATTRIBUTE ''\$attName'' OF GROUP ''OUTGRP1'' OF OPERATOR ''EX_\$plug_name'' SET PROPERTIES (DATATYPE,LENGTH, EXPRESSION, BUSINESS_NAME) VALUES (''VARCHAR2'', 4000, ''extractValue(INGRP1.XML_SOURCE, ''''/\$xmlAttName'''', ''''\$NameSpaceValue'''')'', ''\$xmlAttName'')\n              }\n          } else {\n            if {\[java::instanceof \[\$xe getType\] \$XMLSCHEMAPACKAGE.XSDComplexType\] == 1} {\n                OMBALTER PLUGGABLE_MAPPING ''\$pplug'' ADD ATTRIBUTE ''\$attName'' OF GROUP ''OUTGRP1'' OF OPERATOR ''EX_\$plug_name'' SET PROPERTIES (DATATYPE, EXPRESSION, BUSINESS_NAME) VALUES (''XMLTYPE'', ''extract(INGRP1.XML_SOURCE, ''''\$xpath/\$xmlAttName'''', ''''\$NameSpaceValue'''')'', ''\$xmlAttName'') \n            } else {\n                OMBALTER PLUGGABLE_MAPPING ''\$pplug'' ADD ATTRIBUTE ''\$attName'' OF GROUP ''OUTGRP1'' OF OPERATOR ''EX_\$plug_name'' SET PROPERTIES (DATATYPE,LENGTH, EXPRESSION, BUSINESS_NAME) VALUES (''VARCHAR2'', 4000, ''extractValue(extract(INGRP1.XML_SOURCE,''''\$xpath/\$xmlAttName'''', ''''\$NameSpaceValue''''),''''/\$xmlAttName'''', ''''\$NameSpaceValue'''')'', ''\$xmlAttName'') \n              }\n            }\n\n            OMBALTER PLUGGABLE_MAPPING ''\$pplug'' ADD CONNECTION FROM ATTRIBUTE ''\$attName'' OF GROUP ''OUTGRP1'' OF OPERATOR ''EX_\$plug_name'' TO GROUP ''OUTGRP1'' OF OPERATOR ''OUTPUT_SIGNATURE'' \n            if {\[java::instanceof \[\$xe getType\] \$XMLSCHEMAPACKAGE.XSDComplexType\] == 1} { \n              processElement \$item \$xe \n            }             \n  }\n}\n\n#\n#   GROUP processing\n#\nproc processGroup {item ob pplug plug_name} {\n  global HASHNAMES \n  global HASHNAMECNT \n  global PLUGNAMES \n  global PLUGNAMECNT \n  global XMLSCHEMAPACKAGE\n        if {\[java::instanceof \$ob \$XMLSCHEMAPACKAGE.XSDGroup\] == 1} { \n            set xg \[java::cast \$XMLSCHEMAPACKAGE.XSDGroup \$ob\] \n            set pts \[\$xg getNodeVector\]\n            for {set ij 0} {\$ij < \[\$pts size\]} {incr ij} { \n              set obg \[\$pts get \$ij\] \n              if {\[java::instanceof \$obg \$XMLSCHEMAPACKAGE.XSDGroup\] == 1} { \n                set obgg \[java::cast \$XMLSCHEMAPACKAGE.XSDGroup \$obg\] \n                processGroup \$item \$obgg \$pplug \$plug_name\n              } else {\n                set obgg \[java::cast \$XMLSCHEMAPACKAGE.XSDElement \$obg\] \n                processAttribute \$item \$obgg \$pplug \$plug_name\n              }\n            }\n        }\n}\n\n#\n#   ELEMENT processing - a recursive routine.\n#\n# Elements may have been processed through recursion that are also being processed\n# by createXMLUtils in the top level element loop - this is handled. \n#\nproc processElement {parent item} { \n  global HASHNAMES \n  global HASHNAMECNT \n  global PLUGNAMES \n  global PLUGNAMECNT \n  global XMLSCHEMAPACKAGE\n  global TYPETOOWBMAP\n  global NameSpaceValue\n  \n  set pfx \"A\"\n  set HASHNAMECNT 0 \n  set HASHNAMES \[java::new java.util.Hashtable\] \n  set eee \[java::cast \$XMLSCHEMAPACKAGE.XSDElement \$item\]\n  set td \[\$eee getType\] \n\n  set origplug \[\$item getName\] \n  set plug_name \[string range \[string toupper \[\$item getName\]\] 0 26\] \n  set plug_name \[string map {\"-\" \"\"} \$plug_name\] \n \n  set l 28 \n  set plug \[string range \[string toupper \[\$item getName\]\] 0 \$l\] \n  set plug \[string map {\"-\" \"\"} \$plug\] \n  \n  # Check if the element has already been processed.\n  set exists \[\$PLUGNAMES get \$plug\] \n  if {\[string length \$plug\] <= 29 && \[java::isnull \$exists\] != 1} { \n    return \n  } \n\n  # Generate a unique name for the map and operators \n  while {\[java::isnull \$exists\] != 1} { \n     incr PLUGNAMECNT \n     set plug \[string range \[string toupper \[\$item getName\]\] 0 \$l\] \n     set plug \"\$plug\$PLUGNAMECNT\" \n     if {\[string length \$plug\] >30} { \n       set l 27 \n       set plug \[string range \[string toupper \[\$item getName\]\] 0 \$l\] \n       set plug \"\$plug\$PLUGNAMECNT\" \n     } \n     set origplug \[\$item getName\] \n     set origplug \"\$origplug\$PLUGNAMECNT\" \n     set plug \[string map {\"-\" \"\"} \$plug\] \n     set exists \[\$PLUGNAMES get \$plug\] \n   } \n   set plug \[string map {\"-\" \"\"} \$plug\] \n   \$PLUGNAMES put \$plug 1 \n \n   # XML Namespace \n   set ns \[\$item getRefNamespace\] \n\n  set pplug \$plug\n  set rst 0\n  # create pluggable mapping\n  catch { \n    OMBCREATE PLUGGABLE_MAPPING ''\$plug'' SET PROPERTIES (BUSINESS_NAME, DESCRIPTION) VALUES (''\$origplug'', ''XML Namespace: \$ns  XML Name: \$origplug'') \n  } rst\n  if {\[string first created \$rst\] == -1} {\n    set pplug \$plug\\_1\n    OMBCREATE PLUGGABLE_MAPPING ''\$pplug'' SET PROPERTIES (BUSINESS_NAME, DESCRIPTION) VALUES (''\$origplug'', ''XML Namespace: \$ns  XML Name: \$origplug'') \n  }\n  \$TYPETOOWBMAP put \[\$item getName\] \$pplug\n  catch {\n    set ics \[OMBLIST ICONSETS\]\n    set xmlexists \[lsearch \$ics XML_IMAGES\]\n    if {\$xmlexists != -1} {\n      OMBALTER PLUGGABLE_MAPPING ''\$pplug'' SET REF ICONSET ''XML_IMAGES''\n    }\n  }\n  # add attributes to input signature\n  OMBALTER PLUGGABLE_MAPPING ''\$pplug'' ADD ATTRIBUTE ''XML_SOURCE'' OF GROUP ''INGRP1'' OF OPERATOR ''INPUT_SIGNATURE'' SET PROPERTIES (DATATYPE, BUSINESS_NAME) VALUES (''XMLTYPE'', ''XML Source'') \n\n  # add 1 expression operators \n  OMBALTER PLUGGABLE_MAPPING ''\$pplug'' ADD EXPRESSION OPERATOR ''EX_\$plug_name'' \n\n  set xmlseqpath \"/\[\$item getName\]\" \n  if {\[java::isnull \$parent\] != 1} { \n    set xmlseqpath \"/\[\$parent getName\]/\[\$item getName\]\" \n  }\n  \n  # add attribute to EX and connect from input to EX\n  OMBALTER PLUGGABLE_MAPPING ''\$pplug'' ADD CONNECTION FROM ATTRIBUTE ''XML_SOURCE'' OF GROUP ''INGRP1'' OF OPERATOR ''INPUT_SIGNATURE'' TO GROUP ''INGRP1'' OF OPERATOR ''EX_\$plug_name'' \n\n  set xpath \"/\[\$item getName\]\" \n                         \n  # if item complex type, do incursive routing \n  if {\[java::instanceof \$td \$XMLSCHEMAPACKAGE.XSDComplexType\] == 1} { \n    # handle attributes\n    set aol \[\[java::cast \$XMLSCHEMAPACKAGE.XSDComplexType \$td\] getAttributeDeclarations\] \n    for {set aio 0} {\$aio < \[\$aol length\]} {incr aio} { \n      set ob \[\$aol get \$aio\] \n      if {\[java::instanceof \$ob \$XMLSCHEMAPACKAGE.XSDAttribute\] == 1} { \n        set ad \[java::cast \$XMLSCHEMAPACKAGE.XSDAttribute  \$ob\] \n        set xmlAttName \[\$ad getName\] \n        set attName \[string range \[string toupper \$xmlAttName\] 0 28\] \n        set attName \[string map {\"-\" \"\"} \$attName\] \n        set exists \[\$HASHNAMES get \$attName\] \n        # Generate a unique name for the att \n        while {\[java::isnull \$exists\] != 1} { \n          incr HASHNAMECNT \n          set attName \[string range \[string toupper \$xmlAttName\] 0 26\] \n          set attName \"\$attName\$HASHNAMECNT\" \n          set attName \[string map {\"-\" \"\"} \$attName\] \n          set exists \[\$HASHNAMES get \$attName\] \n        } \n        \$HASHNAMES put \$attName 1 \n\n          OMBALTER PLUGGABLE_MAPPING ''\$pplug'' ADD ATTRIBUTE ''\$pfx\$attName'' OF GROUP ''OUTGRP1'' OF OPERATOR ''EX_\$plug_name'' SET PROPERTIES (DATATYPE,LENGTH,EXPRESSION, BUSINESS_NAME) VALUES (''VARCHAR2'', 4000, ''extractValue(INGRP1.XML_OBJECT,''''\$xpath/@\$xmlAttName'''', ''''\$NameSpaceValue'''')'', ''\$xmlAttName'') \n        OMBALTER PLUGGABLE_MAPPING ''\$pplug'' ADD CONNECTION FROM ATTRIBUTE ''\$pfx\$attName'' OF GROUP ''OUTGRP1'' OF OPERATOR ''EX_\$plug_name'' TO GROUP ''OUTGRP1'' OF OPERATOR ''OUTPUT_SIGNATURE'' \n      }\n    }\n    # handle child elements\n    if {\[java::isnull \$td\] != 1 && \[java::instanceof \$td \$XMLSCHEMAPACKAGE.XSDComplexType\] == 1} { \n      set btt \[\[java::cast \$XMLSCHEMAPACKAGE.XSDComplexType \$td\] getBaseType\]\n      set ol \[\[java::cast \$XMLSCHEMAPACKAGE.XSDComplexType \$td\] getElementSet\] \n      if {\[java::isnull \$ol\] != 1} {\n        for {set io 0} {\$io < \[\$ol length\]} {incr io} { \n          set ob \[\$ol get \$io\] \n          if {\[java::instanceof \$ob \$XMLSCHEMAPACKAGE.XSDGroup\] == 1} { \n              set xg \[java::cast \$XMLSCHEMAPACKAGE.XSDGroup \$ob\] \n              processGroup \$item \$xg \$pplug \$plug_name\n          }\n          if {\[java::instanceof \$ob \$XMLSCHEMAPACKAGE.XSDNode\] == 1} { \n            if {\[java::instanceof \$ob \$XMLSCHEMAPACKAGE.XSDElement\] == 1} { \n              set xe \[java::cast \$XMLSCHEMAPACKAGE.XSDElement \$ob\] \n              processAttribute \$item \$xe \$pplug \$plug_name\n            }\n          }\n        }\n      }\n    } \n  } \n} \n\n#\n# Get the XML Schema from the WSDL\n#\nproc get_xmlschema {wsdl} {\n  global jxml_schema_object\n  global jdefinition\n  global OutputMap\n  catch {\n    set wsdlFactory \[java::call javax.wsdl.factory.WSDLFactory newInstance \"oracle.webservices.wsdl.WSDLFactoryImpl\"\]\n    set wsdlReader \[\$wsdlFactory newWSDLReader\]\n    set extensionRegistry \[\$wsdlFactory newPopulatedExtensionRegistry\]\n    \$wsdlReader setExtensionRegistry \$extensionRegistry\n    java::call java.lang.System setProperty \[java::field oracle.webservices.wsdl.WSDLFactoryImpl WSDL_READ_TIMEOUT\] \"600\" \n    set def \[\$wsdlReader readWSDL \$wsdl\]\n    # shawn added - put all the output element to OutputMap\n    set portA \[\[\[\$def getPortTypes\] values\] toArray\]\n    set portType \[java::cast javax.wsdl.PortType \[\$portA get 0\]\]\n    set opers \[\$portType getOperations\]\n    for {set oi 0} {\$oi < \[\$opers size\]} {incr oi} {\n      set oper \[java::cast javax.wsdl.Operation \[\$opers get \$oi\]\]\n      set in \[java::cast javax.wsdl.Output \[\$oper getOutput\]\]\n      set msg \[java::cast javax.wsdl.Message \[\$in getMessage\]\]\n      set parts \[\[\[\$msg getParts\] values\] toArray\]\n      for {set pi 0} {\$pi < \[\$parts length\]} {incr pi} {\n      set part \[java::cast javax.wsdl.Part \[\$parts get \$pi\]\]\n      set qname \[java::cast javax.xml.namespace.QName \[\$part getElementName\]\]\n        set elemName \[\$qname getLocalPart\]\n      \$OutputMap put \$elemName 1\n      }\n    }\n    # shawn added end\n    set jdefinition \$def\n    set types \[\$def getTypes\]\n    if {\[java::isnull \$types\] == 0} {\n      set l \[\$types getExtensibilityElements\]\n      set nss \[\$def getNamespaces\]\n      set onss \[\[\$nss values\] toArray\]\n      set okss \[\[\$nss keySet\] toArray\]\n       for {set t 0} {\$t < \[\$l size\]} {incr t} { \n         set sch \[java::cast javax.wsdl.extensions.schema.Schema  \[\$l get \$t\]\]\n         set xsdb \[java::new oracle.xml.parser.schema.XSDBuilder\]\n         set xe \[java::cast oracle.xml.parser.v2.XMLElement \[\$sch getElement\]\]\n         set doc \[java::new oracle.xml.parser.v2.XMLDocument\]\n         set node \[\$doc adoptNode \$xe\]\n         for {set nsi 0} {\$nsi < \[\$onss length\]} {incr nsi} { \n         \[java::cast oracle.xml.parser.v2.XMLElement \$node\] setAttributeNS  \[\[java::cast java.lang.String \[\$onss get \$nsi\]\] toString\]  \"xmlns:\[\[java::cast java.lang.String \[\$okss get \$nsi\]\] toString\]\" \[\[java::cast java.lang.String \[\$onss get \$nsi\]\] toString\]\n         }\n         \$doc appendChild \$node\n         set jxml_schema_object \[\$xsdb {build oracle.xml.parser.v2.XMLDocument java.net.URL} \$doc \[java::cast java.net.URL \[java::null\]\]\]\n       }\n    } else {\n      set jxml_schema_object \[java::null\]\n    }\n  }\n}\n\n\n#\n# TOP LEVEL driver procedure\n#\nproc createXMLUtils {xsdfile} { \n  global XMLSCHEMAPACKAGE\n  global schemaNS\n  global RET_VAL \n  global jxml_schema_object\n  global FOLD_NAME\n  global NameSpaceValue\n  global OutputMap\n\n  set d \"\"\n  set jxml_schema_object \"\"\n  set plug \[string toupper \[lindex \[lindex \$FOLD_NAME 1\] 1\]\]\n  \n  get_xmlschema \$xsdfile\n  set model \$jxml_schema_object\n\n  if {\[java::isnull \$model\] != 1} { \n    set schema \[java::cast \$XMLSCHEMAPACKAGE.XMLSchema \$model\]\n    set NameSpaceValue \"xmlns=\\\"\[\$schema getSchemaTargetNS\]\\\"\" \n    \n    set ans \[\$schema getXMLSchemaNodeTable\] \n    for {set nds \[\$ans elements\]} {\[\$nds hasMoreElements\]} {} { \n      set ano \[\$nds nextElement\]\n      if {\[java::instanceof \$ano \$XMLSCHEMAPACKAGE.XMLSchemaNode\] ==1} { \n        set map \[\[java::cast \$XMLSCHEMAPACKAGE.XMLSchemaNode \$ano\] getElementSet\] \n        for {set i 0} {\$i < \[\$map length\]} {incr i} { \n          set item \[\$map get \$i\] \n          if {\[java::instanceof \$item \$XMLSCHEMAPACKAGE.XSDElement\] ==1} {\n            set elemName \[\$item getName\]\n            set outelem \[\$OutputMap get \$elemName\]\n            if {\[java::isnull \$outelem\]!=1} { \n                processElement \[java::cast \$XMLSCHEMAPACKAGE.XSDElement \[java::null\]\] \[java::cast \$XMLSCHEMAPACKAGE.XSDElement \$item\] \n            }\n          }\n        }\n      }\n    }\n    set d \[\$schema getSchemaTargetNS\]\n    set d \[string range \$d 0 3999\] \n    set schemaNS \$d\n    OMBCC ''..'' \n    OMBALTER PLUGGABLE_MAPPING_FOLDER ''\$plug'' SET PROPERTIES (DESCRIPTION) VALUES (''\$d'') \n    } else {\n      OMBCC ''..'' \n    }\n    OMBCOMMIT\n} \n \nglobal PLUGNAMES \nglobal PLUGNAMECNT \nglobal FUNCNAMECNT\nglobal RET_VAL \nglobal TYPETOOWBMAP\n\n\nset FUNCNAMECNT 0 \nset PLUGNAMECNT 0 \nset PLUGNAMES \[java::new java.util.Hashtable\] \nset TYPETOOWBMAP \[java::new java.util.Hashtable\]\nset OutputMap \[java::new java.util.Hashtable\]\nset xsd_file \[lindex \[lindex \$RET_VAL 1\] 1\] \n\n\n#\n# The MAIN method....process the XML Schema or WSDL...\n#\ncreateXMLUtils \$xsd_file \n"

   puts -nonewline [format "%-36.36s" "Create CREATE_UTILS_FROM_WSDL expert...................................................."]
   try_to_do {
       OMBCREATE EXPERT 'CREATE_UTILS_FROM_WSDL' SET PROPERTIES(BUSINESS_NAME, DESCRIPTION) VALUES('CREATE_UTILS_FROM_WSDL','This is used to create pluggable mappings from WSDL file')

       OMBALTER EXPERT 'CREATE_UTILS_FROM_WSDL' ADD VARIABLE 'FOLD_NAME' ADD VARIABLE 'RET_VAL' ADD VARIABLE 'PACKAGE_FOLDERS'

       OMBALTER EXPERT 'CREATE_UTILS_FROM_WSDL' \
         ADD CUSTOM_DIALOG TASK 'SELECT_WSDL' SET PROPERTIES(MAIN) VALUES('OMUPROMPT DIALOG ''DLG1'' SET PROPERTIES(TITLE,LINE_WRAP, OPTIONS, DEFAULT_OPTION, CANCEL_OPTION) VALUES(''Select WSDL File'', 2, ''OK,Cancel'', ''OK'', ''Cancel'') ADD FILE_CHOOSER ''COMP1'' SET PROPERTIES(CONTENT,SELECTION) VALUES(''WSDL File:'',''FILES_AND_DIRECTORIES'')')

       global npre1 nmain1 npre2 nmain2
       OMBALTER EXPERT 'CREATE_UTILS_FROM_WSDL' ADD CUSTOM_DIALOG TASK 'SELECT_FOLDER' SET PROPERTIES(PREPROCESSING,MAIN) VALUES('$npre1','$nmain1')

       OMBALTER EXPERT 'CREATE_UTILS_FROM_WSDL' MODIFY PARAMETER 'RETURN_VALUE' OF TASK 'SELECT_FOLDER' BIND TO VARIABLE 'FOLD_NAME' \
           MODIFY PARAMETER 'RETURN_VALUE' OF TASK 'SELECT_WSDL' BIND TO VARIABLE 'RET_VAL'

       OMBALTER EXPERT 'CREATE_UTILS_FROM_WSDL' ADD OMB TASK 'CREATE_UTILS' SET PROPERTIES(PREPROCESSING,MAIN) VALUES('$npre2','$nmain2')

       OMBALTER EXPERT 'CREATE_UTILS_FROM_WSDL' ADD TRANSITION 'T1' FROM TASK 'START_TASK' TO 'SELECT_WSDL'\
           ADD TRANSITION 'T2' FROM TASK 'SELECT_WSDL' TO 'SELECT_FOLDER' SET PROPERTIES(TRANSITION_CONDITION) VALUES('SUCCESS') \
           ADD TRANSITION 'T3' FROM TASK 'SELECT_WSDL' TO 'END_TASK' SET PROPERTIES(TRANSITION_CONDITION) VALUES('ERROR') \
           ADD TRANSITION 'T4' FROM TASK 'SELECT_FOLDER' TO 'CREATE_UTILS' SET PROPERTIES(TRANSITION_CONDITION) VALUES('SUCCESS') \
           ADD TRANSITION 'T5' FROM TASK 'SELECT_FOLDER' TO 'END_TASK' SET PROPERTIES(TRANSITION_CONDITION) VALUES('ERROR') \
           ADD TRANSITION 'T6' FROM TASK 'CREATE_UTILS' TO 'END_TASK'
   }

   OMBCOMMIT

#---------------------------------------------------------------
# 10. DISCONNECT
#---------------------------------------------------------------
   puts -nonewline [format "%-43.43s" "Disconnect................................................"]
   try_to_do {
      OMBDISCONNECT
   }

