@echo off
rem
rem %Header; patch_paris_repos.bat 24-feb-2006.06;23;24 bjeffrie Exp %
rem
rem patch_paris_repos.bat
rem
rem Copyright (c) 2006, Oracle. All rights reserved.  
rem
rem    NAME
rem      patch_paris_repos.sh - upgrade OWB repository to current version
rem
rem    DESCRIPTION
rem      This script can be used to patch a repository for the latest build. It
rem    assumes that the base repository version is 10.1.2.5.44 or later.
rem
rem    NOTES
rem      USAGE;
rem        Change default directory to <OWB-HOME>\owb\UnifiedRepos
rem        patch_paris_repos.bat
rem            <host> <port> <svcName> <dbaUsr> <dbaPwd> <owbUsr> <owbPwd>
rem        Where;;
rem          <host>/<port>/<svcName> - Connection information for Oracle
rem                                   instance containing the OWB repository to
rem                                   be upgraded.
rem          <dbaUsr>/<dbaPwd> - Name\Password for user with dba priviledges.
rem                             This user will be logged on AS SYSDBA to execute
rem                             the patch_paris_repos_sys.sql script.
rem          <owbUsr>/<owbPwd> - Name\Password for OWB repository owner. This
rem                             user will be logged on to execute the
rem                             patch_paris_repos.sql script and also to execute
rem                             the owb_uprop_nls table load in this script.
rem      CUSTOMIZATION;
rem        The nls translation set for each language is fairly large and this
rem      script defaults to installing all of them. (This is to match the
rem      behavior of the standard repository installation.) The execution time
rem      of this script can be improved by removing any non-required language
rem      sets in the OWB_UPROP_NLS_FILES variable declaration. Tests on linux
rem      with a local database show savings of approximately 2.5min\language.
rem      (Initial run with just base (en) = 3:11, 2nd run adding de = 5:53
rem       3rd run with all languages = 23min.))
rem
rem
rem
rem    MODIFIED   (MM/DD/YY)
rem    bjeffrie    02/24/06 - Creation
rem

echo =======================================
echo ===== patch_paris_repos Executing =====
echo =======================================
echo .

set HOST=%1
set PORT=%2
set SVCNAME=%3
set DBAUSR=%4
set DBAPWD=%5
set OWBUSR=%6
set OWBPWD=%7

set CURDIR=%~p0
set EXEDIR=..\bin\win32
cd %EXEDIR%

call ..\win32\setowbenv.bat

rem Note; All external files referenced from EXEDIR
set PATCH_FILES_DIR=..\..\UnifiedRepos
rem Note; sql files must have final 'exit;'
set DBA_PATCH_FILE=%PATCH_FILES_DIR%\patch_paris_repos_sys.sql
set OWB_PATCH_FILE=%PATCH_FILES_DIR%\patch_paris_repos.sql

set NLS_FILES_DIR=..\..\browserasst\views
rem REQUIRED!
set OWB_UPROP_NLS_FILES=%NLS_FILES_DIR%\owb_uprop_nls.xml
rem Optional, may comment out those not needed.
set OWB_UPROP_NLS_FILES=%OWB_UPROP_NLS_FILES% %NLS_FILES_DIR%\owb_uprop_nls_de.xml
set OWB_UPROP_NLS_FILES=%OWB_UPROP_NLS_FILES% %NLS_FILES_DIR%\owb_uprop_nls_es.xml
set OWB_UPROP_NLS_FILES=%OWB_UPROP_NLS_FILES% %NLS_FILES_DIR%\owb_uprop_nls_fr.xml
set OWB_UPROP_NLS_FILES=%OWB_UPROP_NLS_FILES% %NLS_FILES_DIR%\owb_uprop_nls_it.xml
set OWB_UPROP_NLS_FILES=%OWB_UPROP_NLS_FILES% %NLS_FILES_DIR%\owb_uprop_nls_ja.xml
set OWB_UPROP_NLS_FILES=%OWB_UPROP_NLS_FILES% %NLS_FILES_DIR%\owb_uprop_nls_ko.xml
set OWB_UPROP_NLS_FILES=%OWB_UPROP_NLS_FILES% %NLS_FILES_DIR%\owb_uprop_nls_pt_BR.xml
set OWB_UPROP_NLS_FILES=%OWB_UPROP_NLS_FILES% %NLS_FILES_DIR%\owb_uprop_nls_zh_CN.xml


%ORACLE_HOME%\bin\sqlplus %DBAUSR%/%DBAPWD% AS SYSDBA@%HOST%:%PORT%/%SVCNAME% @%DBA_PATCH_FILE%

%ORACLE_HOME%\bin\sqlplus %OWBUSR%/%OWBPWD%@%HOST%:%PORT%/%SVCNAME% @%OWB_PATCH_FILE%

echo .
echo ========================================
echo ===== load owb_uprop_nls Executing =====
echo ========================================

.\jvm.bat -classpath ..\..\..\lib\transx.zip;..\..\..\lib\xschema.jar;..\..\..\lib\xsu12.jar;..\..\..\rdbms\jlib\xdb.jar;..\..\lib\int\rtpplatform.jar;..\..\lib\int\rtpcommon.jar;..\..\..\jdbc\lib\ojdbc14.jar;..\..\..\lib\xmlparserv2.jar;..\..\..\sqlj\lib\runtime12.jar;..\..\..\jdk\jre\lib\rt.jar oracle.xml.transx.loader  "(DESCRIPTION=(ADDRESS=(PROTOCOL=TCP)(HOST=%HOST%)(PORT=%PORT%))(CONNECT_DATA=(SERVICE_NAME=%SVCNAME%)))" %OWBUSR% %OWBPWD% %OWB_UPROP_NLS_FILES%

echo ========================================
echo ===== load owb_uprop_nls Finished  =====
echo ========================================
echo .

cd %CURDIR%
echo =======================================
echo ===== patch_paris_repos Finished  =====
echo =======================================
