Rem reset_owbcc_home.sql
Rem
Rem Copyright (c) 2008, Oracle and/or its affiliates.All rights reserved. 
Rem
Rem    NAME
Rem      reset_owbcc_home.sql - This (Install) script sets the 
Rem      correct permissions for the OWB Control Center.
Rem
Rem    DESCRIPTION
Rem      Run this script if you are NOT using an OWB installed in the Oracle
Rem      database home. It ensure that the Control Center runs correctly in
Rem      the specificed home. You are only likely to need to perform this
Rem      step if you are installing OWB against a 10g database, or are not
Rem      using the default 11g installation.
Rem
Rem      Run the script as a user with java admin privilege.
Rem
Rem    NOTES
Rem      Parameter is the path of the OWB Oracle home.
Rem      The path is converted to unix format (using /).
Rem      To view the policies set by this script, look in dba_java_policy
Rem      for all policies granted to OWBSYS.
Rem
Rem
Rem
Rem    MODIFIED   (MM/DD/YYYY)
Rem       nbaldwin   05/08/07 - 
Rem       nbaldwin   03/29/2007 - Creation
Rem

set verify off 
prompt Enter the full path of the Oracle home for the OWB Control Center install.
prompt If you are installing in a Windows environment, please ensure that the case of the path exactly matches the Oracle install path including the drive letter.
prompt 
prompt OWB Control Center Home:
set termout off
define cc_path     = &1
set termout on

Rem  Grant file permissions using the new path
declare 
  path varchar2(500) := '&cc_path';
  unix_path varchar(500);
begin
  unix_path := replace(path, '\', '/');
  dbms_java.grant_permission('OWBSYS','java.io.FilePermission', upper(path||'/owb/bin/admin/rtrepos.properties'), 'read,write');  
  dbms_java.grant_permission('OWBSYS','java.io.FilePermission', unix_path||'/owb/bin/admin/rtrepos.properties', 'read,write');
  
  dbms_java.grant_permission('OWBSYS','java.io.FilePermission', path||'/owb/bin/unix/run_service.sh', 'read,execute');
  dbms_java.grant_permission('OWBSYS','java.io.FilePermission', path||'\owb\bin\win32\run_service.bat', 'read,execute'); 
  dbms_java.grant_permission('OWBSYS','java.io.FilePermission', upper(path||'\owb\bin\win32\run_service.bat'), 'read,execute');   
end;
/

Rem Set up home in owbrtps
declare 
  the_key varchar2(35) := '';
begin
  select '11.2.0.1.0['||instance_number||']' into the_key from v$instance;
  begin
    insert into owbsys.owbrtps (key, value) values (the_key, '&cc_path');
  exception
  when DUP_VAL_ON_INDEX then
    -- do update instead
    update owbsys.owbrtps set value = '&cc_path' where key = the_key;
  end;
  commit;
end;
/


undefine 1
undefine cc_path
