rem $Header: wfagtlst.sql 26.4 2004/07/01 07:33:05 rosthoma ship $
rem
rem NAME
rem   wfagtlst.sql - WorkFlow Event Listener
rem USAGE
rem   @wfagtlst.sql <AGENT> <DEBUG>
rem   To run the file in debug mode pass TRUE for debug  
rem   Remove the rem from the spool Listener.log
rem DESCRIPTION
rem   Dequeues messages off in agents and calls dispatcher 
rem   If the debug is set to TRUE a log Listener.log will 
rem   be generated at the current directory (ensure that the
rem   directory is writable)
rem
rem   dbdrv: none
--
whenever sqlerror exit failure rollback;
set verify off serveroutput on size 1000000

rem spool Listener.log
--
define agent='&agent'
define debug= &debug
--
prompt Listening.....


declare
  l_audsid        NUMBER;

  type log_message is ref cursor;
  log_msg         log_message;

  l_message_text   varchar2(4000);
  l_LOG_LEVEL      number;
  l_MODULE         VARCHAR2(255);
  l_timestamp      date;
  cur_stmt         varchar2(1000);

begin

  dbms_output.put_line('=============================================');

  --wf_log_pkg.wf_debug_flag := TRUE;
  --Enable logging if debug flag is set to true
  if ('&debug'='TRUE') then
      WF_LOG_PKG.Init (LOG_ENABLED  => 1,
                       LOG_LEVEL    => WF_LOG_PKG.LEVEL_STATEMENT,
                       LOG_MODULE   =>'wf.plsql.%');
  end if;

  wf_event.listen('&agent');

  --Spool out the o/p from fnd_log_messages into
  --Listener.log
  --Do this only if we are in Apps the wf_install check is 
  --needed here.

  if ('&debug' = 'TRUE' AND wf_core.translate('WF_INSTALL') = 'EMBEDDED') then
      l_audsid := sys_context('userenv','SESSIONID');

      --Open the cursor for Apps logging to be consolidated
      --into a file
      cur_stmt := ' select message_text ,module ,LOG_LEVEL ,timestamp '||
                  ' from   fnd_log_messages '||
                  ' where  module like ''wf.plsql.%'''||
                  ' and    audsid  = :p_audsid'||
                  ' order by LOG_SEQUENCE';

      OPEN log_msg FOR cur_stmt USING l_audsid; 

      loop
        fetch log_msg into l_message_text , l_module, l_log_level ,l_timestamp;

        exit when log_msg%notfound;
 
        dbms_output.put_line('Level:'||to_char(l_LOG_LEVEL)||' Module:'||l_module||' Time:'||to_char(l_timestamp , 'DD-MON-RR HH24:MI:SS'));
        --This substr is to avoid ORA-20000: ORU-10028: line length overflow
        --error.
        dbms_output.put_line('>>> Message: '||substr(l_message_text,1,250));
      end loop;

      --Close the log_msg cursor
      close log_msg;
  end if;

exception
  when others then
    if log_msg%isopen then
       close log_msg;
    end if;
    raise;
end;
/
commit;
exit;
