rem HEADER
rem   $Header: wfchita.sql 26.1 2001/11/05 20:04:49 ctilley ship $
rem NAME
rem   wfchita.sql - WorkFlow CHange ItemType Attribute
rem USAGE
rem   @wfchita ITEM_TYPE OLD_ATTR NEW_ATTR
rem DESCRIPTION
rem   It will change the internal name and all references to it.
rem
 
rem dbdrv: none

set verify off
whenever SQLERROR exit failure rollback;

prompt -- Change item attribute name
prompt    @wfchita ITM_TYPE OLD_ITMATT NEW_ITMATT
prompt    Specify an item attribute belong to ITM_TYPE.

define itm_type   = '&&1'
define old_itmatt = '&&2'
define new_itmatt = '&&3'

prompt -- insert new wf_item_attributes
insert into WF_ITEM_ATTRIBUTES
(
 ITEM_TYPE,
 NAME,
 SEQUENCE,
 TYPE,
 PROTECT_LEVEL,
 CUSTOM_LEVEL,
 SUBTYPE,
 FORMAT,
 TEXT_DEFAULT,
 NUMBER_DEFAULT,
 DATE_DEFAULT
) select
 ITEM_TYPE,
 '&new_itmatt',
 SEQUENCE,
 TYPE,
 PROTECT_LEVEL,
 CUSTOM_LEVEL,
 SUBTYPE,
 FORMAT,
 TEXT_DEFAULT,
 NUMBER_DEFAULT,
 DATE_DEFAULT
from WF_ITEM_ATTRIBUTES
where ITEM_TYPE = '&itm_type'
  and NAME = '&old_itmatt';

prompt -- update wf_item_attributes_tl
update WF_ITEM_ATTRIBUTES_TL
   set NAME = '&new_itmatt'
 where ITEM_TYPE = '&itm_type'
   and NAME = '&old_itmatt';

prompt -- update wf_item_attribute_values
update WF_ITEM_ATTRIBUTE_VALUES
   set NAME = '&new_itmatt'
 where ITEM_TYPE = '&itm_type'
   and NAME = '&old_itmatt';

prompt -- update wf_message_attributes
update WF_MESSAGE_ATTRIBUTES
   set TEXT_DEFAULT = '&new_itmatt'
 where MESSAGE_TYPE = '&itm_type'
   and VALUE_TYPE = 'ITEMATTR'
   and TEXT_DEFAULT = '&old_itmatt';

prompt -- update wf_activity_attributes
update WF_ACTIVITY_ATTRIBUTES
   set TEXT_DEFAULT = '&new_itmatt'
 where ACTIVITY_ITEM_TYPE = '&itm_type'
   and TYPE = 'ITEMATTR'
   and TEXT_DEFAULT = '&old_itmatt';

prompt -- update wf_activity_attr_values
update WF_ACTIVITY_ATTR_VALUES WAV
   set TEXT_VALUE = '&new_itmatt'
 where TEXT_VALUE = '&old_itmatt'
   and VALUE_TYPE = 'ITEMATTR'
   and exists
 (select null from WF_PROCESS_ACTIVITIES
   where PROCESS_ITEM_TYPE = '&itm_type'
     and INSTANCE_ID = WAV.PROCESS_ACTIVITY_ID);

prompt -- delete old wf_item_attributes
delete from WF_ITEM_ATTRIBUTES
 where ITEM_TYPE = '&itm_type'
   and NAME = '&old_itmatt';

commit;
exit;
