rem $Header: wfevtenq.sql 26.2 2001/11/05 20:08:38 ctilley ship $
rem
rem NAME
rem   wfevtenq.sql - WorkFlow Event Enqueue 
rem USAGE
rem   @wfevtenq 
rem DESCRIPTION
rem   Enqueues event message on queue using override agent
rem

rem dbdrv: none
--
whenever sqlerror exit failure rollback;
--
--
prompt Enter Details for Message to be Enqueued onto In Agent
--
declare

l_overrideagent		varchar2(30) := '&overrideagent';
l_overridesystem 	varchar2(30) := '&overridesystem';
l_fromagent             varchar2(30) := '&fromagent';
l_fromsystem            varchar2(30) := '&fromsystem';
l_toagent 		varchar2(30) := '&toagent';
l_tosystem 		varchar2(30) := '&tosystem';
l_eventname 		varchar2(100) := '&eventname';
l_eventkey 		varchar2(100) := '&eventkey';
l_msg   		varchar2(200) := '&message';
l_clob			clob;
l_overrideagent_t	wf_agent_t;
l_toagent_t		wf_agent_t;
l_fromagent_t		wf_agent_t;
l_event_t		wf_event_t;

begin
  wf_event_t.initialize(l_event_t);

  l_overrideagent_t := wf_agent_t(l_overrideagent, l_overridesystem);
  l_toagent_t := wf_agent_t(l_toagent, l_tosystem);
  l_fromagent_t := wf_agent_t(l_fromagent, l_fromsystem);

  if l_msg is null then
	l_event_t.Content(l_eventname, l_eventkey, null);
  else
	dbms_lob.createtemporary(l_clob, FALSE, DBMS_LOB.CALL);
	dbms_lob.write(l_clob, length(l_msg), 1, l_msg);
	l_event_t.Content(l_eventname, l_eventkey, l_clob);
  end if;

  l_event_t.Address(l_fromagent_t, l_toagent_t, 50, sysdate);

  wf_event.enqueue(l_event_t, l_overrideagent_t);

end;
/
commit;
exit;
