REM +=======================================================================+
REM |    Copyright (c) 1992 Oracle Corporation, Redwood Shores, CA, USA     |
REM |                         All rights reserved.                          |
REM +=======================================================================+
REM | FILENAME
REM |   wfnldat.sql
REM | USAGE
REM |   sqlplus <wfuser/pwd> @wfnldat
REM | DESCRIPTION
REM |   Add default language data for standalone Workflow install.
REM | NOTES
REM |   This script is for STANDALONE Workflow only.  For Apps installs,
REM |   the wf_languages view should point to fnd_languages for data.
REM |   It is only in STANDALONE that wf_languages view is a direct copy of 
REM |   wf_local_languages.
REM +=======================================================================+
REM $Header: wfnldat.sql 26.1 2001/11/05 20:09:32 ctilley ship $
REM
REM dbdrv: none

WHENEVER SQLERROR CONTINUE

insert into WF_LOCAL_LANGUAGES (
    CODE,
    DISPLAY_NAME,
    NLS_LANGUAGE,
    NLS_TERRITORY,
    NLS_CODESET,
    INSTALLED_FLAG
  ) select
    'AR',
    'ARABIC',
    'ARABIC',
    'UNITED ARAB EMIRATES',
    'AR8ISO8859P6',
    'N'
  from SYS.DUAL
  where not exists
    (select null
    from WF_LOCAL_LANGUAGES
    where CODE = 'AR');

insert into WF_LOCAL_LANGUAGES (
    CODE,
    DISPLAY_NAME,
    NLS_LANGUAGE,
    NLS_TERRITORY,
    NLS_CODESET,
    INSTALLED_FLAG
  ) select
    'BG',
    'BULGARIAN',
    'BULGARIAN',
    'BULGARIA',
    'CL8ISO8859P5',
    'N'
  from SYS.DUAL
  where not exists
    (select null
    from WF_LOCAL_LANGUAGES
    where CODE = 'BG');

insert into WF_LOCAL_LANGUAGES (
    CODE,
    DISPLAY_NAME,
    NLS_LANGUAGE,
    NLS_TERRITORY,
    NLS_CODESET,
    INSTALLED_FLAG
  ) select
    'CA',
    'CATALAN',
    'CATALAN',
    'CATALONIA',
    'WE8ISO8859P1',
    'N'
  from SYS.DUAL
  where not exists
    (select null
    from WF_LOCAL_LANGUAGES
    where CODE = 'CA');

insert into WF_LOCAL_LANGUAGES (
    CODE,
    DISPLAY_NAME,
    NLS_LANGUAGE,
    NLS_TERRITORY,
    NLS_CODESET,
    INSTALLED_FLAG
  ) select
    'CS',
    'CZECH',
    'CZECH',
    'CZECHOSLOVAKIA',
    'EE8ISO8859P2',
    'N'
  from SYS.DUAL
  where not exists
    (select null
    from WF_LOCAL_LANGUAGES
    where CODE = 'CS');

insert into WF_LOCAL_LANGUAGES (
    CODE,
    DISPLAY_NAME,
    NLS_LANGUAGE,
    NLS_TERRITORY,
    NLS_CODESET,
    INSTALLED_FLAG
  ) select
    'D',
    'GERMAN',
    'GERMAN',
    'GERMANY',
    'WE8ISO8859P1',
    'N'
  from SYS.DUAL
  where not exists
    (select null
    from WF_LOCAL_LANGUAGES
    where CODE = 'D');

insert into WF_LOCAL_LANGUAGES (
    CODE,
    DISPLAY_NAME,
    NLS_LANGUAGE,
    NLS_TERRITORY,
    NLS_CODESET,
    INSTALLED_FLAG
  ) select
    'DK',
    'DANISH',
    'DANISH',
    'DENMARK',
    'WE8ISO8859P1',
    'N'
  from SYS.DUAL
  where not exists
    (select null
    from WF_LOCAL_LANGUAGES
    where CODE = 'DK');

insert into WF_LOCAL_LANGUAGES (
    CODE,
    DISPLAY_NAME,
    NLS_LANGUAGE,
    NLS_TERRITORY,
    NLS_CODESET,
    INSTALLED_FLAG
  ) select
    'E',
    'SPANISH',
    'SPANISH',
    'SPAIN',
    'WE8ISO8859P1',
    'N'
  from SYS.DUAL
  where not exists
    (select null
    from WF_LOCAL_LANGUAGES
    where CODE = 'E');

insert into WF_LOCAL_LANGUAGES (
    CODE,
    DISPLAY_NAME,
    NLS_LANGUAGE,
    NLS_TERRITORY,
    NLS_CODESET,
    INSTALLED_FLAG
  ) select
    'EG',
    'EGYPTIAN',
    'EGYPTIAN',
    'EGYPT',
    'AR8ISO8859P6',
    'N'
  from SYS.DUAL
  where not exists
    (select null
    from WF_LOCAL_LANGUAGES
    where CODE = 'EG');

insert into WF_LOCAL_LANGUAGES (
    CODE,
    DISPLAY_NAME,
    NLS_LANGUAGE,
    NLS_TERRITORY,
    NLS_CODESET,
    INSTALLED_FLAG
  ) select
    'EL',
    'GREEK',
    'GREEK',
    'GREECE',
    'EL8ISO8859P7',
    'N'
  from SYS.DUAL
  where not exists
    (select null
    from WF_LOCAL_LANGUAGES
    where CODE = 'EL');

insert into WF_LOCAL_LANGUAGES (
    CODE,
    DISPLAY_NAME,
    NLS_LANGUAGE,
    NLS_TERRITORY,
    NLS_CODESET,
    INSTALLED_FLAG
  ) select
    'ESA',
    'LATIN AMERICAN SPANISH',
    'LATIN AMERICAN SPANISH',
    'SPAIN',
    'WE8ISO8859P1',
    'N'
  from SYS.DUAL
  where not exists
    (select null
    from WF_LOCAL_LANGUAGES
    where CODE = 'ESA');

insert into WF_LOCAL_LANGUAGES (
    CODE,
    DISPLAY_NAME,
    NLS_LANGUAGE,
    NLS_TERRITORY,
    NLS_CODESET,
    INSTALLED_FLAG
  ) select
    'F',
    'FRENCH',
    'FRENCH',
    'FRANCE',
    'WE8ISO8859P1',
    'N'
  from SYS.DUAL
  where not exists
    (select null
    from WF_LOCAL_LANGUAGES
    where CODE = 'F');

insert into WF_LOCAL_LANGUAGES (
    CODE,
    DISPLAY_NAME,
    NLS_LANGUAGE,
    NLS_TERRITORY,
    NLS_CODESET,
    INSTALLED_FLAG
  ) select
    'FRC',
    'CANADIAN FRENCH',
    'CANADIAN FRENCH',
    'CANADA',
    'WE8ISO8859P1',
    'N'
  from SYS.DUAL
  where not exists
    (select null
    from WF_LOCAL_LANGUAGES
    where CODE = 'FRC');

insert into WF_LOCAL_LANGUAGES (
    CODE,
    DISPLAY_NAME,
    NLS_LANGUAGE,
    NLS_TERRITORY,
    NLS_CODESET,
    INSTALLED_FLAG
  ) select
    'GB',
    'ENGLISH',
    'ENGLISH',
    'UNITED KINGDOM',
    'WE8ISO8859P1',
    'N'
  from SYS.DUAL
  where not exists
    (select null
    from WF_LOCAL_LANGUAGES
    where CODE = 'GB');

insert into WF_LOCAL_LANGUAGES (
    CODE,
    DISPLAY_NAME,
    NLS_LANGUAGE,
    NLS_TERRITORY,
    NLS_CODESET,
    INSTALLED_FLAG
  ) select
    'HR',
    'CROATIAN',
    'CROATIAN',
    'CROATIA',
    'EE8ISO8859P2',
    'N'
  from SYS.DUAL
  where not exists
    (select null
    from WF_LOCAL_LANGUAGES
    where CODE = 'HR');

insert into WF_LOCAL_LANGUAGES (
    CODE,
    DISPLAY_NAME,
    NLS_LANGUAGE,
    NLS_TERRITORY,
    NLS_CODESET,
    INSTALLED_FLAG
  ) select
    'HU',
    'HUNGARIAN',
    'HUNGARIAN',
    'HUNGARY',
    'EE8ISO8859P2',
    'N'
  from SYS.DUAL
  where not exists
    (select null
    from WF_LOCAL_LANGUAGES
    where CODE = 'HU');

insert into WF_LOCAL_LANGUAGES (
    CODE,
    DISPLAY_NAME,
    NLS_LANGUAGE,
    NLS_TERRITORY,
    NLS_CODESET,
    INSTALLED_FLAG
  ) select
    'I',
    'ITALIAN',
    'ITALIAN',
    'ITALY',
    'WE8ISO8859P1',
    'N'
  from SYS.DUAL
  where not exists
    (select null
    from WF_LOCAL_LANGUAGES
    where CODE = 'I');

insert into WF_LOCAL_LANGUAGES (
    CODE,
    DISPLAY_NAME,
    NLS_LANGUAGE,
    NLS_TERRITORY,
    NLS_CODESET,
    INSTALLED_FLAG
  ) select
    'IS',
    'ICELANDIC',
    'ICELANDIC',
    'ICELAND',
    'WE8ISO8859P1',
    'N'
  from SYS.DUAL
  where not exists
    (select null
    from WF_LOCAL_LANGUAGES
    where CODE = 'IS');

insert into WF_LOCAL_LANGUAGES (
    CODE,
    DISPLAY_NAME,
    NLS_LANGUAGE,
    NLS_TERRITORY,
    NLS_CODESET,
    INSTALLED_FLAG
  ) select
    'IW',
    'HEBREW',
    'HEBREW',
    'ISRAEL',
    'IW8ISO8859P8',
    'N'
  from SYS.DUAL
  where not exists
    (select null
    from WF_LOCAL_LANGUAGES
    where CODE = 'IW');

insert into WF_LOCAL_LANGUAGES (
    CODE,
    DISPLAY_NAME,
    NLS_LANGUAGE,
    NLS_TERRITORY,
    NLS_CODESET,
    INSTALLED_FLAG
  ) select
    'JA',
    'JAPANESE',
    'JAPANESE',
    'JAPAN',
    'JA16EUC',
    'N'
  from SYS.DUAL
  where not exists
    (select null
    from WF_LOCAL_LANGUAGES
    where CODE = 'JA');

insert into WF_LOCAL_LANGUAGES (
    CODE,
    DISPLAY_NAME,
    NLS_LANGUAGE,
    NLS_TERRITORY,
    NLS_CODESET,
    INSTALLED_FLAG
  ) select
    'KO',
    'KOREAN',
    'KOREAN',
    'KOREA',
    'KO16KSC5601',
    'N'
  from SYS.DUAL
  where not exists
    (select null
    from WF_LOCAL_LANGUAGES
    where CODE = 'KO');

insert into WF_LOCAL_LANGUAGES (
    CODE,
    DISPLAY_NAME,
    NLS_LANGUAGE,
    NLS_TERRITORY,
    NLS_CODESET,
    INSTALLED_FLAG
  ) select
    'LT',
    'LITHUANIAN',
    'LITHUANIAN',
    'LITHUANIA',
    'NEE8ISO8859P4',
    'N'
  from SYS.DUAL
  where not exists
    (select null
    from WF_LOCAL_LANGUAGES
    where CODE = 'LT');

insert into WF_LOCAL_LANGUAGES (
    CODE,
    DISPLAY_NAME,
    NLS_LANGUAGE,
    NLS_TERRITORY,
    NLS_CODESET,
    INSTALLED_FLAG
  ) select
    'N',
    'NORWEGIAN',
    'NORWEGIAN',
    'NORWAY',
    'WE8ISO8859P1',
    'N'
  from SYS.DUAL
  where not exists
    (select null
    from WF_LOCAL_LANGUAGES
    where CODE = 'N');

insert into WF_LOCAL_LANGUAGES (
    CODE,
    DISPLAY_NAME,
    NLS_LANGUAGE,
    NLS_TERRITORY,
    NLS_CODESET,
    INSTALLED_FLAG
  ) select
    'NL',
    'DUTCH',
    'DUTCH',
    'THE NETHERLANDS',
    'WE8ISO8859P1',
    'N'
  from SYS.DUAL
  where not exists
    (select null
    from WF_LOCAL_LANGUAGES
    where CODE = 'NL');

insert into WF_LOCAL_LANGUAGES (
    CODE,
    DISPLAY_NAME,
    NLS_LANGUAGE,
    NLS_TERRITORY,
    NLS_CODESET,
    INSTALLED_FLAG
  ) select
    'PL',
    'POLISH',
    'POLISH',
    'POLAND',
    'EE8ISO8859P2',
    'N'
  from SYS.DUAL
  where not exists
    (select null
    from WF_LOCAL_LANGUAGES
    where CODE = 'PL');

insert into WF_LOCAL_LANGUAGES (
    CODE,
    DISPLAY_NAME,
    NLS_LANGUAGE,
    NLS_TERRITORY,
    NLS_CODESET,
    INSTALLED_FLAG
  ) select
    'PT',
    'PORTUGUESE',
    'PORTUGUESE',
    'PORTUGAL',
    'WE8ISO8859P1',
    'N'
  from SYS.DUAL
  where not exists
    (select null
    from WF_LOCAL_LANGUAGES
    where CODE = 'PT');

insert into WF_LOCAL_LANGUAGES (
    CODE,
    DISPLAY_NAME,
    NLS_LANGUAGE,
    NLS_TERRITORY,
    NLS_CODESET,
    INSTALLED_FLAG
  ) select
    'PTB',
    'BRAZILIAN PORTUGUESE',
    'BRAZILIAN PORTUGUESE',
    'BRAZIL',
    'WE8ISO8859P1',
    'N'
  from SYS.DUAL
  where not exists
    (select null
    from WF_LOCAL_LANGUAGES
    where CODE = 'PTB');

insert into WF_LOCAL_LANGUAGES (
    CODE,
    DISPLAY_NAME,
    NLS_LANGUAGE,
    NLS_TERRITORY,
    NLS_CODESET,
    INSTALLED_FLAG
  ) select
    'RO',
    'ROMANIAN',
    'ROMANIAN',
    'ROMANIA',
    'EE8ISO8859P2',
    'N'
  from SYS.DUAL
  where not exists
    (select null
    from WF_LOCAL_LANGUAGES
    where CODE = 'RO');

insert into WF_LOCAL_LANGUAGES (
    CODE,
    DISPLAY_NAME,
    NLS_LANGUAGE,
    NLS_TERRITORY,
    NLS_CODESET,
    INSTALLED_FLAG
  ) select
    'RU',
    'RUSSIAN',
    'RUSSIAN',
    'CIS',
    'CL8ISO8859P5',
    'N'
  from SYS.DUAL
  where not exists
    (select null
    from WF_LOCAL_LANGUAGES
    where CODE = 'RU');

insert into WF_LOCAL_LANGUAGES (
    CODE,
    DISPLAY_NAME,
    NLS_LANGUAGE,
    NLS_TERRITORY,
    NLS_CODESET,
    INSTALLED_FLAG
  ) select
    'S',
    'SWEDISH',
    'SWEDISH',
    'SWEDEN',
    'WE8ISO8859P1',
    'N'
  from SYS.DUAL
  where not exists
    (select null
    from WF_LOCAL_LANGUAGES
    where CODE = 'S');

insert into WF_LOCAL_LANGUAGES (
    CODE,
    DISPLAY_NAME,
    NLS_LANGUAGE,
    NLS_TERRITORY,
    NLS_CODESET,
    INSTALLED_FLAG
  ) select
    'SF',
    'FINNISH',
    'FINNISH',
    'FINLAND',
    'WE8ISO8859P1',
    'N'
  from SYS.DUAL
  where not exists
    (select null
    from WF_LOCAL_LANGUAGES
    where CODE = 'SF');

insert into WF_LOCAL_LANGUAGES (
    CODE,
    DISPLAY_NAME,
    NLS_LANGUAGE,
    NLS_TERRITORY,
    NLS_CODESET,
    INSTALLED_FLAG
  ) select
    'SK',
    'SLOVAK',
    'SLOVAK',
    'SLOVENIA',
    'EE8ISO8859P2',
    'N'
  from SYS.DUAL
  where not exists
    (select null
    from WF_LOCAL_LANGUAGES
    where CODE = 'SK');

insert into WF_LOCAL_LANGUAGES (
    CODE,
    DISPLAY_NAME,
    NLS_LANGUAGE,
    NLS_TERRITORY,
    NLS_CODESET,
    INSTALLED_FLAG
  ) select
    'SL',
    'SLOVENIAN',
    'SLOVENIAN',
    'SLOVENIA',
    'EE8ISO8859P2',
    'N'
  from SYS.DUAL
  where not exists
    (select null
    from WF_LOCAL_LANGUAGES
    where CODE = 'SL');

insert into WF_LOCAL_LANGUAGES (
    CODE,
    DISPLAY_NAME,
    NLS_LANGUAGE,
    NLS_TERRITORY,
    NLS_CODESET,
    INSTALLED_FLAG
  ) select
    'TH',
    'THAI',
    'THAI',
    'THAILAND',
    'TH8TISASCII',
    'N'
  from SYS.DUAL
  where not exists
    (select null
    from WF_LOCAL_LANGUAGES
    where CODE = 'TH');

insert into WF_LOCAL_LANGUAGES (
    CODE,
    DISPLAY_NAME,
    NLS_LANGUAGE,
    NLS_TERRITORY,
    NLS_CODESET,
    INSTALLED_FLAG
  ) select
    'TR',
    'TURKISH',
    'TURKISH',
    'TURKEY',
    'WE8ISO8859P9',
    'N'
  from SYS.DUAL
  where not exists
    (select null
    from WF_LOCAL_LANGUAGES
    where CODE = 'TR');

insert into WF_LOCAL_LANGUAGES (
    CODE,
    DISPLAY_NAME,
    NLS_LANGUAGE,
    NLS_TERRITORY,
    NLS_CODESET,
    INSTALLED_FLAG
  ) select
    'US',
    'AMERICAN',
    'AMERICAN',
    'AMERICA',
    'US7ASCII',
    'N'
  from SYS.DUAL
  where not exists
    (select null
    from WF_LOCAL_LANGUAGES
    where CODE = 'US');

insert into WF_LOCAL_LANGUAGES (
    CODE,
    DISPLAY_NAME,
    NLS_LANGUAGE,
    NLS_TERRITORY,
    NLS_CODESET,
    INSTALLED_FLAG
  ) select
    'ZHS',
    'SIMPLIFIED CHINESE',
    'SIMPLIFIED CHINESE',
    'CHINA',
    'ZHS16CGB231280',
    'N'
  from SYS.DUAL
  where not exists
    (select null
    from WF_LOCAL_LANGUAGES
    where CODE = 'ZHS');

insert into WF_LOCAL_LANGUAGES (
    CODE,
    DISPLAY_NAME,
    NLS_LANGUAGE,
    NLS_TERRITORY,
    NLS_CODESET,
    INSTALLED_FLAG
  ) select
    'ZHT',
    'TRADITIONAL CHINESE',
    'TRADITIONAL CHINESE',
    'TAIWAN',
    'ZHT16BIG5',
    'N'
  from SYS.DUAL
  where not exists
    (select null
    from WF_LOCAL_LANGUAGES
    where CODE = 'ZHT');

commit;
exit;









